// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UADDW_8H_TRACE_AARCH64_H_
#define VIXL_SIM_UADDW_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_uaddw_8H[] = {
  0x00b1, 0x00d4, 0x33b0, 0x55d3, 0x807c, 0x807e, 0x8080, 0x0082,
  0x00d3, 0x00fc, 0x33b1, 0x55d4, 0x807d, 0x807f, 0x8081, 0x0083,
  0x00fb, 0x00fd, 0x33b2, 0x55d5, 0x807e, 0x8080, 0x8082, 0x00aa,
  0x00fc, 0x00fe, 0x33b3, 0x55d6, 0x807f, 0x8081, 0x80a9, 0x00cc,
  0x00fd, 0x00ff, 0x33b4, 0x55d7, 0x8080, 0x80a8, 0x80cb, 0x00f8,
  0x00fe, 0x0100, 0x33b5, 0x55d8, 0x80a7, 0x80ca, 0x80f7, 0x00fd,
  0x00ff, 0x0101, 0x33b6, 0x55ff, 0x80c9, 0x80f6, 0x80fc, 0x00fe,
  0x0100, 0x0102, 0x33dd, 0x5621, 0x80f5, 0x80fb, 0x80fd, 0x00ff,
  0x0101, 0x0129, 0x33ff, 0x564d, 0x80fa, 0x80fc, 0x80fe, 0x0000,
  0x0128, 0x014b, 0x342b, 0x5652, 0x80fb, 0x80fd, 0x7fff, 0x0001,
  0x014a, 0x0177, 0x3430, 0x5653, 0x80fc, 0x7ffe, 0x8000, 0x0002,
  0x0176, 0x017c, 0x3431, 0x5654, 0x7ffd, 0x7fff, 0x8001, 0x0008,
  0x017b, 0x017d, 0x3432, 0x5555, 0x7ffe, 0x8000, 0x8007, 0x0033,
  0x017c, 0x017e, 0x3333, 0x5556, 0x7fff, 0x8006, 0x8032, 0x0055,
  0x017d, 0x007f, 0x3334, 0x5557, 0x8005, 0x8031, 0x8054, 0x007d,
  0x007e, 0x0080, 0x3335, 0x555d, 0x8030, 0x8053, 0x807c, 0x007e,
  0x007f, 0x0081, 0x333b, 0x5588, 0x8052, 0x807b, 0x807d, 0x007f,
  0x0080, 0x0087, 0x3366, 0x55aa, 0x807a, 0x807c, 0x807e, 0x0080,
  0x0086, 0x00b2, 0x3388, 0x55d2, 0x807b, 0x807d, 0x807f, 0x0081,
  0x00b2, 0x3388, 0x55d2, 0x807b, 0x807d, 0x807f, 0x0081, 0x0083,
  0x00d4, 0x33b0, 0x55d3, 0x807c, 0x807e, 0x8080, 0x0082, 0x0084,
  0x00fc, 0x33b1, 0x55d4, 0x807d, 0x807f, 0x8081, 0x0083, 0x00ab,
  0x00fd, 0x33b2, 0x55d5, 0x807e, 0x8080, 0x8082, 0x00aa, 0x00cd,
  0x00fe, 0x33b3, 0x55d6, 0x807f, 0x8081, 0x80a9, 0x00cc, 0x00f9,
  0x00ff, 0x33b4, 0x55d7, 0x8080, 0x80a8, 0x80cb, 0x00f8, 0x00fe,
  0x0100, 0x33b5, 0x55d8, 0x80a7, 0x80ca, 0x80f7, 0x00fd, 0x00ff,
  0x0101, 0x33b6, 0x55ff, 0x80c9, 0x80f6, 0x80fc, 0x00fe, 0x0100,
  0x0102, 0x33dd, 0x5621, 0x80f5, 0x80fb, 0x80fd, 0x00ff, 0x0001,
  0x0129, 0x33ff, 0x564d, 0x80fa, 0x80fc, 0x80fe, 0x0000, 0x0002,
  0x014b, 0x342b, 0x5652, 0x80fb, 0x80fd, 0x7fff, 0x0001, 0x0003,
  0x0177, 0x3430, 0x5653, 0x80fc, 0x7ffe, 0x8000, 0x0002, 0x0009,
  0x017c, 0x3431, 0x5654, 0x7ffd, 0x7fff, 0x8001, 0x0008, 0x0034,
  0x017d, 0x3432, 0x5555, 0x7ffe, 0x8000, 0x8007, 0x0033, 0x0056,
  0x017e, 0x3333, 0x5556, 0x7fff, 0x8006, 0x8032, 0x0055, 0x007e,
  0x007f, 0x3334, 0x5557, 0x8005, 0x8031, 0x8054, 0x007d, 0x007f,
  0x0080, 0x3335, 0x555d, 0x8030, 0x8053, 0x807c, 0x007e, 0x0080,
  0x0081, 0x333b, 0x5588, 0x8052, 0x807b, 0x807d, 0x007f, 0x0081,
  0x0087, 0x3366, 0x55aa, 0x807a, 0x807c, 0x807e, 0x0080, 0x0082,
  0x3366, 0x55aa, 0x807a, 0x807c, 0x807e, 0x0080, 0x0082, 0x0084,
  0x3388, 0x55d2, 0x807b, 0x807d, 0x807f, 0x0081, 0x0083, 0x0085,
  0x33b0, 0x55d3, 0x807c, 0x807e, 0x8080, 0x0082, 0x0084, 0x00ac,
  0x33b1, 0x55d4, 0x807d, 0x807f, 0x8081, 0x0083, 0x00ab, 0x00ce,
  0x33b2, 0x55d5, 0x807e, 0x8080, 0x8082, 0x00aa, 0x00cd, 0x00fa,
  0x33b3, 0x55d6, 0x807f, 0x8081, 0x80a9, 0x00cc, 0x00f9, 0x00ff,
  0x33b4, 0x55d7, 0x8080, 0x80a8, 0x80cb, 0x00f8, 0x00fe, 0x0100,
  0x33b5, 0x55d8, 0x80a7, 0x80ca, 0x80f7, 0x00fd, 0x00ff, 0x0101,
  0x33b6, 0x55ff, 0x80c9, 0x80f6, 0x80fc, 0x00fe, 0x0100, 0x0002,
  0x33dd, 0x5621, 0x80f5, 0x80fb, 0x80fd, 0x00ff, 0x0001, 0x0003,
  0x33ff, 0x564d, 0x80fa, 0x80fc, 0x80fe, 0x0000, 0x0002, 0x0004,
  0x342b, 0x5652, 0x80fb, 0x80fd, 0x7fff, 0x0001, 0x0003, 0x000a,
  0x3430, 0x5653, 0x80fc, 0x7ffe, 0x8000, 0x0002, 0x0009, 0x0035,
  0x3431, 0x5654, 0x7ffd, 0x7fff, 0x8001, 0x0008, 0x0034, 0x0057,
  0x3432, 0x5555, 0x7ffe, 0x8000, 0x8007, 0x0033, 0x0056, 0x007f,
  0x3333, 0x5556, 0x7fff, 0x8006, 0x8032, 0x0055, 0x007e, 0x0080,
  0x3334, 0x5557, 0x8005, 0x8031, 0x8054, 0x007d, 0x007f, 0x0081,
  0x3335, 0x555d, 0x8030, 0x8053, 0x807c, 0x007e, 0x0080, 0x0082,
  0x333b, 0x5588, 0x8052, 0x807b, 0x807d, 0x007f, 0x0081, 0x0083,
  0x5588, 0x8052, 0x807b, 0x807d, 0x007f, 0x0081, 0x0083, 0x0092,
  0x55aa, 0x807a, 0x807c, 0x807e, 0x0080, 0x0082, 0x0084, 0x0093,
  0x55d2, 0x807b, 0x807d, 0x807f, 0x0081, 0x0083, 0x0085, 0x00ba,
  0x55d3, 0x807c, 0x807e, 0x8080, 0x0082, 0x0084, 0x00ac, 0x00dc,
  0x55d4, 0x807d, 0x807f, 0x8081, 0x0083, 0x00ab, 0x00ce, 0x0108,
  0x55d5, 0x807e, 0x8080, 0x8082, 0x00aa, 0x00cd, 0x00fa, 0x010d,
  0x55d6, 0x807f, 0x8081, 0x80a9, 0x00cc, 0x00f9, 0x00ff, 0x010e,
  0x55d7, 0x8080, 0x80a8, 0x80cb, 0x00f8, 0x00fe, 0x0100, 0x010f,
  0x55d8, 0x80a7, 0x80ca, 0x80f7, 0x00fd, 0x00ff, 0x0101, 0x0010,
  0x55ff, 0x80c9, 0x80f6, 0x80fc, 0x00fe, 0x0100, 0x0002, 0x0011,
  0x5621, 0x80f5, 0x80fb, 0x80fd, 0x00ff, 0x0001, 0x0003, 0x0012,
  0x564d, 0x80fa, 0x80fc, 0x80fe, 0x0000, 0x0002, 0x0004, 0x0018,
  0x5652, 0x80fb, 0x80fd, 0x7fff, 0x0001, 0x0003, 0x000a, 0x0043,
  0x5653, 0x80fc, 0x7ffe, 0x8000, 0x0002, 0x0009, 0x0035, 0x0065,
  0x5654, 0x7ffd, 0x7fff, 0x8001, 0x0008, 0x0034, 0x0057, 0x008d,
  0x5555, 0x7ffe, 0x8000, 0x8007, 0x0033, 0x0056, 0x007f, 0x008e,
  0x5556, 0x7fff, 0x8006, 0x8032, 0x0055, 0x007e, 0x0080, 0x008f,
  0x5557, 0x8005, 0x8031, 0x8054, 0x007d, 0x007f, 0x0081, 0x0090,
  0x555d, 0x8030, 0x8053, 0x807c, 0x007e, 0x0080, 0x0082, 0x0091,
  0x8030, 0x8053, 0x807c, 0x007e, 0x0080, 0x0082, 0x0091, 0x00ff,
  0x8052, 0x807b, 0x807d, 0x007f, 0x0081, 0x0083, 0x0092, 0x0100,
  0x807a, 0x807c, 0x807e, 0x0080, 0x0082, 0x0084, 0x0093, 0x0127,
  0x807b, 0x807d, 0x807f, 0x0081, 0x0083, 0x0085, 0x00ba, 0x0149,
  0x807c, 0x807e, 0x8080, 0x0082, 0x0084, 0x00ac, 0x00dc, 0x0175,
  0x807d, 0x807f, 0x8081, 0x0083, 0x00ab, 0x00ce, 0x0108, 0x017a,
  0x807e, 0x8080, 0x8082, 0x00aa, 0x00cd, 0x00fa, 0x010d, 0x017b,
  0x807f, 0x8081, 0x80a9, 0x00cc, 0x00f9, 0x00ff, 0x010e, 0x017c,
  0x8080, 0x80a8, 0x80cb, 0x00f8, 0x00fe, 0x0100, 0x010f, 0x007d,
  0x80a7, 0x80ca, 0x80f7, 0x00fd, 0x00ff, 0x0101, 0x0010, 0x007e,
  0x80c9, 0x80f6, 0x80fc, 0x00fe, 0x0100, 0x0002, 0x0011, 0x007f,
  0x80f5, 0x80fb, 0x80fd, 0x00ff, 0x0001, 0x0003, 0x0012, 0x0085,
  0x80fa, 0x80fc, 0x80fe, 0x0000, 0x0002, 0x0004, 0x0018, 0x00b0,
  0x80fb, 0x80fd, 0x7fff, 0x0001, 0x0003, 0x000a, 0x0043, 0x00d2,
  0x80fc, 0x7ffe, 0x8000, 0x0002, 0x0009, 0x0035, 0x0065, 0x00fa,
  0x7ffd, 0x7fff, 0x8001, 0x0008, 0x0034, 0x0057, 0x008d, 0x00fb,
  0x7ffe, 0x8000, 0x8007, 0x0033, 0x0056, 0x007f, 0x008e, 0x00fc,
  0x7fff, 0x8006, 0x8032, 0x0055, 0x007e, 0x0080, 0x008f, 0x00fd,
  0x8005, 0x8031, 0x8054, 0x007d, 0x007f, 0x0081, 0x0090, 0x00fe,
  0x8031, 0x8054, 0x007d, 0x007f, 0x0081, 0x0090, 0x00fe, 0x0100,
  0x8053, 0x807c, 0x007e, 0x0080, 0x0082, 0x0091, 0x00ff, 0x0101,
  0x807b, 0x807d, 0x007f, 0x0081, 0x0083, 0x0092, 0x0100, 0x0128,
  0x807c, 0x807e, 0x0080, 0x0082, 0x0084, 0x0093, 0x0127, 0x014a,
  0x807d, 0x807f, 0x0081, 0x0083, 0x0085, 0x00ba, 0x0149, 0x0176,
  0x807e, 0x8080, 0x0082, 0x0084, 0x00ac, 0x00dc, 0x0175, 0x017b,
  0x807f, 0x8081, 0x0083, 0x00ab, 0x00ce, 0x0108, 0x017a, 0x017c,
  0x8080, 0x8082, 0x00aa, 0x00cd, 0x00fa, 0x010d, 0x017b, 0x017d,
  0x8081, 0x80a9, 0x00cc, 0x00f9, 0x00ff, 0x010e, 0x017c, 0x007e,
  0x80a8, 0x80cb, 0x00f8, 0x00fe, 0x0100, 0x010f, 0x007d, 0x007f,
  0x80ca, 0x80f7, 0x00fd, 0x00ff, 0x0101, 0x0010, 0x007e, 0x0080,
  0x80f6, 0x80fc, 0x00fe, 0x0100, 0x0002, 0x0011, 0x007f, 0x0086,
  0x80fb, 0x80fd, 0x00ff, 0x0001, 0x0003, 0x0012, 0x0085, 0x00b1,
  0x80fc, 0x80fe, 0x0000, 0x0002, 0x0004, 0x0018, 0x00b0, 0x00d3,
  0x80fd, 0x7fff, 0x0001, 0x0003, 0x000a, 0x0043, 0x00d2, 0x00fb,
  0x7ffe, 0x8000, 0x0002, 0x0009, 0x0035, 0x0065, 0x00fa, 0x00fc,
  0x7fff, 0x8001, 0x0008, 0x0034, 0x0057, 0x008d, 0x00fb, 0x00fd,
  0x8000, 0x8007, 0x0033, 0x0056, 0x007f, 0x008e, 0x00fc, 0x00fe,
  0x8006, 0x8032, 0x0055, 0x007e, 0x0080, 0x008f, 0x00fd, 0x00ff,
  0x8032, 0x0055, 0x007e, 0x0080, 0x008f, 0x00fd, 0x00ff, 0x0101,
  0x8054, 0x007d, 0x007f, 0x0081, 0x0090, 0x00fe, 0x0100, 0x0102,
  0x807c, 0x007e, 0x0080, 0x0082, 0x0091, 0x00ff, 0x0101, 0x0129,
  0x807d, 0x007f, 0x0081, 0x0083, 0x0092, 0x0100, 0x0128, 0x014b,
  0x807e, 0x0080, 0x0082, 0x0084, 0x0093, 0x0127, 0x014a, 0x0177,
  0x807f, 0x0081, 0x0083, 0x0085, 0x00ba, 0x0149, 0x0176, 0x017c,
  0x8080, 0x0082, 0x0084, 0x00ac, 0x00dc, 0x0175, 0x017b, 0x017d,
  0x8081, 0x0083, 0x00ab, 0x00ce, 0x0108, 0x017a, 0x017c, 0x017e,
  0x8082, 0x00aa, 0x00cd, 0x00fa, 0x010d, 0x017b, 0x017d, 0x007f,
  0x80a9, 0x00cc, 0x00f9, 0x00ff, 0x010e, 0x017c, 0x007e, 0x0080,
  0x80cb, 0x00f8, 0x00fe, 0x0100, 0x010f, 0x007d, 0x007f, 0x0081,
  0x80f7, 0x00fd, 0x00ff, 0x0101, 0x0010, 0x007e, 0x0080, 0x0087,
  0x80fc, 0x00fe, 0x0100, 0x0002, 0x0011, 0x007f, 0x0086, 0x00b2,
  0x80fd, 0x00ff, 0x0001, 0x0003, 0x0012, 0x0085, 0x00b1, 0x00d4,
  0x80fe, 0x0000, 0x0002, 0x0004, 0x0018, 0x00b0, 0x00d3, 0x00fc,
  0x7fff, 0x0001, 0x0003, 0x000a, 0x0043, 0x00d2, 0x00fb, 0x00fd,
  0x8000, 0x0002, 0x0009, 0x0035, 0x0065, 0x00fa, 0x00fc, 0x00fe,
  0x8001, 0x0008, 0x0034, 0x0057, 0x008d, 0x00fb, 0x00fd, 0x00ff,
  0x8007, 0x0033, 0x0056, 0x007f, 0x008e, 0x00fc, 0x00fe, 0x0100,
  0x0033, 0x0056, 0x007f, 0x008e, 0x00fc, 0x00fe, 0x0100, 0x33b5,
  0x0055, 0x007e, 0x0080, 0x008f, 0x00fd, 0x00ff, 0x0101, 0x33b6,
  0x007d, 0x007f, 0x0081, 0x0090, 0x00fe, 0x0100, 0x0102, 0x33dd,
  0x007e, 0x0080, 0x0082, 0x0091, 0x00ff, 0x0101, 0x0129, 0x33ff,
  0x007f, 0x0081, 0x0083, 0x0092, 0x0100, 0x0128, 0x014b, 0x342b,
  0x0080, 0x0082, 0x0084, 0x0093, 0x0127, 0x014a, 0x0177, 0x3430,
  0x0081, 0x0083, 0x0085, 0x00ba, 0x0149, 0x0176, 0x017c, 0x3431,
  0x0082, 0x0084, 0x00ac, 0x00dc, 0x0175, 0x017b, 0x017d, 0x3432,
  0x0083, 0x00ab, 0x00ce, 0x0108, 0x017a, 0x017c, 0x017e, 0x3333,
  0x00aa, 0x00cd, 0x00fa, 0x010d, 0x017b, 0x017d, 0x007f, 0x3334,
  0x00cc, 0x00f9, 0x00ff, 0x010e, 0x017c, 0x007e, 0x0080, 0x3335,
  0x00f8, 0x00fe, 0x0100, 0x010f, 0x007d, 0x007f, 0x0081, 0x333b,
  0x00fd, 0x00ff, 0x0101, 0x0010, 0x007e, 0x0080, 0x0087, 0x3366,
  0x00fe, 0x0100, 0x0002, 0x0011, 0x007f, 0x0086, 0x00b2, 0x3388,
  0x00ff, 0x0001, 0x0003, 0x0012, 0x0085, 0x00b1, 0x00d4, 0x33b0,
  0x0000, 0x0002, 0x0004, 0x0018, 0x00b0, 0x00d3, 0x00fc, 0x33b1,
  0x0001, 0x0003, 0x000a, 0x0043, 0x00d2, 0x00fb, 0x00fd, 0x33b2,
  0x0002, 0x0009, 0x0035, 0x0065, 0x00fa, 0x00fc, 0x00fe, 0x33b3,
  0x0008, 0x0034, 0x0057, 0x008d, 0x00fb, 0x00fd, 0x00ff, 0x33b4,
  0x0034, 0x0057, 0x008d, 0x00fb, 0x00fd, 0x00ff, 0x33b4, 0x55d7,
  0x0056, 0x007f, 0x008e, 0x00fc, 0x00fe, 0x0100, 0x33b5, 0x55d8,
  0x007e, 0x0080, 0x008f, 0x00fd, 0x00ff, 0x0101, 0x33b6, 0x55ff,
  0x007f, 0x0081, 0x0090, 0x00fe, 0x0100, 0x0102, 0x33dd, 0x5621,
  0x0080, 0x0082, 0x0091, 0x00ff, 0x0101, 0x0129, 0x33ff, 0x564d,
  0x0081, 0x0083, 0x0092, 0x0100, 0x0128, 0x014b, 0x342b, 0x5652,
  0x0082, 0x0084, 0x0093, 0x0127, 0x014a, 0x0177, 0x3430, 0x5653,
  0x0083, 0x0085, 0x00ba, 0x0149, 0x0176, 0x017c, 0x3431, 0x5654,
  0x0084, 0x00ac, 0x00dc, 0x0175, 0x017b, 0x017d, 0x3432, 0x5555,
  0x00ab, 0x00ce, 0x0108, 0x017a, 0x017c, 0x017e, 0x3333, 0x5556,
  0x00cd, 0x00fa, 0x010d, 0x017b, 0x017d, 0x007f, 0x3334, 0x5557,
  0x00f9, 0x00ff, 0x010e, 0x017c, 0x007e, 0x0080, 0x3335, 0x555d,
  0x00fe, 0x0100, 0x010f, 0x007d, 0x007f, 0x0081, 0x333b, 0x5588,
  0x00ff, 0x0101, 0x0010, 0x007e, 0x0080, 0x0087, 0x3366, 0x55aa,
  0x0100, 0x0002, 0x0011, 0x007f, 0x0086, 0x00b2, 0x3388, 0x55d2,
  0x0001, 0x0003, 0x0012, 0x0085, 0x00b1, 0x00d4, 0x33b0, 0x55d3,
  0x0002, 0x0004, 0x0018, 0x00b0, 0x00d3, 0x00fc, 0x33b1, 0x55d4,
  0x0003, 0x000a, 0x0043, 0x00d2, 0x00fb, 0x00fd, 0x33b2, 0x55d5,
  0x0009, 0x0035, 0x0065, 0x00fa, 0x00fc, 0x00fe, 0x33b3, 0x55d6,
  0x0035, 0x0065, 0x00fa, 0x00fc, 0x00fe, 0x33b3, 0x55d6, 0x807f,
  0x0057, 0x008d, 0x00fb, 0x00fd, 0x00ff, 0x33b4, 0x55d7, 0x8080,
  0x007f, 0x008e, 0x00fc, 0x00fe, 0x0100, 0x33b5, 0x55d8, 0x80a7,
  0x0080, 0x008f, 0x00fd, 0x00ff, 0x0101, 0x33b6, 0x55ff, 0x80c9,
  0x0081, 0x0090, 0x00fe, 0x0100, 0x0102, 0x33dd, 0x5621, 0x80f5,
  0x0082, 0x0091, 0x00ff, 0x0101, 0x0129, 0x33ff, 0x564d, 0x80fa,
  0x0083, 0x0092, 0x0100, 0x0128, 0x014b, 0x342b, 0x5652, 0x80fb,
  0x0084, 0x0093, 0x0127, 0x014a, 0x0177, 0x3430, 0x5653, 0x80fc,
  0x0085, 0x00ba, 0x0149, 0x0176, 0x017c, 0x3431, 0x5654, 0x7ffd,
  0x00ac, 0x00dc, 0x0175, 0x017b, 0x017d, 0x3432, 0x5555, 0x7ffe,
  0x00ce, 0x0108, 0x017a, 0x017c, 0x017e, 0x3333, 0x5556, 0x7fff,
  0x00fa, 0x010d, 0x017b, 0x017d, 0x007f, 0x3334, 0x5557, 0x8005,
  0x00ff, 0x010e, 0x017c, 0x007e, 0x0080, 0x3335, 0x555d, 0x8030,
  0x0100, 0x010f, 0x007d, 0x007f, 0x0081, 0x333b, 0x5588, 0x8052,
  0x0101, 0x0010, 0x007e, 0x0080, 0x0087, 0x3366, 0x55aa, 0x807a,
  0x0002, 0x0011, 0x007f, 0x0086, 0x00b2, 0x3388, 0x55d2, 0x807b,
  0x0003, 0x0012, 0x0085, 0x00b1, 0x00d4, 0x33b0, 0x55d3, 0x807c,
  0x0004, 0x0018, 0x00b0, 0x00d3, 0x00fc, 0x33b1, 0x55d4, 0x807d,
  0x000a, 0x0043, 0x00d2, 0x00fb, 0x00fd, 0x33b2, 0x55d5, 0x807e,
  0x0043, 0x00d2, 0x00fb, 0x00fd, 0x33b2, 0x55d5, 0x807e, 0x8080,
  0x0065, 0x00fa, 0x00fc, 0x00fe, 0x33b3, 0x55d6, 0x807f, 0x8081,
  0x008d, 0x00fb, 0x00fd, 0x00ff, 0x33b4, 0x55d7, 0x8080, 0x80a8,
  0x008e, 0x00fc, 0x00fe, 0x0100, 0x33b5, 0x55d8, 0x80a7, 0x80ca,
  0x008f, 0x00fd, 0x00ff, 0x0101, 0x33b6, 0x55ff, 0x80c9, 0x80f6,
  0x0090, 0x00fe, 0x0100, 0x0102, 0x33dd, 0x5621, 0x80f5, 0x80fb,
  0x0091, 0x00ff, 0x0101, 0x0129, 0x33ff, 0x564d, 0x80fa, 0x80fc,
  0x0092, 0x0100, 0x0128, 0x014b, 0x342b, 0x5652, 0x80fb, 0x80fd,
  0x0093, 0x0127, 0x014a, 0x0177, 0x3430, 0x5653, 0x80fc, 0x7ffe,
  0x00ba, 0x0149, 0x0176, 0x017c, 0x3431, 0x5654, 0x7ffd, 0x7fff,
  0x00dc, 0x0175, 0x017b, 0x017d, 0x3432, 0x5555, 0x7ffe, 0x8000,
  0x0108, 0x017a, 0x017c, 0x017e, 0x3333, 0x5556, 0x7fff, 0x8006,
  0x010d, 0x017b, 0x017d, 0x007f, 0x3334, 0x5557, 0x8005, 0x8031,
  0x010e, 0x017c, 0x007e, 0x0080, 0x3335, 0x555d, 0x8030, 0x8053,
  0x010f, 0x007d, 0x007f, 0x0081, 0x333b, 0x5588, 0x8052, 0x807b,
  0x0010, 0x007e, 0x0080, 0x0087, 0x3366, 0x55aa, 0x807a, 0x807c,
  0x0011, 0x007f, 0x0086, 0x00b2, 0x3388, 0x55d2, 0x807b, 0x807d,
  0x0012, 0x0085, 0x00b1, 0x00d4, 0x33b0, 0x55d3, 0x807c, 0x807e,
  0x0018, 0x00b0, 0x00d3, 0x00fc, 0x33b1, 0x55d4, 0x807d, 0x807f,
  0x00b0, 0x00d3, 0x00fc, 0x33b1, 0x55d4, 0x807d, 0x807f, 0x8081,
  0x00d2, 0x00fb, 0x00fd, 0x33b2, 0x55d5, 0x807e, 0x8080, 0x8082,
  0x00fa, 0x00fc, 0x00fe, 0x33b3, 0x55d6, 0x807f, 0x8081, 0x80a9,
  0x00fb, 0x00fd, 0x00ff, 0x33b4, 0x55d7, 0x8080, 0x80a8, 0x80cb,
  0x00fc, 0x00fe, 0x0100, 0x33b5, 0x55d8, 0x80a7, 0x80ca, 0x80f7,
  0x00fd, 0x00ff, 0x0101, 0x33b6, 0x55ff, 0x80c9, 0x80f6, 0x80fc,
  0x00fe, 0x0100, 0x0102, 0x33dd, 0x5621, 0x80f5, 0x80fb, 0x80fd,
  0x00ff, 0x0101, 0x0129, 0x33ff, 0x564d, 0x80fa, 0x80fc, 0x80fe,
  0x0100, 0x0128, 0x014b, 0x342b, 0x5652, 0x80fb, 0x80fd, 0x7fff,
  0x0127, 0x014a, 0x0177, 0x3430, 0x5653, 0x80fc, 0x7ffe, 0x8000,
  0x0149, 0x0176, 0x017c, 0x3431, 0x5654, 0x7ffd, 0x7fff, 0x8001,
  0x0175, 0x017b, 0x017d, 0x3432, 0x5555, 0x7ffe, 0x8000, 0x8007,
  0x017a, 0x017c, 0x017e, 0x3333, 0x5556, 0x7fff, 0x8006, 0x8032,
  0x017b, 0x017d, 0x007f, 0x3334, 0x5557, 0x8005, 0x8031, 0x8054,
  0x017c, 0x007e, 0x0080, 0x3335, 0x555d, 0x8030, 0x8053, 0x807c,
  0x007d, 0x007f, 0x0081, 0x333b, 0x5588, 0x8052, 0x807b, 0x807d,
  0x007e, 0x0080, 0x0087, 0x3366, 0x55aa, 0x807a, 0x807c, 0x807e,
  0x007f, 0x0086, 0x00b2, 0x3388, 0x55d2, 0x807b, 0x807d, 0x807f,
  0x0085, 0x00b1, 0x00d4, 0x33b0, 0x55d3, 0x807c, 0x807e, 0x8080,
  0x00b1, 0x00d4, 0x33b0, 0x55d3, 0x807c, 0x807e, 0x8080, 0x8082,
  0x00d3, 0x00fc, 0x33b1, 0x55d4, 0x807d, 0x807f, 0x8081, 0x8083,
  0x00fb, 0x00fd, 0x33b2, 0x55d5, 0x807e, 0x8080, 0x8082, 0x80aa,
  0x00fc, 0x00fe, 0x33b3, 0x55d6, 0x807f, 0x8081, 0x80a9, 0x80cc,
  0x00fd, 0x00ff, 0x33b4, 0x55d7, 0x8080, 0x80a8, 0x80cb, 0x80f8,
  0x00fe, 0x0100, 0x33b5, 0x55d8, 0x80a7, 0x80ca, 0x80f7, 0x80fd,
  0x00ff, 0x0101, 0x33b6, 0x55ff, 0x80c9, 0x80f6, 0x80fc, 0x80fe,
  0x0100, 0x0102, 0x33dd, 0x5621, 0x80f5, 0x80fb, 0x80fd, 0x80ff,
  0x0101, 0x0129, 0x33ff, 0x564d, 0x80fa, 0x80fc, 0x80fe, 0x8000,
  0x0128, 0x014b, 0x342b, 0x5652, 0x80fb, 0x80fd, 0x7fff, 0x8001,
  0x014a, 0x0177, 0x3430, 0x5653, 0x80fc, 0x7ffe, 0x8000, 0x8002,
  0x0176, 0x017c, 0x3431, 0x5654, 0x7ffd, 0x7fff, 0x8001, 0x8008,
  0x017b, 0x017d, 0x3432, 0x5555, 0x7ffe, 0x8000, 0x8007, 0x8033,
  0x017c, 0x017e, 0x3333, 0x5556, 0x7fff, 0x8006, 0x8032, 0x8055,
  0x017d, 0x007f, 0x3334, 0x5557, 0x8005, 0x8031, 0x8054, 0x807d,
  0x007e, 0x0080, 0x3335, 0x555d, 0x8030, 0x8053, 0x807c, 0x807e,
  0x007f, 0x0081, 0x333b, 0x5588, 0x8052, 0x807b, 0x807d, 0x807f,
  0x0080, 0x0087, 0x3366, 0x55aa, 0x807a, 0x807c, 0x807e, 0x8080,
  0x0086, 0x00b2, 0x3388, 0x55d2, 0x807b, 0x807d, 0x807f, 0x8081,
  0x00b2, 0x3388, 0x55d2, 0x807b, 0x807d, 0x807f, 0x8081, 0x8083,
  0x00d4, 0x33b0, 0x55d3, 0x807c, 0x807e, 0x8080, 0x8082, 0x8084,
  0x00fc, 0x33b1, 0x55d4, 0x807d, 0x807f, 0x8081, 0x8083, 0x80ab,
  0x00fd, 0x33b2, 0x55d5, 0x807e, 0x8080, 0x8082, 0x80aa, 0x80cd,
  0x00fe, 0x33b3, 0x55d6, 0x807f, 0x8081, 0x80a9, 0x80cc, 0x80f9,
  0x00ff, 0x33b4, 0x55d7, 0x8080, 0x80a8, 0x80cb, 0x80f8, 0x80fe,
  0x0100, 0x33b5, 0x55d8, 0x80a7, 0x80ca, 0x80f7, 0x80fd, 0x80ff,
  0x0101, 0x33b6, 0x55ff, 0x80c9, 0x80f6, 0x80fc, 0x80fe, 0x8100,
  0x0102, 0x33dd, 0x5621, 0x80f5, 0x80fb, 0x80fd, 0x80ff, 0x8001,
  0x0129, 0x33ff, 0x564d, 0x80fa, 0x80fc, 0x80fe, 0x8000, 0x8002,
  0x014b, 0x342b, 0x5652, 0x80fb, 0x80fd, 0x7fff, 0x8001, 0x8003,
  0x0177, 0x3430, 0x5653, 0x80fc, 0x7ffe, 0x8000, 0x8002, 0x8009,
  0x017c, 0x3431, 0x5654, 0x7ffd, 0x7fff, 0x8001, 0x8008, 0x8034,
  0x017d, 0x3432, 0x5555, 0x7ffe, 0x8000, 0x8007, 0x8033, 0x8056,
  0x017e, 0x3333, 0x5556, 0x7fff, 0x8006, 0x8032, 0x8055, 0x807e,
  0x007f, 0x3334, 0x5557, 0x8005, 0x8031, 0x8054, 0x807d, 0x807f,
  0x0080, 0x3335, 0x555d, 0x8030, 0x8053, 0x807c, 0x807e, 0x8080,
  0x0081, 0x333b, 0x5588, 0x8052, 0x807b, 0x807d, 0x807f, 0x8081,
  0x0087, 0x3366, 0x55aa, 0x807a, 0x807c, 0x807e, 0x8080, 0x8082,
  0x3366, 0x55aa, 0x807a, 0x807c, 0x807e, 0x8080, 0x8082, 0xab2c,
  0x3388, 0x55d2, 0x807b, 0x807d, 0x807f, 0x8081, 0x8083, 0xab2d,
  0x33b0, 0x55d3, 0x807c, 0x807e, 0x8080, 0x8082, 0x8084, 0xab54,
  0x33b1, 0x55d4, 0x807d, 0x807f, 0x8081, 0x8083, 0x80ab, 0xab76,
  0x33b2, 0x55d5, 0x807e, 0x8080, 0x8082, 0x80aa, 0x80cd, 0xaba2,
  0x33b3, 0x55d6, 0x807f, 0x8081, 0x80a9, 0x80cc, 0x80f9, 0xaba7,
  0x33b4, 0x55d7, 0x8080, 0x80a8, 0x80cb, 0x80f8, 0x80fe, 0xaba8,
  0x33b5, 0x55d8, 0x80a7, 0x80ca, 0x80f7, 0x80fd, 0x80ff, 0xaba9,
  0x33b6, 0x55ff, 0x80c9, 0x80f6, 0x80fc, 0x80fe, 0x8100, 0xaaaa,
  0x33dd, 0x5621, 0x80f5, 0x80fb, 0x80fd, 0x80ff, 0x8001, 0xaaab,
  0x33ff, 0x564d, 0x80fa, 0x80fc, 0x80fe, 0x8000, 0x8002, 0xaaac,
  0x342b, 0x5652, 0x80fb, 0x80fd, 0x7fff, 0x8001, 0x8003, 0xaab2,
  0x3430, 0x5653, 0x80fc, 0x7ffe, 0x8000, 0x8002, 0x8009, 0xaadd,
  0x3431, 0x5654, 0x7ffd, 0x7fff, 0x8001, 0x8008, 0x8034, 0xaaff,
  0x3432, 0x5555, 0x7ffe, 0x8000, 0x8007, 0x8033, 0x8056, 0xab27,
  0x3333, 0x5556, 0x7fff, 0x8006, 0x8032, 0x8055, 0x807e, 0xab28,
  0x3334, 0x5557, 0x8005, 0x8031, 0x8054, 0x807d, 0x807f, 0xab29,
  0x3335, 0x555d, 0x8030, 0x8053, 0x807c, 0x807e, 0x8080, 0xab2a,
  0x333b, 0x5588, 0x8052, 0x807b, 0x807d, 0x807f, 0x8081, 0xab2b,
  0x5588, 0x8052, 0x807b, 0x807d, 0x807f, 0x8081, 0xab2b, 0xcd4e,
  0x55aa, 0x807a, 0x807c, 0x807e, 0x8080, 0x8082, 0xab2c, 0xcd4f,
  0x55d2, 0x807b, 0x807d, 0x807f, 0x8081, 0x8083, 0xab2d, 0xcd76,
  0x55d3, 0x807c, 0x807e, 0x8080, 0x8082, 0x8084, 0xab54, 0xcd98,
  0x55d4, 0x807d, 0x807f, 0x8081, 0x8083, 0x80ab, 0xab76, 0xcdc4,
  0x55d5, 0x807e, 0x8080, 0x8082, 0x80aa, 0x80cd, 0xaba2, 0xcdc9,
  0x55d6, 0x807f, 0x8081, 0x80a9, 0x80cc, 0x80f9, 0xaba7, 0xcdca,
  0x55d7, 0x8080, 0x80a8, 0x80cb, 0x80f8, 0x80fe, 0xaba8, 0xcdcb,
  0x55d8, 0x80a7, 0x80ca, 0x80f7, 0x80fd, 0x80ff, 0xaba9, 0xcccc,
  0x55ff, 0x80c9, 0x80f6, 0x80fc, 0x80fe, 0x8100, 0xaaaa, 0xcccd,
  0x5621, 0x80f5, 0x80fb, 0x80fd, 0x80ff, 0x8001, 0xaaab, 0xccce,
  0x564d, 0x80fa, 0x80fc, 0x80fe, 0x8000, 0x8002, 0xaaac, 0xccd4,
  0x5652, 0x80fb, 0x80fd, 0x7fff, 0x8001, 0x8003, 0xaab2, 0xccff,
  0x5653, 0x80fc, 0x7ffe, 0x8000, 0x8002, 0x8009, 0xaadd, 0xcd21,
  0x5654, 0x7ffd, 0x7fff, 0x8001, 0x8008, 0x8034, 0xaaff, 0xcd49,
  0x5555, 0x7ffe, 0x8000, 0x8007, 0x8033, 0x8056, 0xab27, 0xcd4a,
  0x5556, 0x7fff, 0x8006, 0x8032, 0x8055, 0x807e, 0xab28, 0xcd4b,
  0x5557, 0x8005, 0x8031, 0x8054, 0x807d, 0x807f, 0xab29, 0xcd4c,
  0x555d, 0x8030, 0x8053, 0x807c, 0x807e, 0x8080, 0xab2a, 0xcd4d,
  0x8030, 0x8053, 0x807c, 0x807e, 0x8080, 0xab2a, 0xcd4d, 0x0002,
  0x8052, 0x807b, 0x807d, 0x807f, 0x8081, 0xab2b, 0xcd4e, 0x0003,
  0x807a, 0x807c, 0x807e, 0x8080, 0x8082, 0xab2c, 0xcd4f, 0x002a,
  0x807b, 0x807d, 0x807f, 0x8081, 0x8083, 0xab2d, 0xcd76, 0x004c,
  0x807c, 0x807e, 0x8080, 0x8082, 0x8084, 0xab54, 0xcd98, 0x0078,
  0x807d, 0x807f, 0x8081, 0x8083, 0x80ab, 0xab76, 0xcdc4, 0x007d,
  0x807e, 0x8080, 0x8082, 0x80aa, 0x80cd, 0xaba2, 0xcdc9, 0x007e,
  0x807f, 0x8081, 0x80a9, 0x80cc, 0x80f9, 0xaba7, 0xcdca, 0x007f,
  0x8080, 0x80a8, 0x80cb, 0x80f8, 0x80fe, 0xaba8, 0xcdcb, 0xff80,
  0x80a7, 0x80ca, 0x80f7, 0x80fd, 0x80ff, 0xaba9, 0xcccc, 0xff81,
  0x80c9, 0x80f6, 0x80fc, 0x80fe, 0x8100, 0xaaaa, 0xcccd, 0xff82,
  0x80f5, 0x80fb, 0x80fd, 0x80ff, 0x8001, 0xaaab, 0xccce, 0xff88,
  0x80fa, 0x80fc, 0x80fe, 0x8000, 0x8002, 0xaaac, 0xccd4, 0xffb3,
  0x80fb, 0x80fd, 0x7fff, 0x8001, 0x8003, 0xaab2, 0xccff, 0xffd5,
  0x80fc, 0x7ffe, 0x8000, 0x8002, 0x8009, 0xaadd, 0xcd21, 0xfffd,
  0x7ffd, 0x7fff, 0x8001, 0x8008, 0x8034, 0xaaff, 0xcd49, 0xfffe,
  0x7ffe, 0x8000, 0x8007, 0x8033, 0x8056, 0xab27, 0xcd4a, 0xffff,
  0x7fff, 0x8006, 0x8032, 0x8055, 0x807e, 0xab28, 0xcd4b, 0x0000,
  0x8005, 0x8031, 0x8054, 0x807d, 0x807f, 0xab29, 0xcd4c, 0x0001,
  0x8031, 0x8054, 0x807d, 0x807f, 0xab29, 0xcd4c, 0x0001, 0x0003,
  0x8053, 0x807c, 0x807e, 0x8080, 0xab2a, 0xcd4d, 0x0002, 0x0004,
  0x807b, 0x807d, 0x807f, 0x8081, 0xab2b, 0xcd4e, 0x0003, 0x002b,
  0x807c, 0x807e, 0x8080, 0x8082, 0xab2c, 0xcd4f, 0x002a, 0x004d,
  0x807d, 0x807f, 0x8081, 0x8083, 0xab2d, 0xcd76, 0x004c, 0x0079,
  0x807e, 0x8080, 0x8082, 0x8084, 0xab54, 0xcd98, 0x0078, 0x007e,
  0x807f, 0x8081, 0x8083, 0x80ab, 0xab76, 0xcdc4, 0x007d, 0x007f,
  0x8080, 0x8082, 0x80aa, 0x80cd, 0xaba2, 0xcdc9, 0x007e, 0x0080,
  0x8081, 0x80a9, 0x80cc, 0x80f9, 0xaba7, 0xcdca, 0x007f, 0xff81,
  0x80a8, 0x80cb, 0x80f8, 0x80fe, 0xaba8, 0xcdcb, 0xff80, 0xff82,
  0x80ca, 0x80f7, 0x80fd, 0x80ff, 0xaba9, 0xcccc, 0xff81, 0xff83,
  0x80f6, 0x80fc, 0x80fe, 0x8100, 0xaaaa, 0xcccd, 0xff82, 0xff89,
  0x80fb, 0x80fd, 0x80ff, 0x8001, 0xaaab, 0xccce, 0xff88, 0xffb4,
  0x80fc, 0x80fe, 0x8000, 0x8002, 0xaaac, 0xccd4, 0xffb3, 0xffd6,
  0x80fd, 0x7fff, 0x8001, 0x8003, 0xaab2, 0xccff, 0xffd5, 0xfffe,
  0x7ffe, 0x8000, 0x8002, 0x8009, 0xaadd, 0xcd21, 0xfffd, 0xffff,
  0x7fff, 0x8001, 0x8008, 0x8034, 0xaaff, 0xcd49, 0xfffe, 0x0000,
  0x8000, 0x8007, 0x8033, 0x8056, 0xab27, 0xcd4a, 0xffff, 0x0001,
  0x8006, 0x8032, 0x8055, 0x807e, 0xab28, 0xcd4b, 0x0000, 0x0002,
  0x8032, 0x8055, 0x807e, 0xab28, 0xcd4b, 0x0000, 0x0002, 0x0004,
  0x8054, 0x807d, 0x807f, 0xab29, 0xcd4c, 0x0001, 0x0003, 0x0005,
  0x807c, 0x807e, 0x8080, 0xab2a, 0xcd4d, 0x0002, 0x0004, 0x002c,
  0x807d, 0x807f, 0x8081, 0xab2b, 0xcd4e, 0x0003, 0x002b, 0x004e,
  0x807e, 0x8080, 0x8082, 0xab2c, 0xcd4f, 0x002a, 0x004d, 0x007a,
  0x807f, 0x8081, 0x8083, 0xab2d, 0xcd76, 0x004c, 0x0079, 0x007f,
  0x8080, 0x8082, 0x8084, 0xab54, 0xcd98, 0x0078, 0x007e, 0x0080,
  0x8081, 0x8083, 0x80ab, 0xab76, 0xcdc4, 0x007d, 0x007f, 0x0081,
  0x8082, 0x80aa, 0x80cd, 0xaba2, 0xcdc9, 0x007e, 0x0080, 0xff82,
  0x80a9, 0x80cc, 0x80f9, 0xaba7, 0xcdca, 0x007f, 0xff81, 0xff83,
  0x80cb, 0x80f8, 0x80fe, 0xaba8, 0xcdcb, 0xff80, 0xff82, 0xff84,
  0x80f7, 0x80fd, 0x80ff, 0xaba9, 0xcccc, 0xff81, 0xff83, 0xff8a,
  0x80fc, 0x80fe, 0x8100, 0xaaaa, 0xcccd, 0xff82, 0xff89, 0xffb5,
  0x80fd, 0x80ff, 0x8001, 0xaaab, 0xccce, 0xff88, 0xffb4, 0xffd7,
  0x80fe, 0x8000, 0x8002, 0xaaac, 0xccd4, 0xffb3, 0xffd6, 0xffff,
  0x7fff, 0x8001, 0x8003, 0xaab2, 0xccff, 0xffd5, 0xfffe, 0x0000,
  0x8000, 0x8002, 0x8009, 0xaadd, 0xcd21, 0xfffd, 0xffff, 0x0001,
  0x8001, 0x8008, 0x8034, 0xaaff, 0xcd49, 0xfffe, 0x0000, 0x0002,
  0x8007, 0x8033, 0x8056, 0xab27, 0xcd4a, 0xffff, 0x0001, 0x0003,
  0x8033, 0x8056, 0xab27, 0xcd4a, 0xffff, 0x0001, 0x0003, 0x0005,
  0x8055, 0x807e, 0xab28, 0xcd4b, 0x0000, 0x0002, 0x0004, 0x0006,
  0x807d, 0x807f, 0xab29, 0xcd4c, 0x0001, 0x0003, 0x0005, 0x002d,
  0x807e, 0x8080, 0xab2a, 0xcd4d, 0x0002, 0x0004, 0x002c, 0x004f,
  0x807f, 0x8081, 0xab2b, 0xcd4e, 0x0003, 0x002b, 0x004e, 0x007b,
  0x8080, 0x8082, 0xab2c, 0xcd4f, 0x002a, 0x004d, 0x007a, 0x0080,
  0x8081, 0x8083, 0xab2d, 0xcd76, 0x004c, 0x0079, 0x007f, 0x0081,
  0x8082, 0x8084, 0xab54, 0xcd98, 0x0078, 0x007e, 0x0080, 0x0082,
  0x8083, 0x80ab, 0xab76, 0xcdc4, 0x007d, 0x007f, 0x0081, 0xff83,
  0x80aa, 0x80cd, 0xaba2, 0xcdc9, 0x007e, 0x0080, 0xff82, 0xff84,
  0x80cc, 0x80f9, 0xaba7, 0xcdca, 0x007f, 0xff81, 0xff83, 0xff85,
  0x80f8, 0x80fe, 0xaba8, 0xcdcb, 0xff80, 0xff82, 0xff84, 0xff8b,
  0x80fd, 0x80ff, 0xaba9, 0xcccc, 0xff81, 0xff83, 0xff8a, 0xffb6,
  0x80fe, 0x8100, 0xaaaa, 0xcccd, 0xff82, 0xff89, 0xffb5, 0xffd8,
  0x80ff, 0x8001, 0xaaab, 0xccce, 0xff88, 0xffb4, 0xffd7, 0x0000,
  0x8000, 0x8002, 0xaaac, 0xccd4, 0xffb3, 0xffd6, 0xffff, 0x0001,
  0x8001, 0x8003, 0xaab2, 0xccff, 0xffd5, 0xfffe, 0x0000, 0x0002,
  0x8002, 0x8009, 0xaadd, 0xcd21, 0xfffd, 0xffff, 0x0001, 0x0003,
  0x8008, 0x8034, 0xaaff, 0xcd49, 0xfffe, 0x0000, 0x0002, 0x0004,
  0x8034, 0xaaff, 0xcd49, 0xfffe, 0x0000, 0x0002, 0x0004, 0x0072,
  0x8056, 0xab27, 0xcd4a, 0xffff, 0x0001, 0x0003, 0x0005, 0x0073,
  0x807e, 0xab28, 0xcd4b, 0x0000, 0x0002, 0x0004, 0x0006, 0x009a,
  0x807f, 0xab29, 0xcd4c, 0x0001, 0x0003, 0x0005, 0x002d, 0x00bc,
  0x8080, 0xab2a, 0xcd4d, 0x0002, 0x0004, 0x002c, 0x004f, 0x00e8,
  0x8081, 0xab2b, 0xcd4e, 0x0003, 0x002b, 0x004e, 0x007b, 0x00ed,
  0x8082, 0xab2c, 0xcd4f, 0x002a, 0x004d, 0x007a, 0x0080, 0x00ee,
  0x8083, 0xab2d, 0xcd76, 0x004c, 0x0079, 0x007f, 0x0081, 0x00ef,
  0x8084, 0xab54, 0xcd98, 0x0078, 0x007e, 0x0080, 0x0082, 0xfff0,
  0x80ab, 0xab76, 0xcdc4, 0x007d, 0x007f, 0x0081, 0xff83, 0xfff1,
  0x80cd, 0xaba2, 0xcdc9, 0x007e, 0x0080, 0xff82, 0xff84, 0xfff2,
  0x80f9, 0xaba7, 0xcdca, 0x007f, 0xff81, 0xff83, 0xff85, 0xfff8,
  0x80fe, 0xaba8, 0xcdcb, 0xff80, 0xff82, 0xff84, 0xff8b, 0x0023,
  0x80ff, 0xaba9, 0xcccc, 0xff81, 0xff83, 0xff8a, 0xffb6, 0x0045,
  0x8100, 0xaaaa, 0xcccd, 0xff82, 0xff89, 0xffb5, 0xffd8, 0x006d,
  0x8001, 0xaaab, 0xccce, 0xff88, 0xffb4, 0xffd7, 0x0000, 0x006e,
  0x8002, 0xaaac, 0xccd4, 0xffb3, 0xffd6, 0xffff, 0x0001, 0x006f,
  0x8003, 0xaab2, 0xccff, 0xffd5, 0xfffe, 0x0000, 0x0002, 0x0070,
  0x8009, 0xaadd, 0xcd21, 0xfffd, 0xffff, 0x0001, 0x0003, 0x0071,
  0xaadd, 0xcd21, 0xfffd, 0xffff, 0x0001, 0x0003, 0x0071, 0x007f,
  0xaaff, 0xcd49, 0xfffe, 0x0000, 0x0002, 0x0004, 0x0072, 0x0080,
  0xab27, 0xcd4a, 0xffff, 0x0001, 0x0003, 0x0005, 0x0073, 0x00a7,
  0xab28, 0xcd4b, 0x0000, 0x0002, 0x0004, 0x0006, 0x009a, 0x00c9,
  0xab29, 0xcd4c, 0x0001, 0x0003, 0x0005, 0x002d, 0x00bc, 0x00f5,
  0xab2a, 0xcd4d, 0x0002, 0x0004, 0x002c, 0x004f, 0x00e8, 0x00fa,
  0xab2b, 0xcd4e, 0x0003, 0x002b, 0x004e, 0x007b, 0x00ed, 0x00fb,
  0xab2c, 0xcd4f, 0x002a, 0x004d, 0x007a, 0x0080, 0x00ee, 0x00fc,
  0xab2d, 0xcd76, 0x004c, 0x0079, 0x007f, 0x0081, 0x00ef, 0xfffd,
  0xab54, 0xcd98, 0x0078, 0x007e, 0x0080, 0x0082, 0xfff0, 0xfffe,
  0xab76, 0xcdc4, 0x007d, 0x007f, 0x0081, 0xff83, 0xfff1, 0xffff,
  0xaba2, 0xcdc9, 0x007e, 0x0080, 0xff82, 0xff84, 0xfff2, 0x0005,
  0xaba7, 0xcdca, 0x007f, 0xff81, 0xff83, 0xff85, 0xfff8, 0x0030,
  0xaba8, 0xcdcb, 0xff80, 0xff82, 0xff84, 0xff8b, 0x0023, 0x0052,
  0xaba9, 0xcccc, 0xff81, 0xff83, 0xff8a, 0xffb6, 0x0045, 0x007a,
  0xaaaa, 0xcccd, 0xff82, 0xff89, 0xffb5, 0xffd8, 0x006d, 0x007b,
  0xaaab, 0xccce, 0xff88, 0xffb4, 0xffd7, 0x0000, 0x006e, 0x007c,
  0xaaac, 0xccd4, 0xffb3, 0xffd6, 0xffff, 0x0001, 0x006f, 0x007d,
  0xaab2, 0xccff, 0xffd5, 0xfffe, 0x0000, 0x0002, 0x0070, 0x007e,
  0xccff, 0xffd5, 0xfffe, 0x0000, 0x0002, 0x0070, 0x007e, 0x0080,
  0xcd21, 0xfffd, 0xffff, 0x0001, 0x0003, 0x0071, 0x007f, 0x0081,
  0xcd49, 0xfffe, 0x0000, 0x0002, 0x0004, 0x0072, 0x0080, 0x00a8,
  0xcd4a, 0xffff, 0x0001, 0x0003, 0x0005, 0x0073, 0x00a7, 0x00ca,
  0xcd4b, 0x0000, 0x0002, 0x0004, 0x0006, 0x009a, 0x00c9, 0x00f6,
  0xcd4c, 0x0001, 0x0003, 0x0005, 0x002d, 0x00bc, 0x00f5, 0x00fb,
  0xcd4d, 0x0002, 0x0004, 0x002c, 0x004f, 0x00e8, 0x00fa, 0x00fc,
  0xcd4e, 0x0003, 0x002b, 0x004e, 0x007b, 0x00ed, 0x00fb, 0x00fd,
  0xcd4f, 0x002a, 0x004d, 0x007a, 0x0080, 0x00ee, 0x00fc, 0xfffe,
  0xcd76, 0x004c, 0x0079, 0x007f, 0x0081, 0x00ef, 0xfffd, 0xffff,
  0xcd98, 0x0078, 0x007e, 0x0080, 0x0082, 0xfff0, 0xfffe, 0x0000,
  0xcdc4, 0x007d, 0x007f, 0x0081, 0xff83, 0xfff1, 0xffff, 0x0006,
  0xcdc9, 0x007e, 0x0080, 0xff82, 0xff84, 0xfff2, 0x0005, 0x0031,
  0xcdca, 0x007f, 0xff81, 0xff83, 0xff85, 0xfff8, 0x0030, 0x0053,
  0xcdcb, 0xff80, 0xff82, 0xff84, 0xff8b, 0x0023, 0x0052, 0x007b,
  0xcccc, 0xff81, 0xff83, 0xff8a, 0xffb6, 0x0045, 0x007a, 0x007c,
  0xcccd, 0xff82, 0xff89, 0xffb5, 0xffd8, 0x006d, 0x007b, 0x007d,
  0xccce, 0xff88, 0xffb4, 0xffd7, 0x0000, 0x006e, 0x007c, 0x007e,
  0xccd4, 0xffb3, 0xffd6, 0xffff, 0x0001, 0x006f, 0x007d, 0x007f,
  0xffb3, 0xffd6, 0xffff, 0x0001, 0x006f, 0x007d, 0x007f, 0x0081,
  0xffd5, 0xfffe, 0x0000, 0x0002, 0x0070, 0x007e, 0x0080, 0x0082,
  0xfffd, 0xffff, 0x0001, 0x0003, 0x0071, 0x007f, 0x0081, 0x00a9,
  0xfffe, 0x0000, 0x0002, 0x0004, 0x0072, 0x0080, 0x00a8, 0x00cb,
  0xffff, 0x0001, 0x0003, 0x0005, 0x0073, 0x00a7, 0x00ca, 0x00f7,
  0x0000, 0x0002, 0x0004, 0x0006, 0x009a, 0x00c9, 0x00f6, 0x00fc,
  0x0001, 0x0003, 0x0005, 0x002d, 0x00bc, 0x00f5, 0x00fb, 0x00fd,
  0x0002, 0x0004, 0x002c, 0x004f, 0x00e8, 0x00fa, 0x00fc, 0x00fe,
  0x0003, 0x002b, 0x004e, 0x007b, 0x00ed, 0x00fb, 0x00fd, 0xffff,
  0x002a, 0x004d, 0x007a, 0x0080, 0x00ee, 0x00fc, 0xfffe, 0x0000,
  0x004c, 0x0079, 0x007f, 0x0081, 0x00ef, 0xfffd, 0xffff, 0x0001,
  0x0078, 0x007e, 0x0080, 0x0082, 0xfff0, 0xfffe, 0x0000, 0x0007,
  0x007d, 0x007f, 0x0081, 0xff83, 0xfff1, 0xffff, 0x0006, 0x0032,
  0x007e, 0x0080, 0xff82, 0xff84, 0xfff2, 0x0005, 0x0031, 0x0054,
  0x007f, 0xff81, 0xff83, 0xff85, 0xfff8, 0x0030, 0x0053, 0x007c,
  0xff80, 0xff82, 0xff84, 0xff8b, 0x0023, 0x0052, 0x007b, 0x007d,
  0xff81, 0xff83, 0xff8a, 0xffb6, 0x0045, 0x007a, 0x007c, 0x007e,
  0xff82, 0xff89, 0xffb5, 0xffd8, 0x006d, 0x007b, 0x007d, 0x007f,
  0xff88, 0xffb4, 0xffd7, 0x0000, 0x006e, 0x007c, 0x007e, 0x0080,
};
const unsigned kExpectedCount_NEON_uaddw_8H = 456;

#endif  // VIXL_SIM_UADDW_8H_TRACE_AARCH64_H_
