/*
 * uMPS - A general purpose computer system simulator
 *
 * Copyright (C) 2010 Tomislav Jonjic
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef BASE_BASIC_TYPES_H
#define BASE_BASIC_TYPES_H

// Not everyone has stdint.h appearently. Guess who lags behind?
#ifndef _MSC_VER
// Just use C99 `stdint.h'. Should be "anywhere it matters".
# include <stdint.h>
#else
# include <boost/cstdint.hpp>
// Pollute namespace as need arises!
using boost::uint8_t;
using boost::uint32_t;
using boost::int32_t;
using boost::uint64_t;
#endif

#include <cstddef>
using std::size_t;

#endif // BASE_BASIC_TYPES_H
