---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, maquette, 
              sous-bibliographies
---

# Comment obtenir des bibliographies séparées par chapitre ?

## Avec l'extension <ctanpkg:chapterbib>

Pour avoir une bibliographie séparée pour chaque "chapitre" d'un document, 
vous pouvez utiliser l'extension <ctanpkg:chapterbib> (qui fournit pas mal 
d'autres fonctionnalités utiles pour les bibliographies).

Cette extension vous permet d'avoir une bibliographie individuelle 
pour chaque fichier `\include` : ainsi, malgré le nom de l'extension, 
la construction des bibliographies se base sur les différents fichiers sources
du document plutôt que sur les éventuels chapitres définis 
par la structure logique. L'extension permet également d'avoir 
une bibliographie globale pour le document.

L'exemple suivant est décomposé (car ne pouvant être traité sur la FAQ). Tout
d'abord, voici le fichier principal qui contient l'appel aux autres fichiers
avec les commandes `\include`. 

```{noedit}
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chapterbib}

\begin{document}
\include{algo}
\include{math}
\end{document}
```

Voici ensuite les fichiers `algo.tex` et `math.tex` appelés 
par le fichier principal :

```{noedit}
\chapter{Algorithmique}
Donald Knuth\cite{art} est réputé pour ses contributions au domaine.
\bibliographystyle{alpha-fr}
\bibliography{mabiblio} 
```

```{noedit}
\chapter{Mathématiques}
Carl Friedrich Gauss\cite{recherches} marqua durablement les 
mathématiques.
\bibliographystyle{alpha-fr}
\bibliography{mabiblio} 
```

Et voici enfin le fichier BIB `mabiblio.bib` :

```bibtex
@book{recherches,
  title = "Recherches arithmétiques",
  author = "Gauss, Carl Friedrich",
  publisher = "Courcier",
  year = "1807"
}
@book{art,
  title = "The Art of Computer Programming",
  author = "Knuth, Donald Ervin",
  publisher = "Pearson Education",
  year = "1997"
}
```

Une fois le document principal compilé, vous devrez exécuter BibTeX 
sur les fichiers `algo` et `math` puis compiler à nouveau le document
principal (autant de fois que nécessaire pour avoir des références
à jour).  


## Avec l'extension <ctanpkg:bibunits>

L'extension <ctanpkg:bibunits>, elle, lie les bibliographies 
aux unités logiques du document : elle traite les chapitres et les sections 
(comme définis par LaTeX), et définit également un environnement `bibunit` 
afin que l'utilisateur puisse sélectionner sa propre structuration.

```{noedit}
% Deux fichiers BIB créés par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{algo.bib}
  @book{recherches,
    title = "Recherches arithmétiques",
    author = "Gauss, Carl Friedrich",
    publisher = "Courcier",
    year = "1807"
  }
\end{filecontents}
\begin{filecontents}[nosearch,overwrite]{math.bib}
  @book{art,
    title = "The Art of Computer Programming",
    author = "Knuth, Donald Ervin",
    publisher = "Pearson Education",
    year = "1997"
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{report}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{bibunits}

\begin{document}
\bibliographyunit[\chapter]
\bibliographystyle{plain-fr}
\bibliography{geometrie,algorithmes}

\chapter{Algorithmique}
Donald Knuth est réputé pour ses contributions au domaine.
\nocite{*}
\putbib[algo]

\chapter{Mathématiques}
Carl Friedrich Gauss\cite{recherches} marqua durablement les 
mathématiques.
\nocite{*}
\putbib[math]
\end{document}
```

La compilation de cet exemple entraîne la création 
de plusieurs fichiers AUX, qu'il faudra ensuite passer à `BibTeX`.


## Avec l'extension [BibLaTeX](ctanpkg:biblatex) (et <ctanpkg:biber>)

L'extension [BibLaTeX](ctanpkg:biblatex), avec <ctanpkg:biber>, 
fournit une fonction similaire : ajoutez le texte pour lequel vous souhaitez 
une bibliographie locale dans un environnement `refsection`, et ajoutez 
à la fin de cet environnement la commande `\printbibliography` :

```
% Un fichier BIB créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{maths.bib}
  @book{recherches,
    title = "Recherches arithmétiques",
    author = "Gauss, Carl Friedrich",
    publisher = "Courcier",
    year = "1807"
  }
  @book{art,
    title = "The Art of Computer Programming",
    author = "Knuth, Donald Ervin",
    publisher = "Pearson Education",
    year = "1997"
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{biblatex}

  \addbibresource{maths.bib}

\begin{document}
\begin{refsection}
  \section{Algorithmique}
  Donald Knuth\cite{art} est réputé pour ses contributions au domaine.
  \printbibliography[title={Textes de référence}]
\end{refsection}

\begin{refsection}
  \section{Mathématiques}
  Carl Friedrich Gauss\cite{recherches} marqua durablement les 
  mathématiques.
  \printbibliography[title={Textes de référence}]
\end{refsection}
\end{document}
```

Ensuite, compilez avec LaTeX (pdfLaTeX, XeLaTeX, LuaLaTeX... peu importe), 
lancez `biber` pour traiter la bibliographie puis recompilez votre document
pour le finaliser. 

Dans l'exemple ci-dessus, nous avons utilisé un argument optionnel 
pour la commande `\printbibliography` afin qu'elle ait un titre personnalisé.


:::{sources}
- [Separate bibliographies per chapter?](faquk:FAQ-chapbib)
- [How to use chapterbib package: syntax](https://tex.stackexchange.com/q/333617),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::