# 2024-05-21 Triage Log

Fairly quiet week with the exception of a very large improvement coming from the switch to `rust-lld` on nightly Linux. This can have very large impacts on benchmarks where linking dominates the build time (e.g., `ripgrep`, `exa`, small binaries like `hello-world`). Aside from that change, there were a few small regressions that were either deemed worth it or are still being investigated.

Triage done by **@rylev**.
Revision range: [9105c57b..1d0e4afd](https://perf.rust-lang.org/?start=9105c57b7f6623310e33f3ee7e48a3114e5190a7&end=1d0e4afd4cac09078e12a232508c3e9f8d42535d&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean   | range           | count |
|:----------------------------------:|:------:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%   | [0.1%, 2.5%]    | 30    |
| Regressions ❌ <br /> (secondary)  | 0.5%   | [0.2%, 0.8%]    | 5     |
| Improvements ✅ <br /> (primary)   | -30.4% | [-71.7%, -0.4%] | 35    |
| Improvements ✅ <br /> (secondary) | -25.6% | [-70.9%, -0.5%] | 75    |
| All ❌✅ (primary)                 | -16.1% | [-71.7%, 2.5%]  | 65    |


4 Regressions, 1 Improvement, 4 Mixed; 2 of them in rollups
66 artifact comparisons made in total

#### Regressions

Add x86_64-unknown-linux-none target [#125023](https://github.com/rust-lang/rust/pull/125023) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c45e831d8fcd33d656047ba97d263c4b91a00735&end=31026b7fe3e510a646eddeda838d1f0859f892e7&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6% | [0.2%, 1.0%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.4%, 0.4%] | 3     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.6% | [0.2%, 1.0%] | 3     |
- Noise


Rollup of 6 pull requests [#125144](https://github.com/rust-lang/rust/pull/125144) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3cb0030fe9de01eeacb7c03eeef0c51420798cfb&end=ade234d5743795423db6cc7cd52541390a088eab&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.2%, 1.2%] | 3     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.2%, 1.2%] | 3     |


Update `expr` matcher for Edition 2024 and add `expr_2021` nonterminal [#123865](https://github.com/rust-lang/rust/pull/123865) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1a7397988684934ae01a71f524bdfff24895d8cc&end=9b75a4388143a163b77fa7d458e4aa4dd34ac1bd&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.3%] | 5     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.2%, 1.7%] | 7     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.3%] | 5     |
- It seems the primary benchmark affected by this html5ever seems to spend lots of time in expand_crate which could be impacted by this change. 
- Asked authors and reviewer whether this is worth an investigation or not.


Update `unexpected_cfgs` lint for Cargo new `check-cfg` config [#125219](https://github.com/rust-lang/rust/pull/125219) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=be71fd477243f253a735bb35e0cd23cc528cf30a&end=b92758a9aef1cef7b79e2b72c3d8ba113e547f89&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.2%, 2.5%] | 21    |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.2%, 0.2%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.2%, 2.5%] | 21    |
- Somewhat further fall out from https://github.com/rust-lang/rust/pull/124684. This adds additional output which will slow down benchmarks which emit this warning particularly often.
- We're likely ok with this given this is the "unhappy path".


#### Improvements

Enable `rust-lld` on nightly `x86_64-unknown-linux-gnu` [#124129](https://github.com/rust-lang/rust/pull/124129) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fa37db51ac2ba8d20eb88079cb3234d0072c5c3a&end=8af67ba01a1b1d95ff375b645ef5a395d3249e09&stat=instructions:u)

| (instructions:u)                   | mean   | range           | count |
|:----------------------------------:|:------:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -      | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -      | -               | 0     |
| Improvements ✅ <br /> (primary)   | -30.8% | [-71.8%, -0.5%] | 31    |
| Improvements ✅ <br /> (secondary) | -25.6% | [-70.9%, -0.5%] | 75    |
| All ❌✅ (primary)                 | -30.8% | [-71.8%, -0.5%] | 31    |


#### Mixed

Rollup of 7 pull requests [#125120](https://github.com/rust-lang/rust/pull/125120) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bdfd941f4dcbe54e0283433ac970febf4092fa6a&end=ac385a5af6d9fa8399a0cec799833cd28324abf8&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.3%, 1.0%]   | 12    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.4%] | 2     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 2     |
- Caused by https://github.com/rust-lang/rust/pull/125088. Asked the author/reviewers whether this is worth following up on.


Remove bound checks from `BorrowedBuf` and `BorrowedCursor` methods [#123786](https://github.com/rust-lang/rust/pull/123786) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=698293518de49ac79eb7874e97557f8e2eabda06&end=959a67a7f2215d80b55e765d6c4b3f5a711ad484&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.8%, 0.8%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 1.3%  | [1.3%, 1.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.7% | [-1.7%, -1.7%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.5% | [-1.7%, 0.8%]  | 2     |
- Noise


optimize inplace collection of Vec [#123878](https://github.com/rust-lang/rust/pull/123878) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d84b9037541f45dc2c52a41d723265af211c0497&end=12075f04e677de64f740687f601114e2a21e09ca&stat=instructions:u)

| (instructions:u)                   | mean   | range           | count |
|:----------------------------------:|:------:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4%   | [0.3%, 2.9%]    | 3     |
| Regressions ❌ <br /> (secondary)  | 0.3%   | [0.2%, 0.3%]    | 2     |
| Improvements ✅ <br /> (primary)   | -22.7% | [-37.4%, -0.4%] | 5     |
| Improvements ✅ <br /> (secondary) | -      | -               | 0     |
| All ❌✅ (primary)                 | -13.7% | [-37.4%, 2.9%]  | 8     |
- Improvements vastly outweigh the regressions which seemed to have returned to baseline after this PR.


Follow-up fixes to `report_return_mismatched_types` [#123812](https://github.com/rust-lang/rust/pull/123812) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1d0e4afd4cac09078e12a232508c3e9f8d42535d&end=e8753914580fb42554a79a4b5c5fb4cc98933231&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [0.6%, 1.8%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.2%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.1%, -1.1%] | 2     |
| All ❌✅ (primary)                 | 1.1%  | [0.6%, 1.8%]   | 3     |
- Single benchmark with a large regression. Asked author to investigate.

