% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_package}
\alias{create_package}
\alias{create_project}
\title{Create a package or project}
\usage{
create_package(
  path,
  fields = list(),
  rstudio = rstudioapi::isAvailable(),
  roxygen = TRUE,
  check_name = TRUE,
  open = rlang::is_interactive()
)

create_project(
  path,
  rstudio = rstudioapi::isAvailable(),
  open = rlang::is_interactive()
)
}
\arguments{
\item{path}{A path. If it exists, it is used. If it does not exist, it is
created, provided that the parent path exists.}

\item{fields}{A named list of fields to add to \code{DESCRIPTION}, potentially
overriding default values. See \code{\link[=use_description]{use_description()}} for how you can set
personalized defaults using package options}

\item{rstudio}{If \code{TRUE}, calls \code{\link[=use_rstudio]{use_rstudio()}} to make the new package or
project into an \href{https://support.rstudio.com/hc/en-us/articles/200526207-Using-Projects}{RStudio Project}.
If \code{FALSE} and a non-package project, a sentinel \code{.here} file is placed so
that the directory can be recognized as a project by the
\href{https://here.r-lib.org}{here} or
\href{https://rprojroot.r-lib.org}{rprojroot} packages.}

\item{roxygen}{Do you plan to use roxygen2 to document your package?}

\item{check_name}{Whether to check if the name is valid for CRAN and throw an
error if not}

\item{open}{If \code{TRUE}, \link[=proj_activate]{activates} the new project:
\itemize{
\item If RStudio desktop, the package is opened in a new session.
\item If on RStudio server, the current RStudio project is activated.
\item Otherwise, the working directory and active project is changed.
}}
}
\value{
Path to the newly created project or package, invisibly.
}
\description{
These functions create an R project:
\itemize{
\item \code{create_package()} creates an R package
\item \code{create_project()} creates a non-package project, i.e. a data analysis
project
}

Both functions can be called on an existing project; you will be asked before
any existing files are changed.
}
\seealso{
\code{\link[=create_tidy_package]{create_tidy_package()}} is a convenience function that extends
\code{create_package()} by immediately applying as many of the tidyverse
development conventions as possible.
}
