#' Sensory data from a french fries experiment.
#'
#' This data was collected from a sensory experiment conducted at Iowa State
#' University in 2004.  The investigators were interested in the effect of
#' using three different fryer oils had on the taste of the fries.
#'
#' Variables:
#'
#' \itemize{
#'   \item time in weeks from start of study.
#'   \item treatment (type of oil),
#'   \item subject,
#'   \item replicate,
#'   \item potato-y flavour,
#'   \item buttery flavour,
#'   \item grassy flavour,
#'   \item rancid flavour,
#'   \item painty flavour
#' }
#'
#' @docType data
#' @format A data frame with 696 rows and 9 variables
#' @keywords datasets
"french_fries"

#' Demo data describing the Smiths.
#'
#' A small demo dataset describing John and Mary Smith.  Used in the
#' introductory vignette.
#'
#' @docType data
#' @format A data frame with 2 rows and 5 variables
#' @keywords datasets
"smiths"

#' Tipping data
#'
#'
#' One waiter recorded information about each tip he received over a
#' period of a few months working in one restaurant. He collected several
#' variables:
#'
#' \itemize{
#'  \item tip in dollars,
#'  \item bill in dollars,
#'  \item sex of the bill payer,
#'  \item whether there were smokers in the party,
#'  \item day of the week,
#'  \item time of day,
#'  \item size of the party.
#' }
#'
#' In all he recorded 244 tips. The data was reported in a collection of
#' case studies for business statistics (Bryant & Smith 1995).
#'
#' @references Bryant, P. G. and Smith, M (1995) \emph{Practical Data
#'   Analysis: Case Studies in Business Statistics}.  Homewood, IL: Richard D.
#'   Irwin Publishing:
#' @format A data frame with 244 rows and 7 variables
#' @keywords datasets
"tips"


