% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{spinglass.community}
\alias{spinglass.community}
\title{Finding communities in graphs based on statistical meachanics}
\usage{
spinglass.community(
  graph,
  weights = NULL,
  vertex = NULL,
  spins = 25,
  parupdate = FALSE,
  start.temp = 1,
  stop.temp = 0.01,
  cool.fact = 0.99,
  update.rule = c("config", "random", "simple"),
  gamma = 1,
  implementation = c("orig", "neg"),
  gamma.minus = 1
)
}
\arguments{
\item{graph}{The input graph. Edge directions are ignored in directed graphs.}

\item{weights}{The weights of the edges. It must be a positive numeric vector,
\code{NULL} or \code{NA}. If it is \code{NULL} and the input graph has a
\sQuote{weight} edge attribute, then that attribute will be used. If
\code{NULL} and no such attribute is present, then the edges will have equal
weights. Set this to \code{NA} if the graph was a \sQuote{weight} edge
attribute, but you don't want to use it for community detection. A larger
edge weight means a stronger connection for this function.}

\item{vertex}{This parameter can be used to calculate the community of a
given vertex without calculating all communities. Note that if this argument
is present then some other arguments are ignored.}

\item{spins}{Integer constant, the number of spins to use. This is the upper
limit for the number of communities. It is not a problem to supply a
(reasonably) big number here, in which case some spin states will be
unpopulated.}

\item{parupdate}{Logical constant, whether to update the spins of the
vertices in parallel (synchronously) or not. This argument is ignored if the
second form of the function is used (i.e. the \sQuote{\code{vertex}} argument
is present). It is also not implemented in the \dQuote{neg} implementation.}

\item{start.temp}{Real constant, the start temperature.  This argument is
ignored if the second form of the function is used (i.e. the
\sQuote{\code{vertex}} argument is present).}

\item{stop.temp}{Real constant, the stop temperature. The simulation
terminates if the temperature lowers below this level.  This argument is
ignored if the second form of the function is used (i.e. the
\sQuote{\code{vertex}} argument is present).}

\item{cool.fact}{Cooling factor for the simulated annealing.  This argument
is ignored if the second form of the function is used (i.e. the
\sQuote{\code{vertex}} argument is present).}

\item{update.rule}{Character constant giving the \sQuote{null-model} of the
simulation. Possible values: \dQuote{simple} and \dQuote{config}.
\dQuote{simple} uses a random graph with the same number of edges as the
baseline probability and \dQuote{config} uses a random graph with the same
vertex degrees as the input graph.}

\item{gamma}{Real constant, the gamma argument of the algorithm. This
specifies the balance between the importance of present and non-present
edges in a community. Roughly, a comunity is a set of vertices having many
edges inside the community and few edges outside the community. The default
1.0 value makes existing and non-existing links equally important. Smaller
values make the existing links, greater values the missing links more
important.}

\item{implementation}{Character scalar. Currently igraph contains two
implementations for the Spin-glass community finding algorithm. The faster
original implementation is the default. The other implementation, that takes
into account negative weights, can be chosen by supplying \sQuote{neg} here.}

\item{gamma.minus}{Real constant, the gamma.minus parameter of the
algorithm. This specifies the balance between the importance of present and
non-present negative weighted edges in a community. Smaller values of
gamma.minus, leads to communities with lesser negative intra-connectivity.
If this argument is set to zero, the algorithm reduces to a graph coloring
algorithm, using the number of spins as the number of colors. This argument
is ignored if the \sQuote{orig} implementation is chosen.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{spinglass.community()} was renamed to \code{\link[=cluster_spinglass]{cluster_spinglass()}} to create a more
consistent API.
}
\keyword{internal}
