% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{parseCssColors}
\alias{parseCssColors}
\title{Parse CSS color strings}
\usage{
parseCssColors(str, mustWork = TRUE)
}
\arguments{
\item{str}{CSS color strings}

\item{mustWork}{If true, invalid color strings will cause an error; if false,
then the result will contain \code{NA} for invalid colors.}
}
\value{
A vector of strings in \verb{#RRGGBB} or \verb{#RRGGBBAA} format (the latter is
only used for colors whose alpha values are less than \code{FF}), or \code{NA} for
invalid colors when \code{mustWork} is false. Such strings are suitable for
use in plots, or parsing with \code{\link[=col2rgb]{col2rgb()}} (be sure to pass \code{alpha = TRUE}
to prevent the alpha channel from being discarded).
}
\description{
Parses/normalizes CSS color strings, and returns them as strings in
\code{"#RRGGBB"} and/or \code{"#RRGGBBAA"} format. Understands hex colors in 3, 4, 6,
and 8 digit forms, \code{rgb()}/\code{rgba()}, \code{hsl()}/\code{hsla()}, and color keywords.
}
\details{
Note that \code{parseCssColors} may return colors in \verb{#RRGGBBAA} format. Such
values are not understood by Internet Explorer, and must be converted to
\code{rgba(red, green, blue, alpha)} format to be safe for the web.
}
\examples{

parseCssColors(c(
  "#0d6efd",
  "#DC35457F",
  "rgb(32,201,151)",
  "  rgba( 23 , 162 , 184 , 0.5 )  ",
  "hsl(261, 51\%, 51\%)",
  "cornflowerblue"
))
}
