% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequence.R
\name{nonsquareDist}
\alias{nonsquareDist}
\title{Calculate pairwise distances between sequences}
\usage{
nonsquareDist(seq, indx, dist_mat = getDNAMatrix())
}
\arguments{
\item{seq}{character vector containing a DNA sequences. The sequence vector needs to
be named.}

\item{indx}{numeric vector contating the indices (a subset of indices of \code{seq}).}

\item{dist_mat}{Character distance matrix. Defaults to a Hamming distance 
matrix returned by \link{getDNAMatrix}. If gap 
characters, \code{c("-", ".")}, are assigned a value of -1 
in \code{dist_mat} then contiguous gaps of any run length,
which are not present in both sequences, will be counted as a 
distance of 1. Meaning, indels of any length will increase
the sequence distance by 1. Gap values other than -1 will 
return a distance that does not consider indels as a special case.}
}
\value{
A matrix of numerical distance between each entry in \code{seq} and 
          sequences specified by \code{indx} indices. 
          
          Note that the input subsampled indices will be ordered ascendingly. Therefore, 
          it is necassary to assign unique names to the input sequences, \code{seq}, 
          to recover the input order later. Row and columns names will be added accordingly.

          Amino acid distance matrix may be built with \link{getAAMatrix}. 
          Uses \link{seqDist} for calculating distances between pairs.
          See \link{pairwiseEqual} for generating an equivalence matrix.
}
\description{
\code{nonsquareDist} calculates all pairwise distance between a set of sequences and a subset of it.
}
\examples{
# Gaps will be treated as Ns with a gap=0 distance matrix
seq <- c(A="ATGGC", B="ATGGG", C="ATGGG", D="AT--C")
pairwiseDist(seq, 
             dist_mat=getDNAMatrix(gap=0))

nonsquareDist(seq, indx=c(1,3), 
             dist_mat=getDNAMatrix(gap=0))

}
