% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_profile_heatmap.R
\name{plot_profile_heatmap}
\alias{plot_profile_heatmap}
\title{Plot a mutation matrix as a heatmap}
\usage{
plot_profile_heatmap(mut_matrix, by = NA, max = 0.02, condensed = FALSE)
}
\arguments{
\item{mut_matrix}{Matrix containing mutation counts.}

\item{by}{Optional grouping variable}

\item{max}{Maximum value used for plotting the relative contributions.
Contributions that are higher will have the maximum colour. (Default: 0.02)}

\item{condensed}{More condensed plotting format. Default = F.}
}
\value{
A ggplot object
}
\description{
Function to plot a SNV mutation matrix as a heatmap.
This is especially useful when looking at a wide mutational context.
}
\examples{

## See the 'mut_matrix()' examples for how we obtained the
## mutation matrix information:
## Get regular matrix
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
  package = "MutationalPatterns"
))

## Create heatmap of profile
plot_profile_heatmap(mut_mat, max = 0.1)

## Get extended matrix
mut_mat_extended <- readRDS(system.file("states/mut_mat_data_extended.rds",
  package = "MutationalPatterns"
))

## Create heatmap of extended profile
plot_profile_heatmap(mut_mat_extended)

## Or plot heatmap per tissue
tissue <- c(
  "colon", "colon", "colon",
  "intestine", "intestine", "intestine",
  "liver", "liver", "liver"
)

plot_profile_heatmap(mut_mat_extended, by = tissue)

## Or plot the heatmap per sample.
plot_profile_heatmap(mut_mat_extended,
  by = colnames(mut_mat_extended),
  max = 0.05
)


## Create a condensed heatmap of extended profile
plot_profile_heatmap(mut_mat_extended, condensed = TRUE)
}
\seealso{
\code{\link{mut_matrix}},
\code{\link{plot_96_profile}},
\code{\link{plot_river}}
}
