# First Contentful Paint Changes in M77

## Changes in Chrome 77
In Chrome 77, two changes to the First Contentful Paint (FCP) metric occurred:

* **The way the metric is computed was changed.** The change improves accuracy of the metric. Previously, the metric end time was the `swap time`--the time at which the compositor frame is sent to the display compositor. The metric was updated to end at the `presentation time` instead. The presentation time is the time pixels actually appear on screen, according to the GPU. The presentation time occurs after the swap time, so the metric duration is longer after this change. [The source code of the change can be seen here](https://chromium-review.googlesource.com/c/chromium/src/+/1598212).
* **There was an additional regression in Chrome's performance on the metric.** In Chrome 77, FCP went up more than expected from the metric change. This points to a performance regression in Chrome. We were not able to find the source of the regression, but the additional regression beyond the metric change **recovered in M78**.

## How does this affect a site's metrics?
These changes will affect the [RUM API](https://developer.mozilla.org/en-US/docs/Web/API/PerformancePaintTiming) data, the data reported in [Chrome User Experience Report](https://developers.google.com/web/tools/chrome-user-experience-report), the values reported in [Chrome Devtools](https://developers.google.com/web/tools/chrome-devtools), and in [Lighthouse](https://developers.google.com/web/tools/lighthouse).

The metric now includes the time between swap time and presentation time, which is measured internally by the Chrome team in the `PageLoad.Internal.Renderer.PresentationTime.DeltaFromSwapTime` metric. How it affects a site will depend on the devices accessing the site, which can vary quite a bit in performance.

* On Android, the swap time is generally between **10 milliseconds** and **65 milliseconds**.
* On Windows, the swap time is generally between **3 milliseconds** and **55 milliseconds**.

The performance regression in M77 will also vary depending on the usage of the site. This regression recovered in M78, so a site can understand the impact by comparing its metrics from M77 and M78.

* On Android, the median impact of the M77 performance regression was about **40 milliseconds**.
* On Windows, the median impact of the M77 performance regression was about **50 milliseconds**.

## When were users affected?

On Android, Chrome was updated by most users:

* To version 77 on September 24
* To version 78 on October 29

On Windows, Chrome was updated by most users:

* To version 77 on September 25
* To version 78 on November 5