/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *                 Jehan <jehan@girinstud.io>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsSBCharSetProber.h"
/****************************************************************
ILL: illegal character.
CTR: control character specific to the charset.
RET: carriage/return.
SYM: symbol (punctuation) that does not belong to word.
NUM: 0 - 9.

*****************************************************************/
static unsigned char Latin11CharToOrderMap[] =
{
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, // 00
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, // 10
SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, // 20
NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, // 30
SYM, 75, 70, 68, 76, 80, 77, 84, 86, 66, 85,101, 82, 81, 78, 89, // 40
 61,103, 79, 64, 73, 95, 93, 83,104,100,102,SYM,SYM,SYM,SYM,SYM, // 50
SYM, 36, 71, 53, 49, 39, 67, 60, 54, 41, 99, 88, 48, 57, 44, 40, // 60
 62, 97, 43, 45, 46, 52, 72, 92, 98, 65, 91,SYM,SYM,SYM,SYM,CTR, // 70
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, // 80
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, // 90
SYM,  3, 25,105, 17,106, 96,  5, 22, 56, 23, 30, 74, 35, 63, 58, // a0
 42, 90, 69, 38, 11, 15, 31, 13, 32,  2, 19, 16, 37, 50, 18, 47, // b0
 33,  7,  8,  1, 51,  9,107, 10, 28, 34, 12, 21, 87,  4, 59, 94, // c0
 14,SYM,  0, 29,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,ILL,ILL,ILL,SYM, // d0
  6, 20, 26, 24, 27,108, 55,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,109, // e0
NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,110,111,ILL,ILL,ILL,ILL, // f0
};

static unsigned char TIS620CharToOrderMap[] =
{
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, // 00
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, // 10
SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, // 20
NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, // 30
SYM, 75, 70, 68, 76, 80, 77, 84, 86, 66, 85,101, 82, 81, 78, 89, // 40
 61,103, 79, 64, 73, 95, 93, 83,104,100,102,SYM,SYM,SYM,SYM,SYM, // 50
SYM, 36, 71, 53, 49, 39, 67, 60, 54, 41, 99, 88, 48, 57, 44, 40, // 60
 62, 97, 43, 45, 46, 52, 72, 92, 98, 65, 91,SYM,SYM,SYM,SYM,CTR, // 70
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, // 80
CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, // 90
ILL,  3, 25,105, 17,112, 96,  5, 22, 56, 23, 30, 74, 35, 63, 58, // a0
 42, 90, 69, 38, 11, 15, 31, 13, 32,  2, 19, 16, 37, 50, 18, 47, // b0
 33,  7,  8,  1, 51,  9,113, 10, 28, 34, 12, 21, 87,  4, 59, 94, // c0
 14,SYM,  0, 29,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,ILL,ILL,ILL,SYM, // d0
  6, 20, 26, 24, 27,114, 55,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,115, // e0
NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,116,117,ILL,ILL,ILL,ILL, // f0
};


/* Model Table:
 * total sequences: 2226
 * first 512 sequences: 0.883855639258837
 * next 512 sequences (512-1024): 0.09168123715915569
 * rest: 0.02446312358200728
 */
char ThaiLangModel[] = 
{
0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,
3,2,3,2,0,2,3,0,0,0,1,0,0,0,0,2,0,0,1,0,0,0,0,0,1,0,1,1,0,0,0,0,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,3,3,2,3,2,1,2,3,
1,2,3,1,0,2,3,0,0,0,1,0,0,0,0,2,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,
3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,
3,3,1,1,0,3,0,0,0,0,2,0,0,0,0,2,0,0,2,1,0,0,0,1,1,0,0,1,0,0,0,0,
3,3,3,3,3,2,3,3,2,3,3,3,3,3,2,3,3,3,3,2,3,2,3,2,3,3,2,3,2,3,2,2,
1,2,3,1,0,2,1,0,0,0,2,0,0,0,0,1,0,0,1,3,0,0,0,1,1,0,2,1,0,0,0,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,3,3,2,3,2,2,2,2,2,3,1,3,1,2,
2,3,1,1,0,2,0,0,0,0,0,0,0,0,0,2,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,
3,3,3,3,3,2,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,3,
1,2,1,2,0,3,0,0,0,0,1,0,0,0,0,1,0,0,2,1,0,0,0,2,2,0,0,1,0,0,0,0,
0,3,3,3,3,2,0,3,3,3,3,3,3,3,0,3,3,3,3,3,0,3,3,3,0,3,0,0,3,0,3,2,
2,2,2,0,0,2,1,0,0,0,0,0,0,0,0,3,0,0,1,0,0,0,0,0,3,0,0,2,0,0,0,0,
3,3,3,3,3,2,3,3,2,2,3,3,3,3,2,3,3,3,3,3,3,3,2,3,3,3,3,3,2,0,2,2,
1,2,3,1,0,2,2,0,0,0,1,0,0,0,0,1,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,1,
3,3,3,3,3,3,3,3,2,3,3,2,3,3,2,3,3,3,3,3,3,2,2,3,3,3,2,3,2,1,2,2,
1,2,0,2,0,2,1,0,0,0,1,0,0,0,0,1,0,0,2,0,0,0,0,1,1,0,0,1,0,0,0,1,
3,2,3,3,3,3,3,2,2,3,3,3,3,3,3,2,2,2,2,2,3,2,2,2,2,3,2,2,1,2,2,1,
1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,2,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,
3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,3,3,1,0,1,2,
0,1,0,1,0,1,2,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,
3,3,3,3,3,3,3,3,3,2,2,2,3,3,1,3,2,3,2,2,3,2,2,2,3,3,2,2,1,3,1,2,
1,2,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,1,0,0,1,0,0,0,0,
3,3,3,2,3,3,3,3,1,3,3,3,1,2,2,3,1,2,2,3,3,3,2,1,2,2,2,2,0,3,2,3,
2,3,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,
3,3,3,1,3,1,2,2,3,1,3,2,2,1,3,0,1,3,1,2,1,3,1,1,1,1,1,1,3,3,1,1,
3,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
0,3,3,3,3,1,3,3,3,2,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,2,3,3,2,0,1,2,
2,2,0,1,0,2,1,0,0,0,1,0,0,0,0,1,0,0,1,1,0,0,0,0,1,0,0,2,0,0,0,0,
3,3,3,3,3,1,3,2,2,2,3,1,2,2,3,2,2,1,1,2,2,1,2,2,2,2,1,2,1,2,1,2,
1,2,0,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,1,3,1,3,3,1,3,2,2,2,2,2,1,1,1,3,1,2,1,2,1,2,2,1,0,2,2,
1,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,3,1,0,0,0,0,
3,3,3,2,3,3,2,3,2,3,3,2,2,2,2,2,1,2,2,2,2,1,1,2,2,1,2,1,1,3,1,0,
0,1,0,0,0,1,2,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,2,2,3,2,3,2,3,3,3,1,2,2,1,1,1,1,2,3,2,1,1,1,2,2,3,1,2,1,1,1,
1,1,0,2,0,1,1,0,0,0,0,0,0,0,0,1,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,2,3,2,2,2,3,3,3,3,1,2,3,3,2,3,2,2,2,2,3,2,2,3,1,1,1,2,
1,2,0,1,0,2,0,0,0,0,1,0,0,0,0,1,0,0,2,0,0,0,0,0,1,0,2,1,0,0,0,0,
0,3,3,3,3,1,0,3,2,3,2,3,3,3,0,3,2,3,2,3,0,3,1,2,0,2,0,0,0,0,2,2,
0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,
3,3,3,2,1,1,0,3,2,3,3,1,2,1,1,3,1,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,
0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,2,3,1,2,3,1,2,2,2,2,2,3,2,1,1,3,2,2,1,3,1,2,2,1,2,1,3,1,1,
0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
3,1,3,3,3,1,2,2,2,2,3,1,3,2,1,1,1,1,1,3,2,1,1,2,1,1,2,1,1,1,0,0,
2,1,1,2,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
0,0,3,2,0,0,0,0,0,0,0,2,2,0,0,3,0,1,0,1,0,3,3,3,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,1,2,1,3,0,1,1,2,1,2,1,1,1,0,3,1,1,0,2,1,1,1,1,1,1,1,1,0,1,1,1,
0,1,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,3,2,3,3,1,0,2,3,3,1,3,1,2,0,3,3,3,2,2,0,1,3,1,0,1,0,0,1,0,3,1,
1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,
0,3,1,2,2,0,0,3,0,2,3,3,1,3,0,2,3,1,1,1,0,2,0,1,0,3,0,0,0,0,2,0,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
3,3,2,2,2,0,3,1,2,1,2,1,3,2,0,3,1,1,2,1,2,1,2,1,2,2,1,2,1,0,1,1,
0,0,2,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,3,3,3,2,2,3,2,1,3,2,2,2,2,0,2,2,3,2,1,3,3,1,1,3,2,2,2,1,0,1,1,
1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,
3,1,2,1,2,2,3,1,1,1,1,1,1,1,2,2,1,1,0,1,1,0,0,0,1,1,1,1,0,0,1,0,
0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,1,2,2,2,0,2,2,2,2,1,1,1,1,0,1,1,1,1,2,1,1,1,1,1,1,1,1,0,0,0,1,
0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,2,2,2,2,1,3,2,0,1,1,1,1,1,1,1,1,1,0,1,1,0,1,1,1,1,1,2,0,0,0,
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,2,0,0,1,0,0,0,0,0,0,0,1,2,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,1,1,2,1,0,1,1,2,0,0,1,1,2,2,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0,1,1,
0,2,0,0,0,1,2,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,2,
3,1,1,1,1,0,2,1,1,1,1,1,1,2,0,1,1,1,1,1,2,2,1,2,2,1,1,1,0,0,1,1,
1,1,0,3,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,1,1,2,0,3,3,2,3,0,3,2,0,0,2,2,1,0,0,2,0,0,2,0,1,0,
1,0,2,0,0,1,0,1,2,3,1,1,2,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,2,1,2,1,1,1,1,1,1,1,1,1,1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,
1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,0,0,1,1,2,0,3,3,3,2,0,2,2,0,0,1,2,1,0,0,2,0,0,1,1,2,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,1,2,1,0,3,3,2,2,0,2,2,0,0,2,1,1,0,0,2,0,0,2,0,2,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,3,0,0,2,3,0,0,2,3,3,2,0,2,2,0,0,1,2,1,0,0,2,0,0,2,0,2,0,
3,1,1,2,3,0,2,3,0,0,1,0,2,1,0,1,2,1,1,3,1,1,1,1,1,1,1,1,1,0,1,0,
2,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,3,0,0,3,2,3,0,2,2,2,2,0,2,2,0,0,1,1,1,0,0,2,0,0,2,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,0,0,0,2,0,0,2,2,2,0,0,1,2,2,0,1,3,0,0,1,2,1,0,0,1,0,0,2,0,0,0,
0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,0,0,2,2,2,0,1,0,2,3,0,1,1,0,0,1,1,2,0,0,1,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,0,0,2,2,3,0,2,1,1,1,0,1,1,0,0,2,1,2,0,0,1,0,0,0,0,1,0,
2,3,1,1,2,0,2,1,0,2,1,0,1,1,1,2,1,1,0,0,1,0,0,1,1,0,1,1,0,0,1,0,
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,3,0,0,2,2,2,0,0,0,1,1,0,2,2,0,0,2,1,1,0,0,1,0,0,1,0,0,0,
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,0,0,3,2,2,0,2,0,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0,0,0,0,
1,3,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,0,0,0,2,0,1,0,2,0,0,0,0,0,1,0,0,0,0,0,0,2,0,0,0,
0,0,3,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,0,0,2,1,1,0,2,2,2,2,0,2,1,0,0,0,1,0,0,0,1,0,0,2,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,0,0,2,2,2,0,1,0,1,1,0,1,0,0,0,1,1,2,0,0,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,0,0,2,2,2,0,1,1,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,1,1,0,1,1,0,0,1,0,1,1,0,0,0,1,0,1,1,0,1,1,1,1,0,1,0,0,0,1,
0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,1,1,1,0,1,0,1,1,2,1,0,0,0,1,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,0,0,2,2,2,0,1,0,1,0,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,2,0,
1,1,0,1,1,0,1,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,0,0,2,1,1,0,2,1,1,1,0,1,1,0,0,2,1,1,0,0,1,0,0,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,0,0,2,2,1,0,2,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,0,0,2,2,1,0,1,0,1,1,0,1,1,0,0,1,0,1,0,0,1,0,0,0,0,1,0,
2,2,1,1,1,0,1,0,0,0,0,0,1,0,0,0,0,1,0,1,0,2,0,0,0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


SequenceModel Latin11_ThaiModel =
{
  Latin11CharToOrderMap,
  ThaiLangModel,
  64,
  (float)0.883855639258837,
  PR_FALSE,
  "ISO-8859-11"
};

SequenceModel TIS620_ThaiModel = 
{
  TIS620CharToOrderMap,
  ThaiLangModel,
  64,
  (float)0.883855639258837,
  PR_FALSE,
  "TIS-620"
};
