# React/Redux Links
Curated tutorial and resource links I've collected on React, Redux, ES6, and more, meant to be a collection of high-quality articles and resources for someone who wants to learn about the React-Redux ecosystem, as well as a source for quality information on advanced topics and techniques.  Not quite "awesome", but hopefully useful as a starting point I can give to others.  Suggestions welcome.

Another important resource is the **Reactiflux community on Discord**, which has chat channels dedicated to discussion of React, Redux, and other related technologies.  There's always a number of people hanging out and answering questions, and it's a great place to ask questions and learn.  The invite link is at **https://www.reactiflux.com**.

You might also want to check out my categorized list of Redux-related addons, libraries, and utilities, at [Redux Ecosystem Links](https://github.com/markerikson/redux-ecosystem-links).  Also see [Community Resources](community-resources.md) for links to other links lists, podcasts, and email newsletters.  Finally, I also keep a dev blog at [blog.isquaredsoftware.com](http://blog.isquaredsoftware.com), where I write about React, Redux, Webpack, and more.


## Table of Contents

#### Getting Started
- [Basic Concepts and Overviews](./basic-concepts.md)
- [Community Resources](./community-resources.md)
- [Javascript Resources](./javascript-resources.md)
- [Git Resources and Tutorials](./git-resources.md)
- [Node.js and NPM](./node-js-and-npm.md)
- [Webpack Tutorials](./webpack-tutorials.md)
- [Boilerplates and Starter Kits](./boilerplates-and-starter-kits.md)

#### Basic Tutorials
- [ES6 Features and Samples](./es6-features.md)
- [React Tutorials](./react-tutorials.md)
- [Flux Tutorials](./flux-tutorials.md)
- [Redux Tutorials](./redux-tutorials.md)
- [MobX Tutorials](./mobx-tutorials.md)

#### Intermediate Concepts

- [Using React with ES6](./using-react-with-es6.md)
- [Functional Programming](./functional-programming.md)
- [Immutable Data](./immutable-data.md)
- [React/Redux Testing](./react-redux-testing.md)
- [React Native](./react-native.md)
- [React Tips and Techniques](./react-techniques.md)

#### Advanced Topics

- **Architecture and Structure**
  - [Project Structure](./project-structure.md)
  - [React Component Patterns](./react-component-patterns.md)
  - [React Component Composition](./react-component-composition.md)
  - [React State Management](./react-state-management.md)
  - [React Architecture and Best Practices](./react-architecture.md)
  - [Redux Architecture and Best Practices](./redux-architecture.md)
  - [React/Redux Performance](./react-performance.md)
  - [React Deployment](./react-deployment.md)
- **React**:
  - [React Implementation and Concepts](./react-implementation.md)
  - [React and Forms](./react-forms.md)
  - [React and AJAX](./react-ajax.md)
  - [React Styling](./react-styling.md)
  - [React Server Rendering](./react-server-rendering.md)
  - [React and Routing](./react-routing.md)  
- **Redux**
  - [Redux Reducers and Selectors](./redux-reducers-selectors.md)
  - [Redux Middleware](./redux-middleware.md)
  - [Redux Side Effects](./redux-side-effects.md)
  - [Redux UI Management](./redux-ui-management.md)
  - [Redux Tips and Techniques](./redux-techniques.md)
  - [Using Redux Without React](./redux-without-react.md)
- **Other**
  - [Webpack Advanced Techniques](./webpack-advanced-techniques.md)
  - [Static Typing](./static-typing.md)


#### Comparisons and Discussion
- [React/Flux/Redux Pros, Cons, and Discussion](./pros-cons-discussion.md)
- [Framework Comparisons](./framework-comparisons.md)




## Best of the Best / Suggested Reading List

All of the links in this collection are worth reading, but there's obviously a LOT of them.  Here's a "best-of" list to get you started:

## Basic Concepts and Learning Approaches

### Overviews of Javascript Tools and Concepts
  - [State of the Javascript Landscape in 2016](http://www.infoq.com/articles/state-of-javascript-2016)  
    A very high-level summary of the important terms and technologies that are used in modern Javascript development.
  - [The \(R\)Evolution of Web Development](http://blog.isquaredsoftware.com/presentations/2016-10-revolution-of-web-dev/)  
    A slideshow giving an overview of web dev history and modern web dev tools, technologies, and trends.
  - [Javascript Package Managers 101](https://medium.com/@shubheksha/javascript-package-managers-101-9afd926add0a)  
    An overview of what packages and package managers are, some related terms, and how these tools work.
    
### Suggested Learning Approaches
  - [A Study Plan to Cure Javascript Fatigue](https://medium.freecodecamp.com/a-study-plan-to-cure-javascript-fatigue-8ad3a54f2eb1)  
    The author of the "State of JS 2016" survey gives an excellent step-by-step study plan to use when learning the Javascript ecosystem.
  - [Grab Front-End Study Guide](https://github.com/grab/front-end-guide)  
    An excellent guide to learning front-end technologies, based on "A Study Plan to Cure Javascript Fatigue".  Includes descriptions of each topic, links to learning resources, and estimates for how much time to spend on each topic.
  - [React How-To](https://github.com/petehunt/react-howto)  
    Pete Hunt, one of React's creators, gives a high-level suggested order to use when learning React-related technologies (React, NPM, bundlers, ES6, routing, and Flux/Redux)
  - [Timeline for Learning React](https://daveceddia.com/timeline-for-learning-react/)  
    [How to Learn React](https://daveceddia.com/how-to-learn-react/)  
    Another high-level suggested timeline for how to approach learning React and related technologies.
  - [React Roadmap](https://github.com/ericdouglas/react-roadmap)  
    A curated list of free resources to master React Development, in suggested learning order
  - [Tips to learn React + Redux](https://www.robinwieruch.de/tips-to-learn-react-redux/)  
    An extensive and excellent list of suggestions to follow when learning and using React and Redux.  Tips include when to use different component patterns, when to bring in a state management library, Redux state structuring, unit testing, and much more.


## Learning Core Javascript (ES5)

### General Resources
  - [Mozilla Developer Network: Javascript](https://developer.mozilla.org/en-US/docs/Web/JavaScript)  
    [Mozilla Developer Network: A Re-Introduction to Javascript](https://developer.mozilla.org/en-US/docs/Web/JavaScript/A_re-introduction_to_JavaScript)  
    Mozilla maintains a fantastic set of developer resources for Web technologies, including a comprehensive reference to the Javascript language and a number of associated tutorials. Their "reintroduction to Javascript" article is a great overview of what the language looks like.
  - [Eric Elliott's Javascript Resource Lists](https://medium.com/javascript-scene/10-priceless-resources-for-javascript-learners-bbf2f7d7f84e)  
    [Eric Elliott's Essential Javascript Links](https://gist.github.com/ericelliott/d576f72441fc1b27dace/0cee592f8f8b7eae39c4b3851ae92b00463b67b9)  
    Eric Elliott is a strong proponent of Javascript, has written numerous articles about learning and understanding Javascript, and assembled some very useful lists of numerous Javascript resources. (Strong opinions, but has useful info.)
  - [Wes Bos's Javascript Resource List](http://wesbos.com/learn-javascript)  
    Speaker and teacher Wes Bos gives links to a number of resources for learning Javascript
    
### Books
  - [Eloquent Javascript](http://eloquentjavascript.net/)  
    A full online book teaching Javascript from the ground up. Very recommended.
  - [You Don't Know Javascript](https://github.com/getify/You-Dont-Know-JS)  
    An online book series intended to teach all aspects of Javascript, including the "tougher" parts.
  - [Exploring Javascript](http://exploringjs.com/)  
    Multiple free online books from Dr. Axel Rauschmayer. "Speaking Javascript" covers all of Javascript through ES5; "Exploring ES6" covers ES6 in depth; and other books look at versions of Javascript after ES6 and how to set up an ES6+ development environment.


## Learning Current Javascript (ES6+)

### ES6 Feature Overviews
  - [ES6 Overview in 350 Bullet Points](https://ponyfoo.com/articles/es6)  
    Quick samples and descriptions of all the various ES6 capabilities
  - [ES6 Features Comparison](http://es6-features.org/)  
    Code snippets comparing ES6 features with their ES5 equivalents
  - [ES6 - The Bits You'll Actually Use](http://jamesknelson.com/es6-the-bits-youll-actually-use/)  
    A quick tour through some of the more useful features in ES6
  - [A Rundown of Javascript 2015 Features](https://auth0.com/blog/a-rundown-of-es6-features/)  
    An overview of the features in ES6 and how they can be used.
    
### In-Depth Details
  - [ES6 In Depth](https://ponyfoo.com/articles/tagged/es6-in-depth)  
    Many articles covering each feature in greater detail
  - [Exploring ES6](http://exploringjs.com/es6/index.html)  
    A full online book covering every aspect of ES6 in fine detail


## React Walkthrough

If you are new to React, try reading these articles in order. 

### Getting Started
  - [React Documentation: Hello World](https://facebook.github.io/react/docs/hello-world.html)  
    [React Documentation: Tutorial](https://facebook.github.io/react/tutorial/tutorial.html)  
    The official React documentation, recently rewritten with an excellent set of tutorials, explanations, and API information.
  - [Create-React-App](https://github.com/facebookincubator/create-react-app)  
    The official project creation tool from the React team.  Allows you to set up a new React project, with no configuration work required.
  - [Simple React Development in 2017](https://hackernoon.com/simple-react-development-in-2017-113bd563691f)  
    An excellent set of instructions for setting up a React project with minimal fuss and effort needed.  Includes links to some useful resources, and info on deploying the app to production.
  - [Modern Web Development with React and Redux](http://blog.isquaredsoftware.com/2017/02/presentation-react-redux-intro/)    
    An up-to-date HTML slideshow that introduces React and Redux, discusses why they help make applications easier to write via declarative code and predictable data flow, and demonstrates their basic concepts and syntax.  Includes several interactive React component examples.
  - [Learn Raw React](http://jamesknelson.com/learn-raw-react-no-jsx-flux-es6-webpack/)  
    A ground-up React tutorial that leaves out any other related "modern" technologies, Very recommended if you want to skip the buzzwords and acronyms.
  - [30 Days of React](https://www.fullstackreact.com/30-days-of-react/)  
    A tutorial series that walks you through how to use React, from the ground up, in 30 bite-size articles covering everything from "What is React?" to data management to testing and deployment.
    
### Data Flow: “State” and “Props”
  - [A Visual Guide to State in React](https://daveceddia.com/visual-guide-to-state-in-react/)  
    Describes what "state" is, what kinds of data should be included into React state, and how state flow relates to component updates.
  - [ReactJS: Props vs State](http://lucybain.com/blog/2016/react-state-vs-pros/)  
    Explains that "props" are data passed in to a component, while "state" is data managed inside a component.
  - [Best Practices for Component State in React](http://brewhouse.io/blog/2015/03/24/best-practices-for-component-state-in-reactjs.html)  
    Some excellent suggestions and approaches for state handling and component structure.
    
### Component Patterns
  - [React Patterns](http://reactpatterns.com/)  
    An excellent list of common patterns for structuring React components, with examples
  - [The React Component Lifecycle](https://www.kirupa.com/react/component_lifecycle.htm)  
    A useful description of the order and purpose of React’s component lifecycle methods.
  - [8 no-Flux strategies for React component communication](http://andrewhfarmer.com/component-communication/)  
    Very helpful list of ways to have React components communicate back and forth
  - [Presentational and Container Components](https://medium.com/@dan_abramov/smart-and-dumb-components-7ca2f9a7c7d0)  
    Dan Abramov's foundational article on classifying components based on intent and behavior. A must-read for anyone using React.
  - [Mixins Considered Harmful](https://facebook.github.io/react/blog/2016/07/13/mixins-considered-harmful.html)  
    Dan Abramov explains why the React team discourages use of mixins, and prefers a pattern called “Higher Order Components” instead
  - [Components, React, and Flux](http://slides.com/danabramov/components-react-flux-wip#/)  
    A fantastic HTML slideshow that discusses how to organize code as reusable components, and the basic concepts and benefits of a Flux unidirectional architecture
  - [Reactive, Component-Based UIs](http://banderson.github.io/reactive-component-ui-presentation/#/)  
    Another fantastic HTML slideshow describing the three principles of React: "functional over OOP", "stateless over stateful", "clarity over brevity" (use arrow keys to advance slides)
    
### Function Binding and `this`
  - [Gentle Explanation of `this` keyword in Javascript](http://rainsoft.io/gentle-explanation-of-this-in-javascript/)  
    A long and in-depth explanation of the various ways that the `this`  keyword can be defined
  - [The Inner Workings of Javascript's `this` keyword](https://www.sitepoint.com/inner-workings-javascripts-this-keyword/)  
    [Mastering Javascript's `this` keyword](https://www.sitepoint.com/mastering-javascripts-this-keyword/)  
    A two-part article on the ins and outs of `this`.
  - [Why and How to Bind Methods in your React Component Classes](http://reactkungfu.com/2015/07/why-and-how-to-bind-methods-in-your-react-component-classes/)  
    A good look at function binding in JS, and how it works with React
  - [React Binding Patterns: 5 Approaches for Handling `this`](https://medium.com/@housecor/react-binding-patterns-5-approaches-for-handling-this-92c651b5af56)  
    Describes five different ways you can handle binding methods to handle the `this` keyword correctly
  - ["Fat arrow vs autobind vs bindbindbind?”](https://www.reddit.com/r/reactjs/comments/54xnao/fat_arrow_vs_autobind_vs_bindbindbindbindbind/d85wj0l)  
    Dan Abramov from the React team gives his thoughts on how to handle method binding.
    
### AJAX requests and Data Fetching
  - [React AJAX Best Practices](http://andrewhfarmer.com/react-ajax-best-practices/)  
    Covers four ways to approach managing queries and data fetching.
  - [AJAX Requests in React: How and Where to Fetch Data](https://daveceddia.com/ajax-requests-in-react/)  
    An overview of where AJAX requests fit into React usage.
    
### Immutable Data
  - [Pros and Cons of Using Immutability With React](http://reactkungfu.com/2015/08/pros-and-cons-of-using-immutability-with-react-js/)  
    Excellent description of what immutability is, how to use use these concepts with React, and pros and cons of managing data immutably. While the title refers to React, most of the writing just deals with plain Javascript concepts.
  - [Javascript and Immutability](http://t4d.io/javascript-and-immutability/)  
    A description of how to properly immutably update objects and arrays using functions like assign and slice
  - [Redux Docs: Structuring Reducers - Immutable Update Patterns](http://redux.js.org/docs/recipes/reducers/ImmutableUpdatePatterns.html)  
    Useful examples for doing proper immutable updates, including common mistakes, proper updates of nested data, updates for arrays, and more.  (Helpful for Redux, but not Redux-specific.)
    
### Functional Programming
  - [The Little Idea of Functional Programming](http://jaysoo.ca/2016/01/13/functional-programming-little-ideas/)  
    Describes the three basic principles of FP: "data in/data out", "code as data", and "function composition" all the way down, and demonstrates transforming some data. Has some very helpful graphics and illustrations.
  - [What Is Functional Programming?](http://blog.jenkster.com/2015/12/what-is-functional-programming.html)  
    Describes how side effects and "hidden inputs" add complexity to code, in very clear terms.
    
### Forms and Inputs
  - [Controlled and uncontrolled form inputs in React don't have to be complicated](http://goshakkk.name/controlled-vs-uncontrolled-inputs-react/)  
    A great summary of what controlled and uncontrolled inputs are, what each approach looks like, and how to handle values from different types of inputs.
  - [React.js Forms: Controlled Components](http://lorenstewart.me/2016/10/31/react-js-forms-controlled-components/)  
    An excellent article that describes the concept of controlled components, and demonstrates examples of how to interact with different types of form inputs
  - [Learn Raw React: Ridiculously Simple Forms](http://jamesknelson.com/learn-raw-react-ridiculously-simple-forms/)  
    Covers the basics of implementing form rendering, updates, and validation, in plain JS
    
### Styles
  - [Styling in React](https://www.kirupa.com/react/styling_in_react.htm)  
    An introduction to using React's built-in inline styling abilities
  - [How To Style React](http://andrewhfarmer.com/how-to-style-react/)  
    An excellent overview of the four major ways to deal with styles in React, and what the various tools are. Includes a decision tree to help you decide what to use.


## Redux

### Getting Started
  - [Redux Docs](http://redux.js.org/index.html)  
    The official Redux documentation.  Contains an excellent tutorial that walks you through “here’s what you want to do, and how we came up with this”, as well as recipes for more advanced topics.  Be sure to read through the FAQ for answers to common questions and links to further information.
  - [Getting Started with Redux - Video Series](https://egghead.io/series/getting-started-with-redux)  
    [Getting Started with Redux - Course Notes](https://github.com/tayiorbeii/egghead.io_redux_course_notes)  
    Dan Abramov, the creator of Redux demonstrates various concepts in 30 short (2-5 minute) videos. The linked Github repo contains notes and transcriptions of the videos.
  - [Building React Applications with Idiomatic Redux - Video Series](https://egghead.io/series/building-react-applications-with-idiomatic-redux)  
    [Building React Applications with Idiomatic Redux - Course Notes](https://github.com/tayiorbeii/egghead.io_idiomatic_redux_course_notes)  
    Dan Abramov's second video tutorial series, continuing directly after the first. Includes lessons on store initial state, using Redux with React Router, using "selector" functions, normalizing state, use of Redux middleware, async action creators, and more. The linked Github repo contains notes and transcriptions of the videos.
  - [A Cartoon Guide to Redux](https://code-cartoons.com/a-cartoon-intro-to-redux-3afb775501a6)  
    A nifty introduction to Redux’s concepts using cartoon explanations
  - [Redux: From Twitter Hype to Production](http://slides.com/jenyaterpil/redux-from-twitter-hype-to-production#/)  
    An extremely well-produced slideshow that visually steps through core Redux concepts, usage with React, project organization, and side effects with thunks and sagas. Has some absolutely fantastic animated diagrams demonstrating how data flows through a React+Redux architecture.
  - [Leveling Up with React: Redux](https://css-tricks.com/learning-react-redux/)  
    A very well-written introduction to Redux and its related concepts, with some useful cartoon-ish diagrams.
  - [Connect.js explained](https://gist.github.com/gaearon/1d19088790e70ac32ea636c025ba424e)  
    A very simplified version of React Redux's `connect()` function that illustrates the basic implementation
    
### AJAX, Timeouts, and other “Side Effects”
  - [Dispatching Redux Actions with a Timeout / ](http://stackoverflow.com/a/35415559/62937)  
    [Why do we need middleware for async flow in Redux?](http://stackoverflow.com/a/34599594/62937)  
    A pair of answers from Dan Abramov, explaining how “side effects” like AJAX calls and asynchronous behavior fit into Redux
  - [What the heck is a "thunk"?](https://daveceddia.com/what-is-a-thunk/)  
    An explanation of the word “thunk”, and how thunks can be used to do things like AJAX calls.
    
### Middleware
  - [Redux Middleware](http://jonnyreeves.co.uk/2016/redux-middleware/)  
    A tutorial describing how Redux compares to typical "MVC", what a "middleware" is, what they can do, and how you can test them.
  - [Exploring Redux Middlewares](http://blog.krawaller.se/posts/exploring-redux-middleware/)  
    Understanding middlewares through a series of small experiments
    
### Debugging
  - [Hot reloading and time travel debugging: what are they?](https://code-cartoons.com/hot-reloading-and-time-travel-debugging-what-are-they-3c8ed2812f35)  
    A short but informative article describing these concepts and why they're useful, with cartoon illustrations
  - [Time Travel in React Redux apps using the Redux DevTools](https://onsen.io/blog/react-redux-devtools-with-time-travel/)  
    Examples of configuring a Redux store to use the DevTools enhancers, and using both the DevTools components and the browser extension for debugging.
    
### Writing Reducers
  - [Redux Docs: Structuring Reducers](http://redux.js.org/docs/recipes/StructuringReducers.html)  
    Comprehensive information on writing reducers and structuring data, covering reducer composition, use of `combineReducers`, normalizing data, proper immutable updating, and more.
  - [Taking Advantage of `combineReducers`](http://randycoulman.com/blog/2016/11/22/taking-advantage-of-combinereducers/)  
    Examples of using `combineReducers` multiple times to produce a state tree, and some thoughts on tradeoffs in various approaches to reducer logic.
    
### Selectors and Normalization
  - [Querying a Redux Store](https://medium.com/@adamrackis/querying-a-redux-store-37db8c7f3b0f)  
    A look at best practices for organizing and storing data in Redux, including normalizing data and use of selector functions.
  - [Normalizing Redux Stores for Maximum Code Reuse](https://medium.com/@adamrackis/normalizing-redux-stores-for-maximum-code-reuse-ae6e3844ae95)  
    Thoughts on how normalized Redux stores enable some useful data handling approaches, with examples of using selector functions to denormalize hierarchical data.
  - [Practical Redux: Redux-ORM Basics](http://blog.isquaredsoftware.com/2016/10/practical-redux-part-1-redux-orm-basics/)  
    [Practical Redux: Redux-ORM Concepts and Techniques](http://blog.isquaredsoftware.com/2016/10/practical-redux-part-2-redux-orm-concepts-and-techniques/)  
    A look at how Redux-ORM can help manage normalized data in a Redux store, including use cases, basic usage, key concepts, and advanced techniques.


## Webpack

### Getting Started
  - [Webpack Documentation](https://webpack.js.org/)  
    Webpack's new documentation site, explaining concepts, configuration, and recipes
  - [Webpack from First Principles](https://youtu.be/WQue1AN93YU)  
    A screencast video explaining what Webpack is and why you would want to use it
  - [What is Webpack and what can it do for you?](http://x-team.com/2016/09/webpack-can-absolute-beginners/)  
    A plain-English explanation of what Webpack is and what problems it can help solve.
  - [SurviveJS - Webpack](http://survivejs.com/webpack/introduction)  
    A full book online book that covers setting up Webpack for both development and production. Also touches topics such as ESLint and npm.
    
### Configuration and Concepts
  - [Webpack: The Confusing Parts](https://medium.com/@rajaraodv/webpack-the-confusing-parts-58712f8fcad9)  
    A great simplification and breakdown of the different pieces that make up a Webpack configuration: dev vs prod, CLI vs dev-server, the "entry" option, the "output" option / "path" vs "publicPath", loaders and configuration, Babel, plugins, and path resolving.
  - [Angular + Webpack < 3](https://docs.google.com/presentation/d/10mIapWjv1pyUQaMv6G8MCdoe9OK2Ey8zz-CLkHuFdRI)  
    A long presentation that describes Webpack and its core concepts in depth. A few parts are Angular-centric, but still an extremely clear and informative set of slides. Covers topics like the "entry" and "output" options, "loaders", and "plugins".
  - [Advanced Webpack](http://presentations.survivejs.com/advanced-webpack/)  
    An in-depth presentation that walks through Webpack concepts, terms, configuration, and usage. Covers a number of advanced topics, and very worth reading.
    
### Build Optimization
  - [Advanced Frontend Optimization with Webpack](http://sokra.github.io/slides/frontend-optimize)  
    Slides by Webpack’s original author, describing ways to improve Webpack builds.
  - [Formidable Playbook](https://formidable.com/open-source/playbook/)  
    Formidable Labs describes their preferred approaches for configuring Webpack, including optimization approaches.
    
### Hot Module Reloading
  - [HMR Tutorial: Why Use HMR?](http://andrewhfarmer.com/why-use-hmr/)  
    [HMR Tutorial: Understanding HMR](http://andrewhfarmer.com/understanding-hmr/)  
    [HMR Tutorial: 3 Ways to use HMR with Webpack](http://andrewhfarmer.com/3-ways-webpack-hmr/)  
    [HMR Tutorial: HMR Ideas and Setup](http://andrewhfarmer.com/webpack-hmr-tutorial/)  
    A very readable and informative series of articles that explains what HMR is, what benefits it gives, and how to use it.
  - [Webpack Hot Reloading and React](https://ctheu.com/2015/12/29/webpack-hot-reloading-and-react-how/)  
    An explanation of how Hot Reloading works, and how the various pieces fit together.
