// Deprecated: Please note, this package has been deprecated. A replacement package is available [github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity](https://pkg.go.dev/github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity). We strongly encourage you to upgrade to continue receiving updates. See [Migration Guide](https://aka.ms/azsdk/golang/t2/migration) for guidance on upgrading. Refer to our [deprecation policy](https://azure.github.io/azure-sdk/policies_support.html) for more details.
package securityapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/security/mgmt/v3.0/security"
	"github.com/Azure/go-autorest/autorest"
)

// MdeOnboardingsClientAPI contains the set of methods on the MdeOnboardingsClient type.
type MdeOnboardingsClientAPI interface {
	Get(ctx context.Context) (result security.MdeOnboardingData, err error)
	List(ctx context.Context) (result security.MdeOnboardingDataList, err error)
}

var _ MdeOnboardingsClientAPI = (*security.MdeOnboardingsClient)(nil)

// CustomAssessmentAutomationsClientAPI contains the set of methods on the CustomAssessmentAutomationsClient type.
type CustomAssessmentAutomationsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, customAssessmentAutomationName string, customAssessmentAutomationBody security.CustomAssessmentAutomationRequest) (result security.CustomAssessmentAutomation, err error)
	Delete(ctx context.Context, resourceGroupName string, customAssessmentAutomationName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, customAssessmentAutomationName string) (result security.CustomAssessmentAutomation, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result security.CustomAssessmentAutomationsListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result security.CustomAssessmentAutomationsListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result security.CustomAssessmentAutomationsListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result security.CustomAssessmentAutomationsListResultIterator, err error)
}

var _ CustomAssessmentAutomationsClientAPI = (*security.CustomAssessmentAutomationsClient)(nil)

// CustomEntityStoreAssignmentsClientAPI contains the set of methods on the CustomEntityStoreAssignmentsClient type.
type CustomEntityStoreAssignmentsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, customEntityStoreAssignmentName string, customEntityStoreAssignmentRequestBody security.CustomEntityStoreAssignmentRequest) (result security.CustomEntityStoreAssignment, err error)
	Delete(ctx context.Context, resourceGroupName string, customEntityStoreAssignmentName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, customEntityStoreAssignmentName string) (result security.CustomEntityStoreAssignment, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result security.CustomEntityStoreAssignmentsListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result security.CustomEntityStoreAssignmentsListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result security.CustomEntityStoreAssignmentsListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result security.CustomEntityStoreAssignmentsListResultIterator, err error)
}

var _ CustomEntityStoreAssignmentsClientAPI = (*security.CustomEntityStoreAssignmentsClient)(nil)

// ComplianceResultsClientAPI contains the set of methods on the ComplianceResultsClient type.
type ComplianceResultsClientAPI interface {
	Get(ctx context.Context, resourceID string, complianceResultName string) (result security.ComplianceResult, err error)
	List(ctx context.Context, scope string) (result security.ComplianceResultListPage, err error)
	ListComplete(ctx context.Context, scope string) (result security.ComplianceResultListIterator, err error)
}

var _ ComplianceResultsClientAPI = (*security.ComplianceResultsClient)(nil)

// PricingsClientAPI contains the set of methods on the PricingsClient type.
type PricingsClientAPI interface {
	Get(ctx context.Context, pricingName string) (result security.Pricing, err error)
	List(ctx context.Context) (result security.PricingList, err error)
	Update(ctx context.Context, pricingName string, pricing security.Pricing) (result security.Pricing, err error)
}

var _ PricingsClientAPI = (*security.PricingsClient)(nil)

// AdvancedThreatProtectionClientAPI contains the set of methods on the AdvancedThreatProtectionClient type.
type AdvancedThreatProtectionClientAPI interface {
	Create(ctx context.Context, resourceID string, advancedThreatProtectionSetting security.AdvancedThreatProtectionSetting) (result security.AdvancedThreatProtectionSetting, err error)
	Get(ctx context.Context, resourceID string) (result security.AdvancedThreatProtectionSetting, err error)
}

var _ AdvancedThreatProtectionClientAPI = (*security.AdvancedThreatProtectionClient)(nil)

// DeviceSecurityGroupsClientAPI contains the set of methods on the DeviceSecurityGroupsClient type.
type DeviceSecurityGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceID string, deviceSecurityGroupName string, deviceSecurityGroup security.DeviceSecurityGroup) (result security.DeviceSecurityGroup, err error)
	Delete(ctx context.Context, resourceID string, deviceSecurityGroupName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceID string, deviceSecurityGroupName string) (result security.DeviceSecurityGroup, err error)
	List(ctx context.Context, resourceID string) (result security.DeviceSecurityGroupListPage, err error)
	ListComplete(ctx context.Context, resourceID string) (result security.DeviceSecurityGroupListIterator, err error)
}

var _ DeviceSecurityGroupsClientAPI = (*security.DeviceSecurityGroupsClient)(nil)

// IotSecuritySolutionClientAPI contains the set of methods on the IotSecuritySolutionClient type.
type IotSecuritySolutionClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, solutionName string, iotSecuritySolutionData security.IoTSecuritySolutionModel) (result security.IoTSecuritySolutionModel, err error)
	Delete(ctx context.Context, resourceGroupName string, solutionName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, solutionName string) (result security.IoTSecuritySolutionModel, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, filter string) (result security.IoTSecuritySolutionsListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, filter string) (result security.IoTSecuritySolutionsListIterator, err error)
	ListBySubscription(ctx context.Context, filter string) (result security.IoTSecuritySolutionsListPage, err error)
	ListBySubscriptionComplete(ctx context.Context, filter string) (result security.IoTSecuritySolutionsListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, solutionName string, updateIotSecuritySolutionData security.UpdateIotSecuritySolutionData) (result security.IoTSecuritySolutionModel, err error)
}

var _ IotSecuritySolutionClientAPI = (*security.IotSecuritySolutionClient)(nil)

// IotSecuritySolutionAnalyticsClientAPI contains the set of methods on the IotSecuritySolutionAnalyticsClient type.
type IotSecuritySolutionAnalyticsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, solutionName string) (result security.IoTSecuritySolutionAnalyticsModel, err error)
	List(ctx context.Context, resourceGroupName string, solutionName string) (result security.IoTSecuritySolutionAnalyticsModelList, err error)
}

var _ IotSecuritySolutionAnalyticsClientAPI = (*security.IotSecuritySolutionAnalyticsClient)(nil)

// IotSecuritySolutionsAnalyticsAggregatedAlertClientAPI contains the set of methods on the IotSecuritySolutionsAnalyticsAggregatedAlertClient type.
type IotSecuritySolutionsAnalyticsAggregatedAlertClientAPI interface {
	Dismiss(ctx context.Context, resourceGroupName string, solutionName string, aggregatedAlertName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, solutionName string, aggregatedAlertName string) (result security.IoTSecurityAggregatedAlert, err error)
	List(ctx context.Context, resourceGroupName string, solutionName string, top *int32) (result security.IoTSecurityAggregatedAlertListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, solutionName string, top *int32) (result security.IoTSecurityAggregatedAlertListIterator, err error)
}

var _ IotSecuritySolutionsAnalyticsAggregatedAlertClientAPI = (*security.IotSecuritySolutionsAnalyticsAggregatedAlertClient)(nil)

// IotSecuritySolutionsAnalyticsRecommendationClientAPI contains the set of methods on the IotSecuritySolutionsAnalyticsRecommendationClient type.
type IotSecuritySolutionsAnalyticsRecommendationClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, solutionName string, aggregatedRecommendationName string) (result security.IoTSecurityAggregatedRecommendation, err error)
	List(ctx context.Context, resourceGroupName string, solutionName string, top *int32) (result security.IoTSecurityAggregatedRecommendationListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, solutionName string, top *int32) (result security.IoTSecurityAggregatedRecommendationListIterator, err error)
}

var _ IotSecuritySolutionsAnalyticsRecommendationClientAPI = (*security.IotSecuritySolutionsAnalyticsRecommendationClient)(nil)

// LocationsClientAPI contains the set of methods on the LocationsClient type.
type LocationsClientAPI interface {
	Get(ctx context.Context, ascLocation string) (result security.AscLocation, err error)
	List(ctx context.Context) (result security.AscLocationListPage, err error)
	ListComplete(ctx context.Context) (result security.AscLocationListIterator, err error)
}

var _ LocationsClientAPI = (*security.LocationsClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result security.OperationListPage, err error)
	ListComplete(ctx context.Context) (result security.OperationListIterator, err error)
}

var _ OperationsClientAPI = (*security.OperationsClient)(nil)

// TasksClientAPI contains the set of methods on the TasksClient type.
type TasksClientAPI interface {
	GetResourceGroupLevelTask(ctx context.Context, resourceGroupName string, ascLocation string, taskName string) (result security.Task, err error)
	GetSubscriptionLevelTask(ctx context.Context, ascLocation string, taskName string) (result security.Task, err error)
	List(ctx context.Context, filter string) (result security.TaskListPage, err error)
	ListComplete(ctx context.Context, filter string) (result security.TaskListIterator, err error)
	ListByHomeRegion(ctx context.Context, ascLocation string, filter string) (result security.TaskListPage, err error)
	ListByHomeRegionComplete(ctx context.Context, ascLocation string, filter string) (result security.TaskListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, ascLocation string, filter string) (result security.TaskListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, ascLocation string, filter string) (result security.TaskListIterator, err error)
	UpdateResourceGroupLevelTaskState(ctx context.Context, resourceGroupName string, ascLocation string, taskName string, taskUpdateActionType security.TaskUpdateActionType) (result autorest.Response, err error)
	UpdateSubscriptionLevelTaskState(ctx context.Context, ascLocation string, taskName string, taskUpdateActionType security.TaskUpdateActionType) (result autorest.Response, err error)
}

var _ TasksClientAPI = (*security.TasksClient)(nil)

// AutoProvisioningSettingsClientAPI contains the set of methods on the AutoProvisioningSettingsClient type.
type AutoProvisioningSettingsClientAPI interface {
	Create(ctx context.Context, settingName string, setting security.AutoProvisioningSetting) (result security.AutoProvisioningSetting, err error)
	Get(ctx context.Context, settingName string) (result security.AutoProvisioningSetting, err error)
	List(ctx context.Context) (result security.AutoProvisioningSettingListPage, err error)
	ListComplete(ctx context.Context) (result security.AutoProvisioningSettingListIterator, err error)
}

var _ AutoProvisioningSettingsClientAPI = (*security.AutoProvisioningSettingsClient)(nil)

// CompliancesClientAPI contains the set of methods on the CompliancesClient type.
type CompliancesClientAPI interface {
	Get(ctx context.Context, scope string, complianceName string) (result security.Compliance, err error)
	List(ctx context.Context, scope string) (result security.ComplianceListPage, err error)
	ListComplete(ctx context.Context, scope string) (result security.ComplianceListIterator, err error)
}

var _ CompliancesClientAPI = (*security.CompliancesClient)(nil)

// InformationProtectionPoliciesClientAPI contains the set of methods on the InformationProtectionPoliciesClient type.
type InformationProtectionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, scope string, informationProtectionPolicyName security.InformationProtectionPolicyName, informationProtectionPolicy security.InformationProtectionPolicy) (result security.InformationProtectionPolicy, err error)
	Get(ctx context.Context, scope string, informationProtectionPolicyName security.InformationProtectionPolicyName) (result security.InformationProtectionPolicy, err error)
	List(ctx context.Context, scope string) (result security.InformationProtectionPolicyListPage, err error)
	ListComplete(ctx context.Context, scope string) (result security.InformationProtectionPolicyListIterator, err error)
}

var _ InformationProtectionPoliciesClientAPI = (*security.InformationProtectionPoliciesClient)(nil)

// ContactsClientAPI contains the set of methods on the ContactsClient type.
type ContactsClientAPI interface {
	Create(ctx context.Context, securityContactName string, securityContact security.Contact) (result security.Contact, err error)
	Delete(ctx context.Context, securityContactName string) (result autorest.Response, err error)
	Get(ctx context.Context, securityContactName string) (result security.Contact, err error)
	List(ctx context.Context) (result security.ContactListPage, err error)
	ListComplete(ctx context.Context) (result security.ContactListIterator, err error)
}

var _ ContactsClientAPI = (*security.ContactsClient)(nil)

// WorkspaceSettingsClientAPI contains the set of methods on the WorkspaceSettingsClient type.
type WorkspaceSettingsClientAPI interface {
	Create(ctx context.Context, workspaceSettingName string, workspaceSetting security.WorkspaceSetting) (result security.WorkspaceSetting, err error)
	Delete(ctx context.Context, workspaceSettingName string) (result autorest.Response, err error)
	Get(ctx context.Context, workspaceSettingName string) (result security.WorkspaceSetting, err error)
	List(ctx context.Context) (result security.WorkspaceSettingListPage, err error)
	ListComplete(ctx context.Context) (result security.WorkspaceSettingListIterator, err error)
	Update(ctx context.Context, workspaceSettingName string, workspaceSetting security.WorkspaceSetting) (result security.WorkspaceSetting, err error)
}

var _ WorkspaceSettingsClientAPI = (*security.WorkspaceSettingsClient)(nil)

// RegulatoryComplianceStandardsClientAPI contains the set of methods on the RegulatoryComplianceStandardsClient type.
type RegulatoryComplianceStandardsClientAPI interface {
	Get(ctx context.Context, regulatoryComplianceStandardName string) (result security.RegulatoryComplianceStandard, err error)
	List(ctx context.Context, filter string) (result security.RegulatoryComplianceStandardListPage, err error)
	ListComplete(ctx context.Context, filter string) (result security.RegulatoryComplianceStandardListIterator, err error)
}

var _ RegulatoryComplianceStandardsClientAPI = (*security.RegulatoryComplianceStandardsClient)(nil)

// RegulatoryComplianceControlsClientAPI contains the set of methods on the RegulatoryComplianceControlsClient type.
type RegulatoryComplianceControlsClientAPI interface {
	Get(ctx context.Context, regulatoryComplianceStandardName string, regulatoryComplianceControlName string) (result security.RegulatoryComplianceControl, err error)
	List(ctx context.Context, regulatoryComplianceStandardName string, filter string) (result security.RegulatoryComplianceControlListPage, err error)
	ListComplete(ctx context.Context, regulatoryComplianceStandardName string, filter string) (result security.RegulatoryComplianceControlListIterator, err error)
}

var _ RegulatoryComplianceControlsClientAPI = (*security.RegulatoryComplianceControlsClient)(nil)

// RegulatoryComplianceAssessmentsClientAPI contains the set of methods on the RegulatoryComplianceAssessmentsClient type.
type RegulatoryComplianceAssessmentsClientAPI interface {
	Get(ctx context.Context, regulatoryComplianceStandardName string, regulatoryComplianceControlName string, regulatoryComplianceAssessmentName string) (result security.RegulatoryComplianceAssessment, err error)
	List(ctx context.Context, regulatoryComplianceStandardName string, regulatoryComplianceControlName string, filter string) (result security.RegulatoryComplianceAssessmentListPage, err error)
	ListComplete(ctx context.Context, regulatoryComplianceStandardName string, regulatoryComplianceControlName string, filter string) (result security.RegulatoryComplianceAssessmentListIterator, err error)
}

var _ RegulatoryComplianceAssessmentsClientAPI = (*security.RegulatoryComplianceAssessmentsClient)(nil)

// SubAssessmentsClientAPI contains the set of methods on the SubAssessmentsClient type.
type SubAssessmentsClientAPI interface {
	Get(ctx context.Context, scope string, assessmentName string, subAssessmentName string) (result security.SubAssessment, err error)
	List(ctx context.Context, scope string, assessmentName string) (result security.SubAssessmentListPage, err error)
	ListComplete(ctx context.Context, scope string, assessmentName string) (result security.SubAssessmentListIterator, err error)
	ListAll(ctx context.Context, scope string) (result security.SubAssessmentListPage, err error)
	ListAllComplete(ctx context.Context, scope string) (result security.SubAssessmentListIterator, err error)
}

var _ SubAssessmentsClientAPI = (*security.SubAssessmentsClient)(nil)

// AutomationsClientAPI contains the set of methods on the AutomationsClient type.
type AutomationsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, automationName string, automation security.Automation) (result security.Automation, err error)
	Delete(ctx context.Context, resourceGroupName string, automationName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, automationName string) (result security.Automation, err error)
	List(ctx context.Context) (result security.AutomationListPage, err error)
	ListComplete(ctx context.Context) (result security.AutomationListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result security.AutomationListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result security.AutomationListIterator, err error)
	Validate(ctx context.Context, resourceGroupName string, automationName string, automation security.Automation) (result security.AutomationValidationStatus, err error)
}

var _ AutomationsClientAPI = (*security.AutomationsClient)(nil)

// AlertsSuppressionRulesClientAPI contains the set of methods on the AlertsSuppressionRulesClient type.
type AlertsSuppressionRulesClientAPI interface {
	Delete(ctx context.Context, alertsSuppressionRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, alertsSuppressionRuleName string) (result security.AlertsSuppressionRule, err error)
	List(ctx context.Context, alertType string) (result security.AlertsSuppressionRulesListPage, err error)
	ListComplete(ctx context.Context, alertType string) (result security.AlertsSuppressionRulesListIterator, err error)
	Update(ctx context.Context, alertsSuppressionRuleName string, alertsSuppressionRule security.AlertsSuppressionRule) (result security.AlertsSuppressionRule, err error)
}

var _ AlertsSuppressionRulesClientAPI = (*security.AlertsSuppressionRulesClient)(nil)

// ServerVulnerabilityAssessmentClientAPI contains the set of methods on the ServerVulnerabilityAssessmentClient type.
type ServerVulnerabilityAssessmentClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string) (result security.ServerVulnerabilityAssessment, err error)
	Delete(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string) (result security.ServerVulnerabilityAssessmentDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string) (result security.ServerVulnerabilityAssessment, err error)
	ListByExtendedResource(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string) (result security.ServerVulnerabilityAssessmentsList, err error)
}

var _ ServerVulnerabilityAssessmentClientAPI = (*security.ServerVulnerabilityAssessmentClient)(nil)

// AssessmentsMetadataClientAPI contains the set of methods on the AssessmentsMetadataClient type.
type AssessmentsMetadataClientAPI interface {
	CreateInSubscription(ctx context.Context, assessmentMetadataName string, assessmentMetadata security.AssessmentMetadataResponse) (result security.AssessmentMetadataResponse, err error)
	DeleteInSubscription(ctx context.Context, assessmentMetadataName string) (result autorest.Response, err error)
	Get(ctx context.Context, assessmentMetadataName string) (result security.AssessmentMetadataResponse, err error)
	GetInSubscription(ctx context.Context, assessmentMetadataName string) (result security.AssessmentMetadataResponse, err error)
	List(ctx context.Context) (result security.AssessmentMetadataResponseListPage, err error)
	ListComplete(ctx context.Context) (result security.AssessmentMetadataResponseListIterator, err error)
	ListBySubscription(ctx context.Context) (result security.AssessmentMetadataResponseListPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result security.AssessmentMetadataResponseListIterator, err error)
}

var _ AssessmentsMetadataClientAPI = (*security.AssessmentsMetadataClient)(nil)

// AssessmentsClientAPI contains the set of methods on the AssessmentsClient type.
type AssessmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceID string, assessmentName string, assessment security.Assessment) (result security.AssessmentResponse, err error)
	Delete(ctx context.Context, resourceID string, assessmentName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceID string, assessmentName string, expand security.ExpandEnum) (result security.AssessmentResponse, err error)
	List(ctx context.Context, scope string) (result security.AssessmentListPage, err error)
	ListComplete(ctx context.Context, scope string) (result security.AssessmentListIterator, err error)
}

var _ AssessmentsClientAPI = (*security.AssessmentsClient)(nil)

// AdaptiveApplicationControlsClientAPI contains the set of methods on the AdaptiveApplicationControlsClient type.
type AdaptiveApplicationControlsClientAPI interface {
	Delete(ctx context.Context, ascLocation string, groupName string) (result autorest.Response, err error)
	Get(ctx context.Context, ascLocation string, groupName string) (result security.AdaptiveApplicationControlGroup, err error)
	List(ctx context.Context, includePathRecommendations *bool, summary *bool) (result security.AdaptiveApplicationControlGroups, err error)
	Put(ctx context.Context, ascLocation string, groupName string, body security.AdaptiveApplicationControlGroup) (result security.AdaptiveApplicationControlGroup, err error)
}

var _ AdaptiveApplicationControlsClientAPI = (*security.AdaptiveApplicationControlsClient)(nil)

// AdaptiveNetworkHardeningsClientAPI contains the set of methods on the AdaptiveNetworkHardeningsClient type.
type AdaptiveNetworkHardeningsClientAPI interface {
	Enforce(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, adaptiveNetworkHardeningResourceName string, body security.AdaptiveNetworkHardeningEnforceRequest) (result security.AdaptiveNetworkHardeningsEnforceFuture, err error)
	Get(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, adaptiveNetworkHardeningResourceName string) (result security.AdaptiveNetworkHardening, err error)
	ListByExtendedResource(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string) (result security.AdaptiveNetworkHardeningsListPage, err error)
	ListByExtendedResourceComplete(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string) (result security.AdaptiveNetworkHardeningsListIterator, err error)
}

var _ AdaptiveNetworkHardeningsClientAPI = (*security.AdaptiveNetworkHardeningsClient)(nil)

// AllowedConnectionsClientAPI contains the set of methods on the AllowedConnectionsClient type.
type AllowedConnectionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, ascLocation string, connectionType security.ConnectionType) (result security.AllowedConnectionsResource, err error)
	List(ctx context.Context) (result security.AllowedConnectionsListPage, err error)
	ListComplete(ctx context.Context) (result security.AllowedConnectionsListIterator, err error)
	ListByHomeRegion(ctx context.Context, ascLocation string) (result security.AllowedConnectionsListPage, err error)
	ListByHomeRegionComplete(ctx context.Context, ascLocation string) (result security.AllowedConnectionsListIterator, err error)
}

var _ AllowedConnectionsClientAPI = (*security.AllowedConnectionsClient)(nil)

// TopologyClientAPI contains the set of methods on the TopologyClient type.
type TopologyClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, ascLocation string, topologyResourceName string) (result security.TopologyResource, err error)
	List(ctx context.Context) (result security.TopologyListPage, err error)
	ListComplete(ctx context.Context) (result security.TopologyListIterator, err error)
	ListByHomeRegion(ctx context.Context, ascLocation string) (result security.TopologyListPage, err error)
	ListByHomeRegionComplete(ctx context.Context, ascLocation string) (result security.TopologyListIterator, err error)
}

var _ TopologyClientAPI = (*security.TopologyClient)(nil)

// JitNetworkAccessPoliciesClientAPI contains the set of methods on the JitNetworkAccessPoliciesClient type.
type JitNetworkAccessPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, ascLocation string, jitNetworkAccessPolicyName string, body security.JitNetworkAccessPolicy) (result security.JitNetworkAccessPolicy, err error)
	Delete(ctx context.Context, resourceGroupName string, ascLocation string, jitNetworkAccessPolicyName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, ascLocation string, jitNetworkAccessPolicyName string) (result security.JitNetworkAccessPolicy, err error)
	Initiate(ctx context.Context, resourceGroupName string, ascLocation string, jitNetworkAccessPolicyName string, body security.JitNetworkAccessPolicyInitiateRequest) (result security.JitNetworkAccessRequest, err error)
	List(ctx context.Context) (result security.JitNetworkAccessPoliciesListPage, err error)
	ListComplete(ctx context.Context) (result security.JitNetworkAccessPoliciesListIterator, err error)
	ListByRegion(ctx context.Context, ascLocation string) (result security.JitNetworkAccessPoliciesListPage, err error)
	ListByRegionComplete(ctx context.Context, ascLocation string) (result security.JitNetworkAccessPoliciesListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result security.JitNetworkAccessPoliciesListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result security.JitNetworkAccessPoliciesListIterator, err error)
	ListByResourceGroupAndRegion(ctx context.Context, resourceGroupName string, ascLocation string) (result security.JitNetworkAccessPoliciesListPage, err error)
	ListByResourceGroupAndRegionComplete(ctx context.Context, resourceGroupName string, ascLocation string) (result security.JitNetworkAccessPoliciesListIterator, err error)
}

var _ JitNetworkAccessPoliciesClientAPI = (*security.JitNetworkAccessPoliciesClient)(nil)

// DiscoveredSecuritySolutionsClientAPI contains the set of methods on the DiscoveredSecuritySolutionsClient type.
type DiscoveredSecuritySolutionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, ascLocation string, discoveredSecuritySolutionName string) (result security.DiscoveredSecuritySolution, err error)
	List(ctx context.Context) (result security.DiscoveredSecuritySolutionListPage, err error)
	ListComplete(ctx context.Context) (result security.DiscoveredSecuritySolutionListIterator, err error)
	ListByHomeRegion(ctx context.Context, ascLocation string) (result security.DiscoveredSecuritySolutionListPage, err error)
	ListByHomeRegionComplete(ctx context.Context, ascLocation string) (result security.DiscoveredSecuritySolutionListIterator, err error)
}

var _ DiscoveredSecuritySolutionsClientAPI = (*security.DiscoveredSecuritySolutionsClient)(nil)

// SolutionsReferenceDataClientAPI contains the set of methods on the SolutionsReferenceDataClient type.
type SolutionsReferenceDataClientAPI interface {
	List(ctx context.Context) (result security.SolutionsReferenceDataList, err error)
	ListByHomeRegion(ctx context.Context, ascLocation string) (result security.SolutionsReferenceDataList, err error)
}

var _ SolutionsReferenceDataClientAPI = (*security.SolutionsReferenceDataClient)(nil)

// ExternalSecuritySolutionsClientAPI contains the set of methods on the ExternalSecuritySolutionsClient type.
type ExternalSecuritySolutionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, ascLocation string, externalSecuritySolutionsName string) (result security.ExternalSecuritySolutionModel, err error)
	List(ctx context.Context) (result security.ExternalSecuritySolutionListPage, err error)
	ListComplete(ctx context.Context) (result security.ExternalSecuritySolutionListIterator, err error)
	ListByHomeRegion(ctx context.Context, ascLocation string) (result security.ExternalSecuritySolutionListPage, err error)
	ListByHomeRegionComplete(ctx context.Context, ascLocation string) (result security.ExternalSecuritySolutionListIterator, err error)
}

var _ ExternalSecuritySolutionsClientAPI = (*security.ExternalSecuritySolutionsClient)(nil)

// SecureScoresClientAPI contains the set of methods on the SecureScoresClient type.
type SecureScoresClientAPI interface {
	Get(ctx context.Context, secureScoreName string) (result security.SecureScoreItem, err error)
	List(ctx context.Context) (result security.SecureScoresListPage, err error)
	ListComplete(ctx context.Context) (result security.SecureScoresListIterator, err error)
}

var _ SecureScoresClientAPI = (*security.SecureScoresClient)(nil)

// SecureScoreControlsClientAPI contains the set of methods on the SecureScoreControlsClient type.
type SecureScoreControlsClientAPI interface {
	List(ctx context.Context, expand security.ExpandControlsEnum) (result security.SecureScoreControlListPage, err error)
	ListComplete(ctx context.Context, expand security.ExpandControlsEnum) (result security.SecureScoreControlListIterator, err error)
	ListBySecureScore(ctx context.Context, secureScoreName string, expand security.ExpandControlsEnum) (result security.SecureScoreControlListPage, err error)
	ListBySecureScoreComplete(ctx context.Context, secureScoreName string, expand security.ExpandControlsEnum) (result security.SecureScoreControlListIterator, err error)
}

var _ SecureScoreControlsClientAPI = (*security.SecureScoreControlsClient)(nil)

// SecureScoreControlDefinitionsClientAPI contains the set of methods on the SecureScoreControlDefinitionsClient type.
type SecureScoreControlDefinitionsClientAPI interface {
	List(ctx context.Context) (result security.SecureScoreControlDefinitionListPage, err error)
	ListComplete(ctx context.Context) (result security.SecureScoreControlDefinitionListIterator, err error)
	ListBySubscription(ctx context.Context) (result security.SecureScoreControlDefinitionListPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result security.SecureScoreControlDefinitionListIterator, err error)
}

var _ SecureScoreControlDefinitionsClientAPI = (*security.SecureScoreControlDefinitionsClient)(nil)

// SolutionsClientAPI contains the set of methods on the SolutionsClient type.
type SolutionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, ascLocation string, securitySolutionName string) (result security.Solution, err error)
	List(ctx context.Context) (result security.SolutionListPage, err error)
	ListComplete(ctx context.Context) (result security.SolutionListIterator, err error)
}

var _ SolutionsClientAPI = (*security.SolutionsClient)(nil)

// ConnectorsClientAPI contains the set of methods on the ConnectorsClient type.
type ConnectorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, connectorName string, connectorSetting security.ConnectorSetting) (result security.ConnectorSetting, err error)
	Delete(ctx context.Context, connectorName string) (result autorest.Response, err error)
	Get(ctx context.Context, connectorName string) (result security.ConnectorSetting, err error)
	List(ctx context.Context) (result security.ConnectorSettingListPage, err error)
	ListComplete(ctx context.Context) (result security.ConnectorSettingListIterator, err error)
}

var _ ConnectorsClientAPI = (*security.ConnectorsClient)(nil)

// SQLVulnerabilityAssessmentScansClientAPI contains the set of methods on the SQLVulnerabilityAssessmentScansClient type.
type SQLVulnerabilityAssessmentScansClientAPI interface {
	Get(ctx context.Context, scanID string, workspaceID string, APIVersion string, resourceID string) (result security.Scan, err error)
	List(ctx context.Context, workspaceID string, APIVersion string, resourceID string) (result security.Scans, err error)
}

var _ SQLVulnerabilityAssessmentScansClientAPI = (*security.SQLVulnerabilityAssessmentScansClient)(nil)

// SQLVulnerabilityAssessmentScanResultsClientAPI contains the set of methods on the SQLVulnerabilityAssessmentScanResultsClient type.
type SQLVulnerabilityAssessmentScanResultsClientAPI interface {
	Get(ctx context.Context, scanID string, scanResultID string, workspaceID string, APIVersion string, resourceID string) (result security.ScanResult, err error)
	List(ctx context.Context, scanID string, workspaceID string, APIVersion string, resourceID string) (result security.ScanResults, err error)
}

var _ SQLVulnerabilityAssessmentScanResultsClientAPI = (*security.SQLVulnerabilityAssessmentScanResultsClient)(nil)

// SQLVulnerabilityAssessmentBaselineRulesClientAPI contains the set of methods on the SQLVulnerabilityAssessmentBaselineRulesClient type.
type SQLVulnerabilityAssessmentBaselineRulesClientAPI interface {
	Add(ctx context.Context, workspaceID string, APIVersion string, resourceID string, body *security.RulesResultsInput) (result security.RulesResults, err error)
	CreateOrUpdate(ctx context.Context, ruleID string, workspaceID string, APIVersion string, resourceID string, body *security.RuleResultsInput) (result security.RuleResults, err error)
	Delete(ctx context.Context, ruleID string, workspaceID string, APIVersion string, resourceID string) (result autorest.Response, err error)
	Get(ctx context.Context, ruleID string, workspaceID string, APIVersion string, resourceID string) (result security.RuleResults, err error)
	List(ctx context.Context, workspaceID string, APIVersion string, resourceID string) (result security.RulesResults, err error)
}

var _ SQLVulnerabilityAssessmentBaselineRulesClientAPI = (*security.SQLVulnerabilityAssessmentBaselineRulesClient)(nil)

// AlertsClientAPI contains the set of methods on the AlertsClient type.
type AlertsClientAPI interface {
	GetResourceGroupLevel(ctx context.Context, resourceGroupName string, ascLocation string, alertName string) (result security.Alert, err error)
	GetSubscriptionLevel(ctx context.Context, ascLocation string, alertName string) (result security.Alert, err error)
	List(ctx context.Context) (result security.AlertListPage, err error)
	ListComplete(ctx context.Context) (result security.AlertListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result security.AlertListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result security.AlertListIterator, err error)
	ListResourceGroupLevelByRegion(ctx context.Context, ascLocation string, resourceGroupName string) (result security.AlertListPage, err error)
	ListResourceGroupLevelByRegionComplete(ctx context.Context, ascLocation string, resourceGroupName string) (result security.AlertListIterator, err error)
	ListSubscriptionLevelByRegion(ctx context.Context, ascLocation string) (result security.AlertListPage, err error)
	ListSubscriptionLevelByRegionComplete(ctx context.Context, ascLocation string) (result security.AlertListIterator, err error)
	Simulate(ctx context.Context, ascLocation string, alertSimulatorRequestBody security.AlertSimulatorRequestBody) (result security.AlertsSimulateFuture, err error)
	UpdateResourceGroupLevelStateToActivate(ctx context.Context, resourceGroupName string, ascLocation string, alertName string) (result autorest.Response, err error)
	UpdateResourceGroupLevelStateToDismiss(ctx context.Context, resourceGroupName string, ascLocation string, alertName string) (result autorest.Response, err error)
	UpdateResourceGroupLevelStateToInProgress(ctx context.Context, resourceGroupName string, ascLocation string, alertName string) (result autorest.Response, err error)
	UpdateResourceGroupLevelStateToResolve(ctx context.Context, resourceGroupName string, ascLocation string, alertName string) (result autorest.Response, err error)
	UpdateSubscriptionLevelStateToActivate(ctx context.Context, ascLocation string, alertName string) (result autorest.Response, err error)
	UpdateSubscriptionLevelStateToDismiss(ctx context.Context, ascLocation string, alertName string) (result autorest.Response, err error)
	UpdateSubscriptionLevelStateToInProgress(ctx context.Context, ascLocation string, alertName string) (result autorest.Response, err error)
	UpdateSubscriptionLevelStateToResolve(ctx context.Context, ascLocation string, alertName string) (result autorest.Response, err error)
}

var _ AlertsClientAPI = (*security.AlertsClient)(nil)

// SettingsClientAPI contains the set of methods on the SettingsClient type.
type SettingsClientAPI interface {
	Get(ctx context.Context, settingName security.SettingName4) (result security.SettingModel, err error)
	List(ctx context.Context) (result security.SettingsListPage, err error)
	ListComplete(ctx context.Context) (result security.SettingsListIterator, err error)
	Update(ctx context.Context, settingName security.SettingName5, setting security.BasicSetting) (result security.SettingModel, err error)
}

var _ SettingsClientAPI = (*security.SettingsClient)(nil)

// IngestionSettingsClientAPI contains the set of methods on the IngestionSettingsClient type.
type IngestionSettingsClientAPI interface {
	Create(ctx context.Context, ingestionSettingName string, ingestionSetting security.IngestionSetting) (result security.IngestionSetting, err error)
	Delete(ctx context.Context, ingestionSettingName string) (result autorest.Response, err error)
	Get(ctx context.Context, ingestionSettingName string) (result security.IngestionSetting, err error)
	List(ctx context.Context) (result security.IngestionSettingListPage, err error)
	ListComplete(ctx context.Context) (result security.IngestionSettingListIterator, err error)
	ListConnectionStrings(ctx context.Context, ingestionSettingName string) (result security.ConnectionStrings, err error)
	ListTokens(ctx context.Context, ingestionSettingName string) (result security.IngestionSettingToken, err error)
}

var _ IngestionSettingsClientAPI = (*security.IngestionSettingsClient)(nil)

// SoftwareInventoriesClientAPI contains the set of methods on the SoftwareInventoriesClient type.
type SoftwareInventoriesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, softwareName string) (result security.Software, err error)
	ListByExtendedResource(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string) (result security.SoftwaresListPage, err error)
	ListByExtendedResourceComplete(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string) (result security.SoftwaresListIterator, err error)
	ListBySubscription(ctx context.Context) (result security.SoftwaresListPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result security.SoftwaresListIterator, err error)
}

var _ SoftwareInventoriesClientAPI = (*security.SoftwareInventoriesClient)(nil)

// ConnectorsGroupClientAPI contains the set of methods on the ConnectorsGroupClient type.
type ConnectorsGroupClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, securityConnectorName string, securityConnector security.Connector) (result security.Connector, err error)
	Delete(ctx context.Context, resourceGroupName string, securityConnectorName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, securityConnectorName string) (result security.Connector, err error)
	List(ctx context.Context) (result security.ConnectorsListPage, err error)
	ListComplete(ctx context.Context) (result security.ConnectorsListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result security.ConnectorsListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result security.ConnectorsListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, securityConnectorName string, securityConnector security.Connector) (result security.Connector, err error)
}

var _ ConnectorsGroupClientAPI = (*security.ConnectorsGroupClient)(nil)

// GovernanceRuleClientAPI contains the set of methods on the GovernanceRuleClient type.
type GovernanceRuleClientAPI interface {
	List(ctx context.Context) (result security.GovernanceRuleListPage, err error)
	ListComplete(ctx context.Context) (result security.GovernanceRuleListIterator, err error)
}

var _ GovernanceRuleClientAPI = (*security.GovernanceRuleClient)(nil)

// GovernanceRulesClientAPI contains the set of methods on the GovernanceRulesClient type.
type GovernanceRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, ruleID string, governanceRule security.GovernanceRule) (result security.GovernanceRule, err error)
	Delete(ctx context.Context, ruleID string) (result autorest.Response, err error)
	Get(ctx context.Context, ruleID string) (result security.GovernanceRule, err error)
	RuleIDExecuteSingleSecurityConnector(ctx context.Context, resourceGroupName string, securityConnectorName string, ruleID string, executeGovernanceRuleParams *security.ExecuteGovernanceRuleParams) (result security.GovernanceRulesRuleIDExecuteSingleSecurityConnectorFuture, err error)
	RuleIDExecuteSingleSubscription(ctx context.Context, ruleID string, executeGovernanceRuleParams *security.ExecuteGovernanceRuleParams) (result security.GovernanceRulesRuleIDExecuteSingleSubscriptionFuture, err error)
}

var _ GovernanceRulesClientAPI = (*security.GovernanceRulesClient)(nil)

// ConnectorGovernanceRuleClientAPI contains the set of methods on the ConnectorGovernanceRuleClient type.
type ConnectorGovernanceRuleClientAPI interface {
	List(ctx context.Context, resourceGroupName string, securityConnectorName string) (result security.GovernanceRuleListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, securityConnectorName string) (result security.GovernanceRuleListIterator, err error)
}

var _ ConnectorGovernanceRuleClientAPI = (*security.ConnectorGovernanceRuleClient)(nil)

// ConnectorGovernanceRulesClientAPI contains the set of methods on the ConnectorGovernanceRulesClient type.
type ConnectorGovernanceRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, securityConnectorName string, ruleID string, governanceRule security.GovernanceRule) (result security.GovernanceRule, err error)
	Delete(ctx context.Context, resourceGroupName string, securityConnectorName string, ruleID string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, securityConnectorName string, ruleID string) (result security.GovernanceRule, err error)
}

var _ ConnectorGovernanceRulesClientAPI = (*security.ConnectorGovernanceRulesClient)(nil)

// SubscriptionGovernanceRulesExecuteStatusClientAPI contains the set of methods on the SubscriptionGovernanceRulesExecuteStatusClient type.
type SubscriptionGovernanceRulesExecuteStatusClientAPI interface {
	Get(ctx context.Context, ruleID string, operationID string) (result security.SubscriptionGovernanceRulesExecuteStatusGetFuture, err error)
}

var _ SubscriptionGovernanceRulesExecuteStatusClientAPI = (*security.SubscriptionGovernanceRulesExecuteStatusClient)(nil)

// ConnectorGovernanceRulesExecuteStatusClientAPI contains the set of methods on the ConnectorGovernanceRulesExecuteStatusClient type.
type ConnectorGovernanceRulesExecuteStatusClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, securityConnectorName string, ruleID string, operationID string) (result security.ConnectorGovernanceRulesExecuteStatusGetFuture, err error)
}

var _ ConnectorGovernanceRulesExecuteStatusClientAPI = (*security.ConnectorGovernanceRulesExecuteStatusClient)(nil)

// GovernanceAssignmentsClientAPI contains the set of methods on the GovernanceAssignmentsClient type.
type GovernanceAssignmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, scope string, assessmentName string, assignmentKey string, governanceAssignment security.GovernanceAssignment) (result security.GovernanceAssignment, err error)
	Delete(ctx context.Context, scope string, assessmentName string, assignmentKey string) (result autorest.Response, err error)
	Get(ctx context.Context, scope string, assessmentName string, assignmentKey string) (result security.GovernanceAssignment, err error)
	List(ctx context.Context, scope string, assessmentName string) (result security.GovernanceAssignmentsListPage, err error)
	ListComplete(ctx context.Context, scope string, assessmentName string) (result security.GovernanceAssignmentsListIterator, err error)
}

var _ GovernanceAssignmentsClientAPI = (*security.GovernanceAssignmentsClient)(nil)

// ApplicationsClientAPI contains the set of methods on the ApplicationsClient type.
type ApplicationsClientAPI interface {
	List(ctx context.Context) (result security.ApplicationsListPage, err error)
	ListComplete(ctx context.Context) (result security.ApplicationsListIterator, err error)
}

var _ ApplicationsClientAPI = (*security.ApplicationsClient)(nil)

// ApplicationClientAPI contains the set of methods on the ApplicationClient type.
type ApplicationClientAPI interface {
	CreateOrUpdate(ctx context.Context, applicationID string, application security.Application) (result security.Application, err error)
	Delete(ctx context.Context, applicationID string) (result autorest.Response, err error)
	Get(ctx context.Context, applicationID string) (result security.Application, err error)
}

var _ ApplicationClientAPI = (*security.ApplicationClient)(nil)

// ConnectorApplicationsClientAPI contains the set of methods on the ConnectorApplicationsClient type.
type ConnectorApplicationsClientAPI interface {
	List(ctx context.Context, resourceGroupName string, securityConnectorName string) (result security.ApplicationsListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, securityConnectorName string) (result security.ApplicationsListIterator, err error)
}

var _ ConnectorApplicationsClientAPI = (*security.ConnectorApplicationsClient)(nil)

// ConnectorApplicationClientAPI contains the set of methods on the ConnectorApplicationClient type.
type ConnectorApplicationClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, securityConnectorName string, applicationID string, application security.Application) (result security.Application, err error)
	Delete(ctx context.Context, resourceGroupName string, securityConnectorName string, applicationID string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, securityConnectorName string, applicationID string) (result security.Application, err error)
}

var _ ConnectorApplicationClientAPI = (*security.ConnectorApplicationClient)(nil)
