package insights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AggregationType enumerates the values for aggregation type.
type AggregationType string

const (
	// AggregationTypeAverage ...
	AggregationTypeAverage AggregationType = "Average"
	// AggregationTypeCount ...
	AggregationTypeCount AggregationType = "Count"
	// AggregationTypeMaximum ...
	AggregationTypeMaximum AggregationType = "Maximum"
	// AggregationTypeMinimum ...
	AggregationTypeMinimum AggregationType = "Minimum"
	// AggregationTypeNone ...
	AggregationTypeNone AggregationType = "None"
	// AggregationTypeTotal ...
	AggregationTypeTotal AggregationType = "Total"
)

// PossibleAggregationTypeValues returns an array of possible values for the AggregationType const type.
func PossibleAggregationTypeValues() []AggregationType {
	return []AggregationType{AggregationTypeAverage, AggregationTypeCount, AggregationTypeMaximum, AggregationTypeMinimum, AggregationTypeNone, AggregationTypeTotal}
}

// AggregationTypeEnum enumerates the values for aggregation type enum.
type AggregationTypeEnum string

const (
	// AggregationTypeEnumAverage ...
	AggregationTypeEnumAverage AggregationTypeEnum = "Average"
	// AggregationTypeEnumCount ...
	AggregationTypeEnumCount AggregationTypeEnum = "Count"
	// AggregationTypeEnumMaximum ...
	AggregationTypeEnumMaximum AggregationTypeEnum = "Maximum"
	// AggregationTypeEnumMinimum ...
	AggregationTypeEnumMinimum AggregationTypeEnum = "Minimum"
	// AggregationTypeEnumTotal ...
	AggregationTypeEnumTotal AggregationTypeEnum = "Total"
)

// PossibleAggregationTypeEnumValues returns an array of possible values for the AggregationTypeEnum const type.
func PossibleAggregationTypeEnumValues() []AggregationTypeEnum {
	return []AggregationTypeEnum{AggregationTypeEnumAverage, AggregationTypeEnumCount, AggregationTypeEnumMaximum, AggregationTypeEnumMinimum, AggregationTypeEnumTotal}
}

// AlertSeverity enumerates the values for alert severity.
type AlertSeverity string

const (
	// AlertSeverityFour ...
	AlertSeverityFour AlertSeverity = "4"
	// AlertSeverityOne ...
	AlertSeverityOne AlertSeverity = "1"
	// AlertSeverityThree ...
	AlertSeverityThree AlertSeverity = "3"
	// AlertSeverityTwo ...
	AlertSeverityTwo AlertSeverity = "2"
	// AlertSeverityZero ...
	AlertSeverityZero AlertSeverity = "0"
)

// PossibleAlertSeverityValues returns an array of possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{AlertSeverityFour, AlertSeverityOne, AlertSeverityThree, AlertSeverityTwo, AlertSeverityZero}
}

// BaselineSensitivity enumerates the values for baseline sensitivity.
type BaselineSensitivity string

const (
	// BaselineSensitivityHigh ...
	BaselineSensitivityHigh BaselineSensitivity = "High"
	// BaselineSensitivityLow ...
	BaselineSensitivityLow BaselineSensitivity = "Low"
	// BaselineSensitivityMedium ...
	BaselineSensitivityMedium BaselineSensitivity = "Medium"
)

// PossibleBaselineSensitivityValues returns an array of possible values for the BaselineSensitivity const type.
func PossibleBaselineSensitivityValues() []BaselineSensitivity {
	return []BaselineSensitivity{BaselineSensitivityHigh, BaselineSensitivityLow, BaselineSensitivityMedium}
}

// CategoryType enumerates the values for category type.
type CategoryType string

const (
	// CategoryTypeLogs ...
	CategoryTypeLogs CategoryType = "Logs"
	// CategoryTypeMetrics ...
	CategoryTypeMetrics CategoryType = "Metrics"
)

// PossibleCategoryTypeValues returns an array of possible values for the CategoryType const type.
func PossibleCategoryTypeValues() []CategoryType {
	return []CategoryType{CategoryTypeLogs, CategoryTypeMetrics}
}

// ComparisonOperationType enumerates the values for comparison operation type.
type ComparisonOperationType string

const (
	// ComparisonOperationTypeEquals ...
	ComparisonOperationTypeEquals ComparisonOperationType = "Equals"
	// ComparisonOperationTypeGreaterThan ...
	ComparisonOperationTypeGreaterThan ComparisonOperationType = "GreaterThan"
	// ComparisonOperationTypeGreaterThanOrEqual ...
	ComparisonOperationTypeGreaterThanOrEqual ComparisonOperationType = "GreaterThanOrEqual"
	// ComparisonOperationTypeLessThan ...
	ComparisonOperationTypeLessThan ComparisonOperationType = "LessThan"
	// ComparisonOperationTypeLessThanOrEqual ...
	ComparisonOperationTypeLessThanOrEqual ComparisonOperationType = "LessThanOrEqual"
	// ComparisonOperationTypeNotEquals ...
	ComparisonOperationTypeNotEquals ComparisonOperationType = "NotEquals"
)

// PossibleComparisonOperationTypeValues returns an array of possible values for the ComparisonOperationType const type.
func PossibleComparisonOperationTypeValues() []ComparisonOperationType {
	return []ComparisonOperationType{ComparisonOperationTypeEquals, ComparisonOperationTypeGreaterThan, ComparisonOperationTypeGreaterThanOrEqual, ComparisonOperationTypeLessThan, ComparisonOperationTypeLessThanOrEqual, ComparisonOperationTypeNotEquals}
}

// ConditionalOperator enumerates the values for conditional operator.
type ConditionalOperator string

const (
	// ConditionalOperatorEqual ...
	ConditionalOperatorEqual ConditionalOperator = "Equal"
	// ConditionalOperatorGreaterThan ...
	ConditionalOperatorGreaterThan ConditionalOperator = "GreaterThan"
	// ConditionalOperatorGreaterThanOrEqual ...
	ConditionalOperatorGreaterThanOrEqual ConditionalOperator = "GreaterThanOrEqual"
	// ConditionalOperatorLessThan ...
	ConditionalOperatorLessThan ConditionalOperator = "LessThan"
	// ConditionalOperatorLessThanOrEqual ...
	ConditionalOperatorLessThanOrEqual ConditionalOperator = "LessThanOrEqual"
)

// PossibleConditionalOperatorValues returns an array of possible values for the ConditionalOperator const type.
func PossibleConditionalOperatorValues() []ConditionalOperator {
	return []ConditionalOperator{ConditionalOperatorEqual, ConditionalOperatorGreaterThan, ConditionalOperatorGreaterThanOrEqual, ConditionalOperatorLessThan, ConditionalOperatorLessThanOrEqual}
}

// ConditionOperator enumerates the values for condition operator.
type ConditionOperator string

const (
	// ConditionOperatorGreaterThan ...
	ConditionOperatorGreaterThan ConditionOperator = "GreaterThan"
	// ConditionOperatorGreaterThanOrEqual ...
	ConditionOperatorGreaterThanOrEqual ConditionOperator = "GreaterThanOrEqual"
	// ConditionOperatorLessThan ...
	ConditionOperatorLessThan ConditionOperator = "LessThan"
	// ConditionOperatorLessThanOrEqual ...
	ConditionOperatorLessThanOrEqual ConditionOperator = "LessThanOrEqual"
)

// PossibleConditionOperatorValues returns an array of possible values for the ConditionOperator const type.
func PossibleConditionOperatorValues() []ConditionOperator {
	return []ConditionOperator{ConditionOperatorGreaterThan, ConditionOperatorGreaterThanOrEqual, ConditionOperatorLessThan, ConditionOperatorLessThanOrEqual}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// CriterionType enumerates the values for criterion type.
type CriterionType string

const (
	// CriterionTypeDynamicThresholdCriterion ...
	CriterionTypeDynamicThresholdCriterion CriterionType = "DynamicThresholdCriterion"
	// CriterionTypeMultiMetricCriteria ...
	CriterionTypeMultiMetricCriteria CriterionType = "MultiMetricCriteria"
	// CriterionTypeStaticThresholdCriterion ...
	CriterionTypeStaticThresholdCriterion CriterionType = "StaticThresholdCriterion"
)

// PossibleCriterionTypeValues returns an array of possible values for the CriterionType const type.
func PossibleCriterionTypeValues() []CriterionType {
	return []CriterionType{CriterionTypeDynamicThresholdCriterion, CriterionTypeMultiMetricCriteria, CriterionTypeStaticThresholdCriterion}
}

// DataStatus enumerates the values for data status.
type DataStatus string

const (
	// DataStatusNotPresent ...
	DataStatusNotPresent DataStatus = "notPresent"
	// DataStatusPresent ...
	DataStatusPresent DataStatus = "present"
)

// PossibleDataStatusValues returns an array of possible values for the DataStatus const type.
func PossibleDataStatusValues() []DataStatus {
	return []DataStatus{DataStatusNotPresent, DataStatusPresent}
}

// DynamicThresholdOperator enumerates the values for dynamic threshold operator.
type DynamicThresholdOperator string

const (
	// DynamicThresholdOperatorGreaterOrLessThan ...
	DynamicThresholdOperatorGreaterOrLessThan DynamicThresholdOperator = "GreaterOrLessThan"
	// DynamicThresholdOperatorGreaterThan ...
	DynamicThresholdOperatorGreaterThan DynamicThresholdOperator = "GreaterThan"
	// DynamicThresholdOperatorLessThan ...
	DynamicThresholdOperatorLessThan DynamicThresholdOperator = "LessThan"
)

// PossibleDynamicThresholdOperatorValues returns an array of possible values for the DynamicThresholdOperator const type.
func PossibleDynamicThresholdOperatorValues() []DynamicThresholdOperator {
	return []DynamicThresholdOperator{DynamicThresholdOperatorGreaterOrLessThan, DynamicThresholdOperatorGreaterThan, DynamicThresholdOperatorLessThan}
}

// DynamicThresholdSensitivity enumerates the values for dynamic threshold sensitivity.
type DynamicThresholdSensitivity string

const (
	// DynamicThresholdSensitivityHigh ...
	DynamicThresholdSensitivityHigh DynamicThresholdSensitivity = "High"
	// DynamicThresholdSensitivityLow ...
	DynamicThresholdSensitivityLow DynamicThresholdSensitivity = "Low"
	// DynamicThresholdSensitivityMedium ...
	DynamicThresholdSensitivityMedium DynamicThresholdSensitivity = "Medium"
)

// PossibleDynamicThresholdSensitivityValues returns an array of possible values for the DynamicThresholdSensitivity const type.
func PossibleDynamicThresholdSensitivityValues() []DynamicThresholdSensitivity {
	return []DynamicThresholdSensitivity{DynamicThresholdSensitivityHigh, DynamicThresholdSensitivityLow, DynamicThresholdSensitivityMedium}
}

// Enabled enumerates the values for enabled.
type Enabled string

const (
	// EnabledFalse ...
	EnabledFalse Enabled = "false"
	// EnabledTrue ...
	EnabledTrue Enabled = "true"
)

// PossibleEnabledValues returns an array of possible values for the Enabled const type.
func PossibleEnabledValues() []Enabled {
	return []Enabled{EnabledFalse, EnabledTrue}
}

// EventLevel enumerates the values for event level.
type EventLevel string

const (
	// EventLevelCritical ...
	EventLevelCritical EventLevel = "Critical"
	// EventLevelError ...
	EventLevelError EventLevel = "Error"
	// EventLevelInformational ...
	EventLevelInformational EventLevel = "Informational"
	// EventLevelVerbose ...
	EventLevelVerbose EventLevel = "Verbose"
	// EventLevelWarning ...
	EventLevelWarning EventLevel = "Warning"
)

// PossibleEventLevelValues returns an array of possible values for the EventLevel const type.
func PossibleEventLevelValues() []EventLevel {
	return []EventLevel{EventLevelCritical, EventLevelError, EventLevelInformational, EventLevelVerbose, EventLevelWarning}
}

// KnownDataCollectionEndpointProvisioningState enumerates the values for known data collection endpoint
// provisioning state.
type KnownDataCollectionEndpointProvisioningState string

const (
	// KnownDataCollectionEndpointProvisioningStateCreating ...
	KnownDataCollectionEndpointProvisioningStateCreating KnownDataCollectionEndpointProvisioningState = "Creating"
	// KnownDataCollectionEndpointProvisioningStateDeleting ...
	KnownDataCollectionEndpointProvisioningStateDeleting KnownDataCollectionEndpointProvisioningState = "Deleting"
	// KnownDataCollectionEndpointProvisioningStateFailed ...
	KnownDataCollectionEndpointProvisioningStateFailed KnownDataCollectionEndpointProvisioningState = "Failed"
	// KnownDataCollectionEndpointProvisioningStateSucceeded ...
	KnownDataCollectionEndpointProvisioningStateSucceeded KnownDataCollectionEndpointProvisioningState = "Succeeded"
	// KnownDataCollectionEndpointProvisioningStateUpdating ...
	KnownDataCollectionEndpointProvisioningStateUpdating KnownDataCollectionEndpointProvisioningState = "Updating"
)

// PossibleKnownDataCollectionEndpointProvisioningStateValues returns an array of possible values for the KnownDataCollectionEndpointProvisioningState const type.
func PossibleKnownDataCollectionEndpointProvisioningStateValues() []KnownDataCollectionEndpointProvisioningState {
	return []KnownDataCollectionEndpointProvisioningState{KnownDataCollectionEndpointProvisioningStateCreating, KnownDataCollectionEndpointProvisioningStateDeleting, KnownDataCollectionEndpointProvisioningStateFailed, KnownDataCollectionEndpointProvisioningStateSucceeded, KnownDataCollectionEndpointProvisioningStateUpdating}
}

// KnownDataCollectionEndpointResourceKind enumerates the values for known data collection endpoint resource
// kind.
type KnownDataCollectionEndpointResourceKind string

const (
	// KnownDataCollectionEndpointResourceKindLinux ...
	KnownDataCollectionEndpointResourceKindLinux KnownDataCollectionEndpointResourceKind = "Linux"
	// KnownDataCollectionEndpointResourceKindWindows ...
	KnownDataCollectionEndpointResourceKindWindows KnownDataCollectionEndpointResourceKind = "Windows"
)

// PossibleKnownDataCollectionEndpointResourceKindValues returns an array of possible values for the KnownDataCollectionEndpointResourceKind const type.
func PossibleKnownDataCollectionEndpointResourceKindValues() []KnownDataCollectionEndpointResourceKind {
	return []KnownDataCollectionEndpointResourceKind{KnownDataCollectionEndpointResourceKindLinux, KnownDataCollectionEndpointResourceKindWindows}
}

// KnownDataCollectionRuleAssociationProvisioningState enumerates the values for known data collection rule
// association provisioning state.
type KnownDataCollectionRuleAssociationProvisioningState string

const (
	// KnownDataCollectionRuleAssociationProvisioningStateCreating ...
	KnownDataCollectionRuleAssociationProvisioningStateCreating KnownDataCollectionRuleAssociationProvisioningState = "Creating"
	// KnownDataCollectionRuleAssociationProvisioningStateDeleting ...
	KnownDataCollectionRuleAssociationProvisioningStateDeleting KnownDataCollectionRuleAssociationProvisioningState = "Deleting"
	// KnownDataCollectionRuleAssociationProvisioningStateFailed ...
	KnownDataCollectionRuleAssociationProvisioningStateFailed KnownDataCollectionRuleAssociationProvisioningState = "Failed"
	// KnownDataCollectionRuleAssociationProvisioningStateSucceeded ...
	KnownDataCollectionRuleAssociationProvisioningStateSucceeded KnownDataCollectionRuleAssociationProvisioningState = "Succeeded"
	// KnownDataCollectionRuleAssociationProvisioningStateUpdating ...
	KnownDataCollectionRuleAssociationProvisioningStateUpdating KnownDataCollectionRuleAssociationProvisioningState = "Updating"
)

// PossibleKnownDataCollectionRuleAssociationProvisioningStateValues returns an array of possible values for the KnownDataCollectionRuleAssociationProvisioningState const type.
func PossibleKnownDataCollectionRuleAssociationProvisioningStateValues() []KnownDataCollectionRuleAssociationProvisioningState {
	return []KnownDataCollectionRuleAssociationProvisioningState{KnownDataCollectionRuleAssociationProvisioningStateCreating, KnownDataCollectionRuleAssociationProvisioningStateDeleting, KnownDataCollectionRuleAssociationProvisioningStateFailed, KnownDataCollectionRuleAssociationProvisioningStateSucceeded, KnownDataCollectionRuleAssociationProvisioningStateUpdating}
}

// KnownDataCollectionRuleProvisioningState enumerates the values for known data collection rule provisioning
// state.
type KnownDataCollectionRuleProvisioningState string

const (
	// KnownDataCollectionRuleProvisioningStateCreating ...
	KnownDataCollectionRuleProvisioningStateCreating KnownDataCollectionRuleProvisioningState = "Creating"
	// KnownDataCollectionRuleProvisioningStateDeleting ...
	KnownDataCollectionRuleProvisioningStateDeleting KnownDataCollectionRuleProvisioningState = "Deleting"
	// KnownDataCollectionRuleProvisioningStateFailed ...
	KnownDataCollectionRuleProvisioningStateFailed KnownDataCollectionRuleProvisioningState = "Failed"
	// KnownDataCollectionRuleProvisioningStateSucceeded ...
	KnownDataCollectionRuleProvisioningStateSucceeded KnownDataCollectionRuleProvisioningState = "Succeeded"
	// KnownDataCollectionRuleProvisioningStateUpdating ...
	KnownDataCollectionRuleProvisioningStateUpdating KnownDataCollectionRuleProvisioningState = "Updating"
)

// PossibleKnownDataCollectionRuleProvisioningStateValues returns an array of possible values for the KnownDataCollectionRuleProvisioningState const type.
func PossibleKnownDataCollectionRuleProvisioningStateValues() []KnownDataCollectionRuleProvisioningState {
	return []KnownDataCollectionRuleProvisioningState{KnownDataCollectionRuleProvisioningStateCreating, KnownDataCollectionRuleProvisioningStateDeleting, KnownDataCollectionRuleProvisioningStateFailed, KnownDataCollectionRuleProvisioningStateSucceeded, KnownDataCollectionRuleProvisioningStateUpdating}
}

// KnownDataCollectionRuleResourceKind enumerates the values for known data collection rule resource kind.
type KnownDataCollectionRuleResourceKind string

const (
	// KnownDataCollectionRuleResourceKindLinux ...
	KnownDataCollectionRuleResourceKindLinux KnownDataCollectionRuleResourceKind = "Linux"
	// KnownDataCollectionRuleResourceKindWindows ...
	KnownDataCollectionRuleResourceKindWindows KnownDataCollectionRuleResourceKind = "Windows"
)

// PossibleKnownDataCollectionRuleResourceKindValues returns an array of possible values for the KnownDataCollectionRuleResourceKind const type.
func PossibleKnownDataCollectionRuleResourceKindValues() []KnownDataCollectionRuleResourceKind {
	return []KnownDataCollectionRuleResourceKind{KnownDataCollectionRuleResourceKindLinux, KnownDataCollectionRuleResourceKindWindows}
}

// KnownDataFlowStreams enumerates the values for known data flow streams.
type KnownDataFlowStreams string

const (
	// KnownDataFlowStreamsMicrosoftEvent ...
	KnownDataFlowStreamsMicrosoftEvent KnownDataFlowStreams = "Microsoft-Event"
	// KnownDataFlowStreamsMicrosoftInsightsMetrics ...
	KnownDataFlowStreamsMicrosoftInsightsMetrics KnownDataFlowStreams = "Microsoft-InsightsMetrics"
	// KnownDataFlowStreamsMicrosoftPerf ...
	KnownDataFlowStreamsMicrosoftPerf KnownDataFlowStreams = "Microsoft-Perf"
	// KnownDataFlowStreamsMicrosoftSyslog ...
	KnownDataFlowStreamsMicrosoftSyslog KnownDataFlowStreams = "Microsoft-Syslog"
	// KnownDataFlowStreamsMicrosoftWindowsEvent ...
	KnownDataFlowStreamsMicrosoftWindowsEvent KnownDataFlowStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownDataFlowStreamsValues returns an array of possible values for the KnownDataFlowStreams const type.
func PossibleKnownDataFlowStreamsValues() []KnownDataFlowStreams {
	return []KnownDataFlowStreams{KnownDataFlowStreamsMicrosoftEvent, KnownDataFlowStreamsMicrosoftInsightsMetrics, KnownDataFlowStreamsMicrosoftPerf, KnownDataFlowStreamsMicrosoftSyslog, KnownDataFlowStreamsMicrosoftWindowsEvent}
}

// KnownExtensionDataSourceStreams enumerates the values for known extension data source streams.
type KnownExtensionDataSourceStreams string

const (
	// KnownExtensionDataSourceStreamsMicrosoftEvent ...
	KnownExtensionDataSourceStreamsMicrosoftEvent KnownExtensionDataSourceStreams = "Microsoft-Event"
	// KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics ...
	KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics KnownExtensionDataSourceStreams = "Microsoft-InsightsMetrics"
	// KnownExtensionDataSourceStreamsMicrosoftPerf ...
	KnownExtensionDataSourceStreamsMicrosoftPerf KnownExtensionDataSourceStreams = "Microsoft-Perf"
	// KnownExtensionDataSourceStreamsMicrosoftSyslog ...
	KnownExtensionDataSourceStreamsMicrosoftSyslog KnownExtensionDataSourceStreams = "Microsoft-Syslog"
	// KnownExtensionDataSourceStreamsMicrosoftWindowsEvent ...
	KnownExtensionDataSourceStreamsMicrosoftWindowsEvent KnownExtensionDataSourceStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownExtensionDataSourceStreamsValues returns an array of possible values for the KnownExtensionDataSourceStreams const type.
func PossibleKnownExtensionDataSourceStreamsValues() []KnownExtensionDataSourceStreams {
	return []KnownExtensionDataSourceStreams{KnownExtensionDataSourceStreamsMicrosoftEvent, KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics, KnownExtensionDataSourceStreamsMicrosoftPerf, KnownExtensionDataSourceStreamsMicrosoftSyslog, KnownExtensionDataSourceStreamsMicrosoftWindowsEvent}
}

// KnownPerfCounterDataSourceStreams enumerates the values for known perf counter data source streams.
type KnownPerfCounterDataSourceStreams string

const (
	// KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics ...
	KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics KnownPerfCounterDataSourceStreams = "Microsoft-InsightsMetrics"
	// KnownPerfCounterDataSourceStreamsMicrosoftPerf ...
	KnownPerfCounterDataSourceStreamsMicrosoftPerf KnownPerfCounterDataSourceStreams = "Microsoft-Perf"
)

// PossibleKnownPerfCounterDataSourceStreamsValues returns an array of possible values for the KnownPerfCounterDataSourceStreams const type.
func PossibleKnownPerfCounterDataSourceStreamsValues() []KnownPerfCounterDataSourceStreams {
	return []KnownPerfCounterDataSourceStreams{KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics, KnownPerfCounterDataSourceStreamsMicrosoftPerf}
}

// KnownPublicNetworkAccessOptions enumerates the values for known public network access options.
type KnownPublicNetworkAccessOptions string

const (
	// KnownPublicNetworkAccessOptionsDisabled ...
	KnownPublicNetworkAccessOptionsDisabled KnownPublicNetworkAccessOptions = "Disabled"
	// KnownPublicNetworkAccessOptionsEnabled ...
	KnownPublicNetworkAccessOptionsEnabled KnownPublicNetworkAccessOptions = "Enabled"
)

// PossibleKnownPublicNetworkAccessOptionsValues returns an array of possible values for the KnownPublicNetworkAccessOptions const type.
func PossibleKnownPublicNetworkAccessOptionsValues() []KnownPublicNetworkAccessOptions {
	return []KnownPublicNetworkAccessOptions{KnownPublicNetworkAccessOptionsDisabled, KnownPublicNetworkAccessOptionsEnabled}
}

// KnownSyslogDataSourceFacilityNames enumerates the values for known syslog data source facility names.
type KnownSyslogDataSourceFacilityNames string

const (
	// KnownSyslogDataSourceFacilityNamesAsterisk ...
	KnownSyslogDataSourceFacilityNamesAsterisk KnownSyslogDataSourceFacilityNames = "*"
	// KnownSyslogDataSourceFacilityNamesAuth ...
	KnownSyslogDataSourceFacilityNamesAuth KnownSyslogDataSourceFacilityNames = "auth"
	// KnownSyslogDataSourceFacilityNamesAuthpriv ...
	KnownSyslogDataSourceFacilityNamesAuthpriv KnownSyslogDataSourceFacilityNames = "authpriv"
	// KnownSyslogDataSourceFacilityNamesCron ...
	KnownSyslogDataSourceFacilityNamesCron KnownSyslogDataSourceFacilityNames = "cron"
	// KnownSyslogDataSourceFacilityNamesDaemon ...
	KnownSyslogDataSourceFacilityNamesDaemon KnownSyslogDataSourceFacilityNames = "daemon"
	// KnownSyslogDataSourceFacilityNamesKern ...
	KnownSyslogDataSourceFacilityNamesKern KnownSyslogDataSourceFacilityNames = "kern"
	// KnownSyslogDataSourceFacilityNamesLocal0 ...
	KnownSyslogDataSourceFacilityNamesLocal0 KnownSyslogDataSourceFacilityNames = "local0"
	// KnownSyslogDataSourceFacilityNamesLocal1 ...
	KnownSyslogDataSourceFacilityNamesLocal1 KnownSyslogDataSourceFacilityNames = "local1"
	// KnownSyslogDataSourceFacilityNamesLocal2 ...
	KnownSyslogDataSourceFacilityNamesLocal2 KnownSyslogDataSourceFacilityNames = "local2"
	// KnownSyslogDataSourceFacilityNamesLocal3 ...
	KnownSyslogDataSourceFacilityNamesLocal3 KnownSyslogDataSourceFacilityNames = "local3"
	// KnownSyslogDataSourceFacilityNamesLocal4 ...
	KnownSyslogDataSourceFacilityNamesLocal4 KnownSyslogDataSourceFacilityNames = "local4"
	// KnownSyslogDataSourceFacilityNamesLocal5 ...
	KnownSyslogDataSourceFacilityNamesLocal5 KnownSyslogDataSourceFacilityNames = "local5"
	// KnownSyslogDataSourceFacilityNamesLocal6 ...
	KnownSyslogDataSourceFacilityNamesLocal6 KnownSyslogDataSourceFacilityNames = "local6"
	// KnownSyslogDataSourceFacilityNamesLocal7 ...
	KnownSyslogDataSourceFacilityNamesLocal7 KnownSyslogDataSourceFacilityNames = "local7"
	// KnownSyslogDataSourceFacilityNamesLpr ...
	KnownSyslogDataSourceFacilityNamesLpr KnownSyslogDataSourceFacilityNames = "lpr"
	// KnownSyslogDataSourceFacilityNamesMail ...
	KnownSyslogDataSourceFacilityNamesMail KnownSyslogDataSourceFacilityNames = "mail"
	// KnownSyslogDataSourceFacilityNamesMark ...
	KnownSyslogDataSourceFacilityNamesMark KnownSyslogDataSourceFacilityNames = "mark"
	// KnownSyslogDataSourceFacilityNamesNews ...
	KnownSyslogDataSourceFacilityNamesNews KnownSyslogDataSourceFacilityNames = "news"
	// KnownSyslogDataSourceFacilityNamesSyslog ...
	KnownSyslogDataSourceFacilityNamesSyslog KnownSyslogDataSourceFacilityNames = "syslog"
	// KnownSyslogDataSourceFacilityNamesUser ...
	KnownSyslogDataSourceFacilityNamesUser KnownSyslogDataSourceFacilityNames = "user"
	// KnownSyslogDataSourceFacilityNamesUucp ...
	KnownSyslogDataSourceFacilityNamesUucp KnownSyslogDataSourceFacilityNames = "uucp"
)

// PossibleKnownSyslogDataSourceFacilityNamesValues returns an array of possible values for the KnownSyslogDataSourceFacilityNames const type.
func PossibleKnownSyslogDataSourceFacilityNamesValues() []KnownSyslogDataSourceFacilityNames {
	return []KnownSyslogDataSourceFacilityNames{KnownSyslogDataSourceFacilityNamesAsterisk, KnownSyslogDataSourceFacilityNamesAuth, KnownSyslogDataSourceFacilityNamesAuthpriv, KnownSyslogDataSourceFacilityNamesCron, KnownSyslogDataSourceFacilityNamesDaemon, KnownSyslogDataSourceFacilityNamesKern, KnownSyslogDataSourceFacilityNamesLocal0, KnownSyslogDataSourceFacilityNamesLocal1, KnownSyslogDataSourceFacilityNamesLocal2, KnownSyslogDataSourceFacilityNamesLocal3, KnownSyslogDataSourceFacilityNamesLocal4, KnownSyslogDataSourceFacilityNamesLocal5, KnownSyslogDataSourceFacilityNamesLocal6, KnownSyslogDataSourceFacilityNamesLocal7, KnownSyslogDataSourceFacilityNamesLpr, KnownSyslogDataSourceFacilityNamesMail, KnownSyslogDataSourceFacilityNamesMark, KnownSyslogDataSourceFacilityNamesNews, KnownSyslogDataSourceFacilityNamesSyslog, KnownSyslogDataSourceFacilityNamesUser, KnownSyslogDataSourceFacilityNamesUucp}
}

// KnownSyslogDataSourceLogLevels enumerates the values for known syslog data source log levels.
type KnownSyslogDataSourceLogLevels string

const (
	// KnownSyslogDataSourceLogLevelsAlert ...
	KnownSyslogDataSourceLogLevelsAlert KnownSyslogDataSourceLogLevels = "Alert"
	// KnownSyslogDataSourceLogLevelsAsterisk ...
	KnownSyslogDataSourceLogLevelsAsterisk KnownSyslogDataSourceLogLevels = "*"
	// KnownSyslogDataSourceLogLevelsCritical ...
	KnownSyslogDataSourceLogLevelsCritical KnownSyslogDataSourceLogLevels = "Critical"
	// KnownSyslogDataSourceLogLevelsDebug ...
	KnownSyslogDataSourceLogLevelsDebug KnownSyslogDataSourceLogLevels = "Debug"
	// KnownSyslogDataSourceLogLevelsEmergency ...
	KnownSyslogDataSourceLogLevelsEmergency KnownSyslogDataSourceLogLevels = "Emergency"
	// KnownSyslogDataSourceLogLevelsError ...
	KnownSyslogDataSourceLogLevelsError KnownSyslogDataSourceLogLevels = "Error"
	// KnownSyslogDataSourceLogLevelsInfo ...
	KnownSyslogDataSourceLogLevelsInfo KnownSyslogDataSourceLogLevels = "Info"
	// KnownSyslogDataSourceLogLevelsNotice ...
	KnownSyslogDataSourceLogLevelsNotice KnownSyslogDataSourceLogLevels = "Notice"
	// KnownSyslogDataSourceLogLevelsWarning ...
	KnownSyslogDataSourceLogLevelsWarning KnownSyslogDataSourceLogLevels = "Warning"
)

// PossibleKnownSyslogDataSourceLogLevelsValues returns an array of possible values for the KnownSyslogDataSourceLogLevels const type.
func PossibleKnownSyslogDataSourceLogLevelsValues() []KnownSyslogDataSourceLogLevels {
	return []KnownSyslogDataSourceLogLevels{KnownSyslogDataSourceLogLevelsAlert, KnownSyslogDataSourceLogLevelsAsterisk, KnownSyslogDataSourceLogLevelsCritical, KnownSyslogDataSourceLogLevelsDebug, KnownSyslogDataSourceLogLevelsEmergency, KnownSyslogDataSourceLogLevelsError, KnownSyslogDataSourceLogLevelsInfo, KnownSyslogDataSourceLogLevelsNotice, KnownSyslogDataSourceLogLevelsWarning}
}

// KnownSyslogDataSourceStreams enumerates the values for known syslog data source streams.
type KnownSyslogDataSourceStreams string

const (
	// KnownSyslogDataSourceStreamsMicrosoftSyslog ...
	KnownSyslogDataSourceStreamsMicrosoftSyslog KnownSyslogDataSourceStreams = "Microsoft-Syslog"
)

// PossibleKnownSyslogDataSourceStreamsValues returns an array of possible values for the KnownSyslogDataSourceStreams const type.
func PossibleKnownSyslogDataSourceStreamsValues() []KnownSyslogDataSourceStreams {
	return []KnownSyslogDataSourceStreams{KnownSyslogDataSourceStreamsMicrosoftSyslog}
}

// KnownWindowsEventLogDataSourceStreams enumerates the values for known windows event log data source streams.
type KnownWindowsEventLogDataSourceStreams string

const (
	// KnownWindowsEventLogDataSourceStreamsMicrosoftEvent ...
	KnownWindowsEventLogDataSourceStreamsMicrosoftEvent KnownWindowsEventLogDataSourceStreams = "Microsoft-Event"
	// KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent ...
	KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent KnownWindowsEventLogDataSourceStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownWindowsEventLogDataSourceStreamsValues returns an array of possible values for the KnownWindowsEventLogDataSourceStreams const type.
func PossibleKnownWindowsEventLogDataSourceStreamsValues() []KnownWindowsEventLogDataSourceStreams {
	return []KnownWindowsEventLogDataSourceStreams{KnownWindowsEventLogDataSourceStreamsMicrosoftEvent, KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent}
}

// MetricClass enumerates the values for metric class.
type MetricClass string

const (
	// MetricClassAvailability ...
	MetricClassAvailability MetricClass = "Availability"
	// MetricClassErrors ...
	MetricClassErrors MetricClass = "Errors"
	// MetricClassLatency ...
	MetricClassLatency MetricClass = "Latency"
	// MetricClassSaturation ...
	MetricClassSaturation MetricClass = "Saturation"
	// MetricClassTransactions ...
	MetricClassTransactions MetricClass = "Transactions"
)

// PossibleMetricClassValues returns an array of possible values for the MetricClass const type.
func PossibleMetricClassValues() []MetricClass {
	return []MetricClass{MetricClassAvailability, MetricClassErrors, MetricClassLatency, MetricClassSaturation, MetricClassTransactions}
}

// MetricStatisticType enumerates the values for metric statistic type.
type MetricStatisticType string

const (
	// MetricStatisticTypeAverage ...
	MetricStatisticTypeAverage MetricStatisticType = "Average"
	// MetricStatisticTypeCount ...
	MetricStatisticTypeCount MetricStatisticType = "Count"
	// MetricStatisticTypeMax ...
	MetricStatisticTypeMax MetricStatisticType = "Max"
	// MetricStatisticTypeMin ...
	MetricStatisticTypeMin MetricStatisticType = "Min"
	// MetricStatisticTypeSum ...
	MetricStatisticTypeSum MetricStatisticType = "Sum"
)

// PossibleMetricStatisticTypeValues returns an array of possible values for the MetricStatisticType const type.
func PossibleMetricStatisticTypeValues() []MetricStatisticType {
	return []MetricStatisticType{MetricStatisticTypeAverage, MetricStatisticTypeCount, MetricStatisticTypeMax, MetricStatisticTypeMin, MetricStatisticTypeSum}
}

// MetricTriggerType enumerates the values for metric trigger type.
type MetricTriggerType string

const (
	// MetricTriggerTypeConsecutive ...
	MetricTriggerTypeConsecutive MetricTriggerType = "Consecutive"
	// MetricTriggerTypeTotal ...
	MetricTriggerTypeTotal MetricTriggerType = "Total"
)

// PossibleMetricTriggerTypeValues returns an array of possible values for the MetricTriggerType const type.
func PossibleMetricTriggerTypeValues() []MetricTriggerType {
	return []MetricTriggerType{MetricTriggerTypeConsecutive, MetricTriggerTypeTotal}
}

// MetricUnit enumerates the values for metric unit.
type MetricUnit string

const (
	// MetricUnitBitsPerSecond ...
	MetricUnitBitsPerSecond MetricUnit = "BitsPerSecond"
	// MetricUnitBytes ...
	MetricUnitBytes MetricUnit = "Bytes"
	// MetricUnitByteSeconds ...
	MetricUnitByteSeconds MetricUnit = "ByteSeconds"
	// MetricUnitBytesPerSecond ...
	MetricUnitBytesPerSecond MetricUnit = "BytesPerSecond"
	// MetricUnitCores ...
	MetricUnitCores MetricUnit = "Cores"
	// MetricUnitCount ...
	MetricUnitCount MetricUnit = "Count"
	// MetricUnitCountPerSecond ...
	MetricUnitCountPerSecond MetricUnit = "CountPerSecond"
	// MetricUnitMilliCores ...
	MetricUnitMilliCores MetricUnit = "MilliCores"
	// MetricUnitMilliSeconds ...
	MetricUnitMilliSeconds MetricUnit = "MilliSeconds"
	// MetricUnitNanoCores ...
	MetricUnitNanoCores MetricUnit = "NanoCores"
	// MetricUnitPercent ...
	MetricUnitPercent MetricUnit = "Percent"
	// MetricUnitSeconds ...
	MetricUnitSeconds MetricUnit = "Seconds"
	// MetricUnitUnspecified ...
	MetricUnitUnspecified MetricUnit = "Unspecified"
)

// PossibleMetricUnitValues returns an array of possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{MetricUnitBitsPerSecond, MetricUnitBytes, MetricUnitByteSeconds, MetricUnitBytesPerSecond, MetricUnitCores, MetricUnitCount, MetricUnitCountPerSecond, MetricUnitMilliCores, MetricUnitMilliSeconds, MetricUnitNanoCores, MetricUnitPercent, MetricUnitSeconds, MetricUnitUnspecified}
}

// NamespaceClassification enumerates the values for namespace classification.
type NamespaceClassification string

const (
	// NamespaceClassificationCustom ...
	NamespaceClassificationCustom NamespaceClassification = "Custom"
	// NamespaceClassificationPlatform ...
	NamespaceClassificationPlatform NamespaceClassification = "Platform"
	// NamespaceClassificationQos ...
	NamespaceClassificationQos NamespaceClassification = "Qos"
)

// PossibleNamespaceClassificationValues returns an array of possible values for the NamespaceClassification const type.
func PossibleNamespaceClassificationValues() []NamespaceClassification {
	return []NamespaceClassification{NamespaceClassificationCustom, NamespaceClassificationPlatform, NamespaceClassificationQos}
}

// OdataType enumerates the values for odata type.
type OdataType string

const (
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource OdataType = "Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource"
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource OdataType = "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource"
	// OdataTypeRuleDataSource ...
	OdataTypeRuleDataSource OdataType = "RuleDataSource"
)

// PossibleOdataTypeValues returns an array of possible values for the OdataType const type.
func PossibleOdataTypeValues() []OdataType {
	return []OdataType{OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource, OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource, OdataTypeRuleDataSource}
}

// OdataTypeBasicAction enumerates the values for odata type basic action.
type OdataTypeBasicAction string

const (
	// OdataTypeBasicActionOdataTypeAction ...
	OdataTypeBasicActionOdataTypeAction OdataTypeBasicAction = "Action"
	// OdataTypeBasicActionOdataTypeMicrosoftWindowsAzureManagementMonitoringAlertsModelsMicrosoftAppInsightsNexusDataContractsResourcesScheduledQueryRulesAlertingAction ...
	OdataTypeBasicActionOdataTypeMicrosoftWindowsAzureManagementMonitoringAlertsModelsMicrosoftAppInsightsNexusDataContractsResourcesScheduledQueryRulesAlertingAction OdataTypeBasicAction = "Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.AlertingAction"
	// OdataTypeBasicActionOdataTypeMicrosoftWindowsAzureManagementMonitoringAlertsModelsMicrosoftAppInsightsNexusDataContractsResourcesScheduledQueryRulesLogToMetricAction ...
	OdataTypeBasicActionOdataTypeMicrosoftWindowsAzureManagementMonitoringAlertsModelsMicrosoftAppInsightsNexusDataContractsResourcesScheduledQueryRulesLogToMetricAction OdataTypeBasicAction = "Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.LogToMetricAction"
)

// PossibleOdataTypeBasicActionValues returns an array of possible values for the OdataTypeBasicAction const type.
func PossibleOdataTypeBasicActionValues() []OdataTypeBasicAction {
	return []OdataTypeBasicAction{OdataTypeBasicActionOdataTypeAction, OdataTypeBasicActionOdataTypeMicrosoftWindowsAzureManagementMonitoringAlertsModelsMicrosoftAppInsightsNexusDataContractsResourcesScheduledQueryRulesAlertingAction, OdataTypeBasicActionOdataTypeMicrosoftWindowsAzureManagementMonitoringAlertsModelsMicrosoftAppInsightsNexusDataContractsResourcesScheduledQueryRulesLogToMetricAction}
}

// OdataTypeBasicMetricAlertCriteria enumerates the values for odata type basic metric alert criteria.
type OdataTypeBasicMetricAlertCriteria string

const (
	// OdataTypeBasicMetricAlertCriteriaOdataTypeMetricAlertCriteria ...
	OdataTypeBasicMetricAlertCriteriaOdataTypeMetricAlertCriteria OdataTypeBasicMetricAlertCriteria = "MetricAlertCriteria"
	// OdataTypeBasicMetricAlertCriteriaOdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria ...
	OdataTypeBasicMetricAlertCriteriaOdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria OdataTypeBasicMetricAlertCriteria = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria"
	// OdataTypeBasicMetricAlertCriteriaOdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria ...
	OdataTypeBasicMetricAlertCriteriaOdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria OdataTypeBasicMetricAlertCriteria = "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria"
	// OdataTypeBasicMetricAlertCriteriaOdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria ...
	OdataTypeBasicMetricAlertCriteriaOdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria OdataTypeBasicMetricAlertCriteria = "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria"
)

// PossibleOdataTypeBasicMetricAlertCriteriaValues returns an array of possible values for the OdataTypeBasicMetricAlertCriteria const type.
func PossibleOdataTypeBasicMetricAlertCriteriaValues() []OdataTypeBasicMetricAlertCriteria {
	return []OdataTypeBasicMetricAlertCriteria{OdataTypeBasicMetricAlertCriteriaOdataTypeMetricAlertCriteria, OdataTypeBasicMetricAlertCriteriaOdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria, OdataTypeBasicMetricAlertCriteriaOdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria, OdataTypeBasicMetricAlertCriteriaOdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria}
}

// OdataTypeBasicRuleAction enumerates the values for odata type basic rule action.
type OdataTypeBasicRuleAction string

const (
	// OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction ...
	OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction OdataTypeBasicRuleAction = "Microsoft.Azure.Management.Insights.Models.RuleEmailAction"
	// OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction ...
	OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction OdataTypeBasicRuleAction = "Microsoft.Azure.Management.Insights.Models.RuleWebhookAction"
	// OdataTypeBasicRuleActionOdataTypeRuleAction ...
	OdataTypeBasicRuleActionOdataTypeRuleAction OdataTypeBasicRuleAction = "RuleAction"
)

// PossibleOdataTypeBasicRuleActionValues returns an array of possible values for the OdataTypeBasicRuleAction const type.
func PossibleOdataTypeBasicRuleActionValues() []OdataTypeBasicRuleAction {
	return []OdataTypeBasicRuleAction{OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction, OdataTypeBasicRuleActionOdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction, OdataTypeBasicRuleActionOdataTypeRuleAction}
}

// OdataTypeBasicRuleCondition enumerates the values for odata type basic rule condition.
type OdataTypeBasicRuleCondition string

const (
	// OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition ...
	OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition OdataTypeBasicRuleCondition = "Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition"
	// OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition ...
	OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition OdataTypeBasicRuleCondition = "Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition"
	// OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition ...
	OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition OdataTypeBasicRuleCondition = "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition"
	// OdataTypeBasicRuleConditionOdataTypeRuleCondition ...
	OdataTypeBasicRuleConditionOdataTypeRuleCondition OdataTypeBasicRuleCondition = "RuleCondition"
)

// PossibleOdataTypeBasicRuleConditionValues returns an array of possible values for the OdataTypeBasicRuleCondition const type.
func PossibleOdataTypeBasicRuleConditionValues() []OdataTypeBasicRuleCondition {
	return []OdataTypeBasicRuleCondition{OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition, OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition, OdataTypeBasicRuleConditionOdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition, OdataTypeBasicRuleConditionOdataTypeRuleCondition}
}

// OnboardingStatus enumerates the values for onboarding status.
type OnboardingStatus string

const (
	// OnboardingStatusNotOnboarded ...
	OnboardingStatusNotOnboarded OnboardingStatus = "notOnboarded"
	// OnboardingStatusOnboarded ...
	OnboardingStatusOnboarded OnboardingStatus = "onboarded"
	// OnboardingStatusUnknown ...
	OnboardingStatusUnknown OnboardingStatus = "unknown"
)

// PossibleOnboardingStatusValues returns an array of possible values for the OnboardingStatus const type.
func PossibleOnboardingStatusValues() []OnboardingStatus {
	return []OnboardingStatus{OnboardingStatusNotOnboarded, OnboardingStatusOnboarded, OnboardingStatusUnknown}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// OperatorEquals ...
	OperatorEquals Operator = "Equals"
	// OperatorGreaterThan ...
	OperatorGreaterThan Operator = "GreaterThan"
	// OperatorGreaterThanOrEqual ...
	OperatorGreaterThanOrEqual Operator = "GreaterThanOrEqual"
	// OperatorLessThan ...
	OperatorLessThan Operator = "LessThan"
	// OperatorLessThanOrEqual ...
	OperatorLessThanOrEqual Operator = "LessThanOrEqual"
	// OperatorNotEquals ...
	OperatorNotEquals Operator = "NotEquals"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{OperatorEquals, OperatorGreaterThan, OperatorGreaterThanOrEqual, OperatorLessThan, OperatorLessThanOrEqual, OperatorNotEquals}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateDeploying ...
	ProvisioningStateDeploying ProvisioningState = "Deploying"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateDeploying, ProvisioningStateFailed, ProvisioningStateSucceeded}
}

// QueryType enumerates the values for query type.
type QueryType string

const (
	// QueryTypeResultCount ...
	QueryTypeResultCount QueryType = "ResultCount"
)

// PossibleQueryTypeValues returns an array of possible values for the QueryType const type.
func PossibleQueryTypeValues() []QueryType {
	return []QueryType{QueryTypeResultCount}
}

// ReceiverStatus enumerates the values for receiver status.
type ReceiverStatus string

const (
	// ReceiverStatusDisabled ...
	ReceiverStatusDisabled ReceiverStatus = "Disabled"
	// ReceiverStatusEnabled ...
	ReceiverStatusEnabled ReceiverStatus = "Enabled"
	// ReceiverStatusNotSpecified ...
	ReceiverStatusNotSpecified ReceiverStatus = "NotSpecified"
)

// PossibleReceiverStatusValues returns an array of possible values for the ReceiverStatus const type.
func PossibleReceiverStatusValues() []ReceiverStatus {
	return []ReceiverStatus{ReceiverStatusDisabled, ReceiverStatusEnabled, ReceiverStatusNotSpecified}
}

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// RecurrenceFrequencyDay ...
	RecurrenceFrequencyDay RecurrenceFrequency = "Day"
	// RecurrenceFrequencyHour ...
	RecurrenceFrequencyHour RecurrenceFrequency = "Hour"
	// RecurrenceFrequencyMinute ...
	RecurrenceFrequencyMinute RecurrenceFrequency = "Minute"
	// RecurrenceFrequencyMonth ...
	RecurrenceFrequencyMonth RecurrenceFrequency = "Month"
	// RecurrenceFrequencyNone ...
	RecurrenceFrequencyNone RecurrenceFrequency = "None"
	// RecurrenceFrequencySecond ...
	RecurrenceFrequencySecond RecurrenceFrequency = "Second"
	// RecurrenceFrequencyWeek ...
	RecurrenceFrequencyWeek RecurrenceFrequency = "Week"
	// RecurrenceFrequencyYear ...
	RecurrenceFrequencyYear RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns an array of possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{RecurrenceFrequencyDay, RecurrenceFrequencyHour, RecurrenceFrequencyMinute, RecurrenceFrequencyMonth, RecurrenceFrequencyNone, RecurrenceFrequencySecond, RecurrenceFrequencyWeek, RecurrenceFrequencyYear}
}

// ResultType enumerates the values for result type.
type ResultType string

const (
	// ResultTypeData ...
	ResultTypeData ResultType = "Data"
	// ResultTypeMetadata ...
	ResultTypeMetadata ResultType = "Metadata"
)

// PossibleResultTypeValues returns an array of possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{ResultTypeData, ResultTypeMetadata}
}

// ScaleDirection enumerates the values for scale direction.
type ScaleDirection string

const (
	// ScaleDirectionDecrease ...
	ScaleDirectionDecrease ScaleDirection = "Decrease"
	// ScaleDirectionIncrease ...
	ScaleDirectionIncrease ScaleDirection = "Increase"
	// ScaleDirectionNone ...
	ScaleDirectionNone ScaleDirection = "None"
)

// PossibleScaleDirectionValues returns an array of possible values for the ScaleDirection const type.
func PossibleScaleDirectionValues() []ScaleDirection {
	return []ScaleDirection{ScaleDirectionDecrease, ScaleDirectionIncrease, ScaleDirectionNone}
}

// ScaleRuleMetricDimensionOperationType enumerates the values for scale rule metric dimension operation type.
type ScaleRuleMetricDimensionOperationType string

const (
	// ScaleRuleMetricDimensionOperationTypeEquals ...
	ScaleRuleMetricDimensionOperationTypeEquals ScaleRuleMetricDimensionOperationType = "Equals"
	// ScaleRuleMetricDimensionOperationTypeNotEquals ...
	ScaleRuleMetricDimensionOperationTypeNotEquals ScaleRuleMetricDimensionOperationType = "NotEquals"
)

// PossibleScaleRuleMetricDimensionOperationTypeValues returns an array of possible values for the ScaleRuleMetricDimensionOperationType const type.
func PossibleScaleRuleMetricDimensionOperationTypeValues() []ScaleRuleMetricDimensionOperationType {
	return []ScaleRuleMetricDimensionOperationType{ScaleRuleMetricDimensionOperationTypeEquals, ScaleRuleMetricDimensionOperationTypeNotEquals}
}

// ScaleType enumerates the values for scale type.
type ScaleType string

const (
	// ScaleTypeChangeCount ...
	ScaleTypeChangeCount ScaleType = "ChangeCount"
	// ScaleTypeExactCount ...
	ScaleTypeExactCount ScaleType = "ExactCount"
	// ScaleTypePercentChangeCount ...
	ScaleTypePercentChangeCount ScaleType = "PercentChangeCount"
	// ScaleTypeServiceAllowedNextValue ...
	ScaleTypeServiceAllowedNextValue ScaleType = "ServiceAllowedNextValue"
)

// PossibleScaleTypeValues returns an array of possible values for the ScaleType const type.
func PossibleScaleTypeValues() []ScaleType {
	return []ScaleType{ScaleTypeChangeCount, ScaleTypeExactCount, ScaleTypePercentChangeCount, ScaleTypeServiceAllowedNextValue}
}

// TimeAggregationOperator enumerates the values for time aggregation operator.
type TimeAggregationOperator string

const (
	// TimeAggregationOperatorAverage ...
	TimeAggregationOperatorAverage TimeAggregationOperator = "Average"
	// TimeAggregationOperatorLast ...
	TimeAggregationOperatorLast TimeAggregationOperator = "Last"
	// TimeAggregationOperatorMaximum ...
	TimeAggregationOperatorMaximum TimeAggregationOperator = "Maximum"
	// TimeAggregationOperatorMinimum ...
	TimeAggregationOperatorMinimum TimeAggregationOperator = "Minimum"
	// TimeAggregationOperatorTotal ...
	TimeAggregationOperatorTotal TimeAggregationOperator = "Total"
)

// PossibleTimeAggregationOperatorValues returns an array of possible values for the TimeAggregationOperator const type.
func PossibleTimeAggregationOperatorValues() []TimeAggregationOperator {
	return []TimeAggregationOperator{TimeAggregationOperatorAverage, TimeAggregationOperatorLast, TimeAggregationOperatorMaximum, TimeAggregationOperatorMinimum, TimeAggregationOperatorTotal}
}

// TimeAggregationType enumerates the values for time aggregation type.
type TimeAggregationType string

const (
	// TimeAggregationTypeAverage ...
	TimeAggregationTypeAverage TimeAggregationType = "Average"
	// TimeAggregationTypeCount ...
	TimeAggregationTypeCount TimeAggregationType = "Count"
	// TimeAggregationTypeLast ...
	TimeAggregationTypeLast TimeAggregationType = "Last"
	// TimeAggregationTypeMaximum ...
	TimeAggregationTypeMaximum TimeAggregationType = "Maximum"
	// TimeAggregationTypeMinimum ...
	TimeAggregationTypeMinimum TimeAggregationType = "Minimum"
	// TimeAggregationTypeTotal ...
	TimeAggregationTypeTotal TimeAggregationType = "Total"
)

// PossibleTimeAggregationTypeValues returns an array of possible values for the TimeAggregationType const type.
func PossibleTimeAggregationTypeValues() []TimeAggregationType {
	return []TimeAggregationType{TimeAggregationTypeAverage, TimeAggregationTypeCount, TimeAggregationTypeLast, TimeAggregationTypeMaximum, TimeAggregationTypeMinimum, TimeAggregationTypeTotal}
}
