// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes permissions for a folder.
func (c *Client) DescribeFolderPermissions(ctx context.Context, params *DescribeFolderPermissionsInput, optFns ...func(*Options)) (*DescribeFolderPermissionsOutput, error) {
	if params == nil {
		params = &DescribeFolderPermissionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeFolderPermissions", params, optFns, c.addOperationDescribeFolderPermissionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeFolderPermissionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeFolderPermissionsInput struct {

	// The ID for the Amazon Web Services account that contains the folder.
	//
	// This member is required.
	AwsAccountId *string

	// The ID of the folder.
	//
	// This member is required.
	FolderId *string

	// The maximum number of results to be returned per request.
	MaxResults *int32

	// The namespace of the folder whose permissions you want described.
	Namespace *string

	// A pagination token for the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeFolderPermissionsOutput struct {

	// The Amazon Resource Name (ARN) for the folder.
	Arn *string

	// The ID of the folder.
	FolderId *string

	// The pagination token for the next set of results, or null if there are no more
	// results.
	NextToken *string

	// Information about the permissions on the folder.
	Permissions []types.ResourcePermission

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status of the request.
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeFolderPermissionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeFolderPermissions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeFolderPermissions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeFolderPermissions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeFolderPermissionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeFolderPermissions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeFolderPermissionsAPIClient is a client that implements the
// DescribeFolderPermissions operation.
type DescribeFolderPermissionsAPIClient interface {
	DescribeFolderPermissions(context.Context, *DescribeFolderPermissionsInput, ...func(*Options)) (*DescribeFolderPermissionsOutput, error)
}

var _ DescribeFolderPermissionsAPIClient = (*Client)(nil)

// DescribeFolderPermissionsPaginatorOptions is the paginator options for
// DescribeFolderPermissions
type DescribeFolderPermissionsPaginatorOptions struct {
	// The maximum number of results to be returned per request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeFolderPermissionsPaginator is a paginator for DescribeFolderPermissions
type DescribeFolderPermissionsPaginator struct {
	options   DescribeFolderPermissionsPaginatorOptions
	client    DescribeFolderPermissionsAPIClient
	params    *DescribeFolderPermissionsInput
	nextToken *string
	firstPage bool
}

// NewDescribeFolderPermissionsPaginator returns a new
// DescribeFolderPermissionsPaginator
func NewDescribeFolderPermissionsPaginator(client DescribeFolderPermissionsAPIClient, params *DescribeFolderPermissionsInput, optFns ...func(*DescribeFolderPermissionsPaginatorOptions)) *DescribeFolderPermissionsPaginator {
	if params == nil {
		params = &DescribeFolderPermissionsInput{}
	}

	options := DescribeFolderPermissionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeFolderPermissionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeFolderPermissionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeFolderPermissions page.
func (p *DescribeFolderPermissionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeFolderPermissionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeFolderPermissions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeFolderPermissions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeFolderPermissions",
	}
}
