//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armworkloads

const (
	moduleName    = "armworkloads"
	moduleVersion = "v0.2.0"
)

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// ApplicationProvisioningState - WordPress instance provisioning state
type ApplicationProvisioningState string

const (
	ApplicationProvisioningStateAccepted     ApplicationProvisioningState = "Accepted"
	ApplicationProvisioningStateCanceled     ApplicationProvisioningState = "Canceled"
	ApplicationProvisioningStateCreated      ApplicationProvisioningState = "Created"
	ApplicationProvisioningStateFailed       ApplicationProvisioningState = "Failed"
	ApplicationProvisioningStateInstalling   ApplicationProvisioningState = "Installing"
	ApplicationProvisioningStateNotSpecified ApplicationProvisioningState = "NotSpecified"
	ApplicationProvisioningStateSucceeded    ApplicationProvisioningState = "Succeeded"
)

// PossibleApplicationProvisioningStateValues returns the possible values for the ApplicationProvisioningState const type.
func PossibleApplicationProvisioningStateValues() []ApplicationProvisioningState {
	return []ApplicationProvisioningState{
		ApplicationProvisioningStateAccepted,
		ApplicationProvisioningStateCanceled,
		ApplicationProvisioningStateCreated,
		ApplicationProvisioningStateFailed,
		ApplicationProvisioningStateInstalling,
		ApplicationProvisioningStateNotSpecified,
		ApplicationProvisioningStateSucceeded,
	}
}

// AzureFrontDoorEnabled - Whether to enable Azure front door
type AzureFrontDoorEnabled string

const (
	AzureFrontDoorEnabledDisabled AzureFrontDoorEnabled = "Disabled"
	AzureFrontDoorEnabledEnabled  AzureFrontDoorEnabled = "Enabled"
)

// PossibleAzureFrontDoorEnabledValues returns the possible values for the AzureFrontDoorEnabled const type.
func PossibleAzureFrontDoorEnabledValues() []AzureFrontDoorEnabled {
	return []AzureFrontDoorEnabled{
		AzureFrontDoorEnabledDisabled,
		AzureFrontDoorEnabledEnabled,
	}
}

// CentralServerVirtualMachineType - Defines the type of central server VM.
type CentralServerVirtualMachineType string

const (
	CentralServerVirtualMachineTypeASCS        CentralServerVirtualMachineType = "ASCS"
	CentralServerVirtualMachineTypeERS         CentralServerVirtualMachineType = "ERS"
	CentralServerVirtualMachineTypeERSInactive CentralServerVirtualMachineType = "ERSInactive"
	CentralServerVirtualMachineTypePrimary     CentralServerVirtualMachineType = "Primary"
	CentralServerVirtualMachineTypeSecondary   CentralServerVirtualMachineType = "Secondary"
	CentralServerVirtualMachineTypeStandby     CentralServerVirtualMachineType = "Standby"
	CentralServerVirtualMachineTypeUnknown     CentralServerVirtualMachineType = "Unknown"
)

// PossibleCentralServerVirtualMachineTypeValues returns the possible values for the CentralServerVirtualMachineType const type.
func PossibleCentralServerVirtualMachineTypeValues() []CentralServerVirtualMachineType {
	return []CentralServerVirtualMachineType{
		CentralServerVirtualMachineTypeASCS,
		CentralServerVirtualMachineTypeERS,
		CentralServerVirtualMachineTypeERSInactive,
		CentralServerVirtualMachineTypePrimary,
		CentralServerVirtualMachineTypeSecondary,
		CentralServerVirtualMachineTypeStandby,
		CentralServerVirtualMachineTypeUnknown,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DatabaseTier - Tier of the server SKU
type DatabaseTier string

const (
	DatabaseTierBurstable       DatabaseTier = "Burstable"
	DatabaseTierGeneralPurpose  DatabaseTier = "GeneralPurpose"
	DatabaseTierMemoryOptimized DatabaseTier = "MemoryOptimized"
)

// PossibleDatabaseTierValues returns the possible values for the DatabaseTier const type.
func PossibleDatabaseTierValues() []DatabaseTier {
	return []DatabaseTier{
		DatabaseTierBurstable,
		DatabaseTierGeneralPurpose,
		DatabaseTierMemoryOptimized,
	}
}

// DatabaseType - Database type
type DatabaseType string

const (
	DatabaseTypeMySQL DatabaseType = "MySql"
)

// PossibleDatabaseTypeValues returns the possible values for the DatabaseType const type.
func PossibleDatabaseTypeValues() []DatabaseType {
	return []DatabaseType{
		DatabaseTypeMySQL,
	}
}

// DiskStorageType - Storage type
type DiskStorageType string

const (
	DiskStorageTypePremiumLRS     DiskStorageType = "Premium_LRS"
	DiskStorageTypeStandardLRS    DiskStorageType = "Standard_LRS"
	DiskStorageTypeStandardSSDLRS DiskStorageType = "StandardSSD_LRS"
)

// PossibleDiskStorageTypeValues returns the possible values for the DiskStorageType const type.
func PossibleDiskStorageTypeValues() []DiskStorageType {
	return []DiskStorageType{
		DiskStorageTypePremiumLRS,
		DiskStorageTypeStandardLRS,
		DiskStorageTypeStandardSSDLRS,
	}
}

// EnableBackup - Whether to enable Azure backup for the workload
type EnableBackup string

const (
	EnableBackupDisabled EnableBackup = "Disabled"
	EnableBackupEnabled  EnableBackup = "Enabled"
)

// PossibleEnableBackupValues returns the possible values for the EnableBackup const type.
func PossibleEnableBackupValues() []EnableBackup {
	return []EnableBackup{
		EnableBackupDisabled,
		EnableBackupEnabled,
	}
}

// EnableSSLEnforcement - Whether to enable SSL enforcement on the database
type EnableSSLEnforcement string

const (
	EnableSSLEnforcementDisabled EnableSSLEnforcement = "Disabled"
	EnableSSLEnforcementEnabled  EnableSSLEnforcement = "Enabled"
)

// PossibleEnableSSLEnforcementValues returns the possible values for the EnableSSLEnforcement const type.
func PossibleEnableSSLEnforcementValues() []EnableSSLEnforcement {
	return []EnableSSLEnforcement{
		EnableSSLEnforcementDisabled,
		EnableSSLEnforcementEnabled,
	}
}

// EnqueueReplicationServerType - Defines the type of Enqueue Replication Server.
type EnqueueReplicationServerType string

const (
	EnqueueReplicationServerTypeEnqueueReplicator1 EnqueueReplicationServerType = "EnqueueReplicator1"
	EnqueueReplicationServerTypeEnqueueReplicator2 EnqueueReplicationServerType = "EnqueueReplicator2"
)

// PossibleEnqueueReplicationServerTypeValues returns the possible values for the EnqueueReplicationServerType const type.
func PossibleEnqueueReplicationServerTypeValues() []EnqueueReplicationServerType {
	return []EnqueueReplicationServerType{
		EnqueueReplicationServerTypeEnqueueReplicator1,
		EnqueueReplicationServerTypeEnqueueReplicator2,
	}
}

// FileShareStorageType - File share backing storage type
type FileShareStorageType string

const (
	FileShareStorageTypePremiumLRS  FileShareStorageType = "Premium_LRS"
	FileShareStorageTypeStandardGRS FileShareStorageType = "Standard_GRS"
	FileShareStorageTypeStandardLRS FileShareStorageType = "Standard_LRS"
	FileShareStorageTypeStandardZRS FileShareStorageType = "Standard_ZRS"
)

// PossibleFileShareStorageTypeValues returns the possible values for the FileShareStorageType const type.
func PossibleFileShareStorageTypeValues() []FileShareStorageType {
	return []FileShareStorageType{
		FileShareStorageTypePremiumLRS,
		FileShareStorageTypeStandardGRS,
		FileShareStorageTypeStandardLRS,
		FileShareStorageTypeStandardZRS,
	}
}

// FileShareType - Share type
type FileShareType string

const (
	FileShareTypeAzureFiles      FileShareType = "AzureFiles"
	FileShareTypeNfsOnController FileShareType = "NfsOnController"
)

// PossibleFileShareTypeValues returns the possible values for the FileShareType const type.
func PossibleFileShareTypeValues() []FileShareType {
	return []FileShareType{
		FileShareTypeAzureFiles,
		FileShareTypeNfsOnController,
	}
}

// HAEnabled - Whether to enable HA for the server
type HAEnabled string

const (
	HAEnabledDisabled HAEnabled = "Disabled"
	HAEnabledEnabled  HAEnabled = "Enabled"
)

// PossibleHAEnabledValues returns the possible values for the HAEnabled const type.
func PossibleHAEnabledValues() []HAEnabled {
	return []HAEnabled{
		HAEnabledDisabled,
		HAEnabledEnabled,
	}
}

// LoadBalancerType - Load balancer type
type LoadBalancerType string

const (
	LoadBalancerTypeApplicationGateway LoadBalancerType = "ApplicationGateway"
	LoadBalancerTypeLoadBalancer       LoadBalancerType = "LoadBalancer"
)

// PossibleLoadBalancerTypeValues returns the possible values for the LoadBalancerType const type.
func PossibleLoadBalancerTypeValues() []LoadBalancerType {
	return []LoadBalancerType{
		LoadBalancerTypeApplicationGateway,
		LoadBalancerTypeLoadBalancer,
	}
}

// LocationType - Type of the extended location.
type LocationType string

const (
	LocationTypeEdgeZone LocationType = "EdgeZone"
	LocationTypeRegion   LocationType = "Region"
)

// PossibleLocationTypeValues returns the possible values for the LocationType const type.
func PossibleLocationTypeValues() []LocationType {
	return []LocationType{
		LocationTypeEdgeZone,
		LocationTypeRegion,
	}
}

// ManagedServiceIdentityType - Type of managed service identity (only None, UserAssigned types are allowed).
type ManagedServiceIdentityType string

const (
	ManagedServiceIdentityTypeNone         ManagedServiceIdentityType = "None"
	ManagedServiceIdentityTypeUserAssigned ManagedServiceIdentityType = "UserAssigned"
)

// PossibleManagedServiceIdentityTypeValues returns the possible values for the ManagedServiceIdentityType const type.
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return []ManagedServiceIdentityType{
		ManagedServiceIdentityTypeNone,
		ManagedServiceIdentityTypeUserAssigned,
	}
}

// OSImageOffer - OS image offer
type OSImageOffer string

const (
	OSImageOfferUbuntuServer OSImageOffer = "UbuntuServer"
)

// PossibleOSImageOfferValues returns the possible values for the OSImageOffer const type.
func PossibleOSImageOfferValues() []OSImageOffer {
	return []OSImageOffer{
		OSImageOfferUbuntuServer,
	}
}

// OSImagePublisher - OS image publisher
type OSImagePublisher string

const (
	OSImagePublisherCanonical OSImagePublisher = "Canonical"
)

// PossibleOSImagePublisherValues returns the possible values for the OSImagePublisher const type.
func PossibleOSImagePublisherValues() []OSImagePublisher {
	return []OSImagePublisher{
		OSImagePublisherCanonical,
	}
}

// OSImageSKU - OS image sku
type OSImageSKU string

const (
	OSImageSKUEighteen04LTS OSImageSKU = "18.04-LTS"
	OSImageSKUSixteen04LTS  OSImageSKU = "16.04-LTS"
)

// PossibleOSImageSKUValues returns the possible values for the OSImageSKU const type.
func PossibleOSImageSKUValues() []OSImageSKU {
	return []OSImageSKU{
		OSImageSKUEighteen04LTS,
		OSImageSKUSixteen04LTS,
	}
}

// OSImageVersion - OS image version
type OSImageVersion string

const (
	OSImageVersionLatest OSImageVersion = "latest"
)

// PossibleOSImageVersionValues returns the possible values for the OSImageVersion const type.
func PossibleOSImageVersionValues() []OSImageVersion {
	return []OSImageVersion{
		OSImageVersionLatest,
	}
}

// OSType - The OS Type
type OSType string

const (
	OSTypeLinux   OSType = "Linux"
	OSTypeWindows OSType = "Windows"
)

// PossibleOSTypeValues returns the possible values for the OSType const type.
func PossibleOSTypeValues() []OSType {
	return []OSType{
		OSTypeLinux,
		OSTypeWindows,
	}
}

// OperationProperties - Defines the workload operation origin.
type OperationProperties string

const (
	OperationPropertiesNotSpecified OperationProperties = "NotSpecified"
	OperationPropertiesSystem       OperationProperties = "System"
	OperationPropertiesUser         OperationProperties = "User"
)

// PossibleOperationPropertiesValues returns the possible values for the OperationProperties const type.
func PossibleOperationPropertiesValues() []OperationProperties {
	return []OperationProperties{
		OperationPropertiesNotSpecified,
		OperationPropertiesSystem,
		OperationPropertiesUser,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// PHPVersion - PHP version
type PHPVersion string

const (
	PHPVersionSeven2 PHPVersion = "7.2"
	PHPVersionSeven3 PHPVersion = "7.3"
	PHPVersionSeven4 PHPVersion = "7.4"
)

// PossiblePHPVersionValues returns the possible values for the PHPVersion const type.
func PossiblePHPVersionValues() []PHPVersion {
	return []PHPVersion{
		PHPVersionSeven2,
		PHPVersionSeven3,
		PHPVersionSeven4,
	}
}

// PhpWorkloadProvisioningState - Php workload resource provisioning state
type PhpWorkloadProvisioningState string

const (
	PhpWorkloadProvisioningStateAccepted     PhpWorkloadProvisioningState = "Accepted"
	PhpWorkloadProvisioningStateCanceled     PhpWorkloadProvisioningState = "Canceled"
	PhpWorkloadProvisioningStateCreated      PhpWorkloadProvisioningState = "Created"
	PhpWorkloadProvisioningStateDeleting     PhpWorkloadProvisioningState = "Deleting"
	PhpWorkloadProvisioningStateFailed       PhpWorkloadProvisioningState = "Failed"
	PhpWorkloadProvisioningStateNotSpecified PhpWorkloadProvisioningState = "NotSpecified"
	PhpWorkloadProvisioningStateProvisioning PhpWorkloadProvisioningState = "Provisioning"
	PhpWorkloadProvisioningStateSucceeded    PhpWorkloadProvisioningState = "Succeeded"
)

// PossiblePhpWorkloadProvisioningStateValues returns the possible values for the PhpWorkloadProvisioningState const type.
func PossiblePhpWorkloadProvisioningStateValues() []PhpWorkloadProvisioningState {
	return []PhpWorkloadProvisioningState{
		PhpWorkloadProvisioningStateAccepted,
		PhpWorkloadProvisioningStateCanceled,
		PhpWorkloadProvisioningStateCreated,
		PhpWorkloadProvisioningStateDeleting,
		PhpWorkloadProvisioningStateFailed,
		PhpWorkloadProvisioningStateNotSpecified,
		PhpWorkloadProvisioningStateProvisioning,
		PhpWorkloadProvisioningStateSucceeded,
	}
}

// RedisCacheFamily - Cache family
type RedisCacheFamily string

const (
	RedisCacheFamilyC RedisCacheFamily = "C"
	RedisCacheFamilyP RedisCacheFamily = "P"
)

// PossibleRedisCacheFamilyValues returns the possible values for the RedisCacheFamily const type.
func PossibleRedisCacheFamilyValues() []RedisCacheFamily {
	return []RedisCacheFamily{
		RedisCacheFamilyC,
		RedisCacheFamilyP,
	}
}

// RoutingPreference - Sets the routing preference of the SAP monitor. By default only RFC1918 traffic is routed to the customer
// VNET.
type RoutingPreference string

const (
	RoutingPreferenceDefault  RoutingPreference = "Default"
	RoutingPreferenceRouteAll RoutingPreference = "RouteAll"
)

// PossibleRoutingPreferenceValues returns the possible values for the RoutingPreference const type.
func PossibleRoutingPreferenceValues() []RoutingPreference {
	return []RoutingPreference{
		RoutingPreferenceDefault,
		RoutingPreferenceRouteAll,
	}
}

// SAPConfigurationType - The configuration Type.
type SAPConfigurationType string

const (
	SAPConfigurationTypeDeployment             SAPConfigurationType = "Deployment"
	SAPConfigurationTypeDeploymentWithOSConfig SAPConfigurationType = "DeploymentWithOSConfig"
	SAPConfigurationTypeDiscovery              SAPConfigurationType = "Discovery"
)

// PossibleSAPConfigurationTypeValues returns the possible values for the SAPConfigurationType const type.
func PossibleSAPConfigurationTypeValues() []SAPConfigurationType {
	return []SAPConfigurationType{
		SAPConfigurationTypeDeployment,
		SAPConfigurationTypeDeploymentWithOSConfig,
		SAPConfigurationTypeDiscovery,
	}
}

// SAPDatabaseScaleMethod - The database scale method.
type SAPDatabaseScaleMethod string

const (
	SAPDatabaseScaleMethodScaleUp SAPDatabaseScaleMethod = "ScaleUp"
)

// PossibleSAPDatabaseScaleMethodValues returns the possible values for the SAPDatabaseScaleMethod const type.
func PossibleSAPDatabaseScaleMethodValues() []SAPDatabaseScaleMethod {
	return []SAPDatabaseScaleMethod{
		SAPDatabaseScaleMethodScaleUp,
	}
}

// SAPDatabaseType - Defines the supported SAP Database types.
type SAPDatabaseType string

const (
	SAPDatabaseTypeDB2  SAPDatabaseType = "DB2"
	SAPDatabaseTypeHANA SAPDatabaseType = "HANA"
)

// PossibleSAPDatabaseTypeValues returns the possible values for the SAPDatabaseType const type.
func PossibleSAPDatabaseTypeValues() []SAPDatabaseType {
	return []SAPDatabaseType{
		SAPDatabaseTypeDB2,
		SAPDatabaseTypeHANA,
	}
}

// SAPDeploymentType - The deployment Type.
type SAPDeploymentType string

const (
	SAPDeploymentTypeSingleServer SAPDeploymentType = "SingleServer"
	SAPDeploymentTypeThreeTier    SAPDeploymentType = "ThreeTier"
)

// PossibleSAPDeploymentTypeValues returns the possible values for the SAPDeploymentType const type.
func PossibleSAPDeploymentTypeValues() []SAPDeploymentType {
	return []SAPDeploymentType{
		SAPDeploymentTypeSingleServer,
		SAPDeploymentTypeThreeTier,
	}
}

// SAPEnvironmentType - Defines the environment type - Production/Non Production.
type SAPEnvironmentType string

const (
	SAPEnvironmentTypeNonProd SAPEnvironmentType = "NonProd"
	SAPEnvironmentTypeProd    SAPEnvironmentType = "Prod"
)

// PossibleSAPEnvironmentTypeValues returns the possible values for the SAPEnvironmentType const type.
func PossibleSAPEnvironmentTypeValues() []SAPEnvironmentType {
	return []SAPEnvironmentType{
		SAPEnvironmentTypeNonProd,
		SAPEnvironmentTypeProd,
	}
}

// SAPHealthState - Defines the SAP Instance health.
type SAPHealthState string

const (
	SAPHealthStateDegraded  SAPHealthState = "Degraded"
	SAPHealthStateHealthy   SAPHealthState = "Healthy"
	SAPHealthStateUnhealthy SAPHealthState = "Unhealthy"
	SAPHealthStateUnknown   SAPHealthState = "Unknown"
)

// PossibleSAPHealthStateValues returns the possible values for the SAPHealthState const type.
func PossibleSAPHealthStateValues() []SAPHealthState {
	return []SAPHealthState{
		SAPHealthStateDegraded,
		SAPHealthStateHealthy,
		SAPHealthStateUnhealthy,
		SAPHealthStateUnknown,
	}
}

// SAPHighAvailabilityType - The high availability Type. AvailabilitySet guarantees 99.95% availability. Availability Zone
// guarantees 99.99% availability.
type SAPHighAvailabilityType string

const (
	SAPHighAvailabilityTypeAvailabilitySet  SAPHighAvailabilityType = "AvailabilitySet"
	SAPHighAvailabilityTypeAvailabilityZone SAPHighAvailabilityType = "AvailabilityZone"
)

// PossibleSAPHighAvailabilityTypeValues returns the possible values for the SAPHighAvailabilityType const type.
func PossibleSAPHighAvailabilityTypeValues() []SAPHighAvailabilityType {
	return []SAPHighAvailabilityType{
		SAPHighAvailabilityTypeAvailabilitySet,
		SAPHighAvailabilityTypeAvailabilityZone,
	}
}

// SAPProductType - Defines the SAP Product type.
type SAPProductType string

const (
	SAPProductTypeECC    SAPProductType = "ECC"
	SAPProductTypeOther  SAPProductType = "Other"
	SAPProductTypeS4HANA SAPProductType = "S4HANA"
)

// PossibleSAPProductTypeValues returns the possible values for the SAPProductType const type.
func PossibleSAPProductTypeValues() []SAPProductType {
	return []SAPProductType{
		SAPProductTypeECC,
		SAPProductTypeOther,
		SAPProductTypeS4HANA,
	}
}

// SAPSoftwareInstallationType - The SAP software installation Type.
type SAPSoftwareInstallationType string

const (
	SAPSoftwareInstallationTypeSAPInstallWithoutOSConfig SAPSoftwareInstallationType = "SAPInstallWithoutOSConfig"
	SAPSoftwareInstallationTypeServiceInitiated          SAPSoftwareInstallationType = "ServiceInitiated"
)

// PossibleSAPSoftwareInstallationTypeValues returns the possible values for the SAPSoftwareInstallationType const type.
func PossibleSAPSoftwareInstallationTypeValues() []SAPSoftwareInstallationType {
	return []SAPSoftwareInstallationType{
		SAPSoftwareInstallationTypeSAPInstallWithoutOSConfig,
		SAPSoftwareInstallationTypeServiceInitiated,
	}
}

// SAPVirtualInstanceState - Defines the Virtual Instance for SAP state.
type SAPVirtualInstanceState string

const (
	SAPVirtualInstanceStateDiscoveryFailed                    SAPVirtualInstanceState = "DiscoveryFailed"
	SAPVirtualInstanceStateDiscoveryInProgress                SAPVirtualInstanceState = "DiscoveryInProgress"
	SAPVirtualInstanceStateDiscoveryPending                   SAPVirtualInstanceState = "DiscoveryPending"
	SAPVirtualInstanceStateInfrastructureDeploymentFailed     SAPVirtualInstanceState = "InfrastructureDeploymentFailed"
	SAPVirtualInstanceStateInfrastructureDeploymentInProgress SAPVirtualInstanceState = "InfrastructureDeploymentInProgress"
	SAPVirtualInstanceStateInfrastructureDeploymentPending    SAPVirtualInstanceState = "InfrastructureDeploymentPending"
	SAPVirtualInstanceStateRegistrationComplete               SAPVirtualInstanceState = "RegistrationComplete"
	SAPVirtualInstanceStateSoftwareInstallationFailed         SAPVirtualInstanceState = "SoftwareInstallationFailed"
	SAPVirtualInstanceStateSoftwareInstallationInProgress     SAPVirtualInstanceState = "SoftwareInstallationInProgress"
	SAPVirtualInstanceStateSoftwareInstallationPending        SAPVirtualInstanceState = "SoftwareInstallationPending"
)

// PossibleSAPVirtualInstanceStateValues returns the possible values for the SAPVirtualInstanceState const type.
func PossibleSAPVirtualInstanceStateValues() []SAPVirtualInstanceState {
	return []SAPVirtualInstanceState{
		SAPVirtualInstanceStateDiscoveryFailed,
		SAPVirtualInstanceStateDiscoveryInProgress,
		SAPVirtualInstanceStateDiscoveryPending,
		SAPVirtualInstanceStateInfrastructureDeploymentFailed,
		SAPVirtualInstanceStateInfrastructureDeploymentInProgress,
		SAPVirtualInstanceStateInfrastructureDeploymentPending,
		SAPVirtualInstanceStateRegistrationComplete,
		SAPVirtualInstanceStateSoftwareInstallationFailed,
		SAPVirtualInstanceStateSoftwareInstallationInProgress,
		SAPVirtualInstanceStateSoftwareInstallationPending,
	}
}

// SAPVirtualInstanceStatus - Defines the SAP Instance status.
type SAPVirtualInstanceStatus string

const (
	SAPVirtualInstanceStatusOffline          SAPVirtualInstanceStatus = "Offline"
	SAPVirtualInstanceStatusPartiallyRunning SAPVirtualInstanceStatus = "PartiallyRunning"
	SAPVirtualInstanceStatusRunning          SAPVirtualInstanceStatus = "Running"
	SAPVirtualInstanceStatusStarting         SAPVirtualInstanceStatus = "Starting"
	SAPVirtualInstanceStatusStopping         SAPVirtualInstanceStatus = "Stopping"
	SAPVirtualInstanceStatusUnavailable      SAPVirtualInstanceStatus = "Unavailable"
)

// PossibleSAPVirtualInstanceStatusValues returns the possible values for the SAPVirtualInstanceStatus const type.
func PossibleSAPVirtualInstanceStatusValues() []SAPVirtualInstanceStatus {
	return []SAPVirtualInstanceStatus{
		SAPVirtualInstanceStatusOffline,
		SAPVirtualInstanceStatusPartiallyRunning,
		SAPVirtualInstanceStatusRunning,
		SAPVirtualInstanceStatusStarting,
		SAPVirtualInstanceStatusStopping,
		SAPVirtualInstanceStatusUnavailable,
	}
}

// SKURestrictionReasonCode - The SKU restriction reason code.
type SKURestrictionReasonCode string

const (
	SKURestrictionReasonCodeNotAvailableForSubscription SKURestrictionReasonCode = "NotAvailableForSubscription"
	SKURestrictionReasonCodeNotSpecified                SKURestrictionReasonCode = "NotSpecified"
	SKURestrictionReasonCodeQuotaID                     SKURestrictionReasonCode = "QuotaId"
)

// PossibleSKURestrictionReasonCodeValues returns the possible values for the SKURestrictionReasonCode const type.
func PossibleSKURestrictionReasonCodeValues() []SKURestrictionReasonCode {
	return []SKURestrictionReasonCode{
		SKURestrictionReasonCodeNotAvailableForSubscription,
		SKURestrictionReasonCodeNotSpecified,
		SKURestrictionReasonCodeQuotaID,
	}
}

// SKURestrictionType - The SKU restriction type.
type SKURestrictionType string

const (
	SKURestrictionTypeLocation     SKURestrictionType = "Location"
	SKURestrictionTypeNotSpecified SKURestrictionType = "NotSpecified"
	SKURestrictionTypeZone         SKURestrictionType = "Zone"
)

// PossibleSKURestrictionTypeValues returns the possible values for the SKURestrictionType const type.
func PossibleSKURestrictionTypeValues() []SKURestrictionType {
	return []SKURestrictionType{
		SKURestrictionTypeLocation,
		SKURestrictionTypeNotSpecified,
		SKURestrictionTypeZone,
	}
}

// SKUScaleType - Scale type of the SKU capacity.
type SKUScaleType string

const (
	SKUScaleTypeAutomatic SKUScaleType = "Automatic"
	SKUScaleTypeManual    SKUScaleType = "Manual"
	SKUScaleTypeNone      SKUScaleType = "None"
)

// PossibleSKUScaleTypeValues returns the possible values for the SKUScaleType const type.
func PossibleSKUScaleTypeValues() []SKUScaleType {
	return []SKUScaleType{
		SKUScaleTypeAutomatic,
		SKUScaleTypeManual,
		SKUScaleTypeNone,
	}
}

// SKUTier - This field is required to be implemented by the Resource Provider if the service has more than one tier, but
// is not required on a PUT.
type SKUTier string

const (
	SKUTierFree     SKUTier = "Free"
	SKUTierBasic    SKUTier = "Basic"
	SKUTierStandard SKUTier = "Standard"
	SKUTierPremium  SKUTier = "Premium"
)

// PossibleSKUTierValues returns the possible values for the SKUTier const type.
func PossibleSKUTierValues() []SKUTier {
	return []SKUTier{
		SKUTierFree,
		SKUTierBasic,
		SKUTierStandard,
		SKUTierPremium,
	}
}

// SapVirtualInstanceProvisioningState - Defines the provisioning states.
type SapVirtualInstanceProvisioningState string

const (
	SapVirtualInstanceProvisioningStateCreating  SapVirtualInstanceProvisioningState = "Creating"
	SapVirtualInstanceProvisioningStateDeleting  SapVirtualInstanceProvisioningState = "Deleting"
	SapVirtualInstanceProvisioningStateFailed    SapVirtualInstanceProvisioningState = "Failed"
	SapVirtualInstanceProvisioningStateSucceeded SapVirtualInstanceProvisioningState = "Succeeded"
	SapVirtualInstanceProvisioningStateUpdating  SapVirtualInstanceProvisioningState = "Updating"
)

// PossibleSapVirtualInstanceProvisioningStateValues returns the possible values for the SapVirtualInstanceProvisioningState const type.
func PossibleSapVirtualInstanceProvisioningStateValues() []SapVirtualInstanceProvisioningState {
	return []SapVirtualInstanceProvisioningState{
		SapVirtualInstanceProvisioningStateCreating,
		SapVirtualInstanceProvisioningStateDeleting,
		SapVirtualInstanceProvisioningStateFailed,
		SapVirtualInstanceProvisioningStateSucceeded,
		SapVirtualInstanceProvisioningStateUpdating,
	}
}

// SearchType - Search type
type SearchType string

const (
	SearchTypeElastic SearchType = "Elastic"
)

// PossibleSearchTypeValues returns the possible values for the SearchType const type.
func PossibleSearchTypeValues() []SearchType {
	return []SearchType{
		SearchTypeElastic,
	}
}

// WordpressVersions - Application version
type WordpressVersions string

const (
	WordpressVersionsFive4  WordpressVersions = "5.4"
	WordpressVersionsFive41 WordpressVersions = "5.4.1"
	WordpressVersionsFive42 WordpressVersions = "5.4.2"
	WordpressVersionsFive43 WordpressVersions = "5.4.3"
)

// PossibleWordpressVersionsValues returns the possible values for the WordpressVersions const type.
func PossibleWordpressVersionsValues() []WordpressVersions {
	return []WordpressVersions{
		WordpressVersionsFive4,
		WordpressVersionsFive41,
		WordpressVersionsFive42,
		WordpressVersionsFive43,
	}
}

// WorkloadKind - Indicates which kind of php workload this resource represent e.g WordPress
type WorkloadKind string

const (
	WorkloadKindWordPress WorkloadKind = "WordPress"
)

// PossibleWorkloadKindValues returns the possible values for the WorkloadKind const type.
func PossibleWorkloadKindValues() []WorkloadKind {
	return []WorkloadKind{
		WorkloadKindWordPress,
	}
}

// WorkloadMonitorActionType - Defines the action type of workload operation.
type WorkloadMonitorActionType string

const (
	WorkloadMonitorActionTypeInternal     WorkloadMonitorActionType = "Internal"
	WorkloadMonitorActionTypeNotSpecified WorkloadMonitorActionType = "NotSpecified"
)

// PossibleWorkloadMonitorActionTypeValues returns the possible values for the WorkloadMonitorActionType const type.
func PossibleWorkloadMonitorActionTypeValues() []WorkloadMonitorActionType {
	return []WorkloadMonitorActionType{
		WorkloadMonitorActionTypeInternal,
		WorkloadMonitorActionTypeNotSpecified,
	}
}

// WorkloadMonitorProvisioningState - State of provisioning of the SAP monitor.
type WorkloadMonitorProvisioningState string

const (
	WorkloadMonitorProvisioningStateAccepted  WorkloadMonitorProvisioningState = "Accepted"
	WorkloadMonitorProvisioningStateCreating  WorkloadMonitorProvisioningState = "Creating"
	WorkloadMonitorProvisioningStateDeleting  WorkloadMonitorProvisioningState = "Deleting"
	WorkloadMonitorProvisioningStateFailed    WorkloadMonitorProvisioningState = "Failed"
	WorkloadMonitorProvisioningStateMigrating WorkloadMonitorProvisioningState = "Migrating"
	WorkloadMonitorProvisioningStateSucceeded WorkloadMonitorProvisioningState = "Succeeded"
	WorkloadMonitorProvisioningStateUpdating  WorkloadMonitorProvisioningState = "Updating"
)

// PossibleWorkloadMonitorProvisioningStateValues returns the possible values for the WorkloadMonitorProvisioningState const type.
func PossibleWorkloadMonitorProvisioningStateValues() []WorkloadMonitorProvisioningState {
	return []WorkloadMonitorProvisioningState{
		WorkloadMonitorProvisioningStateAccepted,
		WorkloadMonitorProvisioningStateCreating,
		WorkloadMonitorProvisioningStateDeleting,
		WorkloadMonitorProvisioningStateFailed,
		WorkloadMonitorProvisioningStateMigrating,
		WorkloadMonitorProvisioningStateSucceeded,
		WorkloadMonitorProvisioningStateUpdating,
	}
}
