//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsubscription

import "time"

// AcceptOwnershipRequest - The parameters required to accept subscription ownership.
type AcceptOwnershipRequest struct {
	// Accept subscription ownership request properties.
	Properties *AcceptOwnershipRequestProperties `json:"properties,omitempty"`
}

// AcceptOwnershipRequestProperties - Accept subscription ownership request properties.
type AcceptOwnershipRequestProperties struct {
	// REQUIRED; The friendly name of the subscription.
	DisplayName *string `json:"displayName,omitempty"`

	// Management group Id for the subscription.
	ManagementGroupID *string `json:"managementGroupId,omitempty"`

	// Tags for the subscription
	Tags map[string]*string `json:"tags,omitempty"`
}

// AcceptOwnershipStatusResponse - Subscription Accept Ownership Response
type AcceptOwnershipStatusResponse struct {
	// The display name of the subscription.
	DisplayName *string `json:"displayName,omitempty"`

	// Tenant Id of the subscription
	SubscriptionTenantID *string `json:"subscriptionTenantId,omitempty"`

	// Tags for the subscription
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The accept ownership state of the resource.
	AcceptOwnershipState *AcceptOwnership `json:"acceptOwnershipState,omitempty" azure:"ro"`

	// READ-ONLY; UPN of the billing owner
	BillingOwner *string `json:"billingOwner,omitempty" azure:"ro"`

	// READ-ONLY; Newly created subscription Id.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// AliasClientBeginCreateOptions contains the optional parameters for the AliasClient.BeginCreate method.
type AliasClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AliasClientDeleteOptions contains the optional parameters for the AliasClient.Delete method.
type AliasClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AliasClientGetOptions contains the optional parameters for the AliasClient.Get method.
type AliasClientGetOptions struct {
	// placeholder for future optional parameters
}

// AliasClientListOptions contains the optional parameters for the AliasClient.List method.
type AliasClientListOptions struct {
	// placeholder for future optional parameters
}

// AliasListResult - The list of aliases.
type AliasListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of alias.
	Value []*AliasResponse `json:"value,omitempty" azure:"ro"`
}

// AliasResponse - Subscription Information with the alias.
type AliasResponse struct {
	// Subscription Alias response properties.
	Properties *AliasResponseProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified ID for the alias resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Alias ID.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type, Microsoft.Subscription/aliases.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AliasResponseProperties - Put subscription creation result properties.
type AliasResponseProperties struct {
	// Billing scope of the subscription. For CustomerLed and FieldLed - /billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}
	// For PartnerLed -
	// /billingAccounts/{billingAccountName}/customers/{customerName} For Legacy EA - /billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}
	BillingScope *string `json:"billingScope,omitempty"`

	// Created Time
	CreatedTime *string `json:"createdTime,omitempty"`

	// The display name of the subscription.
	DisplayName *string `json:"displayName,omitempty"`

	// The Management Group Id.
	ManagementGroupID *string `json:"managementGroupId,omitempty"`

	// The provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`

	// Reseller Id
	ResellerID *string `json:"resellerId,omitempty"`

	// Owner Id of the subscription
	SubscriptionOwnerID *string `json:"subscriptionOwnerId,omitempty"`

	// Tags for the subscription
	Tags map[string]*string `json:"tags,omitempty"`

	// The workload type of the subscription. It can be either Production or DevTest.
	Workload *Workload `json:"workload,omitempty"`

	// READ-ONLY; The accept ownership state of the resource.
	AcceptOwnershipState *AcceptOwnership `json:"acceptOwnershipState,omitempty" azure:"ro"`

	// READ-ONLY; Url to accept ownership of the subscription.
	AcceptOwnershipURL *string `json:"acceptOwnershipUrl,omitempty" azure:"ro"`

	// READ-ONLY; Newly created subscription Id.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// BillingAccountClientGetPolicyOptions contains the optional parameters for the BillingAccountClient.GetPolicy method.
type BillingAccountClientGetPolicyOptions struct {
	// placeholder for future optional parameters
}

// BillingAccountPoliciesResponse - Billing account policies information.
type BillingAccountPoliciesResponse struct {
	// Billing account policies response properties.
	Properties *BillingAccountPoliciesResponseProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified ID for the policy.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Policy name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BillingAccountPoliciesResponseProperties - Put billing account policies response properties.
type BillingAccountPoliciesResponseProperties struct {
	// Determine if the transfers are allowed for the billing account
	AllowTransfers *bool `json:"allowTransfers,omitempty"`

	// Service tenant for the billing account.
	ServiceTenants []*ServiceTenantResponse `json:"serviceTenants,omitempty"`
}

// CanceledSubscriptionID - The ID of the canceled subscription
type CanceledSubscriptionID struct {
	// READ-ONLY; The ID of the canceled subscription
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// ClientAcceptOwnershipStatusOptions contains the optional parameters for the Client.AcceptOwnershipStatus method.
type ClientAcceptOwnershipStatusOptions struct {
	// placeholder for future optional parameters
}

// ClientBeginAcceptOwnershipOptions contains the optional parameters for the Client.BeginAcceptOwnership method.
type ClientBeginAcceptOwnershipOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientCancelOptions contains the optional parameters for the Client.Cancel method.
type ClientCancelOptions struct {
	// placeholder for future optional parameters
}

// ClientEnableOptions contains the optional parameters for the Client.Enable method.
type ClientEnableOptions struct {
	// placeholder for future optional parameters
}

// ClientRenameOptions contains the optional parameters for the Client.Rename method.
type ClientRenameOptions struct {
	// placeholder for future optional parameters
}

// EnabledSubscriptionID - The ID of the subscriptions that is being enabled
type EnabledSubscriptionID struct {
	// READ-ONLY; The ID of the subscriptions that is being enabled
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// ErrorResponse - Describes the format of Error response.
type ErrorResponse struct {
	// Error code
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ErrorResponseBody - Error response indicates that the service is not able to process the incoming request. The reason is
// provided in the error message.
type ErrorResponseBody struct {
	// Error code
	Code *string `json:"code,omitempty"`

	// The details of the error.
	Error *ErrorResponse `json:"error,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// GetTenantPolicyListResponse - Tenant policy information list.
type GetTenantPolicyListResponse struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of tenant policies.
	Value []*GetTenantPolicyResponse `json:"value,omitempty" azure:"ro"`
}

// GetTenantPolicyResponse - Tenant policy Information.
type GetTenantPolicyResponse struct {
	// Tenant policy properties.
	Properties *TenantPolicy `json:"properties,omitempty"`

	// READ-ONLY; Policy Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Policy name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ListResult - Subscription list operation response.
type ListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of subscriptions.
	Value []*Subscription `json:"value,omitempty"`
}

// Location information.
type Location struct {
	// READ-ONLY; The display name of the location.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified ID of the location. For example, /subscriptions/00000000-0000-0000-0000-000000000000/locations/westus.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The latitude of the location.
	Latitude *string `json:"latitude,omitempty" azure:"ro"`

	// READ-ONLY; The longitude of the location.
	Longitude *string `json:"longitude,omitempty" azure:"ro"`

	// READ-ONLY; The location name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The subscription ID.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// LocationListResult - Location list operation response.
type LocationListResult struct {
	// An array of locations.
	Value []*Location `json:"value,omitempty"`
}

// Name - The new name of the subscription.
type Name struct {
	// New subscription name
	SubscriptionName *string `json:"subscriptionName,omitempty"`
}

// Operation - REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Localized friendly description for the operation
	Description *string `json:"description,omitempty"`

	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.Subscription
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list operations. It contains a list of operations and a URL link to get
// the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of operations.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Policies - Subscription policies.
type Policies struct {
	// READ-ONLY; The subscription location placement ID. The ID indicates which regions are visible for a subscription. For example,
	// a subscription with a location placement Id of Public_2014-09-01 has access to Azure
	// public regions.
	LocationPlacementID *string `json:"locationPlacementId,omitempty" azure:"ro"`

	// READ-ONLY; The subscription quota ID.
	QuotaID *string `json:"quotaId,omitempty" azure:"ro"`

	// READ-ONLY; The subscription spending limit.
	SpendingLimit *SpendingLimit `json:"spendingLimit,omitempty" azure:"ro"`
}

// PolicyClientAddUpdatePolicyForTenantOptions contains the optional parameters for the PolicyClient.AddUpdatePolicyForTenant
// method.
type PolicyClientAddUpdatePolicyForTenantOptions struct {
	// placeholder for future optional parameters
}

// PolicyClientGetPolicyForTenantOptions contains the optional parameters for the PolicyClient.GetPolicyForTenant method.
type PolicyClientGetPolicyForTenantOptions struct {
	// placeholder for future optional parameters
}

// PolicyClientListPolicyForTenantOptions contains the optional parameters for the PolicyClient.ListPolicyForTenant method.
type PolicyClientListPolicyForTenantOptions struct {
	// placeholder for future optional parameters
}

// PutAliasRequest - The parameters required to create a new subscription.
type PutAliasRequest struct {
	// Put alias request properties.
	Properties *PutAliasRequestProperties `json:"properties,omitempty"`
}

// PutAliasRequestAdditionalProperties - Put subscription additional properties.
type PutAliasRequestAdditionalProperties struct {
	// Management group Id for the subscription.
	ManagementGroupID *string `json:"managementGroupId,omitempty"`

	// Owner Id of the subscription
	SubscriptionOwnerID *string `json:"subscriptionOwnerId,omitempty"`

	// Tenant Id of the subscription
	SubscriptionTenantID *string `json:"subscriptionTenantId,omitempty"`

	// Tags for the subscription
	Tags map[string]*string `json:"tags,omitempty"`
}

// PutAliasRequestProperties - Put subscription properties.
type PutAliasRequestProperties struct {
	// Put alias request additional properties.
	AdditionalProperties *PutAliasRequestAdditionalProperties `json:"additionalProperties,omitempty"`

	// Billing scope of the subscription. For CustomerLed and FieldLed - /billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}
	// For PartnerLed -
	// /billingAccounts/{billingAccountName}/customers/{customerName} For Legacy EA - /billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}
	BillingScope *string `json:"billingScope,omitempty"`

	// The friendly name of the subscription.
	DisplayName *string `json:"displayName,omitempty"`

	// Reseller Id
	ResellerID *string `json:"resellerId,omitempty"`

	// This parameter can be used to create alias for existing subscription Id
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// The workload type of the subscription. It can be either Production or DevTest.
	Workload *Workload `json:"workload,omitempty"`
}

// PutTenantPolicyRequestProperties - Put tenant policy request properties.
type PutTenantPolicyRequestProperties struct {
	// Blocks the entering of subscriptions into user's tenant.
	BlockSubscriptionsIntoTenant *bool `json:"blockSubscriptionsIntoTenant,omitempty"`

	// Blocks the leaving of subscriptions from user's tenant.
	BlockSubscriptionsLeavingTenant *bool `json:"blockSubscriptionsLeavingTenant,omitempty"`

	// List of user objectIds that are exempted from the set subscription tenant policies for the user's tenant.
	ExemptedPrincipals []*string `json:"exemptedPrincipals,omitempty"`
}

// RenamedSubscriptionID - The ID of the subscriptions that is being renamed
type RenamedSubscriptionID struct {
	// READ-ONLY; The ID of the subscriptions that is being renamed
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// ServiceTenantResponse - Billing account service tenant.
type ServiceTenantResponse struct {
	// Service tenant id.
	TenantID *string `json:"tenantId,omitempty"`

	// Service tenant name.
	TenantName *string `json:"tenantName,omitempty"`
}

// Subscription information.
type Subscription struct {
	// The authorization source of the request. Valid values are one or more combinations of Legacy, RoleBased, Bypassed, Direct
	// and Management. For example, 'Legacy, RoleBased'.
	AuthorizationSource *string `json:"authorizationSource,omitempty"`

	// The subscription policies.
	SubscriptionPolicies *Policies `json:"subscriptionPolicies,omitempty"`

	// READ-ONLY; The subscription display name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified ID for the subscription. For example, /subscriptions/00000000-0000-0000-0000-000000000000.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The subscription state. Possible values are Enabled, Warned, PastDue, Disabled, and Deleted.
	State *SubscriptionState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; The subscription ID.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// SubscriptionsClientGetOptions contains the optional parameters for the SubscriptionsClient.Get method.
type SubscriptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionsClientListLocationsOptions contains the optional parameters for the SubscriptionsClient.ListLocations method.
type SubscriptionsClientListLocationsOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionsClientListOptions contains the optional parameters for the SubscriptionsClient.List method.
type SubscriptionsClientListOptions struct {
	// placeholder for future optional parameters
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TenantIDDescription - Tenant Id information.
type TenantIDDescription struct {
	// READ-ONLY; The fully qualified ID of the tenant. For example, /tenants/00000000-0000-0000-0000-000000000000.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID. For example, 00000000-0000-0000-0000-000000000000.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// TenantListResult - Tenant Ids information.
type TenantListResult struct {
	// REQUIRED; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of tenants.
	Value []*TenantIDDescription `json:"value,omitempty"`
}

// TenantPolicy - Tenant policy.
type TenantPolicy struct {
	// Blocks the entering of subscriptions into user's tenant.
	BlockSubscriptionsIntoTenant *bool `json:"blockSubscriptionsIntoTenant,omitempty"`

	// Blocks the leaving of subscriptions from user's tenant.
	BlockSubscriptionsLeavingTenant *bool `json:"blockSubscriptionsLeavingTenant,omitempty"`

	// List of user objectIds that are exempted from the set subscription tenant policies for the user's tenant.
	ExemptedPrincipals []*string `json:"exemptedPrincipals,omitempty"`

	// READ-ONLY; Policy Id.
	PolicyID *string `json:"policyId,omitempty" azure:"ro"`
}

// TenantsClientListOptions contains the optional parameters for the TenantsClient.List method.
type TenantsClientListOptions struct {
	// placeholder for future optional parameters
}
