//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armkusto

import "time"

// AcceptedAudiences - Represents an accepted audience trusted by the cluster.
type AcceptedAudiences struct {
	// GUID or valid URL representing an accepted audience.
	Value *string `json:"value,omitempty"`
}

// AttachedDatabaseConfiguration - Class representing an attached database configuration.
type AttachedDatabaseConfiguration struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// The properties of the attached database configuration.
	Properties *AttachedDatabaseConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AttachedDatabaseConfigurationListResult - The list attached database configurations operation response.
type AttachedDatabaseConfigurationListResult struct {
	// The list of attached database configurations.
	Value []*AttachedDatabaseConfiguration `json:"value,omitempty"`
}

// AttachedDatabaseConfigurationProperties - Class representing the an attached database configuration properties of kind
// specific.
type AttachedDatabaseConfigurationProperties struct {
	// REQUIRED; The resource id of the cluster where the databases you would like to attach reside.
	ClusterResourceID *string `json:"clusterResourceId,omitempty"`

	// REQUIRED; The name of the database which you would like to attach, use * if you want to follow all current and future databases.
	DatabaseName *string `json:"databaseName,omitempty"`

	// REQUIRED; The default principals modification kind
	DefaultPrincipalsModificationKind *DefaultPrincipalsModificationKind `json:"defaultPrincipalsModificationKind,omitempty"`

	// Overrides the original database name. Relevant only when attaching to a specific database.
	DatabaseNameOverride *string `json:"databaseNameOverride,omitempty"`

	// Adds a prefix to the attached databases name. When following an entire cluster, that prefix would be added to all of the
	// databases original names from leader cluster.
	DatabaseNamePrefix *string `json:"databaseNamePrefix,omitempty"`

	// Table level sharing specifications
	TableLevelSharingProperties *TableLevelSharingProperties `json:"tableLevelSharingProperties,omitempty"`

	// READ-ONLY; The list of databases from the clusterResourceId which are currently attached to the cluster.
	AttachedDatabaseNames []*string `json:"attachedDatabaseNames,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// AttachedDatabaseConfigurationsCheckNameRequest - The result returned from a AttachedDatabaseConfigurations check name availability
// request.
type AttachedDatabaseConfigurationsCheckNameRequest struct {
	// REQUIRED; Attached database resource name.
	Name *string `json:"name,omitempty"`

	// CONSTANT; The type of resource, for instance Microsoft.Kusto/clusters/attachedDatabaseConfigurations.
	// Field has constant value "Microsoft.Kusto/clusters/attachedDatabaseConfigurations", any specified value is ignored.
	Type *string `json:"type,omitempty"`
}

// AttachedDatabaseConfigurationsClientBeginCreateOrUpdateOptions contains the optional parameters for the AttachedDatabaseConfigurationsClient.BeginCreateOrUpdate
// method.
type AttachedDatabaseConfigurationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AttachedDatabaseConfigurationsClientBeginDeleteOptions contains the optional parameters for the AttachedDatabaseConfigurationsClient.BeginDelete
// method.
type AttachedDatabaseConfigurationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AttachedDatabaseConfigurationsClientCheckNameAvailabilityOptions contains the optional parameters for the AttachedDatabaseConfigurationsClient.CheckNameAvailability
// method.
type AttachedDatabaseConfigurationsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// AttachedDatabaseConfigurationsClientGetOptions contains the optional parameters for the AttachedDatabaseConfigurationsClient.Get
// method.
type AttachedDatabaseConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AttachedDatabaseConfigurationsClientListByClusterOptions contains the optional parameters for the AttachedDatabaseConfigurationsClient.ListByCluster
// method.
type AttachedDatabaseConfigurationsClientListByClusterOptions struct {
	// placeholder for future optional parameters
}

// AzureCapacity - Azure capacity definition.
type AzureCapacity struct {
	// REQUIRED; The default capacity that would be used.
	Default *int32 `json:"default,omitempty"`

	// REQUIRED; Maximum allowed capacity.
	Maximum *int32 `json:"maximum,omitempty"`

	// REQUIRED; Minimum allowed capacity.
	Minimum *int32 `json:"minimum,omitempty"`

	// REQUIRED; Scale type.
	ScaleType *AzureScaleType `json:"scaleType,omitempty"`
}

// AzureResourceSKU - Azure resource SKU definition.
type AzureResourceSKU struct {
	// The number of instances of the cluster.
	Capacity *AzureCapacity `json:"capacity,omitempty"`

	// Resource Namespace and Type.
	ResourceType *string `json:"resourceType,omitempty"`

	// The SKU details.
	SKU *AzureSKU `json:"sku,omitempty"`
}

// AzureSKU - Azure SKU definition.
type AzureSKU struct {
	// REQUIRED; SKU name.
	Name *AzureSKUName `json:"name,omitempty"`

	// REQUIRED; SKU tier.
	Tier *AzureSKUTier `json:"tier,omitempty"`

	// The number of instances of the cluster.
	Capacity *int32 `json:"capacity,omitempty"`
}

// CheckNameRequest - The result returned from a database check name availability request.
type CheckNameRequest struct {
	// REQUIRED; Resource name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of resource, for instance Microsoft.Kusto/clusters/databases.
	Type *Type `json:"type,omitempty"`
}

// CheckNameResult - The result returned from a check name availability request.
type CheckNameResult struct {
	// Message indicating an unavailable name due to a conflict, or a description of the naming rules that are violated.
	Message *string `json:"message,omitempty"`

	// The name that was checked.
	Name *string `json:"name,omitempty"`

	// Specifies a Boolean value that indicates if the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// Message providing the reason why the given name is invalid.
	Reason *Reason `json:"reason,omitempty"`
}

// Cluster - Class representing a Kusto cluster.
type Cluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; The SKU of the cluster.
	SKU *AzureSKU `json:"sku,omitempty"`

	// The identity of the cluster, if configured.
	Identity *Identity `json:"identity,omitempty"`

	// The cluster properties.
	Properties *ClusterProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// The availability zones of the cluster.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClusterCheckNameRequest - The result returned from a cluster check name availability request.
type ClusterCheckNameRequest struct {
	// REQUIRED; Cluster name.
	Name *string `json:"name,omitempty"`

	// CONSTANT; The type of resource, Microsoft.Kusto/clusters.
	// Field has constant value "Microsoft.Kusto/clusters", any specified value is ignored.
	Type *string `json:"type,omitempty"`
}

// ClusterListResult - The list Kusto clusters operation response.
type ClusterListResult struct {
	// The list of Kusto clusters.
	Value []*Cluster `json:"value,omitempty"`
}

// ClusterPrincipalAssignment - Class representing a cluster principal assignment.
type ClusterPrincipalAssignment struct {
	// The cluster principal.
	Properties *ClusterPrincipalProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClusterPrincipalAssignmentCheckNameRequest - A principal assignment check name availability request.
type ClusterPrincipalAssignmentCheckNameRequest struct {
	// REQUIRED; Principal Assignment resource name.
	Name *string `json:"name,omitempty"`

	// CONSTANT; The type of resource, Microsoft.Kusto/clusters/principalAssignments.
	// Field has constant value "Microsoft.Kusto/clusters/principalAssignments", any specified value is ignored.
	Type *string `json:"type,omitempty"`
}

// ClusterPrincipalAssignmentListResult - The list Kusto cluster principal assignments operation response.
type ClusterPrincipalAssignmentListResult struct {
	// The list of Kusto cluster principal assignments.
	Value []*ClusterPrincipalAssignment `json:"value,omitempty"`
}

// ClusterPrincipalAssignmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the ClusterPrincipalAssignmentsClient.BeginCreateOrUpdate
// method.
type ClusterPrincipalAssignmentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClusterPrincipalAssignmentsClientBeginDeleteOptions contains the optional parameters for the ClusterPrincipalAssignmentsClient.BeginDelete
// method.
type ClusterPrincipalAssignmentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClusterPrincipalAssignmentsClientCheckNameAvailabilityOptions contains the optional parameters for the ClusterPrincipalAssignmentsClient.CheckNameAvailability
// method.
type ClusterPrincipalAssignmentsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ClusterPrincipalAssignmentsClientGetOptions contains the optional parameters for the ClusterPrincipalAssignmentsClient.Get
// method.
type ClusterPrincipalAssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClusterPrincipalAssignmentsClientListOptions contains the optional parameters for the ClusterPrincipalAssignmentsClient.List
// method.
type ClusterPrincipalAssignmentsClientListOptions struct {
	// placeholder for future optional parameters
}

// ClusterPrincipalProperties - A class representing cluster principal property.
type ClusterPrincipalProperties struct {
	// REQUIRED; The principal ID assigned to the cluster principal. It can be a user email, application ID, or security group
	// name.
	PrincipalID *string `json:"principalId,omitempty"`

	// REQUIRED; Principal type.
	PrincipalType *PrincipalType `json:"principalType,omitempty"`

	// REQUIRED; Cluster principal role.
	Role *ClusterPrincipalRole `json:"role,omitempty"`

	// The tenant id of the principal
	TenantID *string `json:"tenantId,omitempty"`

	// READ-ONLY; The service principal object id in AAD (Azure active directory)
	AADObjectID *string `json:"aadObjectId,omitempty" azure:"ro"`

	// READ-ONLY; The principal name
	PrincipalName *string `json:"principalName,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The tenant name of the principal
	TenantName *string `json:"tenantName,omitempty" azure:"ro"`
}

// ClusterProperties - Class representing the Kusto cluster properties.
type ClusterProperties struct {
	// The cluster's accepted audiences.
	AcceptedAudiences []*AcceptedAudiences `json:"acceptedAudiences,omitempty"`

	// List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
	AllowedFqdnList []*string `json:"allowedFqdnList,omitempty"`

	// The list of ips in the format of CIDR allowed to connect to the cluster.
	AllowedIPRangeList []*string `json:"allowedIpRangeList,omitempty"`

	// A boolean value that indicates if the cluster could be automatically stopped (due to lack of data or no activity for many
	// days).
	EnableAutoStop *bool `json:"enableAutoStop,omitempty"`

	// A boolean value that indicates if the cluster's disks are encrypted.
	EnableDiskEncryption *bool `json:"enableDiskEncryption,omitempty"`

	// A boolean value that indicates if double encryption is enabled.
	EnableDoubleEncryption *bool `json:"enableDoubleEncryption,omitempty"`

	// A boolean value that indicates if the purge operations are enabled.
	EnablePurge *bool `json:"enablePurge,omitempty"`

	// A boolean value that indicates if the streaming ingest is enabled.
	EnableStreamingIngest *bool `json:"enableStreamingIngest,omitempty"`

	// The engine type
	EngineType *EngineType `json:"engineType,omitempty"`

	// KeyVault properties for the cluster encryption.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`

	// Optimized auto scale definition.
	OptimizedAutoscale *OptimizedAutoscale `json:"optimizedAutoscale,omitempty"`

	// Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6)
	PublicIPType *PublicIPType `json:"publicIPType,omitempty"`

	// Public network access to the cluster is enabled by default. When disabled, only private endpoint connection to the cluster
	// is allowed
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Whether or not to restrict outbound network access. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
	RestrictOutboundNetworkAccess *ClusterNetworkAccessFlag `json:"restrictOutboundNetworkAccess,omitempty"`

	// The cluster's external tenants.
	TrustedExternalTenants []*TrustedExternalTenant `json:"trustedExternalTenants,omitempty"`

	// Virtual Cluster graduation properties
	VirtualClusterGraduationProperties *string `json:"virtualClusterGraduationProperties,omitempty"`

	// Virtual network definition.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration `json:"virtualNetworkConfiguration,omitempty"`

	// READ-ONLY; The cluster data ingestion URI.
	DataIngestionURI *string `json:"dataIngestionUri,omitempty" azure:"ro"`

	// READ-ONLY; List of the cluster's language extensions.
	LanguageExtensions *LanguageExtensionsList `json:"languageExtensions,omitempty" azure:"ro"`

	// READ-ONLY; A list of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The state of the resource.
	State *State `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; The reason for the cluster's current state.
	StateReason *string `json:"stateReason,omitempty" azure:"ro"`

	// READ-ONLY; The cluster URI.
	URI *string `json:"uri,omitempty" azure:"ro"`
}

// ClusterUpdate - Class representing an update to a Kusto cluster.
type ClusterUpdate struct {
	// The identity of the cluster, if configured.
	Identity *Identity `json:"identity,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The cluster properties.
	Properties *ClusterProperties `json:"properties,omitempty"`

	// The SKU of the cluster.
	SKU *AzureSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClustersClientBeginAddLanguageExtensionsOptions contains the optional parameters for the ClustersClient.BeginAddLanguageExtensions
// method.
type ClustersClientBeginAddLanguageExtensionsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginCreateOrUpdateOptions contains the optional parameters for the ClustersClient.BeginCreateOrUpdate method.
type ClustersClientBeginCreateOrUpdateOptions struct {
	// The ETag of the cluster. Omit this value to always overwrite the current cluster. Specify the last-seen ETag value to prevent
	// accidentally overwriting concurrent changes.
	IfMatch *string
	// Set to '*' to allow a new cluster to be created, but to prevent updating an existing cluster. Other values will result
	// in a 412 Pre-condition Failed response.
	IfNoneMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginDeleteOptions contains the optional parameters for the ClustersClient.BeginDelete method.
type ClustersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginDetachFollowerDatabasesOptions contains the optional parameters for the ClustersClient.BeginDetachFollowerDatabases
// method.
type ClustersClientBeginDetachFollowerDatabasesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginDiagnoseVirtualNetworkOptions contains the optional parameters for the ClustersClient.BeginDiagnoseVirtualNetwork
// method.
type ClustersClientBeginDiagnoseVirtualNetworkOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginRemoveLanguageExtensionsOptions contains the optional parameters for the ClustersClient.BeginRemoveLanguageExtensions
// method.
type ClustersClientBeginRemoveLanguageExtensionsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginStartOptions contains the optional parameters for the ClustersClient.BeginStart method.
type ClustersClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginStopOptions contains the optional parameters for the ClustersClient.BeginStop method.
type ClustersClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginUpdateOptions contains the optional parameters for the ClustersClient.BeginUpdate method.
type ClustersClientBeginUpdateOptions struct {
	// The ETag of the cluster. Omit this value to always overwrite the current cluster. Specify the last-seen ETag value to prevent
	// accidentally overwriting concurrent changes.
	IfMatch *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientCheckNameAvailabilityOptions contains the optional parameters for the ClustersClient.CheckNameAvailability
// method.
type ClustersClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientGetOptions contains the optional parameters for the ClustersClient.Get method.
type ClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListByResourceGroupOptions contains the optional parameters for the ClustersClient.ListByResourceGroup method.
type ClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListFollowerDatabasesOptions contains the optional parameters for the ClustersClient.ListFollowerDatabases
// method.
type ClustersClientListFollowerDatabasesOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListLanguageExtensionsOptions contains the optional parameters for the ClustersClient.ListLanguageExtensions
// method.
type ClustersClientListLanguageExtensionsOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListOptions contains the optional parameters for the ClustersClient.List method.
type ClustersClientListOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListOutboundNetworkDependenciesEndpointsOptions contains the optional parameters for the ClustersClient.ListOutboundNetworkDependenciesEndpoints
// method.
type ClustersClientListOutboundNetworkDependenciesEndpointsOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListSKUsByResourceOptions contains the optional parameters for the ClustersClient.ListSKUsByResource method.
type ClustersClientListSKUsByResourceOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListSKUsOptions contains the optional parameters for the ClustersClient.ListSKUs method.
type ClustersClientListSKUsOptions struct {
	// placeholder for future optional parameters
}

type ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// DataConnectionClassification provides polymorphic access to related types.
// Call the interface's GetDataConnection() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DataConnection, *EventGridDataConnection, *EventHubDataConnection, *IotHubDataConnection
type DataConnectionClassification interface {
	// GetDataConnection returns the DataConnection content of the underlying type.
	GetDataConnection() *DataConnection
}

// DataConnection - Class representing an data connection.
type DataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataConnection implements the DataConnectionClassification interface for type DataConnection.
func (d *DataConnection) GetDataConnection() *DataConnection { return d }

// DataConnectionCheckNameRequest - A data connection check name availability request.
type DataConnectionCheckNameRequest struct {
	// REQUIRED; Data Connection name.
	Name *string `json:"name,omitempty"`

	// CONSTANT; The type of resource, Microsoft.Kusto/clusters/databases/dataConnections.
	// Field has constant value "Microsoft.Kusto/clusters/databases/dataConnections", any specified value is ignored.
	Type *string `json:"type,omitempty"`
}

// DataConnectionListResult - The list Kusto data connections operation response.
type DataConnectionListResult struct {
	// The list of Kusto data connections.
	Value []DataConnectionClassification `json:"value,omitempty"`
}

// DataConnectionValidation - Class representing an data connection validation.
type DataConnectionValidation struct {
	// The name of the data connection.
	DataConnectionName *string `json:"dataConnectionName,omitempty"`

	// The data connection properties to validate.
	Properties DataConnectionClassification `json:"properties,omitempty"`
}

// DataConnectionValidationListResult - The list Kusto data connection validation result.
type DataConnectionValidationListResult struct {
	// The list of Kusto data connection validation errors.
	Value []*DataConnectionValidationResult `json:"value,omitempty"`
}

// DataConnectionValidationResult - The result returned from a data connection validation request.
type DataConnectionValidationResult struct {
	// A message which indicates a problem in data connection validation.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// DataConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the DataConnectionsClient.BeginCreateOrUpdate
// method.
type DataConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DataConnectionsClientBeginDataConnectionValidationOptions contains the optional parameters for the DataConnectionsClient.BeginDataConnectionValidation
// method.
type DataConnectionsClientBeginDataConnectionValidationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DataConnectionsClientBeginDeleteOptions contains the optional parameters for the DataConnectionsClient.BeginDelete method.
type DataConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DataConnectionsClientBeginUpdateOptions contains the optional parameters for the DataConnectionsClient.BeginUpdate method.
type DataConnectionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DataConnectionsClientCheckNameAvailabilityOptions contains the optional parameters for the DataConnectionsClient.CheckNameAvailability
// method.
type DataConnectionsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// DataConnectionsClientGetOptions contains the optional parameters for the DataConnectionsClient.Get method.
type DataConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataConnectionsClientListByDatabaseOptions contains the optional parameters for the DataConnectionsClient.ListByDatabase
// method.
type DataConnectionsClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// DatabaseClassification provides polymorphic access to related types.
// Call the interface's GetDatabase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *Database, *ReadOnlyFollowingDatabase, *ReadWriteDatabase
type DatabaseClassification interface {
	// GetDatabase returns the Database content of the underlying type.
	GetDatabase() *Database
}

// Database - Class representing a Kusto database.
type Database struct {
	// REQUIRED; Kind of the database
	Kind *Kind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDatabase implements the DatabaseClassification interface for type Database.
func (d *Database) GetDatabase() *Database { return d }

// DatabaseListResult - The list Kusto databases operation response.
type DatabaseListResult struct {
	// The list of Kusto databases.
	Value []DatabaseClassification `json:"value,omitempty"`
}

// DatabasePrincipal - A class representing database principal entity.
type DatabasePrincipal struct {
	// REQUIRED; Database principal name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Database principal role.
	Role *DatabasePrincipalRole `json:"role,omitempty"`

	// REQUIRED; Database principal type.
	Type *DatabasePrincipalType `json:"type,omitempty"`

	// Application id - relevant only for application principal type.
	AppID *string `json:"appId,omitempty"`

	// Database principal email if exists.
	Email *string `json:"email,omitempty"`

	// Database principal fully qualified name.
	Fqn *string `json:"fqn,omitempty"`

	// READ-ONLY; The tenant name of the principal
	TenantName *string `json:"tenantName,omitempty" azure:"ro"`
}

// DatabasePrincipalAssignment - Class representing a database principal assignment.
type DatabasePrincipalAssignment struct {
	// The database principal.
	Properties *DatabasePrincipalProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabasePrincipalAssignmentCheckNameRequest - A principal assignment check name availability request.
type DatabasePrincipalAssignmentCheckNameRequest struct {
	// REQUIRED; Principal Assignment resource name.
	Name *string `json:"name,omitempty"`

	// CONSTANT; The type of resource, Microsoft.Kusto/clusters/databases/principalAssignments.
	// Field has constant value "Microsoft.Kusto/clusters/databases/principalAssignments", any specified value is ignored.
	Type *string `json:"type,omitempty"`
}

// DatabasePrincipalAssignmentListResult - The list Kusto database principal assignments operation response.
type DatabasePrincipalAssignmentListResult struct {
	// The list of Kusto database principal assignments.
	Value []*DatabasePrincipalAssignment `json:"value,omitempty"`
}

// DatabasePrincipalAssignmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the DatabasePrincipalAssignmentsClient.BeginCreateOrUpdate
// method.
type DatabasePrincipalAssignmentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasePrincipalAssignmentsClientBeginDeleteOptions contains the optional parameters for the DatabasePrincipalAssignmentsClient.BeginDelete
// method.
type DatabasePrincipalAssignmentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasePrincipalAssignmentsClientCheckNameAvailabilityOptions contains the optional parameters for the DatabasePrincipalAssignmentsClient.CheckNameAvailability
// method.
type DatabasePrincipalAssignmentsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// DatabasePrincipalAssignmentsClientGetOptions contains the optional parameters for the DatabasePrincipalAssignmentsClient.Get
// method.
type DatabasePrincipalAssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabasePrincipalAssignmentsClientListOptions contains the optional parameters for the DatabasePrincipalAssignmentsClient.List
// method.
type DatabasePrincipalAssignmentsClientListOptions struct {
	// placeholder for future optional parameters
}

// DatabasePrincipalListRequest - The list Kusto database principals operation request.
type DatabasePrincipalListRequest struct {
	// The list of Kusto database principals.
	Value []*DatabasePrincipal `json:"value,omitempty"`
}

// DatabasePrincipalListResult - The list Kusto database principals operation response.
type DatabasePrincipalListResult struct {
	// The list of Kusto database principals.
	Value []*DatabasePrincipal `json:"value,omitempty"`
}

// DatabasePrincipalProperties - A class representing database principal property.
type DatabasePrincipalProperties struct {
	// REQUIRED; The principal ID assigned to the database principal. It can be a user email, application ID, or security group
	// name.
	PrincipalID *string `json:"principalId,omitempty"`

	// REQUIRED; Principal type.
	PrincipalType *PrincipalType `json:"principalType,omitempty"`

	// REQUIRED; Database principal role.
	Role *DatabasePrincipalRole `json:"role,omitempty"`

	// The tenant id of the principal
	TenantID *string `json:"tenantId,omitempty"`

	// READ-ONLY; The service principal object id in AAD (Azure active directory)
	AADObjectID *string `json:"aadObjectId,omitempty" azure:"ro"`

	// READ-ONLY; The principal name
	PrincipalName *string `json:"principalName,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The tenant name of the principal
	TenantName *string `json:"tenantName,omitempty" azure:"ro"`
}

// DatabaseStatistics - A class that contains database statistics information.
type DatabaseStatistics struct {
	// The database size - the total size of compressed data and index in bytes.
	Size *float32 `json:"size,omitempty"`
}

// DatabasesClientAddPrincipalsOptions contains the optional parameters for the DatabasesClient.AddPrincipals method.
type DatabasesClientAddPrincipalsOptions struct {
	// placeholder for future optional parameters
}

// DatabasesClientBeginCreateOrUpdateOptions contains the optional parameters for the DatabasesClient.BeginCreateOrUpdate
// method.
type DatabasesClientBeginCreateOrUpdateOptions struct {
	// By default, any user who run operation on a database become an Admin on it. This property allows the caller to exclude
	// the caller from Admins list.
	CallerRole *CallerRole
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientBeginDeleteOptions contains the optional parameters for the DatabasesClient.BeginDelete method.
type DatabasesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientBeginUpdateOptions contains the optional parameters for the DatabasesClient.BeginUpdate method.
type DatabasesClientBeginUpdateOptions struct {
	// By default, any user who run operation on a database become an Admin on it. This property allows the caller to exclude
	// the caller from Admins list.
	CallerRole *CallerRole
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientCheckNameAvailabilityOptions contains the optional parameters for the DatabasesClient.CheckNameAvailability
// method.
type DatabasesClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// DatabasesClientGetOptions contains the optional parameters for the DatabasesClient.Get method.
type DatabasesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabasesClientListByClusterOptions contains the optional parameters for the DatabasesClient.ListByCluster method.
type DatabasesClientListByClusterOptions struct {
	// placeholder for future optional parameters
}

// DatabasesClientListPrincipalsOptions contains the optional parameters for the DatabasesClient.ListPrincipals method.
type DatabasesClientListPrincipalsOptions struct {
	// placeholder for future optional parameters
}

// DatabasesClientRemovePrincipalsOptions contains the optional parameters for the DatabasesClient.RemovePrincipals method.
type DatabasesClientRemovePrincipalsOptions struct {
	// placeholder for future optional parameters
}

type DiagnoseVirtualNetworkResult struct {
	// The list of network connectivity diagnostic finding
	Findings []*string `json:"findings,omitempty"`
}

// EndpointDependency - A domain name that a service is reached at, including details of the current connection status.
type EndpointDependency struct {
	// The domain name of the dependency.
	DomainName *string `json:"domainName,omitempty"`

	// The ports used when connecting to DomainName.
	EndpointDetails []*EndpointDetail `json:"endpointDetails,omitempty"`
}

// EndpointDetail - Current TCP connectivity information from the Kusto cluster to a single endpoint.
type EndpointDetail struct {
	// The port an endpoint is connected to.
	Port *int32 `json:"port,omitempty"`
}

// EventGridConnectionProperties - Class representing the Kusto event grid connection properties.
type EventGridConnectionProperties struct {
	// REQUIRED; The event hub consumer group.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`

	// REQUIRED; The resource ID where the event grid is configured to send events.
	EventHubResourceID *string `json:"eventHubResourceId,omitempty"`

	// REQUIRED; The resource ID of the storage account where the data resides.
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`

	// The name of blob storage event type to process.
	BlobStorageEventType *BlobStorageEventType `json:"blobStorageEventType,omitempty"`

	// The data format of the message. Optionally the data format can be added to each message.
	DataFormat *EventGridDataFormat `json:"dataFormat,omitempty"`

	// Indication for database routing information from the data connection, by default only database routing information is allowed
	DatabaseRouting *DatabaseRouting `json:"databaseRouting,omitempty"`

	// The resource ID of the event grid that is subscribed to the storage account events.
	EventGridResourceID *string `json:"eventGridResourceId,omitempty"`

	// A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file
	IgnoreFirstRecord *bool `json:"ignoreFirstRecord,omitempty"`

	// The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub and storage account.
	ManagedIdentityResourceID *string `json:"managedIdentityResourceId,omitempty"`

	// The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string `json:"mappingRuleName,omitempty"`

	// The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string `json:"tableName,omitempty"`

	// READ-ONLY; The object ID of managedIdentityResourceId
	ManagedIdentityObjectID *string `json:"managedIdentityObjectId,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// EventGridDataConnection - Class representing an Event Grid data connection.
type EventGridDataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The properties of the Event Grid data connection.
	Properties *EventGridConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataConnection implements the DataConnectionClassification interface for type EventGridDataConnection.
func (e *EventGridDataConnection) GetDataConnection() *DataConnection {
	return &DataConnection{
		Location: e.Location,
		Kind:     e.Kind,
		ID:       e.ID,
		Name:     e.Name,
		Type:     e.Type,
	}
}

// EventHubConnectionProperties - Class representing the Kusto event hub connection properties.
type EventHubConnectionProperties struct {
	// REQUIRED; The event hub consumer group.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`

	// REQUIRED; The resource ID of the event hub to be used to create a data connection.
	EventHubResourceID *string `json:"eventHubResourceId,omitempty"`

	// The event hub messages compression type
	Compression *Compression `json:"compression,omitempty"`

	// The data format of the message. Optionally the data format can be added to each message.
	DataFormat *EventHubDataFormat `json:"dataFormat,omitempty"`

	// Indication for database routing information from the data connection, by default only database routing information is allowed
	DatabaseRouting *DatabaseRouting `json:"databaseRouting,omitempty"`

	// System properties of the event hub
	EventSystemProperties []*string `json:"eventSystemProperties,omitempty"`

	// The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub.
	ManagedIdentityResourceID *string `json:"managedIdentityResourceId,omitempty"`

	// The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string `json:"mappingRuleName,omitempty"`

	// When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only
	// retrieve events retained by the Event hub, based on its retention period.
	RetrievalStartDate *time.Time `json:"retrievalStartDate,omitempty"`

	// The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string `json:"tableName,omitempty"`

	// READ-ONLY; The object ID of the managedIdentityResourceId
	ManagedIdentityObjectID *string `json:"managedIdentityObjectId,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// EventHubDataConnection - Class representing an event hub data connection.
type EventHubDataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The Event Hub data connection properties to validate.
	Properties *EventHubConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataConnection implements the DataConnectionClassification interface for type EventHubDataConnection.
func (e *EventHubDataConnection) GetDataConnection() *DataConnection {
	return &DataConnection{
		Location: e.Location,
		Kind:     e.Kind,
		ID:       e.ID,
		Name:     e.Name,
		Type:     e.Type,
	}
}

// FollowerDatabaseDefinition - A class representing follower database request.
type FollowerDatabaseDefinition struct {
	// REQUIRED; Resource name of the attached database configuration in the follower cluster.
	AttachedDatabaseConfigurationName *string `json:"attachedDatabaseConfigurationName,omitempty"`

	// REQUIRED; Resource id of the cluster that follows a database owned by this cluster.
	ClusterResourceID *string `json:"clusterResourceId,omitempty"`

	// READ-ONLY; The database name owned by this cluster that was followed. * in case following all databases.
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; The origin of the following setup.
	DatabaseShareOrigin *DatabaseShareOrigin `json:"databaseShareOrigin,omitempty" azure:"ro"`

	// READ-ONLY; Table level sharing specifications
	TableLevelSharingProperties *TableLevelSharingProperties `json:"tableLevelSharingProperties,omitempty" azure:"ro"`
}

// FollowerDatabaseListResult - The list Kusto database principals operation response.
type FollowerDatabaseListResult struct {
	// The list of follower database result.
	Value []*FollowerDatabaseDefinition `json:"value,omitempty"`
}

// Identity for the resource.
type Identity struct {
	// REQUIRED; The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created
	// identity and a set of user-assigned identities. The type 'None' will remove all
	// identities.
	Type *IdentityType `json:"type,omitempty"`

	// The list of user identities associated with the Kusto cluster. The user identity dictionary key references will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// IotHubConnectionProperties - Class representing the Kusto Iot hub connection properties.
type IotHubConnectionProperties struct {
	// REQUIRED; The iot hub consumer group.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`

	// REQUIRED; The resource ID of the Iot hub to be used to create a data connection.
	IotHubResourceID *string `json:"iotHubResourceId,omitempty"`

	// REQUIRED; The name of the share access policy
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`

	// The data format of the message. Optionally the data format can be added to each message.
	DataFormat *IotHubDataFormat `json:"dataFormat,omitempty"`

	// Indication for database routing information from the data connection, by default only database routing information is allowed
	DatabaseRouting *DatabaseRouting `json:"databaseRouting,omitempty"`

	// System properties of the iot hub
	EventSystemProperties []*string `json:"eventSystemProperties,omitempty"`

	// The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
	MappingRuleName *string `json:"mappingRuleName,omitempty"`

	// When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only
	// retrieve events retained by the Event hub, based on its retention period.
	RetrievalStartDate *time.Time `json:"retrievalStartDate,omitempty"`

	// The table where the data should be ingested. Optionally the table information can be added to each message.
	TableName *string `json:"tableName,omitempty"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// IotHubDataConnection - Class representing an iot hub data connection.
type IotHubDataConnection struct {
	// REQUIRED; Kind of the endpoint for the data connection
	Kind *DataConnectionKind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The Iot Hub data connection properties.
	Properties *IotHubConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataConnection implements the DataConnectionClassification interface for type IotHubDataConnection.
func (i *IotHubDataConnection) GetDataConnection() *DataConnection {
	return &DataConnection{
		Location: i.Location,
		Kind:     i.Kind,
		ID:       i.ID,
		Name:     i.Name,
		Type:     i.Type,
	}
}

// KeyVaultProperties - Properties of the key vault.
type KeyVaultProperties struct {
	// The name of the key vault key.
	KeyName *string `json:"keyName,omitempty"`

	// The Uri of the key vault.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`

	// The version of the key vault key.
	KeyVersion *string `json:"keyVersion,omitempty"`

	// The user assigned identity (ARM resource id) that has access to the key.
	UserIdentity *string `json:"userIdentity,omitempty"`
}

// LanguageExtension - The language extension object.
type LanguageExtension struct {
	// The language extension name.
	LanguageExtensionName *LanguageExtensionName `json:"languageExtensionName,omitempty"`
}

// LanguageExtensionsList - The list of language extension objects.
type LanguageExtensionsList struct {
	// The list of language extensions.
	Value []*LanguageExtension `json:"value,omitempty"`
}

// ListResourceSKUsResult - List of available SKUs for a Kusto Cluster.
type ListResourceSKUsResult struct {
	// The collection of available SKUs for an existing resource.
	Value []*AzureResourceSKU `json:"value,omitempty"`
}

// ManagedPrivateEndpoint - Class representing a managed private endpoint.
type ManagedPrivateEndpoint struct {
	// A managed private endpoint.
	Properties *ManagedPrivateEndpointProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedPrivateEndpointListResult - The list managed private endpoints operation response.
type ManagedPrivateEndpointListResult struct {
	// The list of managed private endpoints.
	Value []*ManagedPrivateEndpoint `json:"value,omitempty"`
}

// ManagedPrivateEndpointProperties - A class representing the properties of a managed private endpoint object.
type ManagedPrivateEndpointProperties struct {
	// REQUIRED; The groupId in which the managed private endpoint is created.
	GroupID *string `json:"groupId,omitempty"`

	// REQUIRED; The ARM resource ID of the resource for which the managed private endpoint is created.
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`

	// The region of the resource to which the managed private endpoint is created.
	PrivateLinkResourceRegion *string `json:"privateLinkResourceRegion,omitempty"`

	// The user request message.
	RequestMessage *string `json:"requestMessage,omitempty"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedPrivateEndpointsCheckNameRequest - The result returned from a managedPrivateEndpoints check name availability request.
type ManagedPrivateEndpointsCheckNameRequest struct {
	// REQUIRED; Managed private endpoint resource name.
	Name *string `json:"name,omitempty"`

	// CONSTANT; The type of resource, for instance Microsoft.Kusto/clusters/managedPrivateEndpoints.
	// Field has constant value "Microsoft.Kusto/clusters/managedPrivateEndpoints", any specified value is ignored.
	Type *string `json:"type,omitempty"`
}

// ManagedPrivateEndpointsClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedPrivateEndpointsClient.BeginCreateOrUpdate
// method.
type ManagedPrivateEndpointsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedPrivateEndpointsClientBeginDeleteOptions contains the optional parameters for the ManagedPrivateEndpointsClient.BeginDelete
// method.
type ManagedPrivateEndpointsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedPrivateEndpointsClientBeginUpdateOptions contains the optional parameters for the ManagedPrivateEndpointsClient.BeginUpdate
// method.
type ManagedPrivateEndpointsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedPrivateEndpointsClientCheckNameAvailabilityOptions contains the optional parameters for the ManagedPrivateEndpointsClient.CheckNameAvailability
// method.
type ManagedPrivateEndpointsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ManagedPrivateEndpointsClientGetOptions contains the optional parameters for the ManagedPrivateEndpointsClient.Get method.
type ManagedPrivateEndpointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedPrivateEndpointsClientListOptions contains the optional parameters for the ManagedPrivateEndpointsClient.List method.
type ManagedPrivateEndpointsClientListOptions struct {
	// placeholder for future optional parameters
}

// Operation - A REST API operation
type Operation struct {
	// The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// This is of the format {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`

	// The intended executor of the operation.
	Origin *string `json:"origin,omitempty"`

	// Properties of the operation.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationDisplay - The object that describes the operation.
type OperationDisplay struct {
	// The friendly name of the operation.
	Description *string `json:"description,omitempty"`

	// For example: read, write, delete.
	Operation *string `json:"operation,omitempty"`

	// Friendly name of the resource provider.
	Provider *string `json:"provider,omitempty"`

	// The resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list REST API operations. It contains a list of operations and a URL nextLink
// to get the next set of results.
type OperationListResult struct {
	// The URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of operations supported by the resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationResult - Operation Result Entity.
type OperationResult struct {
	// The operation end time
	EndTime *time.Time `json:"endTime,omitempty"`

	// Object that contains the error code and message if the operation failed.
	Error *OperationResultErrorProperties `json:"error,omitempty"`

	// Percentage completed.
	PercentComplete *float64 `json:"percentComplete,omitempty"`

	// Properties of the operation results
	Properties *OperationResultProperties `json:"properties,omitempty"`

	// The operation start time
	StartTime *time.Time `json:"startTime,omitempty"`

	// READ-ONLY; ID of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; status of the Operation result.
	Status *Status `json:"status,omitempty" azure:"ro"`
}

// OperationResultErrorProperties - Operation result error properties
type OperationResultErrorProperties struct {
	// The code of the error.
	Code *string `json:"code,omitempty"`

	// The error message.
	Message *string `json:"message,omitempty"`
}

// OperationResultProperties - Operation result properties
type OperationResultProperties struct {
	// The kind of the operation.
	OperationKind *string `json:"operationKind,omitempty"`

	// The state of the operation.
	OperationState *string `json:"operationState,omitempty"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationsResultsClientGetOptions contains the optional parameters for the OperationsResultsClient.Get method.
type OperationsResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationsResultsLocationClientGetOptions contains the optional parameters for the OperationsResultsLocationClient.Get
// method.
type OperationsResultsLocationClientGetOptions struct {
	// placeholder for future optional parameters
}

// OptimizedAutoscale - A class that contains the optimized auto scale definition.
type OptimizedAutoscale struct {
	// REQUIRED; A boolean value that indicate if the optimized autoscale feature is enabled or not.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// REQUIRED; Maximum allowed instances count.
	Maximum *int32 `json:"maximum,omitempty"`

	// REQUIRED; Minimum allowed instances count.
	Minimum *int32 `json:"minimum,omitempty"`

	// REQUIRED; The version of the template defined, for instance 1.
	Version *int32 `json:"version,omitempty"`
}

// OutboundNetworkDependenciesEndpoint - Endpoints accessed for a common purpose that the Kusto Service Environment requires
// outbound network access to.
type OutboundNetworkDependenciesEndpoint struct {
	// The outbound environment endpoint properties.
	Properties *OutboundNetworkDependenciesEndpointProperties `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OutboundNetworkDependenciesEndpointListResult - Collection of Outbound Environment Endpoints
type OutboundNetworkDependenciesEndpointListResult struct {
	// REQUIRED; Collection of resources.
	Value []*OutboundNetworkDependenciesEndpoint `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// OutboundNetworkDependenciesEndpointProperties - Endpoints accessed for a common purpose that the Kusto Service Environment
// requires outbound network access to.
type OutboundNetworkDependenciesEndpointProperties struct {
	// The type of service accessed by the Kusto Service Environment, e.g., Azure Storage, Azure SQL Database, and Azure Active
	// Directory.
	Category *string `json:"category,omitempty"`

	// The endpoints that the Kusto Service Environment reaches the service at.
	Endpoints []*EndpointDependency `json:"endpoints,omitempty"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; Connection State of the Private Endpoint Connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; Group id of the private endpoint.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the private endpoint.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointProperty - Private endpoint which the connection belongs to.
type PrivateEndpointProperty struct {
	// READ-ONLY; Resource id of the private endpoint.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required zone names.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListOptions contains the optional parameters for the PrivateLinkResourcesClient.List method.
type PrivateLinkResourcesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionStateProperty - Connection State of the Private Endpoint Connection.
type PrivateLinkServiceConnectionStateProperty struct {
	// The private link service connection description.
	Description *string `json:"description,omitempty"`

	// The private link service connection status.
	Status *string `json:"status,omitempty"`

	// READ-ONLY; Any action that is required beyond basic workflow (approve/ reject/ disconnect)
	ActionsRequired *string `json:"actionsRequired,omitempty" azure:"ro"`
}

// ReadOnlyFollowingDatabase - Class representing a read only following database.
type ReadOnlyFollowingDatabase struct {
	// REQUIRED; Kind of the database
	Kind *Kind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The database properties.
	Properties *ReadOnlyFollowingDatabaseProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDatabase implements the DatabaseClassification interface for type ReadOnlyFollowingDatabase.
func (r *ReadOnlyFollowingDatabase) GetDatabase() *Database {
	return &Database{
		Location: r.Location,
		Kind:     r.Kind,
		ID:       r.ID,
		Name:     r.Name,
		Type:     r.Type,
	}
}

// ReadOnlyFollowingDatabaseProperties - Class representing the Kusto database properties.
type ReadOnlyFollowingDatabaseProperties struct {
	// The time the data should be kept in cache for fast queries in TimeSpan.
	HotCachePeriod *string `json:"hotCachePeriod,omitempty"`

	// READ-ONLY; The name of the attached database configuration cluster
	AttachedDatabaseConfigurationName *string `json:"attachedDatabaseConfigurationName,omitempty" azure:"ro"`

	// READ-ONLY; The origin of the following setup.
	DatabaseShareOrigin *DatabaseShareOrigin `json:"databaseShareOrigin,omitempty" azure:"ro"`

	// READ-ONLY; The name of the leader cluster
	LeaderClusterResourceID *string `json:"leaderClusterResourceId,omitempty" azure:"ro"`

	// READ-ONLY; The original database name, before databaseNameOverride or databaseNamePrefix where applied.
	OriginalDatabaseName *string `json:"originalDatabaseName,omitempty" azure:"ro"`

	// READ-ONLY; The principals modification kind of the database
	PrincipalsModificationKind *PrincipalsModificationKind `json:"principalsModificationKind,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The time the data should be kept before it stops being accessible to queries in TimeSpan.
	SoftDeletePeriod *string `json:"softDeletePeriod,omitempty" azure:"ro"`

	// READ-ONLY; The statistics of the database.
	Statistics *DatabaseStatistics `json:"statistics,omitempty" azure:"ro"`

	// READ-ONLY; Table level sharing specifications
	TableLevelSharingProperties *TableLevelSharingProperties `json:"tableLevelSharingProperties,omitempty" azure:"ro"`
}

// ReadWriteDatabase - Class representing a read write database.
type ReadWriteDatabase struct {
	// REQUIRED; Kind of the database
	Kind *Kind `json:"kind,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// The database properties.
	Properties *ReadWriteDatabaseProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDatabase implements the DatabaseClassification interface for type ReadWriteDatabase.
func (r *ReadWriteDatabase) GetDatabase() *Database {
	return &Database{
		Location: r.Location,
		Kind:     r.Kind,
		ID:       r.ID,
		Name:     r.Name,
		Type:     r.Type,
	}
}

// ReadWriteDatabaseProperties - Class representing the Kusto database properties.
type ReadWriteDatabaseProperties struct {
	// The time the data should be kept in cache for fast queries in TimeSpan.
	HotCachePeriod *string `json:"hotCachePeriod,omitempty"`

	// The time the data should be kept before it stops being accessible to queries in TimeSpan.
	SoftDeletePeriod *string `json:"softDeletePeriod,omitempty"`

	// READ-ONLY; Indicates whether the database is followed.
	IsFollowed *bool `json:"isFollowed,omitempty" azure:"ro"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The statistics of the database.
	Statistics *DatabaseStatistics `json:"statistics,omitempty" azure:"ro"`
}

// SKUDescription - The Kusto SKU description of given resource type
type SKUDescription struct {
	// READ-ONLY; Locations and zones
	LocationInfo []*SKULocationInfoItem `json:"locationInfo,omitempty" azure:"ro"`

	// READ-ONLY; The set of locations that the SKU is available
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The name of the SKU
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; The restrictions because of which SKU cannot be used
	Restrictions []interface{} `json:"restrictions,omitempty" azure:"ro"`

	// READ-ONLY; The tier of the SKU
	Tier *string `json:"tier,omitempty" azure:"ro"`
}

// SKUDescriptionList - The list of the EngagementFabric SKU descriptions
type SKUDescriptionList struct {
	// READ-ONLY; SKU descriptions
	Value []*SKUDescription `json:"value,omitempty" azure:"ro"`
}

// SKULocationInfoItem - The locations and zones info for SKU.
type SKULocationInfoItem struct {
	// REQUIRED; The available location of the SKU.
	Location *string `json:"location,omitempty"`

	// The available zone of the SKU.
	Zones []*string `json:"zones,omitempty"`
}

// Script - Class representing a database script.
type Script struct {
	// The database script.
	Properties *ScriptProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScriptCheckNameRequest - A script name availability request.
type ScriptCheckNameRequest struct {
	// REQUIRED; Script name.
	Name *string `json:"name,omitempty"`

	// CONSTANT; The type of resource, Microsoft.Kusto/clusters/databases/scripts.
	// Field has constant value "Microsoft.Kusto/clusters/databases/scripts", any specified value is ignored.
	Type *string `json:"type,omitempty"`
}

// ScriptListResult - The list Kusto database script operation response.
type ScriptListResult struct {
	// The list of Kusto scripts.
	Value []*Script `json:"value,omitempty"`
}

// ScriptProperties - A class representing database script property.
type ScriptProperties struct {
	// Flag that indicates whether to continue if one of the command fails.
	ContinueOnErrors *bool `json:"continueOnErrors,omitempty"`

	// A unique string. If changed the script will be applied again.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// The script content. This property should be used when the script is provide inline and not through file in a SA. Must not
	// be used together with scriptUrl and scriptUrlSasToken properties.
	ScriptContent *string `json:"scriptContent,omitempty"`

	// The url to the KQL script blob file. Must not be used together with scriptContent property
	ScriptURL *string `json:"scriptUrl,omitempty"`

	// The SaS token that provide read access to the file which contain the script. Must be provided when using scriptUrl property.
	ScriptURLSasToken *string `json:"scriptUrlSasToken,omitempty"`

	// READ-ONLY; The provisioned state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ScriptsClientBeginCreateOrUpdateOptions contains the optional parameters for the ScriptsClient.BeginCreateOrUpdate method.
type ScriptsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ScriptsClientBeginDeleteOptions contains the optional parameters for the ScriptsClient.BeginDelete method.
type ScriptsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ScriptsClientBeginUpdateOptions contains the optional parameters for the ScriptsClient.BeginUpdate method.
type ScriptsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ScriptsClientCheckNameAvailabilityOptions contains the optional parameters for the ScriptsClient.CheckNameAvailability
// method.
type ScriptsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ScriptsClientGetOptions contains the optional parameters for the ScriptsClient.Get method.
type ScriptsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ScriptsClientListByDatabaseOptions contains the optional parameters for the ScriptsClient.ListByDatabase method.
type ScriptsClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TableLevelSharingProperties - Tables that will be included and excluded in the follower database
type TableLevelSharingProperties struct {
	// List of external tables exclude from the follower database
	ExternalTablesToExclude []*string `json:"externalTablesToExclude,omitempty"`

	// List of external tables to include in the follower database
	ExternalTablesToInclude []*string `json:"externalTablesToInclude,omitempty"`

	// List of materialized views exclude from the follower database
	MaterializedViewsToExclude []*string `json:"materializedViewsToExclude,omitempty"`

	// List of materialized views to include in the follower database
	MaterializedViewsToInclude []*string `json:"materializedViewsToInclude,omitempty"`

	// List of tables to exclude from the follower database
	TablesToExclude []*string `json:"tablesToExclude,omitempty"`

	// List of tables to include in the follower database
	TablesToInclude []*string `json:"tablesToInclude,omitempty"`
}

// TrustedExternalTenant - Represents a tenant ID that is trusted by the cluster.
type TrustedExternalTenant struct {
	// GUID representing an external tenant.
	Value *string `json:"value,omitempty"`
}

// VirtualNetworkConfiguration - A class that contains virtual network definition.
type VirtualNetworkConfiguration struct {
	// REQUIRED; Data management's service public IP address resource id.
	DataManagementPublicIPID *string `json:"dataManagementPublicIpId,omitempty"`

	// REQUIRED; Engine service's public IP address resource id.
	EnginePublicIPID *string `json:"enginePublicIpId,omitempty"`

	// REQUIRED; The subnet resource id.
	SubnetID *string `json:"subnetId,omitempty"`
}
