//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdevhub

const (
	moduleName    = "armdevhub"
	moduleVersion = "v0.2.0"
)

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// ManifestType - Determines the type of manifests within the repository.
type ManifestType string

const (
	// ManifestTypeHelm - Repositories using helm
	ManifestTypeHelm ManifestType = "helm"
	// ManifestTypeKube - Repositories using kubernetes manifests
	ManifestTypeKube ManifestType = "kube"
)

// PossibleManifestTypeValues returns the possible values for the ManifestType const type.
func PossibleManifestTypeValues() []ManifestType {
	return []ManifestType{
		ManifestTypeHelm,
		ManifestTypeKube,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// PullRequestStatus - The status of the Pull Request submitted against the users repository.
type PullRequestStatus string

const (
	// PullRequestStatusMerged - Pull Request merged into repository.
	PullRequestStatusMerged PullRequestStatus = "merged"
	// PullRequestStatusRemoved - Workflow no longer found within repository.
	PullRequestStatusRemoved PullRequestStatus = "removed"
	// PullRequestStatusSubmitted - Pull Request submitted to repository.
	PullRequestStatusSubmitted PullRequestStatus = "submitted"
	// PullRequestStatusUnknown - Pull Request state unknown.
	PullRequestStatusUnknown PullRequestStatus = "unknown"
)

// PossiblePullRequestStatusValues returns the possible values for the PullRequestStatus const type.
func PossiblePullRequestStatusValues() []PullRequestStatus {
	return []PullRequestStatus{
		PullRequestStatusMerged,
		PullRequestStatusRemoved,
		PullRequestStatusSubmitted,
		PullRequestStatusUnknown,
	}
}
