//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcustomerinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// InteractionsClient contains the methods for the Interactions group.
// Don't use this type directly, use NewInteractionsClient() instead.
type InteractionsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewInteractionsClient creates a new instance of InteractionsClient with the specified values.
// subscriptionID - Gets subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID
// forms part of the URI for every service call.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewInteractionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*InteractionsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &InteractionsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Creates an interaction or updates an existing interaction within a hub.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
// resourceGroupName - The name of the resource group.
// hubName - The name of the hub.
// interactionName - The name of the interaction.
// parameters - Parameters supplied to the CreateOrUpdate Interaction operation.
// options - InteractionsClientBeginCreateOrUpdateOptions contains the optional parameters for the InteractionsClient.BeginCreateOrUpdate
// method.
func (client *InteractionsClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, hubName string, interactionName string, parameters InteractionResourceFormat, options *InteractionsClientBeginCreateOrUpdateOptions) (*runtime.Poller[InteractionsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, hubName, interactionName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[InteractionsClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[InteractionsClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Creates an interaction or updates an existing interaction within a hub.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
func (client *InteractionsClient) createOrUpdate(ctx context.Context, resourceGroupName string, hubName string, interactionName string, parameters InteractionResourceFormat, options *InteractionsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, hubName, interactionName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *InteractionsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, hubName string, interactionName string, parameters InteractionResourceFormat, options *InteractionsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/interactions/{interactionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if interactionName == "" {
		return nil, errors.New("parameter interactionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{interactionName}", url.PathEscape(interactionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// Get - Gets information about the specified interaction.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
// resourceGroupName - The name of the resource group.
// hubName - The name of the hub.
// interactionName - The name of the interaction.
// options - InteractionsClientGetOptions contains the optional parameters for the InteractionsClient.Get method.
func (client *InteractionsClient) Get(ctx context.Context, resourceGroupName string, hubName string, interactionName string, options *InteractionsClientGetOptions) (InteractionsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, hubName, interactionName, options)
	if err != nil {
		return InteractionsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return InteractionsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return InteractionsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *InteractionsClient) getCreateRequest(ctx context.Context, resourceGroupName string, hubName string, interactionName string, options *InteractionsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/interactions/{interactionName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if interactionName == "" {
		return nil, errors.New("parameter interactionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{interactionName}", url.PathEscape(interactionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.LocaleCode != nil {
		reqQP.Set("locale-code", *options.LocaleCode)
	}
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *InteractionsClient) getHandleResponse(resp *http.Response) (InteractionsClientGetResponse, error) {
	result := InteractionsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.InteractionResourceFormat); err != nil {
		return InteractionsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByHubPager - Gets all interactions in the hub.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
// resourceGroupName - The name of the resource group.
// hubName - The name of the hub.
// options - InteractionsClientListByHubOptions contains the optional parameters for the InteractionsClient.ListByHub method.
func (client *InteractionsClient) NewListByHubPager(resourceGroupName string, hubName string, options *InteractionsClientListByHubOptions) *runtime.Pager[InteractionsClientListByHubResponse] {
	return runtime.NewPager(runtime.PagingHandler[InteractionsClientListByHubResponse]{
		More: func(page InteractionsClientListByHubResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *InteractionsClientListByHubResponse) (InteractionsClientListByHubResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByHubCreateRequest(ctx, resourceGroupName, hubName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return InteractionsClientListByHubResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return InteractionsClientListByHubResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return InteractionsClientListByHubResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByHubHandleResponse(resp)
		},
	})
}

// listByHubCreateRequest creates the ListByHub request.
func (client *InteractionsClient) listByHubCreateRequest(ctx context.Context, resourceGroupName string, hubName string, options *InteractionsClientListByHubOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/interactions"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.LocaleCode != nil {
		reqQP.Set("locale-code", *options.LocaleCode)
	}
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByHubHandleResponse handles the ListByHub response.
func (client *InteractionsClient) listByHubHandleResponse(resp *http.Response) (InteractionsClientListByHubResponse, error) {
	result := InteractionsClientListByHubResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.InteractionListResult); err != nil {
		return InteractionsClientListByHubResponse{}, err
	}
	return result, nil
}

// SuggestRelationshipLinks - Suggests relationships to create relationship links.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
// resourceGroupName - The name of the resource group.
// hubName - The name of the hub.
// interactionName - The name of the interaction.
// options - InteractionsClientSuggestRelationshipLinksOptions contains the optional parameters for the InteractionsClient.SuggestRelationshipLinks
// method.
func (client *InteractionsClient) SuggestRelationshipLinks(ctx context.Context, resourceGroupName string, hubName string, interactionName string, options *InteractionsClientSuggestRelationshipLinksOptions) (InteractionsClientSuggestRelationshipLinksResponse, error) {
	req, err := client.suggestRelationshipLinksCreateRequest(ctx, resourceGroupName, hubName, interactionName, options)
	if err != nil {
		return InteractionsClientSuggestRelationshipLinksResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return InteractionsClientSuggestRelationshipLinksResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return InteractionsClientSuggestRelationshipLinksResponse{}, runtime.NewResponseError(resp)
	}
	return client.suggestRelationshipLinksHandleResponse(resp)
}

// suggestRelationshipLinksCreateRequest creates the SuggestRelationshipLinks request.
func (client *InteractionsClient) suggestRelationshipLinksCreateRequest(ctx context.Context, resourceGroupName string, hubName string, interactionName string, options *InteractionsClientSuggestRelationshipLinksOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/interactions/{interactionName}/suggestRelationshipLinks"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if interactionName == "" {
		return nil, errors.New("parameter interactionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{interactionName}", url.PathEscape(interactionName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// suggestRelationshipLinksHandleResponse handles the SuggestRelationshipLinks response.
func (client *InteractionsClient) suggestRelationshipLinksHandleResponse(resp *http.Response) (InteractionsClientSuggestRelationshipLinksResponse, error) {
	result := InteractionsClientSuggestRelationshipLinksResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SuggestRelationshipLinksResponse); err != nil {
		return InteractionsClientSuggestRelationshipLinksResponse{}, err
	}
	return result, nil
}
