//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapplicationinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ComponentLinkedStorageAccountsClient contains the methods for the ComponentLinkedStorageAccounts group.
// Don't use this type directly, use NewComponentLinkedStorageAccountsClient() instead.
type ComponentLinkedStorageAccountsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewComponentLinkedStorageAccountsClient creates a new instance of ComponentLinkedStorageAccountsClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewComponentLinkedStorageAccountsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ComponentLinkedStorageAccountsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ComponentLinkedStorageAccountsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateAndUpdate - Replace current linked storage account for an Application Insights component.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-03-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the Application Insights component resource.
// storageType - The type of the Application Insights component data source for the linked storage account.
// linkedStorageAccountsProperties - Properties that need to be specified to update linked storage accounts for an Application
// Insights component.
// options - ComponentLinkedStorageAccountsClientCreateAndUpdateOptions contains the optional parameters for the ComponentLinkedStorageAccountsClient.CreateAndUpdate
// method.
func (client *ComponentLinkedStorageAccountsClient) CreateAndUpdate(ctx context.Context, resourceGroupName string, resourceName string, storageType StorageType, linkedStorageAccountsProperties ComponentLinkedStorageAccounts, options *ComponentLinkedStorageAccountsClientCreateAndUpdateOptions) (ComponentLinkedStorageAccountsClientCreateAndUpdateResponse, error) {
	req, err := client.createAndUpdateCreateRequest(ctx, resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties, options)
	if err != nil {
		return ComponentLinkedStorageAccountsClientCreateAndUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ComponentLinkedStorageAccountsClientCreateAndUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ComponentLinkedStorageAccountsClientCreateAndUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createAndUpdateHandleResponse(resp)
}

// createAndUpdateCreateRequest creates the CreateAndUpdate request.
func (client *ComponentLinkedStorageAccountsClient) createAndUpdateCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, storageType StorageType, linkedStorageAccountsProperties ComponentLinkedStorageAccounts, options *ComponentLinkedStorageAccountsClientCreateAndUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/linkedStorageAccounts/{storageType}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if storageType == "" {
		return nil, errors.New("parameter storageType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{storageType}", url.PathEscape(string(storageType)))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, linkedStorageAccountsProperties)
}

// createAndUpdateHandleResponse handles the CreateAndUpdate response.
func (client *ComponentLinkedStorageAccountsClient) createAndUpdateHandleResponse(resp *http.Response) (ComponentLinkedStorageAccountsClientCreateAndUpdateResponse, error) {
	result := ComponentLinkedStorageAccountsClientCreateAndUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ComponentLinkedStorageAccounts); err != nil {
		return ComponentLinkedStorageAccountsClientCreateAndUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Delete linked storage accounts for an Application Insights component.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-03-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the Application Insights component resource.
// storageType - The type of the Application Insights component data source for the linked storage account.
// options - ComponentLinkedStorageAccountsClientDeleteOptions contains the optional parameters for the ComponentLinkedStorageAccountsClient.Delete
// method.
func (client *ComponentLinkedStorageAccountsClient) Delete(ctx context.Context, resourceGroupName string, resourceName string, storageType StorageType, options *ComponentLinkedStorageAccountsClientDeleteOptions) (ComponentLinkedStorageAccountsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, resourceName, storageType, options)
	if err != nil {
		return ComponentLinkedStorageAccountsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ComponentLinkedStorageAccountsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return ComponentLinkedStorageAccountsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return ComponentLinkedStorageAccountsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ComponentLinkedStorageAccountsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, storageType StorageType, options *ComponentLinkedStorageAccountsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/linkedStorageAccounts/{storageType}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if storageType == "" {
		return nil, errors.New("parameter storageType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{storageType}", url.PathEscape(string(storageType)))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Returns the current linked storage settings for an Application Insights component.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-03-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the Application Insights component resource.
// storageType - The type of the Application Insights component data source for the linked storage account.
// options - ComponentLinkedStorageAccountsClientGetOptions contains the optional parameters for the ComponentLinkedStorageAccountsClient.Get
// method.
func (client *ComponentLinkedStorageAccountsClient) Get(ctx context.Context, resourceGroupName string, resourceName string, storageType StorageType, options *ComponentLinkedStorageAccountsClientGetOptions) (ComponentLinkedStorageAccountsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, resourceName, storageType, options)
	if err != nil {
		return ComponentLinkedStorageAccountsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ComponentLinkedStorageAccountsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ComponentLinkedStorageAccountsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ComponentLinkedStorageAccountsClient) getCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, storageType StorageType, options *ComponentLinkedStorageAccountsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/linkedStorageAccounts/{storageType}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if storageType == "" {
		return nil, errors.New("parameter storageType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{storageType}", url.PathEscape(string(storageType)))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ComponentLinkedStorageAccountsClient) getHandleResponse(resp *http.Response) (ComponentLinkedStorageAccountsClientGetResponse, error) {
	result := ComponentLinkedStorageAccountsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ComponentLinkedStorageAccounts); err != nil {
		return ComponentLinkedStorageAccountsClientGetResponse{}, err
	}
	return result, nil
}

// Update - Update linked storage accounts for an Application Insights component.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-03-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the Application Insights component resource.
// storageType - The type of the Application Insights component data source for the linked storage account.
// linkedStorageAccountsProperties - Properties that need to be specified to update a linked storage accounts for an Application
// Insights component.
// options - ComponentLinkedStorageAccountsClientUpdateOptions contains the optional parameters for the ComponentLinkedStorageAccountsClient.Update
// method.
func (client *ComponentLinkedStorageAccountsClient) Update(ctx context.Context, resourceGroupName string, resourceName string, storageType StorageType, linkedStorageAccountsProperties ComponentLinkedStorageAccountsPatch, options *ComponentLinkedStorageAccountsClientUpdateOptions) (ComponentLinkedStorageAccountsClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties, options)
	if err != nil {
		return ComponentLinkedStorageAccountsClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ComponentLinkedStorageAccountsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ComponentLinkedStorageAccountsClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *ComponentLinkedStorageAccountsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, storageType StorageType, linkedStorageAccountsProperties ComponentLinkedStorageAccountsPatch, options *ComponentLinkedStorageAccountsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/linkedStorageAccounts/{storageType}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if storageType == "" {
		return nil, errors.New("parameter storageType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{storageType}", url.PathEscape(string(storageType)))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, linkedStorageAccountsProperties)
}

// updateHandleResponse handles the Update response.
func (client *ComponentLinkedStorageAccountsClient) updateHandleResponse(resp *http.Response) (ComponentLinkedStorageAccountsClientUpdateResponse, error) {
	result := ComponentLinkedStorageAccountsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ComponentLinkedStorageAccounts); err != nil {
		return ComponentLinkedStorageAccountsClientUpdateResponse{}, err
	}
	return result, nil
}
