//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armadvisor

import "time"

// ARMErrorResponseBody - ARM error response body.
type ARMErrorResponseBody struct {
	// Gets or sets the string that can be used to programmatically identify the error.
	Code *string `json:"code,omitempty"`

	// Gets or sets the string that describes the error in detail and provides debugging information.
	Message *string `json:"message,omitempty"`
}

type ArmErrorResponse struct {
	// ARM error response body.
	Error *ARMErrorResponseBody `json:"error,omitempty"`
}

// ConfigData - The Advisor configuration data structure.
type ConfigData struct {
	// The Advisor configuration data structure.
	Properties *ConfigDataProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConfigDataProperties - Configuration data properties
type ConfigDataProperties struct {
	// Advisor digest configuration. Valid only for subscriptions
	Digests []*DigestConfig `json:"digests,omitempty"`

	// Exclude the resource from Advisor evaluations. Valid values: False (default) or True.
	Exclude *bool `json:"exclude,omitempty"`

	// Minimum percentage threshold for Advisor low CPU utilization evaluation. Valid only for subscriptions. Valid values: 5
	// (default), 10, 15 or 20.
	LowCPUThreshold *CPUThreshold `json:"lowCpuThreshold,omitempty"`
}

// ConfigurationListResult - The list of Advisor configurations.
type ConfigurationListResult struct {
	// The link used to get the next page of configurations.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of configurations.
	Value []*ConfigData `json:"value,omitempty"`
}

// ConfigurationsClientCreateInResourceGroupOptions contains the optional parameters for the ConfigurationsClient.CreateInResourceGroup
// method.
type ConfigurationsClientCreateInResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationsClientCreateInSubscriptionOptions contains the optional parameters for the ConfigurationsClient.CreateInSubscription
// method.
type ConfigurationsClientCreateInSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationsClientListByResourceGroupOptions contains the optional parameters for the ConfigurationsClient.ListByResourceGroup
// method.
type ConfigurationsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationsClientListBySubscriptionOptions contains the optional parameters for the ConfigurationsClient.ListBySubscription
// method.
type ConfigurationsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// DigestConfig - Advisor Digest configuration entity
type DigestConfig struct {
	// Action group resource id used by digest.
	ActionGroupResourceID *string `json:"actionGroupResourceId,omitempty"`

	// Categories to send digest for. If categories are not provided, then digest will be sent for all categories.
	Categories []*Category `json:"categories,omitempty"`

	// Frequency that digest will be triggered, in days. Value must be between 7 and 30 days inclusive.
	Frequency *int32 `json:"frequency,omitempty"`

	// Language for digest content body. Value must be ISO 639-1 code for one of Azure portal supported languages. Otherwise,
	// it will be converted into one. Default value is English (en).
	Language *string `json:"language,omitempty"`

	// Name of digest configuration. Value is case-insensitive and must be unique within a subscription.
	Name *string `json:"name,omitempty"`

	// State of digest configuration.
	State *DigestConfigState `json:"state,omitempty"`
}

// MetadataEntity - The metadata entity contract.
type MetadataEntity struct {
	// The resource Id of the metadata entity.
	ID *string `json:"id,omitempty"`

	// The name of the metadata entity.
	Name *string `json:"name,omitempty"`

	// The metadata entity properties.
	Properties *MetadataEntityProperties `json:"properties,omitempty"`

	// The type of the metadata entity.
	Type *string `json:"type,omitempty"`
}

// MetadataEntityListResult - The list of metadata entities
type MetadataEntityListResult struct {
	// The link used to get the next page of metadata.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of metadata entities.
	Value []*MetadataEntity `json:"value,omitempty"`
}

// MetadataEntityProperties - The metadata entity properties
type MetadataEntityProperties struct {
	// The list of scenarios applicable to this metadata entity.
	ApplicableScenarios []*Scenario `json:"applicableScenarios,omitempty"`

	// The list of keys on which this entity depends on.
	DependsOn []*string `json:"dependsOn,omitempty"`

	// The display name.
	DisplayName *string `json:"displayName,omitempty"`

	// The list of supported values.
	SupportedValues []*MetadataSupportedValueDetail `json:"supportedValues,omitempty"`
}

// MetadataSupportedValueDetail - The metadata supported value detail.
type MetadataSupportedValueDetail struct {
	// The display name.
	DisplayName *string `json:"displayName,omitempty"`

	// The id.
	ID *string `json:"id,omitempty"`
}

// OperationDisplayInfo - The operation supported by Advisor.
type OperationDisplayInfo struct {
	// The description of the operation.
	Description *string `json:"description,omitempty"`

	// The action that users can perform, based on their permission level.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft Advisor.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationEntity - The operation supported by Advisor.
type OperationEntity struct {
	// The operation supported by Advisor.
	Display *OperationDisplayInfo `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
}

// OperationEntityListResult - The list of Advisor operations.
type OperationEntityListResult struct {
	// The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of operations.
	Value []*OperationEntity `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// RecommendationMetadataClientGetOptions contains the optional parameters for the RecommendationMetadataClient.Get method.
type RecommendationMetadataClientGetOptions struct {
	// placeholder for future optional parameters
}

// RecommendationMetadataClientListOptions contains the optional parameters for the RecommendationMetadataClient.List method.
type RecommendationMetadataClientListOptions struct {
	// placeholder for future optional parameters
}

// RecommendationProperties - The properties of the recommendation.
type RecommendationProperties struct {
	// The list of recommended actions to implement recommendation.
	Actions []map[string]interface{} `json:"actions,omitempty"`

	// The category of the recommendation.
	Category *Category `json:"category,omitempty"`

	// The detailed description of recommendation.
	Description *string `json:"description,omitempty"`

	// The recommendation metadata properties exposed to customer to provide additional information.
	ExposedMetadataProperties map[string]interface{} `json:"exposedMetadataProperties,omitempty"`

	// Extended properties
	ExtendedProperties map[string]*string `json:"extendedProperties,omitempty"`

	// The business impact of the recommendation.
	Impact *Impact `json:"impact,omitempty"`

	// The resource type identified by Advisor.
	ImpactedField *string `json:"impactedField,omitempty"`

	// The resource identified by Advisor.
	ImpactedValue *string `json:"impactedValue,omitempty"`

	// The label of recommendation.
	Label *string `json:"label,omitempty"`

	// The most recent time that Advisor checked the validity of the recommendation.
	LastUpdated *time.Time `json:"lastUpdated,omitempty"`

	// The link to learn more about recommendation and generation logic.
	LearnMoreLink *string `json:"learnMoreLink,omitempty"`

	// The recommendation metadata.
	Metadata map[string]interface{} `json:"metadata,omitempty"`

	// The potential benefit of implementing recommendation.
	PotentialBenefits *string `json:"potentialBenefits,omitempty"`

	// The recommendation-type GUID.
	RecommendationTypeID *string `json:"recommendationTypeId,omitempty"`

	// The automated way to apply recommendation.
	Remediation map[string]interface{} `json:"remediation,omitempty"`

	// Metadata of resource that was assessed
	ResourceMetadata *ResourceMetadata `json:"resourceMetadata,omitempty"`

	// The potential risk of not implementing the recommendation.
	Risk *Risk `json:"risk,omitempty"`

	// A summary of the recommendation.
	ShortDescription *ShortDescription `json:"shortDescription,omitempty"`

	// The list of snoozed and dismissed rules for the recommendation.
	SuppressionIDs []*string `json:"suppressionIds,omitempty"`
}

// RecommendationsClientGenerateOptions contains the optional parameters for the RecommendationsClient.Generate method.
type RecommendationsClientGenerateOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientGetGenerateStatusOptions contains the optional parameters for the RecommendationsClient.GetGenerateStatus
// method.
type RecommendationsClientGetGenerateStatusOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientGetOptions contains the optional parameters for the RecommendationsClient.Get method.
type RecommendationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientListOptions contains the optional parameters for the RecommendationsClient.List method.
type RecommendationsClientListOptions struct {
	// The filter to apply to the recommendations.
	// Filter can be applied to properties ['ResourceId', 'ResourceGroup', 'RecommendationTypeGuid', 'Category'] with operators
	// ['eq', 'and', 'or'].
	// Example:
	// - $filter=Category eq 'Cost' and ResourceGroup eq 'MyResourceGroup'
	Filter *string
	// The page-continuation token to use with a paged version of this API.
	SkipToken *string
	// The number of recommendations per page if a paged version of this API is being used.
	Top *int32
}

// Resource - An Azure resource.
type Resource struct {
	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceMetadata - Recommendation resource metadata
type ResourceMetadata struct {
	// The action to view resource.
	Action map[string]interface{} `json:"action,omitempty"`

	// The plural user friendly name of resource type. eg: virtual machines
	Plural *string `json:"plural,omitempty"`

	// Azure resource Id of the assessed resource
	ResourceID *string `json:"resourceId,omitempty"`

	// The singular user friendly name of resource type. eg: virtual machine
	Singular *string `json:"singular,omitempty"`

	// Source from which recommendation is generated
	Source *string `json:"source,omitempty"`
}

// ResourceRecommendationBase - Advisor Recommendation.
type ResourceRecommendationBase struct {
	// The properties of the recommendation.
	Properties *RecommendationProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceRecommendationBaseListResult - The list of Advisor recommendations.
type ResourceRecommendationBaseListResult struct {
	// The link used to get the next page of recommendations.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of recommendations.
	Value []*ResourceRecommendationBase `json:"value,omitempty"`
}

// ShortDescription - A summary of the recommendation.
type ShortDescription struct {
	// The issue or opportunity identified by the recommendation.
	Problem *string `json:"problem,omitempty"`

	// The remediation action suggested by the recommendation.
	Solution *string `json:"solution,omitempty"`
}

// SuppressionContract - The details of the snoozed or dismissed rule; for example, the duration, name, and GUID associated
// with the rule.
type SuppressionContract struct {
	// The properties of the suppression.
	Properties *SuppressionProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SuppressionContractListResult - The list of Advisor suppressions.
type SuppressionContractListResult struct {
	// The link used to get the next page of suppressions.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of suppressions.
	Value []*SuppressionContract `json:"value,omitempty"`
}

// SuppressionProperties - The properties of the suppression.
type SuppressionProperties struct {
	// The GUID of the suppression.
	SuppressionID *string `json:"suppressionId,omitempty"`

	// The duration for which the suppression is valid.
	TTL *string `json:"ttl,omitempty"`

	// READ-ONLY; Gets or sets the expiration time stamp.
	ExpirationTimeStamp *time.Time `json:"expirationTimeStamp,omitempty" azure:"ro"`
}

// SuppressionsClientCreateOptions contains the optional parameters for the SuppressionsClient.Create method.
type SuppressionsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// SuppressionsClientDeleteOptions contains the optional parameters for the SuppressionsClient.Delete method.
type SuppressionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SuppressionsClientGetOptions contains the optional parameters for the SuppressionsClient.Get method.
type SuppressionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SuppressionsClientListOptions contains the optional parameters for the SuppressionsClient.List method.
type SuppressionsClientListOptions struct {
	// The page-continuation token to use with a paged version of this API.
	SkipToken *string
	// The number of suppressions per page if a paged version of this API is being used.
	Top *int32
}
