// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The details of the Apache Kafka cluster to which the connector is connected.
type ApacheKafkaCluster struct {

	// The bootstrap servers of the cluster.
	//
	// This member is required.
	BootstrapServers *string

	// Details of an Amazon VPC which has network connectivity to the Apache Kafka
	// cluster.
	//
	// This member is required.
	Vpc *Vpc

	noSmithyDocumentSerde
}

// The description of the Apache Kafka cluster to which the connector is connected.
type ApacheKafkaClusterDescription struct {

	// The bootstrap servers of the cluster.
	BootstrapServers *string

	// Details of an Amazon VPC which has network connectivity to the Apache Kafka
	// cluster.
	Vpc *VpcDescription

	noSmithyDocumentSerde
}

// Specifies how the connector scales.
type AutoScaling struct {

	// The maximum number of workers allocated to the connector.
	//
	// This member is required.
	MaxWorkerCount int32

	// The number of microcontroller units (MCUs) allocated to each connector worker.
	// The valid values are 1,2,4,8.
	//
	// This member is required.
	McuCount int32

	// The minimum number of workers allocated to the connector.
	//
	// This member is required.
	MinWorkerCount int32

	// The sacle-in policy for the connector.
	ScaleInPolicy *ScaleInPolicy

	// The sacle-out policy for the connector.
	ScaleOutPolicy *ScaleOutPolicy

	noSmithyDocumentSerde
}

// Information about the auto scaling parameters for the connector.
type AutoScalingDescription struct {

	// The maximum number of workers allocated to the connector.
	MaxWorkerCount int32

	// The number of microcontroller units (MCUs) allocated to each connector worker.
	// The valid values are 1,2,4,8.
	McuCount int32

	// The minimum number of workers allocated to the connector.
	MinWorkerCount int32

	// The sacle-in policy for the connector.
	ScaleInPolicy *ScaleInPolicyDescription

	// The sacle-out policy for the connector.>
	ScaleOutPolicy *ScaleOutPolicyDescription

	noSmithyDocumentSerde
}

// The updates to the auto scaling parameters for the connector.
type AutoScalingUpdate struct {

	// The target maximum number of workers allocated to the connector.
	//
	// This member is required.
	MaxWorkerCount int32

	// The target number of microcontroller units (MCUs) allocated to each connector
	// worker. The valid values are 1,2,4,8.
	//
	// This member is required.
	McuCount int32

	// The target minimum number of workers allocated to the connector.
	//
	// This member is required.
	MinWorkerCount int32

	// The target sacle-in policy for the connector.
	//
	// This member is required.
	ScaleInPolicy *ScaleInPolicyUpdate

	// The target sacle-out policy for the connector.
	//
	// This member is required.
	ScaleOutPolicy *ScaleOutPolicyUpdate

	noSmithyDocumentSerde
}

// Information about the capacity of the connector, whether it is auto scaled or
// provisioned.
type Capacity struct {

	// Information about the auto scaling parameters for the connector.
	AutoScaling *AutoScaling

	// Details about a fixed capacity allocated to a connector.
	ProvisionedCapacity *ProvisionedCapacity

	noSmithyDocumentSerde
}

// A description of the connector's capacity.
type CapacityDescription struct {

	// Describes the connector's auto scaling capacity.
	AutoScaling *AutoScalingDescription

	// Describes a connector's provisioned capacity.
	ProvisionedCapacity *ProvisionedCapacityDescription

	noSmithyDocumentSerde
}

// The target capacity for the connector. The capacity can be auto scaled or
// provisioned.
type CapacityUpdate struct {

	// The target auto scaling setting.
	AutoScaling *AutoScalingUpdate

	// The target settings for provisioned capacity.
	ProvisionedCapacity *ProvisionedCapacityUpdate

	noSmithyDocumentSerde
}

// The settings for delivering connector logs to Amazon CloudWatch Logs.
type CloudWatchLogsLogDelivery struct {

	// Whether log delivery to Amazon CloudWatch Logs is enabled.
	//
	// This member is required.
	Enabled bool

	// The name of the CloudWatch log group that is the destination for log delivery.
	LogGroup *string

	noSmithyDocumentSerde
}

// A description of the log delivery settings.
type CloudWatchLogsLogDeliveryDescription struct {

	// Whether log delivery to Amazon CloudWatch Logs is enabled.
	Enabled bool

	// The name of the CloudWatch log group that is the destination for log delivery.
	LogGroup *string

	noSmithyDocumentSerde
}

// Summary of a connector.
type ConnectorSummary struct {

	// The connector's compute capacity settings.
	Capacity *CapacityDescription

	// The Amazon Resource Name (ARN) of the connector.
	ConnectorArn *string

	// The description of the connector.
	ConnectorDescription *string

	// The name of the connector.
	ConnectorName *string

	// The state of the connector.
	ConnectorState ConnectorState

	// The time that the connector was created.
	CreationTime *time.Time

	// The current version of the connector.
	CurrentVersion *string

	// The details of the Apache Kafka cluster to which the connector is connected.
	KafkaCluster *KafkaClusterDescription

	// The type of client authentication used to connect to the Apache Kafka cluster.
	// The value is NONE when no client authentication is used.
	KafkaClusterClientAuthentication *KafkaClusterClientAuthenticationDescription

	// Details of encryption in transit to the Apache Kafka cluster.
	KafkaClusterEncryptionInTransit *KafkaClusterEncryptionInTransitDescription

	// The version of Kafka Connect. It has to be compatible with both the Apache
	// Kafka cluster's version and the plugins.
	KafkaConnectVersion *string

	// The settings for delivering connector logs to Amazon CloudWatch Logs.
	LogDelivery *LogDeliveryDescription

	// Specifies which plugins were used for this connector.
	Plugins []PluginDescription

	// The Amazon Resource Name (ARN) of the IAM role used by the connector to access
	// Amazon Web Services resources.
	ServiceExecutionRoleArn *string

	// The worker configurations that are in use with the connector.
	WorkerConfiguration *WorkerConfigurationDescription

	noSmithyDocumentSerde
}

// A plugin is an Amazon Web Services resource that contains the code that defines
// a connector's logic.
type CustomPlugin struct {

	// The Amazon Resource Name (ARN) of the custom plugin.
	//
	// This member is required.
	CustomPluginArn *string

	// The revision of the custom plugin.
	//
	// This member is required.
	Revision int64

	noSmithyDocumentSerde
}

// Details about a custom plugin.
type CustomPluginDescription struct {

	// The Amazon Resource Name (ARN) of the custom plugin.
	CustomPluginArn *string

	// The revision of the custom plugin.
	Revision int64

	noSmithyDocumentSerde
}

// Details about a custom plugin file.
type CustomPluginFileDescription struct {

	// The hex-encoded MD5 checksum of the custom plugin file. You can use it to
	// validate the file.
	FileMd5 *string

	// The size in bytes of the custom plugin file. You can use it to validate the
	// file.
	FileSize int64

	noSmithyDocumentSerde
}

// Information about the location of a custom plugin.
type CustomPluginLocation struct {

	// The S3 bucket Amazon Resource Name (ARN), file key, and object version of the
	// plugin file stored in Amazon S3.
	//
	// This member is required.
	S3Location *S3Location

	noSmithyDocumentSerde
}

// Information about the location of a custom plugin.
type CustomPluginLocationDescription struct {

	// The S3 bucket Amazon Resource Name (ARN), file key, and object version of the
	// plugin file stored in Amazon S3.
	S3Location *S3LocationDescription

	noSmithyDocumentSerde
}

// Details about the revision of a custom plugin.
type CustomPluginRevisionSummary struct {

	// The format of the plugin file.
	ContentType CustomPluginContentType

	// The time that the custom plugin was created.
	CreationTime *time.Time

	// The description of the custom plugin.
	Description *string

	// Details about the custom plugin file.
	FileDescription *CustomPluginFileDescription

	// Information about the location of the custom plugin.
	Location *CustomPluginLocationDescription

	// The revision of the custom plugin.
	Revision int64

	noSmithyDocumentSerde
}

// A summary of the custom plugin.
type CustomPluginSummary struct {

	// The time that the custom plugin was created.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the custom plugin.
	CustomPluginArn *string

	// The state of the custom plugin.
	CustomPluginState CustomPluginState

	// A description of the custom plugin.
	Description *string

	// The latest revision of the custom plugin.
	LatestRevision *CustomPluginRevisionSummary

	// The name of the custom plugin.
	Name *string

	noSmithyDocumentSerde
}

// The settings for delivering logs to Amazon Kinesis Data Firehose.
type FirehoseLogDelivery struct {

	// Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
	//
	// This member is required.
	Enabled bool

	// The name of the Kinesis Data Firehose delivery stream that is the destination
	// for log delivery.
	DeliveryStream *string

	noSmithyDocumentSerde
}

// A description of the settings for delivering logs to Amazon Kinesis Data
// Firehose.
type FirehoseLogDeliveryDescription struct {

	// The name of the Kinesis Data Firehose delivery stream that is the destination
	// for log delivery.
	DeliveryStream *string

	// Specifies whether connector logs get delivered to Amazon Kinesis Data Firehose.
	Enabled bool

	noSmithyDocumentSerde
}

// The details of the Apache Kafka cluster to which the connector is connected.
type KafkaCluster struct {

	// The Apache Kafka cluster to which the connector is connected.
	//
	// This member is required.
	ApacheKafkaCluster *ApacheKafkaCluster

	noSmithyDocumentSerde
}

// The client authentication information used in order to authenticate with the
// Apache Kafka cluster.
type KafkaClusterClientAuthentication struct {

	// The type of client authentication used to connect to the Apache Kafka cluster.
	// Value NONE means that no client authentication is used.
	//
	// This member is required.
	AuthenticationType KafkaClusterClientAuthenticationType

	noSmithyDocumentSerde
}

// The client authentication information used in order to authenticate with the
// Apache Kafka cluster.
type KafkaClusterClientAuthenticationDescription struct {

	// The type of client authentication used to connect to the Apache Kafka cluster.
	// Value NONE means that no client authentication is used.
	AuthenticationType KafkaClusterClientAuthenticationType

	noSmithyDocumentSerde
}

// Details of how to connect to the Apache Kafka cluster.
type KafkaClusterDescription struct {

	// The Apache Kafka cluster to which the connector is connected.
	ApacheKafkaCluster *ApacheKafkaClusterDescription

	noSmithyDocumentSerde
}

// Details of encryption in transit to the Apache Kafka cluster.
type KafkaClusterEncryptionInTransit struct {

	// The type of encryption in transit to the Apache Kafka cluster.
	//
	// This member is required.
	EncryptionType KafkaClusterEncryptionInTransitType

	noSmithyDocumentSerde
}

// The description of the encryption in transit to the Apache Kafka cluster.
type KafkaClusterEncryptionInTransitDescription struct {

	// The type of encryption in transit to the Apache Kafka cluster.
	EncryptionType KafkaClusterEncryptionInTransitType

	noSmithyDocumentSerde
}

// Details about log delivery.
type LogDelivery struct {

	// The workers can send worker logs to different destination types. This
	// configuration specifies the details of these destinations.
	//
	// This member is required.
	WorkerLogDelivery *WorkerLogDelivery

	noSmithyDocumentSerde
}

// The description of the log delivery settings.
type LogDeliveryDescription struct {

	// The workers can send worker logs to different destination types. This
	// configuration specifies the details of these destinations.
	WorkerLogDelivery *WorkerLogDeliveryDescription

	noSmithyDocumentSerde
}

// A plugin is an Amazon Web Services resource that contains the code that defines
// your connector logic.
type Plugin struct {

	// Details about a custom plugin.
	//
	// This member is required.
	CustomPlugin *CustomPlugin

	noSmithyDocumentSerde
}

// The description of the plugin.
type PluginDescription struct {

	// Details about a custom plugin.
	CustomPlugin *CustomPluginDescription

	noSmithyDocumentSerde
}

// Details about a connector's provisioned capacity.
type ProvisionedCapacity struct {

	// The number of microcontroller units (MCUs) allocated to each connector worker.
	// The valid values are 1,2,4,8.
	//
	// This member is required.
	McuCount int32

	// The number of workers that are allocated to the connector.
	//
	// This member is required.
	WorkerCount int32

	noSmithyDocumentSerde
}

// The description of a connector's provisioned capacity.
type ProvisionedCapacityDescription struct {

	// The number of microcontroller units (MCUs) allocated to each connector worker.
	// The valid values are 1,2,4,8.
	McuCount int32

	// The number of workers that are allocated to the connector.
	WorkerCount int32

	noSmithyDocumentSerde
}

// An update to a connector's fixed capacity.
type ProvisionedCapacityUpdate struct {

	// The number of microcontroller units (MCUs) allocated to each connector worker.
	// The valid values are 1,2,4,8.
	//
	// This member is required.
	McuCount int32

	// The number of workers that are allocated to the connector.
	//
	// This member is required.
	WorkerCount int32

	noSmithyDocumentSerde
}

// The location of an object in Amazon S3.
type S3Location struct {

	// The Amazon Resource Name (ARN) of an S3 bucket.
	//
	// This member is required.
	BucketArn *string

	// The file key for an object in an S3 bucket.
	//
	// This member is required.
	FileKey *string

	// The version of an object in an S3 bucket.
	ObjectVersion *string

	noSmithyDocumentSerde
}

// The description of the location of an object in Amazon S3.
type S3LocationDescription struct {

	// The Amazon Resource Name (ARN) of an S3 bucket.
	BucketArn *string

	// The file key for an object in an S3 bucket.
	FileKey *string

	// The version of an object in an S3 bucket.
	ObjectVersion *string

	noSmithyDocumentSerde
}

// Details about delivering logs to Amazon S3.
type S3LogDelivery struct {

	// Specifies whether connector logs get sent to the specified Amazon S3
	// destination.
	//
	// This member is required.
	Enabled bool

	// The name of the S3 bucket that is the destination for log delivery.
	Bucket *string

	// The S3 prefix that is the destination for log delivery.
	Prefix *string

	noSmithyDocumentSerde
}

// The description of the details about delivering logs to Amazon S3.
type S3LogDeliveryDescription struct {

	// The name of the S3 bucket that is the destination for log delivery.
	Bucket *string

	// Specifies whether connector logs get sent to the specified Amazon S3
	// destination.
	Enabled bool

	// The S3 prefix that is the destination for log delivery.
	Prefix *string

	noSmithyDocumentSerde
}

// The scale-in policy for the connector.
type ScaleInPolicy struct {

	// Specifies the CPU utilization percentage threshold at which you want connector
	// scale in to be triggered.
	//
	// This member is required.
	CpuUtilizationPercentage int32

	noSmithyDocumentSerde
}

// The description of the scale-in policy for the connector.
type ScaleInPolicyDescription struct {

	// Specifies the CPU utilization percentage threshold at which you want connector
	// scale in to be triggered.
	CpuUtilizationPercentage int32

	noSmithyDocumentSerde
}

// An update to the connector's scale-in policy.
type ScaleInPolicyUpdate struct {

	// The target CPU utilization percentage threshold at which you want connector
	// scale in to be triggered.
	//
	// This member is required.
	CpuUtilizationPercentage int32

	noSmithyDocumentSerde
}

// The scale-out policy for the connector.
type ScaleOutPolicy struct {

	// The CPU utilization percentage threshold at which you want connector scale out
	// to be triggered.
	//
	// This member is required.
	CpuUtilizationPercentage int32

	noSmithyDocumentSerde
}

// The description of the scale-out policy for the connector.
type ScaleOutPolicyDescription struct {

	// The CPU utilization percentage threshold at which you want connector scale out
	// to be triggered.
	CpuUtilizationPercentage int32

	noSmithyDocumentSerde
}

// An update to the connector's scale-out policy.
type ScaleOutPolicyUpdate struct {

	// The target CPU utilization percentage threshold at which you want connector
	// scale out to be triggered.
	//
	// This member is required.
	CpuUtilizationPercentage int32

	noSmithyDocumentSerde
}

// Details about the state of a resource.
type StateDescription struct {

	// A code that describes the state of a resource.
	Code *string

	// A message that describes the state of a resource.
	Message *string

	noSmithyDocumentSerde
}

// Information about the VPC in which the connector resides.
type Vpc struct {

	// The subnets for the connector.
	//
	// This member is required.
	Subnets []string

	// The security groups for the connector.
	SecurityGroups []string

	noSmithyDocumentSerde
}

// The description of the VPC in which the connector resides.
type VpcDescription struct {

	// The security groups for the connector.
	SecurityGroups []string

	// The subnets for the connector.
	Subnets []string

	noSmithyDocumentSerde
}

// The configuration of the workers, which are the processes that run the
// connector logic.
type WorkerConfiguration struct {

	// The revision of the worker configuration.
	//
	// This member is required.
	Revision int64

	// The Amazon Resource Name (ARN) of the worker configuration.
	//
	// This member is required.
	WorkerConfigurationArn *string

	noSmithyDocumentSerde
}

// The description of the worker configuration.
type WorkerConfigurationDescription struct {

	// The revision of the worker configuration.
	Revision int64

	// The Amazon Resource Name (ARN) of the worker configuration.
	WorkerConfigurationArn *string

	noSmithyDocumentSerde
}

// The description of the worker configuration revision.
type WorkerConfigurationRevisionDescription struct {

	// The time that the worker configuration was created.
	CreationTime *time.Time

	// The description of the worker configuration revision.
	Description *string

	// Base64 encoded contents of the connect-distributed.properties file.
	PropertiesFileContent *string

	// The description of a revision of the worker configuration.
	Revision int64

	noSmithyDocumentSerde
}

// The summary of a worker configuration revision.
type WorkerConfigurationRevisionSummary struct {

	// The time that a worker configuration revision was created.
	CreationTime *time.Time

	// The description of a worker configuration revision.
	Description *string

	// The revision of a worker configuration.
	Revision int64

	noSmithyDocumentSerde
}

// The summary of a worker configuration.
type WorkerConfigurationSummary struct {

	// The time that a worker configuration was created.
	CreationTime *time.Time

	// The description of a worker configuration.
	Description *string

	// The latest revision of a worker configuration.
	LatestRevision *WorkerConfigurationRevisionSummary

	// The name of the worker configuration.
	Name *string

	// The Amazon Resource Name (ARN) of the worker configuration.
	WorkerConfigurationArn *string

	// The state of the worker configuration.
	WorkerConfigurationState WorkerConfigurationState

	noSmithyDocumentSerde
}

// Workers can send worker logs to different destination types. This configuration
// specifies the details of these destinations.
type WorkerLogDelivery struct {

	// Details about delivering logs to Amazon CloudWatch Logs.
	CloudWatchLogs *CloudWatchLogsLogDelivery

	// Details about delivering logs to Amazon Kinesis Data Firehose.
	Firehose *FirehoseLogDelivery

	// Details about delivering logs to Amazon S3.
	S3 *S3LogDelivery

	noSmithyDocumentSerde
}

// Workers can send worker logs to different destination types. This configuration
// specifies the details of these destinations.
type WorkerLogDeliveryDescription struct {

	// Details about delivering logs to Amazon CloudWatch Logs.
	CloudWatchLogs *CloudWatchLogsLogDeliveryDescription

	// Details about delivering logs to Amazon Kinesis Data Firehose.
	Firehose *FirehoseLogDeliveryDescription

	// Details about delivering logs to Amazon S3.
	S3 *S3LogDeliveryDescription

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
