//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple1200series

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertFilter.
func (a *AlertFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appearedOnTime":
			err = unpopulateTimeRFC3339(val, "AppearedOnTime", &a.AppearedOnTime)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &a.Severity)
			delete(rawMsg, key)
		case "sourceName":
			err = unpopulate(val, "SourceName", &a.SourceName)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &a.SourceType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertProperties.
func (a AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alertType", a.AlertType)
	populateTimeRFC3339(objectMap, "appearedAtSourceTime", a.AppearedAtSourceTime)
	populateTimeRFC3339(objectMap, "appearedAtTime", a.AppearedAtTime)
	populateTimeRFC3339(objectMap, "clearedAtSourceTime", a.ClearedAtSourceTime)
	populateTimeRFC3339(objectMap, "clearedAtTime", a.ClearedAtTime)
	populate(objectMap, "detailedInformation", a.DetailedInformation)
	populate(objectMap, "errorDetails", a.ErrorDetails)
	populate(objectMap, "recommendation", a.Recommendation)
	populate(objectMap, "resolutionReason", a.ResolutionReason)
	populate(objectMap, "scope", a.Scope)
	populate(objectMap, "severity", a.Severity)
	populate(objectMap, "source", a.Source)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "title", a.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertProperties.
func (a *AlertProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertType":
			err = unpopulate(val, "AlertType", &a.AlertType)
			delete(rawMsg, key)
		case "appearedAtSourceTime":
			err = unpopulateTimeRFC3339(val, "AppearedAtSourceTime", &a.AppearedAtSourceTime)
			delete(rawMsg, key)
		case "appearedAtTime":
			err = unpopulateTimeRFC3339(val, "AppearedAtTime", &a.AppearedAtTime)
			delete(rawMsg, key)
		case "clearedAtSourceTime":
			err = unpopulateTimeRFC3339(val, "ClearedAtSourceTime", &a.ClearedAtSourceTime)
			delete(rawMsg, key)
		case "clearedAtTime":
			err = unpopulateTimeRFC3339(val, "ClearedAtTime", &a.ClearedAtTime)
			delete(rawMsg, key)
		case "detailedInformation":
			err = unpopulate(val, "DetailedInformation", &a.DetailedInformation)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &a.ErrorDetails)
			delete(rawMsg, key)
		case "recommendation":
			err = unpopulate(val, "Recommendation", &a.Recommendation)
			delete(rawMsg, key)
		case "resolutionReason":
			err = unpopulate(val, "ResolutionReason", &a.ResolutionReason)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &a.Scope)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &a.Severity)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &a.Source)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertSettingsProperties.
func (a AlertSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalRecipientEmailList", a.AdditionalRecipientEmailList)
	populate(objectMap, "alertNotificationCulture", a.AlertNotificationCulture)
	populate(objectMap, "emailNotification", a.EmailNotification)
	populate(objectMap, "notificationToServiceOwners", a.NotificationToServiceOwners)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupFilter.
func (b *BackupFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &b.CreatedTime)
			delete(rawMsg, key)
		case "initiatedBy":
			err = unpopulate(val, "InitiatedBy", &b.InitiatedBy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupProperties.
func (b BackupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdTime", b.CreatedTime)
	populate(objectMap, "deviceId", b.DeviceID)
	populate(objectMap, "elements", b.Elements)
	populateTimeRFC3339(objectMap, "expirationTime", b.ExpirationTime)
	populate(objectMap, "initiatedBy", b.InitiatedBy)
	populate(objectMap, "sizeInBytes", b.SizeInBytes)
	populate(objectMap, "targetId", b.TargetID)
	populate(objectMap, "targetType", b.TargetType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupProperties.
func (b *BackupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdTime":
			err = unpopulateTimeRFC3339(val, "CreatedTime", &b.CreatedTime)
			delete(rawMsg, key)
		case "deviceId":
			err = unpopulate(val, "DeviceID", &b.DeviceID)
			delete(rawMsg, key)
		case "elements":
			err = unpopulate(val, "Elements", &b.Elements)
			delete(rawMsg, key)
		case "expirationTime":
			err = unpopulateTimeRFC3339(val, "ExpirationTime", &b.ExpirationTime)
			delete(rawMsg, key)
		case "initiatedBy":
			err = unpopulate(val, "InitiatedBy", &b.InitiatedBy)
			delete(rawMsg, key)
		case "sizeInBytes":
			err = unpopulate(val, "SizeInBytes", &b.SizeInBytes)
			delete(rawMsg, key)
		case "targetId":
			err = unpopulate(val, "TargetID", &b.TargetID)
			delete(rawMsg, key)
		case "targetType":
			err = unpopulate(val, "TargetType", &b.TargetType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClearAlertRequest.
func (c ClearAlertRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alerts", c.Alerts)
	populate(objectMap, "resolutionMessage", c.ResolutionMessage)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DevicePatch.
func (d DevicePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deviceDescription", d.DeviceDescription)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DeviceProperties.
func (d DeviceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "activationTime", d.ActivationTime)
	populate(objectMap, "allowedDeviceOperations", d.AllowedDeviceOperations)
	populate(objectMap, "culture", d.Culture)
	populate(objectMap, "details", d.Details)
	populate(objectMap, "deviceCapabilities", d.DeviceCapabilities)
	populate(objectMap, "deviceConfigurationStatus", d.DeviceConfigurationStatus)
	populate(objectMap, "deviceDescription", d.DeviceDescription)
	populate(objectMap, "deviceSoftwareVersion", d.DeviceSoftwareVersion)
	populate(objectMap, "domainName", d.DomainName)
	populate(objectMap, "friendlySoftwareName", d.FriendlySoftwareName)
	populate(objectMap, "modelDescription", d.ModelDescription)
	populate(objectMap, "status", d.Status)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceProperties.
func (d *DeviceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activationTime":
			err = unpopulateTimeRFC3339(val, "ActivationTime", &d.ActivationTime)
			delete(rawMsg, key)
		case "allowedDeviceOperations":
			err = unpopulate(val, "AllowedDeviceOperations", &d.AllowedDeviceOperations)
			delete(rawMsg, key)
		case "culture":
			err = unpopulate(val, "Culture", &d.Culture)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &d.Details)
			delete(rawMsg, key)
		case "deviceCapabilities":
			err = unpopulate(val, "DeviceCapabilities", &d.DeviceCapabilities)
			delete(rawMsg, key)
		case "deviceConfigurationStatus":
			err = unpopulate(val, "DeviceConfigurationStatus", &d.DeviceConfigurationStatus)
			delete(rawMsg, key)
		case "deviceDescription":
			err = unpopulate(val, "DeviceDescription", &d.DeviceDescription)
			delete(rawMsg, key)
		case "deviceSoftwareVersion":
			err = unpopulate(val, "DeviceSoftwareVersion", &d.DeviceSoftwareVersion)
			delete(rawMsg, key)
		case "domainName":
			err = unpopulate(val, "DomainName", &d.DomainName)
			delete(rawMsg, key)
		case "friendlySoftwareName":
			err = unpopulate(val, "FriendlySoftwareName", &d.FriendlySoftwareName)
			delete(rawMsg, key)
		case "modelDescription":
			err = unpopulate(val, "ModelDescription", &d.ModelDescription)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverRequest.
func (f FailoverRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accesspointIds", f.AccesspointIDs)
	populate(objectMap, "keepSourceDevice", f.KeepSourceDevice)
	populate(objectMap, "skipValidation", f.SkipValidation)
	populate(objectMap, "targetDeviceId", f.TargetDeviceID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ISCSIDiskProperties.
func (i ISCSIDiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "accessControlRecords", i.AccessControlRecords)
	populate(objectMap, "dataPolicy", i.DataPolicy)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "diskStatus", i.DiskStatus)
	populate(objectMap, "localUsedCapacityInBytes", i.LocalUsedCapacityInBytes)
	populate(objectMap, "monitoringStatus", i.MonitoringStatus)
	populate(objectMap, "provisionedCapacityInBytes", i.ProvisionedCapacityInBytes)
	populate(objectMap, "usedCapacityInBytes", i.UsedCapacityInBytes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "error", j.Error)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "percentComplete", j.PercentComplete)
	populate(objectMap, "properties", j.Properties)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "status", j.Status)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Job.
func (j *Job) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &j.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &j.PercentComplete)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobErrorDetails.
func (j JobErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", j.Code)
	populate(objectMap, "errorDetails", j.ErrorDetails)
	populate(objectMap, "message", j.Message)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JobErrorItem.
func (j JobErrorItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", j.Code)
	populate(objectMap, "message", j.Message)
	populate(objectMap, "recommendations", j.Recommendations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobFilter.
func (j *JobFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobType":
			err = unpopulate(val, "JobType", &j.JobType)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobProperties.
func (j JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "backupPointInTime", j.BackupPointInTime)
	populate(objectMap, "deviceId", j.DeviceID)
	populate(objectMap, "downloadProgress", j.DownloadProgress)
	populate(objectMap, "entityId", j.EntityID)
	populate(objectMap, "entityType", j.EntityType)
	populate(objectMap, "installProgress", j.InstallProgress)
	populate(objectMap, "isCancellable", j.IsCancellable)
	populate(objectMap, "jobStages", j.JobStages)
	populate(objectMap, "jobType", j.JobType)
	populate(objectMap, "sourceDeviceId", j.SourceDeviceID)
	populate(objectMap, "stats", j.Stats)
	populate(objectMap, "targetId", j.TargetID)
	populate(objectMap, "targetType", j.TargetType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobProperties.
func (j *JobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupPointInTime":
			err = unpopulateTimeRFC3339(val, "BackupPointInTime", &j.BackupPointInTime)
			delete(rawMsg, key)
		case "deviceId":
			err = unpopulate(val, "DeviceID", &j.DeviceID)
			delete(rawMsg, key)
		case "downloadProgress":
			err = unpopulate(val, "DownloadProgress", &j.DownloadProgress)
			delete(rawMsg, key)
		case "entityId":
			err = unpopulate(val, "EntityID", &j.EntityID)
			delete(rawMsg, key)
		case "entityType":
			err = unpopulate(val, "EntityType", &j.EntityType)
			delete(rawMsg, key)
		case "installProgress":
			err = unpopulate(val, "InstallProgress", &j.InstallProgress)
			delete(rawMsg, key)
		case "isCancellable":
			err = unpopulate(val, "IsCancellable", &j.IsCancellable)
			delete(rawMsg, key)
		case "jobStages":
			err = unpopulate(val, "JobStages", &j.JobStages)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &j.JobType)
			delete(rawMsg, key)
		case "sourceDeviceId":
			err = unpopulate(val, "SourceDeviceID", &j.SourceDeviceID)
			delete(rawMsg, key)
		case "stats":
			err = unpopulate(val, "Stats", &j.Stats)
			delete(rawMsg, key)
		case "targetId":
			err = unpopulate(val, "TargetID", &j.TargetID)
			delete(rawMsg, key)
		case "targetType":
			err = unpopulate(val, "TargetType", &j.TargetType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Manager.
func (m Manager) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagerExtendedInfo.
func (m ManagerExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ManagerPatch.
func (m ManagerPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricData.
func (m *MetricData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "average":
			err = unpopulate(val, "Average", &m.Average)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &m.Count)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &m.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &m.Minimum)
			delete(rawMsg, key)
		case "sum":
			err = unpopulate(val, "Sum", &m.Sum)
			delete(rawMsg, key)
		case "timeStamp":
			err = unpopulateTimeRFC3339(val, "TimeStamp", &m.TimeStamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricFilter.
func (m *MetricFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &m.EndTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &m.TimeGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Metrics.
func (m *Metrics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &m.EndTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "primaryAggregation":
			err = unpopulate(val, "PrimaryAggregation", &m.PrimaryAggregation)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &m.ResourceID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &m.TimeGrain)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &m.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkSettingsProperties.
func (n NetworkSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nodeNetworks", n.NodeNetworks)
	populate(objectMap, "primaryDnsServer", n.PrimaryDNSServer)
	populate(objectMap, "secondaryDnsServer", n.SecondaryDNSServer)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NodeNetwork.
func (n NodeNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "networkAdapters", n.NetworkAdapters)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ResourceCertificateAndAADDetails.
func (r ResourceCertificateAndAADDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aadAuthority", r.AADAuthority)
	populate(objectMap, "aadTenantId", r.AADTenantID)
	populate(objectMap, "authType", r.AuthType)
	populate(objectMap, "azureManagementEndpointAudience", r.AzureManagementEndpointAudience)
	populate(objectMap, "certificate", r.Certificate)
	populate(objectMap, "friendlyName", r.FriendlyName)
	populate(objectMap, "issuer", r.Issuer)
	populate(objectMap, "resourceId", r.ResourceID)
	populate(objectMap, "servicePrincipalClientId", r.ServicePrincipalClientID)
	populate(objectMap, "servicePrincipalObjectId", r.ServicePrincipalObjectID)
	populate(objectMap, "subject", r.Subject)
	populate(objectMap, "thumbprint", r.Thumbprint)
	populateTimeRFC3339(objectMap, "validFrom", r.ValidFrom)
	populateTimeRFC3339(objectMap, "validTo", r.ValidTo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceCertificateAndAADDetails.
func (r *ResourceCertificateAndAADDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadAuthority":
			err = unpopulate(val, "AADAuthority", &r.AADAuthority)
			delete(rawMsg, key)
		case "aadTenantId":
			err = unpopulate(val, "AADTenantID", &r.AADTenantID)
			delete(rawMsg, key)
		case "authType":
			err = unpopulate(val, "AuthType", &r.AuthType)
			delete(rawMsg, key)
		case "azureManagementEndpointAudience":
			err = unpopulate(val, "AzureManagementEndpointAudience", &r.AzureManagementEndpointAudience)
			delete(rawMsg, key)
		case "certificate":
			err = unpopulate(val, "Certificate", &r.Certificate)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "issuer":
			err = unpopulate(val, "Issuer", &r.Issuer)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &r.ResourceID)
			delete(rawMsg, key)
		case "servicePrincipalClientId":
			err = unpopulate(val, "ServicePrincipalClientID", &r.ServicePrincipalClientID)
			delete(rawMsg, key)
		case "servicePrincipalObjectId":
			err = unpopulate(val, "ServicePrincipalObjectID", &r.ServicePrincipalObjectID)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &r.Subject)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &r.Thumbprint)
			delete(rawMsg, key)
		case "validFrom":
			err = unpopulateTimeRFC3339(val, "ValidFrom", &r.ValidFrom)
			delete(rawMsg, key)
		case "validTo":
			err = unpopulateTimeRFC3339(val, "ValidTo", &r.ValidTo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SendTestAlertEmailRequest.
func (s SendTestAlertEmailRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "emailList", s.EmailList)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type StorageDomainProperties.
func (s StorageDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "encryptionKey", s.EncryptionKey)
	populate(objectMap, "encryptionStatus", s.EncryptionStatus)
	populate(objectMap, "storageAccountCredentialIds", s.StorageAccountCredentialIDs)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdatesProperties.
func (u UpdatesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "deviceLastScannedTime", u.DeviceLastScannedTime)
	populate(objectMap, "deviceVersion", u.DeviceVersion)
	populate(objectMap, "inProgressDownloadJobId", u.InProgressDownloadJobID)
	populateTimeRFC3339(objectMap, "inProgressDownloadJobStartedTime", u.InProgressDownloadJobStartedTime)
	populate(objectMap, "inProgressInstallJobId", u.InProgressInstallJobID)
	populateTimeRFC3339(objectMap, "inProgressInstallJobStartedTime", u.InProgressInstallJobStartedTime)
	populateTimeRFC3339(objectMap, "inProgressScanStartedTime", u.InProgressScanStartedTime)
	populateTimeRFC3339(objectMap, "lastCompletedDownloadJobTime", u.LastCompletedDownloadJobTime)
	populateTimeRFC3339(objectMap, "lastCompletedInstallJobTime", u.LastCompletedInstallJobTime)
	populateTimeRFC3339(objectMap, "lastCompletedScanTime", u.LastCompletedScanTime)
	populate(objectMap, "rebootRequiredForInstall", u.RebootRequiredForInstall)
	populate(objectMap, "regularUpdatesAvailable", u.RegularUpdatesAvailable)
	populate(objectMap, "status", u.Status)
	populate(objectMap, "totalItemsPendingForDownload", u.TotalItemsPendingForDownload)
	populate(objectMap, "totalItemsPendingForInstall", u.TotalItemsPendingForInstall)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdatesProperties.
func (u *UpdatesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceLastScannedTime":
			err = unpopulateTimeRFC3339(val, "DeviceLastScannedTime", &u.DeviceLastScannedTime)
			delete(rawMsg, key)
		case "deviceVersion":
			err = unpopulate(val, "DeviceVersion", &u.DeviceVersion)
			delete(rawMsg, key)
		case "inProgressDownloadJobId":
			err = unpopulate(val, "InProgressDownloadJobID", &u.InProgressDownloadJobID)
			delete(rawMsg, key)
		case "inProgressDownloadJobStartedTime":
			err = unpopulateTimeRFC3339(val, "InProgressDownloadJobStartedTime", &u.InProgressDownloadJobStartedTime)
			delete(rawMsg, key)
		case "inProgressInstallJobId":
			err = unpopulate(val, "InProgressInstallJobID", &u.InProgressInstallJobID)
			delete(rawMsg, key)
		case "inProgressInstallJobStartedTime":
			err = unpopulateTimeRFC3339(val, "InProgressInstallJobStartedTime", &u.InProgressInstallJobStartedTime)
			delete(rawMsg, key)
		case "inProgressScanStartedTime":
			err = unpopulateTimeRFC3339(val, "InProgressScanStartedTime", &u.InProgressScanStartedTime)
			delete(rawMsg, key)
		case "lastCompletedDownloadJobTime":
			err = unpopulateTimeRFC3339(val, "LastCompletedDownloadJobTime", &u.LastCompletedDownloadJobTime)
			delete(rawMsg, key)
		case "lastCompletedInstallJobTime":
			err = unpopulateTimeRFC3339(val, "LastCompletedInstallJobTime", &u.LastCompletedInstallJobTime)
			delete(rawMsg, key)
		case "lastCompletedScanTime":
			err = unpopulateTimeRFC3339(val, "LastCompletedScanTime", &u.LastCompletedScanTime)
			delete(rawMsg, key)
		case "rebootRequiredForInstall":
			err = unpopulate(val, "RebootRequiredForInstall", &u.RebootRequiredForInstall)
			delete(rawMsg, key)
		case "regularUpdatesAvailable":
			err = unpopulate(val, "RegularUpdatesAvailable", &u.RegularUpdatesAvailable)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &u.Status)
			delete(rawMsg, key)
		case "totalItemsPendingForDownload":
			err = unpopulate(val, "TotalItemsPendingForDownload", &u.TotalItemsPendingForDownload)
			delete(rawMsg, key)
		case "totalItemsPendingForInstall":
			err = unpopulate(val, "TotalItemsPendingForInstall", &u.TotalItemsPendingForInstall)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
