//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armeducation

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// LabsClient contains the methods for the Labs group.
// Don't use this type directly, use NewLabsClient() instead.
type LabsClient struct {
	host string
	pl   runtime.Pipeline
}

// NewLabsClient creates a new instance of LabsClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewLabsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*LabsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &LabsClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// CreateOrUpdate - Create a new lab or update a previously created lab.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// billingAccountName - Billing account name.
// billingProfileName - Billing profile name.
// invoiceSectionName - Invoice section name.
// parameters - Request parameters that are provided to create lab resource.
// options - LabsClientCreateOrUpdateOptions contains the optional parameters for the LabsClient.CreateOrUpdate method.
func (client *LabsClient) CreateOrUpdate(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, parameters LabDetails, options *LabsClientCreateOrUpdateOptions) (LabsClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, billingAccountName, billingProfileName, invoiceSectionName, parameters, options)
	if err != nil {
		return LabsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return LabsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return LabsClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *LabsClient) createOrUpdateCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, parameters LabDetails, options *LabsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	if invoiceSectionName == "" {
		return nil, errors.New("parameter invoiceSectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{invoiceSectionName}", url.PathEscape(invoiceSectionName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *LabsClient) createOrUpdateHandleResponse(resp *http.Response) (LabsClientCreateOrUpdateResponse, error) {
	result := LabsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.LabDetails); err != nil {
		return LabsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Delete a specific lab associated with the provided billing account name, billing profile name, and invoice section
// name. Note all students must be removed from the lab in order to delete the lab.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// billingAccountName - Billing account name.
// billingProfileName - Billing profile name.
// invoiceSectionName - Invoice section name.
// options - LabsClientDeleteOptions contains the optional parameters for the LabsClient.Delete method.
func (client *LabsClient) Delete(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, options *LabsClientDeleteOptions) (LabsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, billingAccountName, billingProfileName, invoiceSectionName, options)
	if err != nil {
		return LabsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return LabsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return LabsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return LabsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *LabsClient) deleteCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, options *LabsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	if invoiceSectionName == "" {
		return nil, errors.New("parameter invoiceSectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{invoiceSectionName}", url.PathEscape(invoiceSectionName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GenerateInviteCode - Generate invite code for a lab
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// billingAccountName - Billing account name.
// billingProfileName - Billing profile name.
// invoiceSectionName - Invoice section name.
// parameters - Request parameters that are provided to generate invite code.
// options - LabsClientGenerateInviteCodeOptions contains the optional parameters for the LabsClient.GenerateInviteCode method.
func (client *LabsClient) GenerateInviteCode(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, parameters InviteCodeGenerateRequest, options *LabsClientGenerateInviteCodeOptions) (LabsClientGenerateInviteCodeResponse, error) {
	req, err := client.generateInviteCodeCreateRequest(ctx, billingAccountName, billingProfileName, invoiceSectionName, parameters, options)
	if err != nil {
		return LabsClientGenerateInviteCodeResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return LabsClientGenerateInviteCodeResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return LabsClientGenerateInviteCodeResponse{}, runtime.NewResponseError(resp)
	}
	return client.generateInviteCodeHandleResponse(resp)
}

// generateInviteCodeCreateRequest creates the GenerateInviteCode request.
func (client *LabsClient) generateInviteCodeCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, parameters InviteCodeGenerateRequest, options *LabsClientGenerateInviteCodeOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default/generateInviteCode"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	if invoiceSectionName == "" {
		return nil, errors.New("parameter invoiceSectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{invoiceSectionName}", url.PathEscape(invoiceSectionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.OnlyUpdateStudentCountParameter != nil {
		reqQP.Set("onlyUpdateStudentCountParameter", strconv.FormatBool(*options.OnlyUpdateStudentCountParameter))
	}
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// generateInviteCodeHandleResponse handles the GenerateInviteCode response.
func (client *LabsClient) generateInviteCodeHandleResponse(resp *http.Response) (LabsClientGenerateInviteCodeResponse, error) {
	result := LabsClientGenerateInviteCodeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.LabDetails); err != nil {
		return LabsClientGenerateInviteCodeResponse{}, err
	}
	return result, nil
}

// Get - Get the details for a specific lab associated with the provided billing account name, billing profile name, and invoice
// section name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// billingAccountName - Billing account name.
// billingProfileName - Billing profile name.
// invoiceSectionName - Invoice section name.
// options - LabsClientGetOptions contains the optional parameters for the LabsClient.Get method.
func (client *LabsClient) Get(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, options *LabsClientGetOptions) (LabsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, billingAccountName, billingProfileName, invoiceSectionName, options)
	if err != nil {
		return LabsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return LabsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return LabsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *LabsClient) getCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, options *LabsClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	if invoiceSectionName == "" {
		return nil, errors.New("parameter invoiceSectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{invoiceSectionName}", url.PathEscape(invoiceSectionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.IncludeBudget != nil {
		reqQP.Set("includeBudget", strconv.FormatBool(*options.IncludeBudget))
	}
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *LabsClient) getHandleResponse(resp *http.Response) (LabsClientGetResponse, error) {
	result := LabsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.LabDetails); err != nil {
		return LabsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Get the details for a specific lab associated with the provided billing account name, billing profile name,
// and invoice section name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// billingAccountName - Billing account name.
// billingProfileName - Billing profile name.
// invoiceSectionName - Invoice section name.
// options - LabsClientListOptions contains the optional parameters for the LabsClient.List method.
func (client *LabsClient) NewListPager(billingAccountName string, billingProfileName string, invoiceSectionName string, options *LabsClientListOptions) *runtime.Pager[LabsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[LabsClientListResponse]{
		More: func(page LabsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *LabsClientListResponse) (LabsClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, billingAccountName, billingProfileName, invoiceSectionName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return LabsClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return LabsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return LabsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *LabsClient) listCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, options *LabsClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	if invoiceSectionName == "" {
		return nil, errors.New("parameter invoiceSectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{invoiceSectionName}", url.PathEscape(invoiceSectionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.IncludeBudget != nil {
		reqQP.Set("includeBudget", strconv.FormatBool(*options.IncludeBudget))
	}
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *LabsClient) listHandleResponse(resp *http.Response) (LabsClientListResponse, error) {
	result := LabsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.LabListResult); err != nil {
		return LabsClientListResponse{}, err
	}
	return result, nil
}

// NewListAllPager - Get a list of labs associated with the provided billing account name and billing profile name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01-preview
// billingAccountName - Billing account name.
// billingProfileName - Billing profile name.
// options - LabsClientListAllOptions contains the optional parameters for the LabsClient.ListAll method.
func (client *LabsClient) NewListAllPager(billingAccountName string, billingProfileName string, options *LabsClientListAllOptions) *runtime.Pager[LabsClientListAllResponse] {
	return runtime.NewPager(runtime.PagingHandler[LabsClientListAllResponse]{
		More: func(page LabsClientListAllResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *LabsClientListAllResponse) (LabsClientListAllResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listAllCreateRequest(ctx, billingAccountName, billingProfileName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return LabsClientListAllResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return LabsClientListAllResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return LabsClientListAllResponse{}, runtime.NewResponseError(resp)
			}
			return client.listAllHandleResponse(resp)
		},
	})
}

// listAllCreateRequest creates the ListAll request.
func (client *LabsClient) listAllCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, options *LabsClientListAllOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/providers/Microsoft.Education/labs"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.IncludeBudget != nil {
		reqQP.Set("includeBudget", strconv.FormatBool(*options.IncludeBudget))
	}
	if options != nil && options.IncludeDeleted != nil {
		reqQP.Set("includeDeleted", strconv.FormatBool(*options.IncludeDeleted))
	}
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAllHandleResponse handles the ListAll response.
func (client *LabsClient) listAllHandleResponse(resp *http.Response) (LabsClientListAllResponse, error) {
	result := LabsClientListAllResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.LabListResult); err != nil {
		return LabsClientListAllResponse{}, err
	}
	return result, nil
}
