// Code generated by smithy-go-codegen DO NOT EDIT.

package amp

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/amp/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The CreateScraper operation creates a scraper to collect metrics. A scraper
// pulls metrics from Prometheus-compatible sources within an Amazon EKS cluster,
// and sends them to your Amazon Managed Service for Prometheus workspace. You can
// configure the scraper to control what metrics are collected, and what
// transformations are applied prior to sending them to your workspace.
//
// If needed, an IAM role will be created for you that gives Amazon Managed
// Service for Prometheus access to the metrics in your cluster. For more
// information, see [Using roles for scraping metrics from EKS]in the Amazon Managed Service for Prometheus User Guide.
//
// You cannot update a scraper. If you want to change the configuration of the
// scraper, create a new scraper and delete the old one.
//
// The scrapeConfiguration parameter contains the base64-encoded version of the
// YAML configuration file.
//
// For more information about collectors, including what metrics are collected,
// and how to configure the scraper, see [Amazon Web Services managed collectors]in the Amazon Managed Service for
// Prometheus User Guide.
//
// [Amazon Web Services managed collectors]: https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector.html
// [Using roles for scraping metrics from EKS]: https://docs.aws.amazon.com/prometheus/latest/userguide/using-service-linked-roles.html#using-service-linked-roles-prom-scraper
func (c *Client) CreateScraper(ctx context.Context, params *CreateScraperInput, optFns ...func(*Options)) (*CreateScraperOutput, error) {
	if params == nil {
		params = &CreateScraperInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateScraper", params, optFns, c.addOperationCreateScraperMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateScraperOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a CreateScraper operation.
type CreateScraperInput struct {

	// The Amazon Managed Service for Prometheus workspace to send metrics to.
	//
	// This member is required.
	Destination types.Destination

	// The configuration file to use in the new scraper. For more information, see Scraper configuration in
	// the Amazon Managed Service for Prometheus User Guide.
	//
	// This member is required.
	ScrapeConfiguration types.ScrapeConfiguration

	// The Amazon EKS cluster from which the scraper will collect metrics.
	//
	// This member is required.
	Source types.Source

	// (optional) a name to associate with the scraper. This is for your use, and does
	// not need to be unique.
	Alias *string

	// (Optional) A unique, case-sensitive identifier that you can provide to ensure
	// the idempotency of the request.
	ClientToken *string

	// (Optional) The list of tag keys and values to associate with the scraper.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Represents the output of a CreateScraper operation.
type CreateScraperOutput struct {

	// The Amazon Resource Name (ARN) of the new scraper.
	//
	// This member is required.
	Arn *string

	// The ID of the new scraper.
	//
	// This member is required.
	ScraperId *string

	// A structure that displays the current status of the scraper.
	//
	// This member is required.
	Status *types.ScraperStatus

	// The list of tag keys and values that are associated with the scraper.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateScraperMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateScraper{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateScraper{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateScraper"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateScraperMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateScraperValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateScraper(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateScraper struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateScraper) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateScraper) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateScraperInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateScraperInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateScraperMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateScraper{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateScraper(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateScraper",
	}
}
