//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnotificationhubs

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type CheckAvailabilityParameters.
func (c CheckAvailabilityParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "isAvailiable", c.IsAvailiable)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CheckAvailabilityResult.
func (c CheckAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populate(objectMap, "isAvailiable", c.IsAvailiable)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DebugSendResponse.
func (d DebugSendResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NamespaceCreateOrUpdateParameters.
func (n NamespaceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "sku", n.SKU)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NamespacePatchParameters.
func (n NamespacePatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "sku", n.SKU)
	populate(objectMap, "tags", n.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NamespaceProperties.
func (n NamespaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", n.CreatedAt)
	populate(objectMap, "critical", n.Critical)
	populate(objectMap, "dataCenter", n.DataCenter)
	populate(objectMap, "enabled", n.Enabled)
	populate(objectMap, "metricId", n.MetricID)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "namespaceType", n.NamespaceType)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "region", n.Region)
	populate(objectMap, "scaleUnit", n.ScaleUnit)
	populate(objectMap, "serviceBusEndpoint", n.ServiceBusEndpoint)
	populate(objectMap, "status", n.Status)
	populate(objectMap, "subscriptionId", n.SubscriptionID)
	populateTimeRFC3339(objectMap, "updatedAt", n.UpdatedAt)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamespaceProperties.
func (n *NamespaceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &n.CreatedAt)
			delete(rawMsg, key)
		case "critical":
			err = unpopulate(val, "Critical", &n.Critical)
			delete(rawMsg, key)
		case "dataCenter":
			err = unpopulate(val, "DataCenter", &n.DataCenter)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &n.Enabled)
			delete(rawMsg, key)
		case "metricId":
			err = unpopulate(val, "MetricID", &n.MetricID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "namespaceType":
			err = unpopulate(val, "NamespaceType", &n.NamespaceType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &n.Region)
			delete(rawMsg, key)
		case "scaleUnit":
			err = unpopulate(val, "ScaleUnit", &n.ScaleUnit)
			delete(rawMsg, key)
		case "serviceBusEndpoint":
			err = unpopulate(val, "ServiceBusEndpoint", &n.ServiceBusEndpoint)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &n.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &n.SubscriptionID)
			delete(rawMsg, key)
		case "updatedAt":
			err = unpopulateTimeRFC3339(val, "UpdatedAt", &n.UpdatedAt)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamespaceResource.
func (n NamespaceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "sku", n.SKU)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NotificationHubCreateOrUpdateParameters.
func (n NotificationHubCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "sku", n.SKU)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NotificationHubPatchParameters.
func (n NotificationHubPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "sku", n.SKU)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NotificationHubProperties.
func (n NotificationHubProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "admCredential", n.AdmCredential)
	populate(objectMap, "apnsCredential", n.ApnsCredential)
	populate(objectMap, "authorizationRules", n.AuthorizationRules)
	populate(objectMap, "baiduCredential", n.BaiduCredential)
	populate(objectMap, "gcmCredential", n.GCMCredential)
	populate(objectMap, "mpnsCredential", n.MpnsCredential)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "registrationTtl", n.RegistrationTTL)
	populate(objectMap, "wnsCredential", n.WnsCredential)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NotificationHubResource.
func (n NotificationHubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "sku", n.SKU)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PnsCredentialsResource.
func (p PnsCredentialsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SharedAccessAuthorizationRuleProperties.
func (s SharedAccessAuthorizationRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "claimType", s.ClaimType)
	populate(objectMap, "claimValue", s.ClaimValue)
	populate(objectMap, "createdTime", s.CreatedTime)
	populate(objectMap, "keyName", s.KeyName)
	populate(objectMap, "modifiedTime", s.ModifiedTime)
	populate(objectMap, "primaryKey", s.PrimaryKey)
	populate(objectMap, "revision", s.Revision)
	populate(objectMap, "rights", s.Rights)
	populate(objectMap, "secondaryKey", s.SecondaryKey)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SharedAccessAuthorizationRuleResource.
func (s SharedAccessAuthorizationRuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
