//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatamigration

const (
	moduleName    = "armdatamigration"
	moduleVersion = "v1.0.0"
)

// AuthenticationType - An enumeration of possible authentication types when connecting
type AuthenticationType string

const (
	AuthenticationTypeActiveDirectoryIntegrated AuthenticationType = "ActiveDirectoryIntegrated"
	AuthenticationTypeActiveDirectoryPassword   AuthenticationType = "ActiveDirectoryPassword"
	AuthenticationTypeNone                      AuthenticationType = "None"
	AuthenticationTypeSQLAuthentication         AuthenticationType = "SqlAuthentication"
	AuthenticationTypeWindowsAuthentication     AuthenticationType = "WindowsAuthentication"
)

// PossibleAuthenticationTypeValues returns the possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{
		AuthenticationTypeActiveDirectoryIntegrated,
		AuthenticationTypeActiveDirectoryPassword,
		AuthenticationTypeNone,
		AuthenticationTypeSQLAuthentication,
		AuthenticationTypeWindowsAuthentication,
	}
}

// BackupFileStatus - An enumeration of Status of the log backup file.
type BackupFileStatus string

const (
	BackupFileStatusArrived   BackupFileStatus = "Arrived"
	BackupFileStatusCancelled BackupFileStatus = "Cancelled"
	BackupFileStatusQueued    BackupFileStatus = "Queued"
	BackupFileStatusRestored  BackupFileStatus = "Restored"
	BackupFileStatusRestoring BackupFileStatus = "Restoring"
	BackupFileStatusUploaded  BackupFileStatus = "Uploaded"
	BackupFileStatusUploading BackupFileStatus = "Uploading"
)

// PossibleBackupFileStatusValues returns the possible values for the BackupFileStatus const type.
func PossibleBackupFileStatusValues() []BackupFileStatus {
	return []BackupFileStatus{
		BackupFileStatusArrived,
		BackupFileStatusCancelled,
		BackupFileStatusQueued,
		BackupFileStatusRestored,
		BackupFileStatusRestoring,
		BackupFileStatusUploaded,
		BackupFileStatusUploading,
	}
}

// BackupMode - An enumeration of backup modes
type BackupMode string

const (
	BackupModeCreateBackup   BackupMode = "CreateBackup"
	BackupModeExistingBackup BackupMode = "ExistingBackup"
)

// PossibleBackupModeValues returns the possible values for the BackupMode const type.
func PossibleBackupModeValues() []BackupMode {
	return []BackupMode{
		BackupModeCreateBackup,
		BackupModeExistingBackup,
	}
}

// BackupType - Enum of the different backup types.
type BackupType string

const (
	BackupTypeDatabase             BackupType = "Database"
	BackupTypeDifferentialDatabase BackupType = "DifferentialDatabase"
	BackupTypeDifferentialFile     BackupType = "DifferentialFile"
	BackupTypeDifferentialPartial  BackupType = "DifferentialPartial"
	BackupTypeFile                 BackupType = "File"
	BackupTypePartial              BackupType = "Partial"
	BackupTypeTransactionLog       BackupType = "TransactionLog"
)

// PossibleBackupTypeValues returns the possible values for the BackupType const type.
func PossibleBackupTypeValues() []BackupType {
	return []BackupType{
		BackupTypeDatabase,
		BackupTypeDifferentialDatabase,
		BackupTypeDifferentialFile,
		BackupTypeDifferentialPartial,
		BackupTypeFile,
		BackupTypePartial,
		BackupTypeTransactionLog,
	}
}

// CommandState - The state of the command. This is ignored if submitted.
type CommandState string

const (
	CommandStateAccepted  CommandState = "Accepted"
	CommandStateFailed    CommandState = "Failed"
	CommandStateRunning   CommandState = "Running"
	CommandStateSucceeded CommandState = "Succeeded"
	CommandStateUnknown   CommandState = "Unknown"
)

// PossibleCommandStateValues returns the possible values for the CommandState const type.
func PossibleCommandStateValues() []CommandState {
	return []CommandState{
		CommandStateAccepted,
		CommandStateFailed,
		CommandStateRunning,
		CommandStateSucceeded,
		CommandStateUnknown,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DataMigrationResultCode - Result code of the data migration
type DataMigrationResultCode string

const (
	DataMigrationResultCodeCompleted                  DataMigrationResultCode = "Completed"
	DataMigrationResultCodeFatalError                 DataMigrationResultCode = "FatalError"
	DataMigrationResultCodeInitial                    DataMigrationResultCode = "Initial"
	DataMigrationResultCodeObjectNotExistsInSource    DataMigrationResultCode = "ObjectNotExistsInSource"
	DataMigrationResultCodeObjectNotExistsInTarget    DataMigrationResultCode = "ObjectNotExistsInTarget"
	DataMigrationResultCodeTargetObjectIsInaccessible DataMigrationResultCode = "TargetObjectIsInaccessible"
)

// PossibleDataMigrationResultCodeValues returns the possible values for the DataMigrationResultCode const type.
func PossibleDataMigrationResultCodeValues() []DataMigrationResultCode {
	return []DataMigrationResultCode{
		DataMigrationResultCodeCompleted,
		DataMigrationResultCodeFatalError,
		DataMigrationResultCodeInitial,
		DataMigrationResultCodeObjectNotExistsInSource,
		DataMigrationResultCodeObjectNotExistsInTarget,
		DataMigrationResultCodeTargetObjectIsInaccessible,
	}
}

// DatabaseCompatLevel - An enumeration of SQL Server database compatibility levels
type DatabaseCompatLevel string

const (
	DatabaseCompatLevelCompatLevel100 DatabaseCompatLevel = "CompatLevel100"
	DatabaseCompatLevelCompatLevel110 DatabaseCompatLevel = "CompatLevel110"
	DatabaseCompatLevelCompatLevel120 DatabaseCompatLevel = "CompatLevel120"
	DatabaseCompatLevelCompatLevel130 DatabaseCompatLevel = "CompatLevel130"
	DatabaseCompatLevelCompatLevel140 DatabaseCompatLevel = "CompatLevel140"
	DatabaseCompatLevelCompatLevel80  DatabaseCompatLevel = "CompatLevel80"
	DatabaseCompatLevelCompatLevel90  DatabaseCompatLevel = "CompatLevel90"
)

// PossibleDatabaseCompatLevelValues returns the possible values for the DatabaseCompatLevel const type.
func PossibleDatabaseCompatLevelValues() []DatabaseCompatLevel {
	return []DatabaseCompatLevel{
		DatabaseCompatLevelCompatLevel100,
		DatabaseCompatLevelCompatLevel110,
		DatabaseCompatLevelCompatLevel120,
		DatabaseCompatLevelCompatLevel130,
		DatabaseCompatLevelCompatLevel140,
		DatabaseCompatLevelCompatLevel80,
		DatabaseCompatLevelCompatLevel90,
	}
}

// DatabaseFileType - An enumeration of SQL Server database file types
type DatabaseFileType string

const (
	DatabaseFileTypeFilestream   DatabaseFileType = "Filestream"
	DatabaseFileTypeFulltext     DatabaseFileType = "Fulltext"
	DatabaseFileTypeLog          DatabaseFileType = "Log"
	DatabaseFileTypeNotSupported DatabaseFileType = "NotSupported"
	DatabaseFileTypeRows         DatabaseFileType = "Rows"
)

// PossibleDatabaseFileTypeValues returns the possible values for the DatabaseFileType const type.
func PossibleDatabaseFileTypeValues() []DatabaseFileType {
	return []DatabaseFileType{
		DatabaseFileTypeFilestream,
		DatabaseFileTypeFulltext,
		DatabaseFileTypeLog,
		DatabaseFileTypeNotSupported,
		DatabaseFileTypeRows,
	}
}

// DatabaseMigrationStage - Current stage of migration
type DatabaseMigrationStage string

const (
	DatabaseMigrationStageBackup     DatabaseMigrationStage = "Backup"
	DatabaseMigrationStageCompleted  DatabaseMigrationStage = "Completed"
	DatabaseMigrationStageFileCopy   DatabaseMigrationStage = "FileCopy"
	DatabaseMigrationStageInitialize DatabaseMigrationStage = "Initialize"
	DatabaseMigrationStageNone       DatabaseMigrationStage = "None"
	DatabaseMigrationStageRestore    DatabaseMigrationStage = "Restore"
)

// PossibleDatabaseMigrationStageValues returns the possible values for the DatabaseMigrationStage const type.
func PossibleDatabaseMigrationStageValues() []DatabaseMigrationStage {
	return []DatabaseMigrationStage{
		DatabaseMigrationStageBackup,
		DatabaseMigrationStageCompleted,
		DatabaseMigrationStageFileCopy,
		DatabaseMigrationStageInitialize,
		DatabaseMigrationStageNone,
		DatabaseMigrationStageRestore,
	}
}

// DatabaseMigrationState - Database level migration state.
type DatabaseMigrationState string

const (
	DatabaseMigrationStateCANCELLED             DatabaseMigrationState = "CANCELLED"
	DatabaseMigrationStateCOMPLETED             DatabaseMigrationState = "COMPLETED"
	DatabaseMigrationStateCUTOVERSTART          DatabaseMigrationState = "CUTOVER_START"
	DatabaseMigrationStateFAILED                DatabaseMigrationState = "FAILED"
	DatabaseMigrationStateFULLBACKUPUPLOADSTART DatabaseMigrationState = "FULL_BACKUP_UPLOAD_START"
	DatabaseMigrationStateINITIAL               DatabaseMigrationState = "INITIAL"
	DatabaseMigrationStateLOGSHIPPINGSTART      DatabaseMigrationState = "LOG_SHIPPING_START"
	DatabaseMigrationStatePOSTCUTOVERCOMPLETE   DatabaseMigrationState = "POST_CUTOVER_COMPLETE"
	DatabaseMigrationStateUNDEFINED             DatabaseMigrationState = "UNDEFINED"
	DatabaseMigrationStateUPLOADLOGFILESSTART   DatabaseMigrationState = "UPLOAD_LOG_FILES_START"
)

// PossibleDatabaseMigrationStateValues returns the possible values for the DatabaseMigrationState const type.
func PossibleDatabaseMigrationStateValues() []DatabaseMigrationState {
	return []DatabaseMigrationState{
		DatabaseMigrationStateCANCELLED,
		DatabaseMigrationStateCOMPLETED,
		DatabaseMigrationStateCUTOVERSTART,
		DatabaseMigrationStateFAILED,
		DatabaseMigrationStateFULLBACKUPUPLOADSTART,
		DatabaseMigrationStateINITIAL,
		DatabaseMigrationStateLOGSHIPPINGSTART,
		DatabaseMigrationStatePOSTCUTOVERCOMPLETE,
		DatabaseMigrationStateUNDEFINED,
		DatabaseMigrationStateUPLOADLOGFILESSTART,
	}
}

// DatabaseState - An enumeration of SQL Server Database states
type DatabaseState string

const (
	DatabaseStateCopying          DatabaseState = "Copying"
	DatabaseStateEmergency        DatabaseState = "Emergency"
	DatabaseStateOffline          DatabaseState = "Offline"
	DatabaseStateOfflineSecondary DatabaseState = "OfflineSecondary"
	DatabaseStateOnline           DatabaseState = "Online"
	DatabaseStateRecovering       DatabaseState = "Recovering"
	DatabaseStateRecoveryPending  DatabaseState = "RecoveryPending"
	DatabaseStateRestoring        DatabaseState = "Restoring"
	DatabaseStateSuspect          DatabaseState = "Suspect"
)

// PossibleDatabaseStateValues returns the possible values for the DatabaseState const type.
func PossibleDatabaseStateValues() []DatabaseState {
	return []DatabaseState{
		DatabaseStateCopying,
		DatabaseStateEmergency,
		DatabaseStateOffline,
		DatabaseStateOfflineSecondary,
		DatabaseStateOnline,
		DatabaseStateRecovering,
		DatabaseStateRecoveryPending,
		DatabaseStateRestoring,
		DatabaseStateSuspect,
	}
}

// ErrorType - Error type
type ErrorType string

const (
	ErrorTypeDefault ErrorType = "Default"
	ErrorTypeError   ErrorType = "Error"
	ErrorTypeWarning ErrorType = "Warning"
)

// PossibleErrorTypeValues returns the possible values for the ErrorType const type.
func PossibleErrorTypeValues() []ErrorType {
	return []ErrorType{
		ErrorTypeDefault,
		ErrorTypeError,
		ErrorTypeWarning,
	}
}

// LoginMigrationStage - Enum of the different stage of login migration.
type LoginMigrationStage string

const (
	LoginMigrationStageAssignRoleMembership       LoginMigrationStage = "AssignRoleMembership"
	LoginMigrationStageAssignRoleOwnership        LoginMigrationStage = "AssignRoleOwnership"
	LoginMigrationStageCompleted                  LoginMigrationStage = "Completed"
	LoginMigrationStageEstablishObjectPermissions LoginMigrationStage = "EstablishObjectPermissions"
	LoginMigrationStageEstablishServerPermissions LoginMigrationStage = "EstablishServerPermissions"
	LoginMigrationStageEstablishUserMapping       LoginMigrationStage = "EstablishUserMapping"
	LoginMigrationStageInitialize                 LoginMigrationStage = "Initialize"
	LoginMigrationStageLoginMigration             LoginMigrationStage = "LoginMigration"
	LoginMigrationStageNone                       LoginMigrationStage = "None"
)

// PossibleLoginMigrationStageValues returns the possible values for the LoginMigrationStage const type.
func PossibleLoginMigrationStageValues() []LoginMigrationStage {
	return []LoginMigrationStage{
		LoginMigrationStageAssignRoleMembership,
		LoginMigrationStageAssignRoleOwnership,
		LoginMigrationStageCompleted,
		LoginMigrationStageEstablishObjectPermissions,
		LoginMigrationStageEstablishServerPermissions,
		LoginMigrationStageEstablishUserMapping,
		LoginMigrationStageInitialize,
		LoginMigrationStageLoginMigration,
		LoginMigrationStageNone,
	}
}

// LoginType - Enum mapping of SMO LoginType.
type LoginType string

const (
	LoginTypeAsymmetricKey LoginType = "AsymmetricKey"
	LoginTypeCertificate   LoginType = "Certificate"
	LoginTypeExternalGroup LoginType = "ExternalGroup"
	LoginTypeExternalUser  LoginType = "ExternalUser"
	LoginTypeSQLLogin      LoginType = "SqlLogin"
	LoginTypeWindowsGroup  LoginType = "WindowsGroup"
	LoginTypeWindowsUser   LoginType = "WindowsUser"
)

// PossibleLoginTypeValues returns the possible values for the LoginType const type.
func PossibleLoginTypeValues() []LoginType {
	return []LoginType{
		LoginTypeAsymmetricKey,
		LoginTypeCertificate,
		LoginTypeExternalGroup,
		LoginTypeExternalUser,
		LoginTypeSQLLogin,
		LoginTypeWindowsGroup,
		LoginTypeWindowsUser,
	}
}

// MigrationState - Current state of migration
type MigrationState string

const (
	MigrationStateCompleted  MigrationState = "Completed"
	MigrationStateFailed     MigrationState = "Failed"
	MigrationStateInProgress MigrationState = "InProgress"
	MigrationStateNone       MigrationState = "None"
	MigrationStateSkipped    MigrationState = "Skipped"
	MigrationStateStopped    MigrationState = "Stopped"
	MigrationStateWarning    MigrationState = "Warning"
)

// PossibleMigrationStateValues returns the possible values for the MigrationState const type.
func PossibleMigrationStateValues() []MigrationState {
	return []MigrationState{
		MigrationStateCompleted,
		MigrationStateFailed,
		MigrationStateInProgress,
		MigrationStateNone,
		MigrationStateSkipped,
		MigrationStateStopped,
		MigrationStateWarning,
	}
}

// MigrationStatus - Current status of migration
type MigrationStatus string

const (
	MigrationStatusCompleted               MigrationStatus = "Completed"
	MigrationStatusCompletedWithWarnings   MigrationStatus = "CompletedWithWarnings"
	MigrationStatusConfigured              MigrationStatus = "Configured"
	MigrationStatusConnecting              MigrationStatus = "Connecting"
	MigrationStatusDefault                 MigrationStatus = "Default"
	MigrationStatusError                   MigrationStatus = "Error"
	MigrationStatusRunning                 MigrationStatus = "Running"
	MigrationStatusSelectLogins            MigrationStatus = "SelectLogins"
	MigrationStatusSourceAndTargetSelected MigrationStatus = "SourceAndTargetSelected"
	MigrationStatusStopped                 MigrationStatus = "Stopped"
)

// PossibleMigrationStatusValues returns the possible values for the MigrationStatus const type.
func PossibleMigrationStatusValues() []MigrationStatus {
	return []MigrationStatus{
		MigrationStatusCompleted,
		MigrationStatusCompletedWithWarnings,
		MigrationStatusConfigured,
		MigrationStatusConnecting,
		MigrationStatusDefault,
		MigrationStatusError,
		MigrationStatusRunning,
		MigrationStatusSelectLogins,
		MigrationStatusSourceAndTargetSelected,
		MigrationStatusStopped,
	}
}

// MongoDbClusterType - The type of data source
type MongoDbClusterType string

const (
	MongoDbClusterTypeBlobContainer MongoDbClusterType = "BlobContainer"
	MongoDbClusterTypeCosmosDb      MongoDbClusterType = "CosmosDb"
	MongoDbClusterTypeMongoDb       MongoDbClusterType = "MongoDb"
)

// PossibleMongoDbClusterTypeValues returns the possible values for the MongoDbClusterType const type.
func PossibleMongoDbClusterTypeValues() []MongoDbClusterType {
	return []MongoDbClusterType{
		MongoDbClusterTypeBlobContainer,
		MongoDbClusterTypeCosmosDb,
		MongoDbClusterTypeMongoDb,
	}
}

// MongoDbErrorType - The type of error or warning
type MongoDbErrorType string

const (
	MongoDbErrorTypeError           MongoDbErrorType = "Error"
	MongoDbErrorTypeValidationError MongoDbErrorType = "ValidationError"
	MongoDbErrorTypeWarning         MongoDbErrorType = "Warning"
)

// PossibleMongoDbErrorTypeValues returns the possible values for the MongoDbErrorType const type.
func PossibleMongoDbErrorTypeValues() []MongoDbErrorType {
	return []MongoDbErrorType{
		MongoDbErrorTypeError,
		MongoDbErrorTypeValidationError,
		MongoDbErrorTypeWarning,
	}
}

type MongoDbMigrationState string

const (
	MongoDbMigrationStateCanceled        MongoDbMigrationState = "Canceled"
	MongoDbMigrationStateComplete        MongoDbMigrationState = "Complete"
	MongoDbMigrationStateCopying         MongoDbMigrationState = "Copying"
	MongoDbMigrationStateFailed          MongoDbMigrationState = "Failed"
	MongoDbMigrationStateFinalizing      MongoDbMigrationState = "Finalizing"
	MongoDbMigrationStateInitialReplay   MongoDbMigrationState = "InitialReplay"
	MongoDbMigrationStateInitializing    MongoDbMigrationState = "Initializing"
	MongoDbMigrationStateNotStarted      MongoDbMigrationState = "NotStarted"
	MongoDbMigrationStateReplaying       MongoDbMigrationState = "Replaying"
	MongoDbMigrationStateRestarting      MongoDbMigrationState = "Restarting"
	MongoDbMigrationStateValidatingInput MongoDbMigrationState = "ValidatingInput"
)

// PossibleMongoDbMigrationStateValues returns the possible values for the MongoDbMigrationState const type.
func PossibleMongoDbMigrationStateValues() []MongoDbMigrationState {
	return []MongoDbMigrationState{
		MongoDbMigrationStateCanceled,
		MongoDbMigrationStateComplete,
		MongoDbMigrationStateCopying,
		MongoDbMigrationStateFailed,
		MongoDbMigrationStateFinalizing,
		MongoDbMigrationStateInitialReplay,
		MongoDbMigrationStateInitializing,
		MongoDbMigrationStateNotStarted,
		MongoDbMigrationStateReplaying,
		MongoDbMigrationStateRestarting,
		MongoDbMigrationStateValidatingInput,
	}
}

// MongoDbProgressResultType - The type of progress object
type MongoDbProgressResultType string

const (
	MongoDbProgressResultTypeCollection MongoDbProgressResultType = "Collection"
	MongoDbProgressResultTypeDatabase   MongoDbProgressResultType = "Database"
	MongoDbProgressResultTypeMigration  MongoDbProgressResultType = "Migration"
)

// PossibleMongoDbProgressResultTypeValues returns the possible values for the MongoDbProgressResultType const type.
func PossibleMongoDbProgressResultTypeValues() []MongoDbProgressResultType {
	return []MongoDbProgressResultType{
		MongoDbProgressResultTypeCollection,
		MongoDbProgressResultTypeDatabase,
		MongoDbProgressResultTypeMigration,
	}
}

// MongoDbReplication - Describes how changes will be replicated from the source to the target. The default is OneTime.
type MongoDbReplication string

const (
	MongoDbReplicationContinuous MongoDbReplication = "Continuous"
	MongoDbReplicationDisabled   MongoDbReplication = "Disabled"
	MongoDbReplicationOneTime    MongoDbReplication = "OneTime"
)

// PossibleMongoDbReplicationValues returns the possible values for the MongoDbReplication const type.
func PossibleMongoDbReplicationValues() []MongoDbReplication {
	return []MongoDbReplication{
		MongoDbReplicationContinuous,
		MongoDbReplicationDisabled,
		MongoDbReplicationOneTime,
	}
}

// MongoDbShardKeyOrder - The field ordering
type MongoDbShardKeyOrder string

const (
	MongoDbShardKeyOrderForward MongoDbShardKeyOrder = "Forward"
	MongoDbShardKeyOrderHashed  MongoDbShardKeyOrder = "Hashed"
	MongoDbShardKeyOrderReverse MongoDbShardKeyOrder = "Reverse"
)

// PossibleMongoDbShardKeyOrderValues returns the possible values for the MongoDbShardKeyOrder const type.
func PossibleMongoDbShardKeyOrderValues() []MongoDbShardKeyOrder {
	return []MongoDbShardKeyOrder{
		MongoDbShardKeyOrderForward,
		MongoDbShardKeyOrderHashed,
		MongoDbShardKeyOrderReverse,
	}
}

// MySQLTargetPlatformType - An enumeration of possible target types when migrating from MySQL
type MySQLTargetPlatformType string

const (
	MySQLTargetPlatformTypeAzureDbForMySQL MySQLTargetPlatformType = "AzureDbForMySQL"
	MySQLTargetPlatformTypeSQLServer       MySQLTargetPlatformType = "SqlServer"
)

// PossibleMySQLTargetPlatformTypeValues returns the possible values for the MySQLTargetPlatformType const type.
func PossibleMySQLTargetPlatformTypeValues() []MySQLTargetPlatformType {
	return []MySQLTargetPlatformType{
		MySQLTargetPlatformTypeAzureDbForMySQL,
		MySQLTargetPlatformTypeSQLServer,
	}
}

// NameCheckFailureReason - The reason why the name is not available, if nameAvailable is false
type NameCheckFailureReason string

const (
	NameCheckFailureReasonAlreadyExists NameCheckFailureReason = "AlreadyExists"
	NameCheckFailureReasonInvalid       NameCheckFailureReason = "Invalid"
)

// PossibleNameCheckFailureReasonValues returns the possible values for the NameCheckFailureReason const type.
func PossibleNameCheckFailureReasonValues() []NameCheckFailureReason {
	return []NameCheckFailureReason{
		NameCheckFailureReasonAlreadyExists,
		NameCheckFailureReasonInvalid,
	}
}

// ObjectType - An enumeration of type of objects
type ObjectType string

const (
	ObjectTypeFunction         ObjectType = "Function"
	ObjectTypeStoredProcedures ObjectType = "StoredProcedures"
	ObjectTypeTable            ObjectType = "Table"
	ObjectTypeUser             ObjectType = "User"
	ObjectTypeView             ObjectType = "View"
)

// PossibleObjectTypeValues returns the possible values for the ObjectType const type.
func PossibleObjectTypeValues() []ObjectType {
	return []ObjectType{
		ObjectTypeFunction,
		ObjectTypeStoredProcedures,
		ObjectTypeTable,
		ObjectTypeUser,
		ObjectTypeView,
	}
}

// ProjectProvisioningState - The project's provisioning state
type ProjectProvisioningState string

const (
	ProjectProvisioningStateDeleting  ProjectProvisioningState = "Deleting"
	ProjectProvisioningStateSucceeded ProjectProvisioningState = "Succeeded"
)

// PossibleProjectProvisioningStateValues returns the possible values for the ProjectProvisioningState const type.
func PossibleProjectProvisioningStateValues() []ProjectProvisioningState {
	return []ProjectProvisioningState{
		ProjectProvisioningStateDeleting,
		ProjectProvisioningStateSucceeded,
	}
}

// ProjectSourcePlatform - Source platform of the project
type ProjectSourcePlatform string

const (
	ProjectSourcePlatformMongoDb    ProjectSourcePlatform = "MongoDb"
	ProjectSourcePlatformMySQL      ProjectSourcePlatform = "MySQL"
	ProjectSourcePlatformPostgreSQL ProjectSourcePlatform = "PostgreSql"
	ProjectSourcePlatformSQL        ProjectSourcePlatform = "SQL"
	ProjectSourcePlatformUnknown    ProjectSourcePlatform = "Unknown"
)

// PossibleProjectSourcePlatformValues returns the possible values for the ProjectSourcePlatform const type.
func PossibleProjectSourcePlatformValues() []ProjectSourcePlatform {
	return []ProjectSourcePlatform{
		ProjectSourcePlatformMongoDb,
		ProjectSourcePlatformMySQL,
		ProjectSourcePlatformPostgreSQL,
		ProjectSourcePlatformSQL,
		ProjectSourcePlatformUnknown,
	}
}

// ProjectTargetPlatform - Target platform of the project
type ProjectTargetPlatform string

const (
	ProjectTargetPlatformAzureDbForMySQL      ProjectTargetPlatform = "AzureDbForMySql"
	ProjectTargetPlatformAzureDbForPostgreSQL ProjectTargetPlatform = "AzureDbForPostgreSql"
	ProjectTargetPlatformMongoDb              ProjectTargetPlatform = "MongoDb"
	ProjectTargetPlatformSQLDB                ProjectTargetPlatform = "SQLDB"
	ProjectTargetPlatformSQLMI                ProjectTargetPlatform = "SQLMI"
	ProjectTargetPlatformUnknown              ProjectTargetPlatform = "Unknown"
)

// PossibleProjectTargetPlatformValues returns the possible values for the ProjectTargetPlatform const type.
func PossibleProjectTargetPlatformValues() []ProjectTargetPlatform {
	return []ProjectTargetPlatform{
		ProjectTargetPlatformAzureDbForMySQL,
		ProjectTargetPlatformAzureDbForPostgreSQL,
		ProjectTargetPlatformMongoDb,
		ProjectTargetPlatformSQLDB,
		ProjectTargetPlatformSQLMI,
		ProjectTargetPlatformUnknown,
	}
}

// ReplicateMigrationState - Wrapper for replicate reported migration states.
type ReplicateMigrationState string

const (
	ReplicateMigrationStateACTIONREQUIRED ReplicateMigrationState = "ACTION_REQUIRED"
	ReplicateMigrationStateCOMPLETE       ReplicateMigrationState = "COMPLETE"
	ReplicateMigrationStateFAILED         ReplicateMigrationState = "FAILED"
	ReplicateMigrationStatePENDING        ReplicateMigrationState = "PENDING"
	ReplicateMigrationStateUNDEFINED      ReplicateMigrationState = "UNDEFINED"
	ReplicateMigrationStateVALIDATING     ReplicateMigrationState = "VALIDATING"
)

// PossibleReplicateMigrationStateValues returns the possible values for the ReplicateMigrationState const type.
func PossibleReplicateMigrationStateValues() []ReplicateMigrationState {
	return []ReplicateMigrationState{
		ReplicateMigrationStateACTIONREQUIRED,
		ReplicateMigrationStateCOMPLETE,
		ReplicateMigrationStateFAILED,
		ReplicateMigrationStatePENDING,
		ReplicateMigrationStateUNDEFINED,
		ReplicateMigrationStateVALIDATING,
	}
}

// ResourceSKUCapacityScaleType - The scale type applicable to the SKU.
type ResourceSKUCapacityScaleType string

const (
	ResourceSKUCapacityScaleTypeAutomatic ResourceSKUCapacityScaleType = "Automatic"
	ResourceSKUCapacityScaleTypeManual    ResourceSKUCapacityScaleType = "Manual"
	ResourceSKUCapacityScaleTypeNone      ResourceSKUCapacityScaleType = "None"
)

// PossibleResourceSKUCapacityScaleTypeValues returns the possible values for the ResourceSKUCapacityScaleType const type.
func PossibleResourceSKUCapacityScaleTypeValues() []ResourceSKUCapacityScaleType {
	return []ResourceSKUCapacityScaleType{
		ResourceSKUCapacityScaleTypeAutomatic,
		ResourceSKUCapacityScaleTypeManual,
		ResourceSKUCapacityScaleTypeNone,
	}
}

// ResourceSKURestrictionsReasonCode - The reason code for restriction.
type ResourceSKURestrictionsReasonCode string

const (
	ResourceSKURestrictionsReasonCodeNotAvailableForSubscription ResourceSKURestrictionsReasonCode = "NotAvailableForSubscription"
	ResourceSKURestrictionsReasonCodeQuotaID                     ResourceSKURestrictionsReasonCode = "QuotaId"
)

// PossibleResourceSKURestrictionsReasonCodeValues returns the possible values for the ResourceSKURestrictionsReasonCode const type.
func PossibleResourceSKURestrictionsReasonCodeValues() []ResourceSKURestrictionsReasonCode {
	return []ResourceSKURestrictionsReasonCode{
		ResourceSKURestrictionsReasonCodeNotAvailableForSubscription,
		ResourceSKURestrictionsReasonCodeQuotaID,
	}
}

// ResourceSKURestrictionsType - The type of restrictions.
type ResourceSKURestrictionsType string

const (
	ResourceSKURestrictionsTypeLocation ResourceSKURestrictionsType = "location"
)

// PossibleResourceSKURestrictionsTypeValues returns the possible values for the ResourceSKURestrictionsType const type.
func PossibleResourceSKURestrictionsTypeValues() []ResourceSKURestrictionsType {
	return []ResourceSKURestrictionsType{
		ResourceSKURestrictionsTypeLocation,
	}
}

// SQLSourcePlatform - An enumeration of source platform types
type SQLSourcePlatform string

const (
	SQLSourcePlatformSQLOnPrem SQLSourcePlatform = "SqlOnPrem"
)

// PossibleSQLSourcePlatformValues returns the possible values for the SQLSourcePlatform const type.
func PossibleSQLSourcePlatformValues() []SQLSourcePlatform {
	return []SQLSourcePlatform{
		SQLSourcePlatformSQLOnPrem,
	}
}

// ScenarioSource - An enumeration of source type
type ScenarioSource string

const (
	ScenarioSourceAccess        ScenarioSource = "Access"
	ScenarioSourceDB2           ScenarioSource = "DB2"
	ScenarioSourceMongoDB       ScenarioSource = "MongoDB"
	ScenarioSourceMySQL         ScenarioSource = "MySQL"
	ScenarioSourceMySQLRDS      ScenarioSource = "MySQLRDS"
	ScenarioSourceOracle        ScenarioSource = "Oracle"
	ScenarioSourcePostgreSQL    ScenarioSource = "PostgreSQL"
	ScenarioSourcePostgreSQLRDS ScenarioSource = "PostgreSQLRDS"
	ScenarioSourceSQL           ScenarioSource = "SQL"
	ScenarioSourceSQLRDS        ScenarioSource = "SQLRDS"
	ScenarioSourceSybase        ScenarioSource = "Sybase"
)

// PossibleScenarioSourceValues returns the possible values for the ScenarioSource const type.
func PossibleScenarioSourceValues() []ScenarioSource {
	return []ScenarioSource{
		ScenarioSourceAccess,
		ScenarioSourceDB2,
		ScenarioSourceMongoDB,
		ScenarioSourceMySQL,
		ScenarioSourceMySQLRDS,
		ScenarioSourceOracle,
		ScenarioSourcePostgreSQL,
		ScenarioSourcePostgreSQLRDS,
		ScenarioSourceSQL,
		ScenarioSourceSQLRDS,
		ScenarioSourceSybase,
	}
}

// ScenarioTarget - An enumeration of target type
type ScenarioTarget string

const (
	ScenarioTargetAzureDBForMySQL       ScenarioTarget = "AzureDBForMySql"
	ScenarioTargetAzureDBForPostgresSQL ScenarioTarget = "AzureDBForPostgresSQL"
	ScenarioTargetMongoDB               ScenarioTarget = "MongoDB"
	ScenarioTargetSQLDB                 ScenarioTarget = "SQLDB"
	ScenarioTargetSQLDW                 ScenarioTarget = "SQLDW"
	ScenarioTargetSQLMI                 ScenarioTarget = "SQLMI"
	ScenarioTargetSQLServer             ScenarioTarget = "SQLServer"
)

// PossibleScenarioTargetValues returns the possible values for the ScenarioTarget const type.
func PossibleScenarioTargetValues() []ScenarioTarget {
	return []ScenarioTarget{
		ScenarioTargetAzureDBForMySQL,
		ScenarioTargetAzureDBForPostgresSQL,
		ScenarioTargetMongoDB,
		ScenarioTargetSQLDB,
		ScenarioTargetSQLDW,
		ScenarioTargetSQLMI,
		ScenarioTargetSQLServer,
	}
}

// SchemaMigrationOption - Option for how schema is extracted and applied to target
type SchemaMigrationOption string

const (
	SchemaMigrationOptionExtractFromSource SchemaMigrationOption = "ExtractFromSource"
	SchemaMigrationOptionNone              SchemaMigrationOption = "None"
	SchemaMigrationOptionUseStorageFile    SchemaMigrationOption = "UseStorageFile"
)

// PossibleSchemaMigrationOptionValues returns the possible values for the SchemaMigrationOption const type.
func PossibleSchemaMigrationOptionValues() []SchemaMigrationOption {
	return []SchemaMigrationOption{
		SchemaMigrationOptionExtractFromSource,
		SchemaMigrationOptionNone,
		SchemaMigrationOptionUseStorageFile,
	}
}

// SchemaMigrationStage - Current stage of schema migration
type SchemaMigrationStage string

const (
	SchemaMigrationStageCollectingObjects     SchemaMigrationStage = "CollectingObjects"
	SchemaMigrationStageCompleted             SchemaMigrationStage = "Completed"
	SchemaMigrationStageCompletedWithWarnings SchemaMigrationStage = "CompletedWithWarnings"
	SchemaMigrationStageDeployingSchema       SchemaMigrationStage = "DeployingSchema"
	SchemaMigrationStageDownloadingScript     SchemaMigrationStage = "DownloadingScript"
	SchemaMigrationStageFailed                SchemaMigrationStage = "Failed"
	SchemaMigrationStageGeneratingScript      SchemaMigrationStage = "GeneratingScript"
	SchemaMigrationStageNotStarted            SchemaMigrationStage = "NotStarted"
	SchemaMigrationStageUploadingScript       SchemaMigrationStage = "UploadingScript"
	SchemaMigrationStageValidatingInputs      SchemaMigrationStage = "ValidatingInputs"
)

// PossibleSchemaMigrationStageValues returns the possible values for the SchemaMigrationStage const type.
func PossibleSchemaMigrationStageValues() []SchemaMigrationStage {
	return []SchemaMigrationStage{
		SchemaMigrationStageCollectingObjects,
		SchemaMigrationStageCompleted,
		SchemaMigrationStageCompletedWithWarnings,
		SchemaMigrationStageDeployingSchema,
		SchemaMigrationStageDownloadingScript,
		SchemaMigrationStageFailed,
		SchemaMigrationStageGeneratingScript,
		SchemaMigrationStageNotStarted,
		SchemaMigrationStageUploadingScript,
		SchemaMigrationStageValidatingInputs,
	}
}

// ServerLevelPermissionsGroup - Permission group for validations. These groups will run a set of permissions for validating
// user activity. Select the permission group for the activity that you are performing.
type ServerLevelPermissionsGroup string

const (
	ServerLevelPermissionsGroupDefault                             ServerLevelPermissionsGroup = "Default"
	ServerLevelPermissionsGroupMigrationFromSQLServerToAzureDB     ServerLevelPermissionsGroup = "MigrationFromSqlServerToAzureDB"
	ServerLevelPermissionsGroupMigrationFromSQLServerToAzureMI     ServerLevelPermissionsGroup = "MigrationFromSqlServerToAzureMI"
	ServerLevelPermissionsGroupMigrationFromMySQLToAzureDBForMySQL ServerLevelPermissionsGroup = "MigrationFromMySQLToAzureDBForMySQL"
)

// PossibleServerLevelPermissionsGroupValues returns the possible values for the ServerLevelPermissionsGroup const type.
func PossibleServerLevelPermissionsGroupValues() []ServerLevelPermissionsGroup {
	return []ServerLevelPermissionsGroup{
		ServerLevelPermissionsGroupDefault,
		ServerLevelPermissionsGroupMigrationFromSQLServerToAzureDB,
		ServerLevelPermissionsGroupMigrationFromSQLServerToAzureMI,
		ServerLevelPermissionsGroupMigrationFromMySQLToAzureDBForMySQL,
	}
}

// ServiceProvisioningState - The resource's provisioning state
type ServiceProvisioningState string

const (
	ServiceProvisioningStateAccepted      ServiceProvisioningState = "Accepted"
	ServiceProvisioningStateDeleting      ServiceProvisioningState = "Deleting"
	ServiceProvisioningStateDeploying     ServiceProvisioningState = "Deploying"
	ServiceProvisioningStateFailed        ServiceProvisioningState = "Failed"
	ServiceProvisioningStateFailedToStart ServiceProvisioningState = "FailedToStart"
	ServiceProvisioningStateFailedToStop  ServiceProvisioningState = "FailedToStop"
	ServiceProvisioningStateStarting      ServiceProvisioningState = "Starting"
	ServiceProvisioningStateStopped       ServiceProvisioningState = "Stopped"
	ServiceProvisioningStateStopping      ServiceProvisioningState = "Stopping"
	ServiceProvisioningStateSucceeded     ServiceProvisioningState = "Succeeded"
)

// PossibleServiceProvisioningStateValues returns the possible values for the ServiceProvisioningState const type.
func PossibleServiceProvisioningStateValues() []ServiceProvisioningState {
	return []ServiceProvisioningState{
		ServiceProvisioningStateAccepted,
		ServiceProvisioningStateDeleting,
		ServiceProvisioningStateDeploying,
		ServiceProvisioningStateFailed,
		ServiceProvisioningStateFailedToStart,
		ServiceProvisioningStateFailedToStop,
		ServiceProvisioningStateStarting,
		ServiceProvisioningStateStopped,
		ServiceProvisioningStateStopping,
		ServiceProvisioningStateSucceeded,
	}
}

// ServiceScalability - The scalability approach
type ServiceScalability string

const (
	ServiceScalabilityAutomatic ServiceScalability = "automatic"
	ServiceScalabilityManual    ServiceScalability = "manual"
	ServiceScalabilityNone      ServiceScalability = "none"
)

// PossibleServiceScalabilityValues returns the possible values for the ServiceScalability const type.
func PossibleServiceScalabilityValues() []ServiceScalability {
	return []ServiceScalability{
		ServiceScalabilityAutomatic,
		ServiceScalabilityManual,
		ServiceScalabilityNone,
	}
}

// Severity - Severity of the validation error
type Severity string

const (
	SeverityError   Severity = "Error"
	SeverityMessage Severity = "Message"
	SeverityWarning Severity = "Warning"
)

// PossibleSeverityValues returns the possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{
		SeverityError,
		SeverityMessage,
		SeverityWarning,
	}
}

// SsisMigrationOverwriteOption - The overwrite option for SSIS object migration, only ignore and overwrite are supported
// in DMS now and future may add Reuse option for container object
type SsisMigrationOverwriteOption string

const (
	SsisMigrationOverwriteOptionIgnore    SsisMigrationOverwriteOption = "Ignore"
	SsisMigrationOverwriteOptionOverwrite SsisMigrationOverwriteOption = "Overwrite"
)

// PossibleSsisMigrationOverwriteOptionValues returns the possible values for the SsisMigrationOverwriteOption const type.
func PossibleSsisMigrationOverwriteOptionValues() []SsisMigrationOverwriteOption {
	return []SsisMigrationOverwriteOption{
		SsisMigrationOverwriteOptionIgnore,
		SsisMigrationOverwriteOptionOverwrite,
	}
}

// SsisMigrationStage - Current stage of SSIS migration
type SsisMigrationStage string

const (
	SsisMigrationStageCompleted  SsisMigrationStage = "Completed"
	SsisMigrationStageInProgress SsisMigrationStage = "InProgress"
	SsisMigrationStageInitialize SsisMigrationStage = "Initialize"
	SsisMigrationStageNone       SsisMigrationStage = "None"
)

// PossibleSsisMigrationStageValues returns the possible values for the SsisMigrationStage const type.
func PossibleSsisMigrationStageValues() []SsisMigrationStage {
	return []SsisMigrationStage{
		SsisMigrationStageCompleted,
		SsisMigrationStageInProgress,
		SsisMigrationStageInitialize,
		SsisMigrationStageNone,
	}
}

// SsisStoreType - An enumeration of supported source SSIS store type in DMS
type SsisStoreType string

const (
	SsisStoreTypeSsisCatalog SsisStoreType = "SsisCatalog"
)

// PossibleSsisStoreTypeValues returns the possible values for the SsisStoreType const type.
func PossibleSsisStoreTypeValues() []SsisStoreType {
	return []SsisStoreType{
		SsisStoreTypeSsisCatalog,
	}
}

// SyncDatabaseMigrationReportingState - Enum of the different state of database level online migration.
type SyncDatabaseMigrationReportingState string

const (
	SyncDatabaseMigrationReportingStateBACKUPCOMPLETED    SyncDatabaseMigrationReportingState = "BACKUP_COMPLETED"
	SyncDatabaseMigrationReportingStateBACKUPINPROGRESS   SyncDatabaseMigrationReportingState = "BACKUP_IN_PROGRESS"
	SyncDatabaseMigrationReportingStateCANCELLED          SyncDatabaseMigrationReportingState = "CANCELLED"
	SyncDatabaseMigrationReportingStateCANCELLING         SyncDatabaseMigrationReportingState = "CANCELLING"
	SyncDatabaseMigrationReportingStateCOMPLETE           SyncDatabaseMigrationReportingState = "COMPLETE"
	SyncDatabaseMigrationReportingStateCOMPLETING         SyncDatabaseMigrationReportingState = "COMPLETING"
	SyncDatabaseMigrationReportingStateCONFIGURING        SyncDatabaseMigrationReportingState = "CONFIGURING"
	SyncDatabaseMigrationReportingStateFAILED             SyncDatabaseMigrationReportingState = "FAILED"
	SyncDatabaseMigrationReportingStateINITIALIAZING      SyncDatabaseMigrationReportingState = "INITIALIAZING"
	SyncDatabaseMigrationReportingStateREADYTOCOMPLETE    SyncDatabaseMigrationReportingState = "READY_TO_COMPLETE"
	SyncDatabaseMigrationReportingStateRESTORECOMPLETED   SyncDatabaseMigrationReportingState = "RESTORE_COMPLETED"
	SyncDatabaseMigrationReportingStateRESTOREINPROGRESS  SyncDatabaseMigrationReportingState = "RESTORE_IN_PROGRESS"
	SyncDatabaseMigrationReportingStateRUNNING            SyncDatabaseMigrationReportingState = "RUNNING"
	SyncDatabaseMigrationReportingStateSTARTING           SyncDatabaseMigrationReportingState = "STARTING"
	SyncDatabaseMigrationReportingStateUNDEFINED          SyncDatabaseMigrationReportingState = "UNDEFINED"
	SyncDatabaseMigrationReportingStateVALIDATING         SyncDatabaseMigrationReportingState = "VALIDATING"
	SyncDatabaseMigrationReportingStateVALIDATIONCOMPLETE SyncDatabaseMigrationReportingState = "VALIDATION_COMPLETE"
	SyncDatabaseMigrationReportingStateVALIDATIONFAILED   SyncDatabaseMigrationReportingState = "VALIDATION_FAILED"
)

// PossibleSyncDatabaseMigrationReportingStateValues returns the possible values for the SyncDatabaseMigrationReportingState const type.
func PossibleSyncDatabaseMigrationReportingStateValues() []SyncDatabaseMigrationReportingState {
	return []SyncDatabaseMigrationReportingState{
		SyncDatabaseMigrationReportingStateBACKUPCOMPLETED,
		SyncDatabaseMigrationReportingStateBACKUPINPROGRESS,
		SyncDatabaseMigrationReportingStateCANCELLED,
		SyncDatabaseMigrationReportingStateCANCELLING,
		SyncDatabaseMigrationReportingStateCOMPLETE,
		SyncDatabaseMigrationReportingStateCOMPLETING,
		SyncDatabaseMigrationReportingStateCONFIGURING,
		SyncDatabaseMigrationReportingStateFAILED,
		SyncDatabaseMigrationReportingStateINITIALIAZING,
		SyncDatabaseMigrationReportingStateREADYTOCOMPLETE,
		SyncDatabaseMigrationReportingStateRESTORECOMPLETED,
		SyncDatabaseMigrationReportingStateRESTOREINPROGRESS,
		SyncDatabaseMigrationReportingStateRUNNING,
		SyncDatabaseMigrationReportingStateSTARTING,
		SyncDatabaseMigrationReportingStateUNDEFINED,
		SyncDatabaseMigrationReportingStateVALIDATING,
		SyncDatabaseMigrationReportingStateVALIDATIONCOMPLETE,
		SyncDatabaseMigrationReportingStateVALIDATIONFAILED,
	}
}

// SyncTableMigrationState - Enum of the different state of table level online migration.
type SyncTableMigrationState string

const (
	SyncTableMigrationStateBEFORELOAD SyncTableMigrationState = "BEFORE_LOAD"
	SyncTableMigrationStateCANCELED   SyncTableMigrationState = "CANCELED"
	SyncTableMigrationStateCOMPLETED  SyncTableMigrationState = "COMPLETED"
	SyncTableMigrationStateERROR      SyncTableMigrationState = "ERROR"
	SyncTableMigrationStateFAILED     SyncTableMigrationState = "FAILED"
	SyncTableMigrationStateFULLLOAD   SyncTableMigrationState = "FULL_LOAD"
)

// PossibleSyncTableMigrationStateValues returns the possible values for the SyncTableMigrationState const type.
func PossibleSyncTableMigrationStateValues() []SyncTableMigrationState {
	return []SyncTableMigrationState{
		SyncTableMigrationStateBEFORELOAD,
		SyncTableMigrationStateCANCELED,
		SyncTableMigrationStateCOMPLETED,
		SyncTableMigrationStateERROR,
		SyncTableMigrationStateFAILED,
		SyncTableMigrationStateFULLLOAD,
	}
}

// TaskState - The state of the task. This is ignored if submitted.
type TaskState string

const (
	TaskStateCanceled              TaskState = "Canceled"
	TaskStateFailed                TaskState = "Failed"
	TaskStateFailedInputValidation TaskState = "FailedInputValidation"
	TaskStateFaulted               TaskState = "Faulted"
	TaskStateQueued                TaskState = "Queued"
	TaskStateRunning               TaskState = "Running"
	TaskStateSucceeded             TaskState = "Succeeded"
	TaskStateUnknown               TaskState = "Unknown"
)

// PossibleTaskStateValues returns the possible values for the TaskState const type.
func PossibleTaskStateValues() []TaskState {
	return []TaskState{
		TaskStateCanceled,
		TaskStateFailed,
		TaskStateFailedInputValidation,
		TaskStateFaulted,
		TaskStateQueued,
		TaskStateRunning,
		TaskStateSucceeded,
		TaskStateUnknown,
	}
}

// UpdateActionType - Type of the actual difference for the compared object, while performing schema comparison
type UpdateActionType string

const (
	UpdateActionTypeAddedOnTarget   UpdateActionType = "AddedOnTarget"
	UpdateActionTypeChangedOnTarget UpdateActionType = "ChangedOnTarget"
	UpdateActionTypeDeletedOnTarget UpdateActionType = "DeletedOnTarget"
)

// PossibleUpdateActionTypeValues returns the possible values for the UpdateActionType const type.
func PossibleUpdateActionTypeValues() []UpdateActionType {
	return []UpdateActionType{
		UpdateActionTypeAddedOnTarget,
		UpdateActionTypeChangedOnTarget,
		UpdateActionTypeDeletedOnTarget,
	}
}

// ValidationStatus - Current status of the validation
type ValidationStatus string

const (
	ValidationStatusCompleted           ValidationStatus = "Completed"
	ValidationStatusCompletedWithIssues ValidationStatus = "CompletedWithIssues"
	ValidationStatusDefault             ValidationStatus = "Default"
	ValidationStatusFailed              ValidationStatus = "Failed"
	ValidationStatusInProgress          ValidationStatus = "InProgress"
	ValidationStatusInitialized         ValidationStatus = "Initialized"
	ValidationStatusNotStarted          ValidationStatus = "NotStarted"
	ValidationStatusStopped             ValidationStatus = "Stopped"
)

// PossibleValidationStatusValues returns the possible values for the ValidationStatus const type.
func PossibleValidationStatusValues() []ValidationStatus {
	return []ValidationStatus{
		ValidationStatusCompleted,
		ValidationStatusCompletedWithIssues,
		ValidationStatusDefault,
		ValidationStatusFailed,
		ValidationStatusInProgress,
		ValidationStatusInitialized,
		ValidationStatusNotStarted,
		ValidationStatusStopped,
	}
}
