//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// WebSiteManagementClient contains the methods for the WebSiteManagementClient group.
// Don't use this type directly, use NewWebSiteManagementClient() instead.
type WebSiteManagementClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewWebSiteManagementClient creates a new instance of WebSiteManagementClient with the specified values.
// subscriptionID - Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewWebSiteManagementClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*WebSiteManagementClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &WebSiteManagementClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CheckNameAvailability - Description for Check if a resource name is available.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// request - Name availability request.
// options - WebSiteManagementClientCheckNameAvailabilityOptions contains the optional parameters for the WebSiteManagementClient.CheckNameAvailability
// method.
func (client *WebSiteManagementClient) CheckNameAvailability(ctx context.Context, request ResourceNameAvailabilityRequest, options *WebSiteManagementClientCheckNameAvailabilityOptions) (WebSiteManagementClientCheckNameAvailabilityResponse, error) {
	req, err := client.checkNameAvailabilityCreateRequest(ctx, request, options)
	if err != nil {
		return WebSiteManagementClientCheckNameAvailabilityResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebSiteManagementClientCheckNameAvailabilityResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebSiteManagementClientCheckNameAvailabilityResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkNameAvailabilityHandleResponse(resp)
}

// checkNameAvailabilityCreateRequest creates the CheckNameAvailability request.
func (client *WebSiteManagementClient) checkNameAvailabilityCreateRequest(ctx context.Context, request ResourceNameAvailabilityRequest, options *WebSiteManagementClientCheckNameAvailabilityOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/checknameavailability"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, request)
}

// checkNameAvailabilityHandleResponse handles the CheckNameAvailability response.
func (client *WebSiteManagementClient) checkNameAvailabilityHandleResponse(resp *http.Response) (WebSiteManagementClientCheckNameAvailabilityResponse, error) {
	result := WebSiteManagementClientCheckNameAvailabilityResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceNameAvailability); err != nil {
		return WebSiteManagementClientCheckNameAvailabilityResponse{}, err
	}
	return result, nil
}

// GetPublishingUser - Description for Gets publishing user
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - WebSiteManagementClientGetPublishingUserOptions contains the optional parameters for the WebSiteManagementClient.GetPublishingUser
// method.
func (client *WebSiteManagementClient) GetPublishingUser(ctx context.Context, options *WebSiteManagementClientGetPublishingUserOptions) (WebSiteManagementClientGetPublishingUserResponse, error) {
	req, err := client.getPublishingUserCreateRequest(ctx, options)
	if err != nil {
		return WebSiteManagementClientGetPublishingUserResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebSiteManagementClientGetPublishingUserResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebSiteManagementClientGetPublishingUserResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPublishingUserHandleResponse(resp)
}

// getPublishingUserCreateRequest creates the GetPublishingUser request.
func (client *WebSiteManagementClient) getPublishingUserCreateRequest(ctx context.Context, options *WebSiteManagementClientGetPublishingUserOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Web/publishingUsers/web"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPublishingUserHandleResponse handles the GetPublishingUser response.
func (client *WebSiteManagementClient) getPublishingUserHandleResponse(resp *http.Response) (WebSiteManagementClientGetPublishingUserResponse, error) {
	result := WebSiteManagementClientGetPublishingUserResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.User); err != nil {
		return WebSiteManagementClientGetPublishingUserResponse{}, err
	}
	return result, nil
}

// GetSourceControl - Description for Gets source control token
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// sourceControlType - Type of source control
// options - WebSiteManagementClientGetSourceControlOptions contains the optional parameters for the WebSiteManagementClient.GetSourceControl
// method.
func (client *WebSiteManagementClient) GetSourceControl(ctx context.Context, sourceControlType string, options *WebSiteManagementClientGetSourceControlOptions) (WebSiteManagementClientGetSourceControlResponse, error) {
	req, err := client.getSourceControlCreateRequest(ctx, sourceControlType, options)
	if err != nil {
		return WebSiteManagementClientGetSourceControlResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebSiteManagementClientGetSourceControlResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebSiteManagementClientGetSourceControlResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSourceControlHandleResponse(resp)
}

// getSourceControlCreateRequest creates the GetSourceControl request.
func (client *WebSiteManagementClient) getSourceControlCreateRequest(ctx context.Context, sourceControlType string, options *WebSiteManagementClientGetSourceControlOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Web/sourcecontrols/{sourceControlType}"
	if sourceControlType == "" {
		return nil, errors.New("parameter sourceControlType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sourceControlType}", url.PathEscape(sourceControlType))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSourceControlHandleResponse handles the GetSourceControl response.
func (client *WebSiteManagementClient) getSourceControlHandleResponse(resp *http.Response) (WebSiteManagementClientGetSourceControlResponse, error) {
	result := WebSiteManagementClientGetSourceControlResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SourceControl); err != nil {
		return WebSiteManagementClientGetSourceControlResponse{}, err
	}
	return result, nil
}

// GetSubscriptionDeploymentLocations - Description for Gets list of available geo regions plus ministamps
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - WebSiteManagementClientGetSubscriptionDeploymentLocationsOptions contains the optional parameters for the WebSiteManagementClient.GetSubscriptionDeploymentLocations
// method.
func (client *WebSiteManagementClient) GetSubscriptionDeploymentLocations(ctx context.Context, options *WebSiteManagementClientGetSubscriptionDeploymentLocationsOptions) (WebSiteManagementClientGetSubscriptionDeploymentLocationsResponse, error) {
	req, err := client.getSubscriptionDeploymentLocationsCreateRequest(ctx, options)
	if err != nil {
		return WebSiteManagementClientGetSubscriptionDeploymentLocationsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebSiteManagementClientGetSubscriptionDeploymentLocationsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebSiteManagementClientGetSubscriptionDeploymentLocationsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getSubscriptionDeploymentLocationsHandleResponse(resp)
}

// getSubscriptionDeploymentLocationsCreateRequest creates the GetSubscriptionDeploymentLocations request.
func (client *WebSiteManagementClient) getSubscriptionDeploymentLocationsCreateRequest(ctx context.Context, options *WebSiteManagementClientGetSubscriptionDeploymentLocationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/deploymentLocations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSubscriptionDeploymentLocationsHandleResponse handles the GetSubscriptionDeploymentLocations response.
func (client *WebSiteManagementClient) getSubscriptionDeploymentLocationsHandleResponse(resp *http.Response) (WebSiteManagementClientGetSubscriptionDeploymentLocationsResponse, error) {
	result := WebSiteManagementClientGetSubscriptionDeploymentLocationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeploymentLocations); err != nil {
		return WebSiteManagementClientGetSubscriptionDeploymentLocationsResponse{}, err
	}
	return result, nil
}

// NewListBillingMetersPager - Description for Gets a list of meters for a given location.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - WebSiteManagementClientListBillingMetersOptions contains the optional parameters for the WebSiteManagementClient.ListBillingMeters
// method.
func (client *WebSiteManagementClient) NewListBillingMetersPager(options *WebSiteManagementClientListBillingMetersOptions) *runtime.Pager[WebSiteManagementClientListBillingMetersResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebSiteManagementClientListBillingMetersResponse]{
		More: func(page WebSiteManagementClientListBillingMetersResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebSiteManagementClientListBillingMetersResponse) (WebSiteManagementClientListBillingMetersResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBillingMetersCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebSiteManagementClientListBillingMetersResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebSiteManagementClientListBillingMetersResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebSiteManagementClientListBillingMetersResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBillingMetersHandleResponse(resp)
		},
	})
}

// listBillingMetersCreateRequest creates the ListBillingMeters request.
func (client *WebSiteManagementClient) listBillingMetersCreateRequest(ctx context.Context, options *WebSiteManagementClientListBillingMetersOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/billingMeters"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.BillingLocation != nil {
		reqQP.Set("billingLocation", *options.BillingLocation)
	}
	if options != nil && options.OSType != nil {
		reqQP.Set("osType", *options.OSType)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBillingMetersHandleResponse handles the ListBillingMeters response.
func (client *WebSiteManagementClient) listBillingMetersHandleResponse(resp *http.Response) (WebSiteManagementClientListBillingMetersResponse, error) {
	result := WebSiteManagementClientListBillingMetersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BillingMeterCollection); err != nil {
		return WebSiteManagementClientListBillingMetersResponse{}, err
	}
	return result, nil
}

// NewListCustomHostNameSitesPager - Get custom hostnames under this subscription
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - WebSiteManagementClientListCustomHostNameSitesOptions contains the optional parameters for the WebSiteManagementClient.ListCustomHostNameSites
// method.
func (client *WebSiteManagementClient) NewListCustomHostNameSitesPager(options *WebSiteManagementClientListCustomHostNameSitesOptions) *runtime.Pager[WebSiteManagementClientListCustomHostNameSitesResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebSiteManagementClientListCustomHostNameSitesResponse]{
		More: func(page WebSiteManagementClientListCustomHostNameSitesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebSiteManagementClientListCustomHostNameSitesResponse) (WebSiteManagementClientListCustomHostNameSitesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCustomHostNameSitesCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebSiteManagementClientListCustomHostNameSitesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebSiteManagementClientListCustomHostNameSitesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebSiteManagementClientListCustomHostNameSitesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listCustomHostNameSitesHandleResponse(resp)
		},
	})
}

// listCustomHostNameSitesCreateRequest creates the ListCustomHostNameSites request.
func (client *WebSiteManagementClient) listCustomHostNameSitesCreateRequest(ctx context.Context, options *WebSiteManagementClientListCustomHostNameSitesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/customhostnameSites"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Hostname != nil {
		reqQP.Set("hostname", *options.Hostname)
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCustomHostNameSitesHandleResponse handles the ListCustomHostNameSites response.
func (client *WebSiteManagementClient) listCustomHostNameSitesHandleResponse(resp *http.Response) (WebSiteManagementClientListCustomHostNameSitesResponse, error) {
	result := WebSiteManagementClientListCustomHostNameSitesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CustomHostnameSitesCollection); err != nil {
		return WebSiteManagementClientListCustomHostNameSitesResponse{}, err
	}
	return result, nil
}

// NewListGeoRegionsPager - Description for Get a list of available geographical regions.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - WebSiteManagementClientListGeoRegionsOptions contains the optional parameters for the WebSiteManagementClient.ListGeoRegions
// method.
func (client *WebSiteManagementClient) NewListGeoRegionsPager(options *WebSiteManagementClientListGeoRegionsOptions) *runtime.Pager[WebSiteManagementClientListGeoRegionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebSiteManagementClientListGeoRegionsResponse]{
		More: func(page WebSiteManagementClientListGeoRegionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebSiteManagementClientListGeoRegionsResponse) (WebSiteManagementClientListGeoRegionsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listGeoRegionsCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebSiteManagementClientListGeoRegionsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebSiteManagementClientListGeoRegionsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebSiteManagementClientListGeoRegionsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listGeoRegionsHandleResponse(resp)
		},
	})
}

// listGeoRegionsCreateRequest creates the ListGeoRegions request.
func (client *WebSiteManagementClient) listGeoRegionsCreateRequest(ctx context.Context, options *WebSiteManagementClientListGeoRegionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/geoRegions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.SKU != nil {
		reqQP.Set("sku", string(*options.SKU))
	}
	if options != nil && options.LinuxWorkersEnabled != nil {
		reqQP.Set("linuxWorkersEnabled", strconv.FormatBool(*options.LinuxWorkersEnabled))
	}
	if options != nil && options.XenonWorkersEnabled != nil {
		reqQP.Set("xenonWorkersEnabled", strconv.FormatBool(*options.XenonWorkersEnabled))
	}
	if options != nil && options.LinuxDynamicWorkersEnabled != nil {
		reqQP.Set("linuxDynamicWorkersEnabled", strconv.FormatBool(*options.LinuxDynamicWorkersEnabled))
	}
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGeoRegionsHandleResponse handles the ListGeoRegions response.
func (client *WebSiteManagementClient) listGeoRegionsHandleResponse(resp *http.Response) (WebSiteManagementClientListGeoRegionsResponse, error) {
	result := WebSiteManagementClientListGeoRegionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GeoRegionCollection); err != nil {
		return WebSiteManagementClientListGeoRegionsResponse{}, err
	}
	return result, nil
}

// NewListPremierAddOnOffersPager - Description for List all premier add-on offers.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - WebSiteManagementClientListPremierAddOnOffersOptions contains the optional parameters for the WebSiteManagementClient.ListPremierAddOnOffers
// method.
func (client *WebSiteManagementClient) NewListPremierAddOnOffersPager(options *WebSiteManagementClientListPremierAddOnOffersOptions) *runtime.Pager[WebSiteManagementClientListPremierAddOnOffersResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebSiteManagementClientListPremierAddOnOffersResponse]{
		More: func(page WebSiteManagementClientListPremierAddOnOffersResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebSiteManagementClientListPremierAddOnOffersResponse) (WebSiteManagementClientListPremierAddOnOffersResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listPremierAddOnOffersCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebSiteManagementClientListPremierAddOnOffersResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebSiteManagementClientListPremierAddOnOffersResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebSiteManagementClientListPremierAddOnOffersResponse{}, runtime.NewResponseError(resp)
			}
			return client.listPremierAddOnOffersHandleResponse(resp)
		},
	})
}

// listPremierAddOnOffersCreateRequest creates the ListPremierAddOnOffers request.
func (client *WebSiteManagementClient) listPremierAddOnOffersCreateRequest(ctx context.Context, options *WebSiteManagementClientListPremierAddOnOffersOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/premieraddonoffers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listPremierAddOnOffersHandleResponse handles the ListPremierAddOnOffers response.
func (client *WebSiteManagementClient) listPremierAddOnOffersHandleResponse(resp *http.Response) (WebSiteManagementClientListPremierAddOnOffersResponse, error) {
	result := WebSiteManagementClientListPremierAddOnOffersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PremierAddOnOfferCollection); err != nil {
		return WebSiteManagementClientListPremierAddOnOffersResponse{}, err
	}
	return result, nil
}

// ListSKUs - Description for List all SKUs.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - WebSiteManagementClientListSKUsOptions contains the optional parameters for the WebSiteManagementClient.ListSKUs
// method.
func (client *WebSiteManagementClient) ListSKUs(ctx context.Context, options *WebSiteManagementClientListSKUsOptions) (WebSiteManagementClientListSKUsResponse, error) {
	req, err := client.listSKUsCreateRequest(ctx, options)
	if err != nil {
		return WebSiteManagementClientListSKUsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebSiteManagementClientListSKUsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebSiteManagementClientListSKUsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listSKUsHandleResponse(resp)
}

// listSKUsCreateRequest creates the ListSKUs request.
func (client *WebSiteManagementClient) listSKUsCreateRequest(ctx context.Context, options *WebSiteManagementClientListSKUsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/skus"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSKUsHandleResponse handles the ListSKUs response.
func (client *WebSiteManagementClient) listSKUsHandleResponse(resp *http.Response) (WebSiteManagementClientListSKUsResponse, error) {
	result := WebSiteManagementClientListSKUsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUInfos); err != nil {
		return WebSiteManagementClientListSKUsResponse{}, err
	}
	return result, nil
}

// NewListSiteIdentifiersAssignedToHostNamePager - Description for List all apps that are assigned to a hostname.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// nameIdentifier - Hostname information.
// options - WebSiteManagementClientListSiteIdentifiersAssignedToHostNameOptions contains the optional parameters for the
// WebSiteManagementClient.ListSiteIdentifiersAssignedToHostName method.
func (client *WebSiteManagementClient) NewListSiteIdentifiersAssignedToHostNamePager(nameIdentifier NameIdentifier, options *WebSiteManagementClientListSiteIdentifiersAssignedToHostNameOptions) *runtime.Pager[WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse]{
		More: func(page WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse) (WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSiteIdentifiersAssignedToHostNameCreateRequest(ctx, nameIdentifier, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSiteIdentifiersAssignedToHostNameHandleResponse(resp)
		},
	})
}

// listSiteIdentifiersAssignedToHostNameCreateRequest creates the ListSiteIdentifiersAssignedToHostName request.
func (client *WebSiteManagementClient) listSiteIdentifiersAssignedToHostNameCreateRequest(ctx context.Context, nameIdentifier NameIdentifier, options *WebSiteManagementClientListSiteIdentifiersAssignedToHostNameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/listSitesAssignedToHostName"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, nameIdentifier)
}

// listSiteIdentifiersAssignedToHostNameHandleResponse handles the ListSiteIdentifiersAssignedToHostName response.
func (client *WebSiteManagementClient) listSiteIdentifiersAssignedToHostNameHandleResponse(resp *http.Response) (WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse, error) {
	result := WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.IdentifierCollection); err != nil {
		return WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse{}, err
	}
	return result, nil
}

// NewListSourceControlsPager - Description for Gets the source controls available for Azure websites.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// options - WebSiteManagementClientListSourceControlsOptions contains the optional parameters for the WebSiteManagementClient.ListSourceControls
// method.
func (client *WebSiteManagementClient) NewListSourceControlsPager(options *WebSiteManagementClientListSourceControlsOptions) *runtime.Pager[WebSiteManagementClientListSourceControlsResponse] {
	return runtime.NewPager(runtime.PagingHandler[WebSiteManagementClientListSourceControlsResponse]{
		More: func(page WebSiteManagementClientListSourceControlsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WebSiteManagementClientListSourceControlsResponse) (WebSiteManagementClientListSourceControlsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listSourceControlsCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WebSiteManagementClientListSourceControlsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WebSiteManagementClientListSourceControlsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WebSiteManagementClientListSourceControlsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listSourceControlsHandleResponse(resp)
		},
	})
}

// listSourceControlsCreateRequest creates the ListSourceControls request.
func (client *WebSiteManagementClient) listSourceControlsCreateRequest(ctx context.Context, options *WebSiteManagementClientListSourceControlsOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Web/sourcecontrols"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listSourceControlsHandleResponse handles the ListSourceControls response.
func (client *WebSiteManagementClient) listSourceControlsHandleResponse(resp *http.Response) (WebSiteManagementClientListSourceControlsResponse, error) {
	result := WebSiteManagementClientListSourceControlsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SourceControlCollection); err != nil {
		return WebSiteManagementClientListSourceControlsResponse{}, err
	}
	return result, nil
}

// Move - Description for Move resources between resource groups.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// moveResourceEnvelope - Object that represents the resource to move.
// options - WebSiteManagementClientMoveOptions contains the optional parameters for the WebSiteManagementClient.Move method.
func (client *WebSiteManagementClient) Move(ctx context.Context, resourceGroupName string, moveResourceEnvelope CsmMoveResourceEnvelope, options *WebSiteManagementClientMoveOptions) (WebSiteManagementClientMoveResponse, error) {
	req, err := client.moveCreateRequest(ctx, resourceGroupName, moveResourceEnvelope, options)
	if err != nil {
		return WebSiteManagementClientMoveResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebSiteManagementClientMoveResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebSiteManagementClientMoveResponse{}, runtime.NewResponseError(resp)
	}
	return WebSiteManagementClientMoveResponse{}, nil
}

// moveCreateRequest creates the Move request.
func (client *WebSiteManagementClient) moveCreateRequest(ctx context.Context, resourceGroupName string, moveResourceEnvelope CsmMoveResourceEnvelope, options *WebSiteManagementClientMoveOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/moveResources"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, moveResourceEnvelope)
}

// UpdatePublishingUser - Description for Updates publishing user
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// userDetails - Details of publishing user
// options - WebSiteManagementClientUpdatePublishingUserOptions contains the optional parameters for the WebSiteManagementClient.UpdatePublishingUser
// method.
func (client *WebSiteManagementClient) UpdatePublishingUser(ctx context.Context, userDetails User, options *WebSiteManagementClientUpdatePublishingUserOptions) (WebSiteManagementClientUpdatePublishingUserResponse, error) {
	req, err := client.updatePublishingUserCreateRequest(ctx, userDetails, options)
	if err != nil {
		return WebSiteManagementClientUpdatePublishingUserResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebSiteManagementClientUpdatePublishingUserResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebSiteManagementClientUpdatePublishingUserResponse{}, runtime.NewResponseError(resp)
	}
	return client.updatePublishingUserHandleResponse(resp)
}

// updatePublishingUserCreateRequest creates the UpdatePublishingUser request.
func (client *WebSiteManagementClient) updatePublishingUserCreateRequest(ctx context.Context, userDetails User, options *WebSiteManagementClientUpdatePublishingUserOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Web/publishingUsers/web"
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, userDetails)
}

// updatePublishingUserHandleResponse handles the UpdatePublishingUser response.
func (client *WebSiteManagementClient) updatePublishingUserHandleResponse(resp *http.Response) (WebSiteManagementClientUpdatePublishingUserResponse, error) {
	result := WebSiteManagementClientUpdatePublishingUserResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.User); err != nil {
		return WebSiteManagementClientUpdatePublishingUserResponse{}, err
	}
	return result, nil
}

// UpdateSourceControl - Description for Updates source control token
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// sourceControlType - Type of source control
// requestMessage - Source control token information
// options - WebSiteManagementClientUpdateSourceControlOptions contains the optional parameters for the WebSiteManagementClient.UpdateSourceControl
// method.
func (client *WebSiteManagementClient) UpdateSourceControl(ctx context.Context, sourceControlType string, requestMessage SourceControl, options *WebSiteManagementClientUpdateSourceControlOptions) (WebSiteManagementClientUpdateSourceControlResponse, error) {
	req, err := client.updateSourceControlCreateRequest(ctx, sourceControlType, requestMessage, options)
	if err != nil {
		return WebSiteManagementClientUpdateSourceControlResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebSiteManagementClientUpdateSourceControlResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebSiteManagementClientUpdateSourceControlResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateSourceControlHandleResponse(resp)
}

// updateSourceControlCreateRequest creates the UpdateSourceControl request.
func (client *WebSiteManagementClient) updateSourceControlCreateRequest(ctx context.Context, sourceControlType string, requestMessage SourceControl, options *WebSiteManagementClientUpdateSourceControlOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Web/sourcecontrols/{sourceControlType}"
	if sourceControlType == "" {
		return nil, errors.New("parameter sourceControlType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sourceControlType}", url.PathEscape(sourceControlType))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, requestMessage)
}

// updateSourceControlHandleResponse handles the UpdateSourceControl response.
func (client *WebSiteManagementClient) updateSourceControlHandleResponse(resp *http.Response) (WebSiteManagementClientUpdateSourceControlResponse, error) {
	result := WebSiteManagementClientUpdateSourceControlResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SourceControl); err != nil {
		return WebSiteManagementClientUpdateSourceControlResponse{}, err
	}
	return result, nil
}

// Validate - Description for Validate if a resource can be created.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// validateRequest - Request with the resources to validate.
// options - WebSiteManagementClientValidateOptions contains the optional parameters for the WebSiteManagementClient.Validate
// method.
func (client *WebSiteManagementClient) Validate(ctx context.Context, resourceGroupName string, validateRequest ValidateRequest, options *WebSiteManagementClientValidateOptions) (WebSiteManagementClientValidateResponse, error) {
	req, err := client.validateCreateRequest(ctx, resourceGroupName, validateRequest, options)
	if err != nil {
		return WebSiteManagementClientValidateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebSiteManagementClientValidateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebSiteManagementClientValidateResponse{}, runtime.NewResponseError(resp)
	}
	return client.validateHandleResponse(resp)
}

// validateCreateRequest creates the Validate request.
func (client *WebSiteManagementClient) validateCreateRequest(ctx context.Context, resourceGroupName string, validateRequest ValidateRequest, options *WebSiteManagementClientValidateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/validate"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, validateRequest)
}

// validateHandleResponse handles the Validate response.
func (client *WebSiteManagementClient) validateHandleResponse(resp *http.Response) (WebSiteManagementClientValidateResponse, error) {
	result := WebSiteManagementClientValidateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ValidateResponse); err != nil {
		return WebSiteManagementClientValidateResponse{}, err
	}
	return result, nil
}

// ValidateMove - Description for Validate whether a resource can be moved.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// resourceGroupName - Name of the resource group to which the resource belongs.
// moveResourceEnvelope - Object that represents the resource to move.
// options - WebSiteManagementClientValidateMoveOptions contains the optional parameters for the WebSiteManagementClient.ValidateMove
// method.
func (client *WebSiteManagementClient) ValidateMove(ctx context.Context, resourceGroupName string, moveResourceEnvelope CsmMoveResourceEnvelope, options *WebSiteManagementClientValidateMoveOptions) (WebSiteManagementClientValidateMoveResponse, error) {
	req, err := client.validateMoveCreateRequest(ctx, resourceGroupName, moveResourceEnvelope, options)
	if err != nil {
		return WebSiteManagementClientValidateMoveResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebSiteManagementClientValidateMoveResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return WebSiteManagementClientValidateMoveResponse{}, runtime.NewResponseError(resp)
	}
	return WebSiteManagementClientValidateMoveResponse{}, nil
}

// validateMoveCreateRequest creates the ValidateMove request.
func (client *WebSiteManagementClient) validateMoveCreateRequest(ctx context.Context, resourceGroupName string, moveResourceEnvelope CsmMoveResourceEnvelope, options *WebSiteManagementClientValidateMoveOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/validateMoveResources"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, moveResourceEnvelope)
}

// VerifyHostingEnvironmentVnet - Description for Verifies if this VNET is compatible with an App Service Environment by analyzing
// the Network Security Group rules.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// parameters - VNET information
// options - WebSiteManagementClientVerifyHostingEnvironmentVnetOptions contains the optional parameters for the WebSiteManagementClient.VerifyHostingEnvironmentVnet
// method.
func (client *WebSiteManagementClient) VerifyHostingEnvironmentVnet(ctx context.Context, parameters VnetParameters, options *WebSiteManagementClientVerifyHostingEnvironmentVnetOptions) (WebSiteManagementClientVerifyHostingEnvironmentVnetResponse, error) {
	req, err := client.verifyHostingEnvironmentVnetCreateRequest(ctx, parameters, options)
	if err != nil {
		return WebSiteManagementClientVerifyHostingEnvironmentVnetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WebSiteManagementClientVerifyHostingEnvironmentVnetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WebSiteManagementClientVerifyHostingEnvironmentVnetResponse{}, runtime.NewResponseError(resp)
	}
	return client.verifyHostingEnvironmentVnetHandleResponse(resp)
}

// verifyHostingEnvironmentVnetCreateRequest creates the VerifyHostingEnvironmentVnet request.
func (client *WebSiteManagementClient) verifyHostingEnvironmentVnetCreateRequest(ctx context.Context, parameters VnetParameters, options *WebSiteManagementClientVerifyHostingEnvironmentVnetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/verifyHostingEnvironmentVnet"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// verifyHostingEnvironmentVnetHandleResponse handles the VerifyHostingEnvironmentVnet response.
func (client *WebSiteManagementClient) verifyHostingEnvironmentVnetHandleResponse(resp *http.Response) (WebSiteManagementClientVerifyHostingEnvironmentVnetResponse, error) {
	result := WebSiteManagementClientVerifyHostingEnvironmentVnetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetValidationFailureDetails); err != nil {
		return WebSiteManagementClientVerifyHostingEnvironmentVnetResponse{}, err
	}
	return result, nil
}
