/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.gui;

import geotrans3.exception.CoordinateConversionException;
import geotrans3.jni.JNIFiomeths;
import geotrans3.misc.StringHandler;
import geotrans3.utility.Utility;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProgressDlg
extends JDialog {
    JNIFiomeths jniFiomeths;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JLabel elapsedTimeLabel;
    private JLabel numErrorsLabel;
    private JLabel numProcessedLabel;
    private JLabel numWarningsLabel;
    private JButton okButton;
    private JPanel resultsPanel;
    private JButton startButton;
    private JLabel statusLabel;

    public ProgressDlg(JDialog jDialog, boolean bl, JNIFiomeths jNIFiomeths) {
        super((Dialog)jDialog, bl);
        this.jniFiomeths = jNIFiomeths;
        this.initComponents();
        this.numProcessedLabel.setVisible(false);
        this.numWarningsLabel.setVisible(false);
        this.numErrorsLabel.setVisible(false);
        this.elapsedTimeLabel.setVisible(false);
        this.getRootPane().setDefaultButton(this.startButton);
        this.pack();
        Utility.center(jDialog, this);
    }

    private void initComponents() {
        this.buttonsPanel = new JPanel();
        this.startButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.statusLabel = new JLabel();
        this.resultsPanel = new JPanel();
        this.numProcessedLabel = new JLabel();
        this.numWarningsLabel = new JLabel();
        this.numErrorsLabel = new JLabel();
        this.elapsedTimeLabel = new JLabel();
        this.setTitle("File Processing");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProgressDlg.this.closeDialog(windowEvent);
            }
        });
        this.buttonsPanel.setMinimumSize(new Dimension(274, 26));
        this.buttonsPanel.setPreferredSize(new Dimension(274, 26));
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.startButton.setMnemonic(83);
        this.startButton.setText("Start");
        this.startButton.setBorder(BorderFactory.createBevelBorder(0));
        this.startButton.setMaximumSize(new Dimension(76, 21));
        this.startButton.setMinimumSize(new Dimension(76, 21));
        this.startButton.setPreferredSize(new Dimension(76, 21));
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressDlg.this.startButtonActionPerformed(actionEvent);
            }
        });
        this.startButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ProgressDlg.this.startButtonMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ProgressDlg.this.startButtonMouseReleased(mouseEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 4, 15);
        this.buttonsPanel.add((Component)this.startButton, gridBagConstraints);
        this.okButton.setMnemonic(79);
        this.okButton.setText("OK");
        this.okButton.setBorder(BorderFactory.createBevelBorder(0));
        this.okButton.setEnabled(false);
        this.okButton.setMaximumSize(new Dimension(76, 21));
        this.okButton.setMinimumSize(new Dimension(76, 21));
        this.okButton.setPreferredSize(new Dimension(76, 21));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressDlg.this.okButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 4, 15);
        this.buttonsPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setBorder(BorderFactory.createBevelBorder(0));
        this.cancelButton.setMaximumSize(new Dimension(76, 21));
        this.cancelButton.setMinimumSize(new Dimension(76, 21));
        this.cancelButton.setPreferredSize(new Dimension(76, 21));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressDlg.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 4, 0);
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setText("Waiting");
        this.statusLabel.setMaximumSize(new Dimension(35, 26));
        this.statusLabel.setMinimumSize(new Dimension(35, 26));
        this.statusLabel.setPreferredSize(new Dimension(35, 26));
        this.getContentPane().add((Component)this.statusLabel, "North");
        this.resultsPanel.setMinimumSize(new Dimension(274, 100));
        this.resultsPanel.setPreferredSize(new Dimension(274, 100));
        this.resultsPanel.setLayout(new GridBagLayout());
        this.numProcessedLabel.setHorizontalAlignment(0);
        this.numProcessedLabel.setText("Num Processed:");
        this.numProcessedLabel.setMaximumSize(new Dimension(274, 16));
        this.numProcessedLabel.setMinimumSize(new Dimension(274, 16));
        this.numProcessedLabel.setPreferredSize(new Dimension(274, 16));
        this.resultsPanel.add((Component)this.numProcessedLabel, new GridBagConstraints());
        this.numWarningsLabel.setHorizontalAlignment(0);
        this.numWarningsLabel.setText("Num Warnings:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.resultsPanel.add((Component)this.numWarningsLabel, gridBagConstraints);
        this.numErrorsLabel.setHorizontalAlignment(0);
        this.numErrorsLabel.setText("Num Errors:");
        this.numErrorsLabel.setMaximumSize(new Dimension(73, 16));
        this.numErrorsLabel.setMinimumSize(new Dimension(73, 16));
        this.numErrorsLabel.setPreferredSize(new Dimension(73, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.resultsPanel.add((Component)this.numErrorsLabel, gridBagConstraints);
        this.elapsedTimeLabel.setHorizontalAlignment(0);
        this.elapsedTimeLabel.setText("Elapsed Time:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.resultsPanel.add((Component)this.elapsedTimeLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.resultsPanel, "Center");
    }

    private void startButtonMousePressed(MouseEvent mouseEvent) {
        this.startButtonPressed();
    }

    private void startButtonMouseReleased(MouseEvent mouseEvent) {
        this.startButtonReleased();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
        try {
            this.jniFiomeths.closeInputFile();
            this.jniFiomeths.closeOutputFile();
        }
        catch (Exception exception) {
            new StringHandler().displayErrorMsg(this, exception.getMessage());
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
        try {
            this.jniFiomeths.closeInputFile();
            this.jniFiomeths.closeOutputFile();
        }
        catch (Exception exception) {
            new StringHandler().displayErrorMsg(this, exception.getMessage());
        }
    }

    private void startButtonActionPerformed(ActionEvent actionEvent) {
        this.startButtonPressed();
        this.startButtonReleased();
    }

    void startButtonPressed() {
        this.statusLabel.setText("In Progress");
        this.setCursor(new Cursor(3));
        this.startButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
    }

    void startButtonReleased() {
        try {
            this.jniFiomeths.convertFile();
            this.statusLabel.setText("Completed");
            this.setCursor(new Cursor(0));
            long l = this.jniFiomeths.getNumProcessed();
            this.numProcessedLabel.setVisible(true);
            this.numProcessedLabel.setText("Number of coordinates processed = " + l);
            long l2 = this.jniFiomeths.getNumWarnings();
            this.numWarningsLabel.setVisible(true);
            this.numWarningsLabel.setText("Number of warnings = " + l2);
            long l3 = this.jniFiomeths.getNumErrors();
            this.numErrorsLabel.setVisible(true);
            this.numErrorsLabel.setText("Number of errors = " + l3);
            double d = this.jniFiomeths.getElapsedTime();
            this.elapsedTimeLabel.setVisible(true);
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMaximumFractionDigits(5);
            numberFormat.setMinimumFractionDigits(5);
            this.elapsedTimeLabel.setText("Elapsed Time = " + numberFormat.format(d) + " s");
            this.okButton.setEnabled(true);
            this.getRootPane().setDefaultButton(this.okButton);
        }
        catch (CoordinateConversionException coordinateConversionException) {
            try {
                this.jniFiomeths.closeInputFile();
                this.jniFiomeths.closeOutputFile();
            }
            catch (Exception exception) {
                new StringHandler().displayErrorMsg(this, exception.getMessage());
            }
            new StringHandler().displayErrorMsg(this, coordinateConversionException.getMessage());
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] stringArray) {
    }
}

