/** @file

Copyright (c) 2024, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPS_UPD_H__
#define __FSPS_UPD_H__

#include <FspUpd.h>

#pragma pack(1)

typedef struct {

/**  PCIe Controller 0
  Enable / Disable PCI Express controller 0
  $EN_DIS
**/
  UINT8                       EnablePcie0;

/**  PCIe Controller 1
  Enable / Disable PCI Express controller 1
  $EN_DIS
**/
  UINT8                       EnablePcie1;

/**  Embedded Multi-Media Controller (eMMC)
  Enable / Disable Embedded Multi-Media controller
  $EN_DIS
**/
  UINT8                       EnableEmmc;

/**  LAN Controllers
  Enable / Disable LAN controllers, refer to FSP Integration Guide for details.
  0:Disable LAN 0 & LAN 1, 1:Enable LAN 0 & LAN 1, 2:Disable LAN 1 only
**/
  UINT8                       EnableGbE;

/**  PCIe Root Port 0 DeEmphasis
  Desired DeEmphasis level for PCIE root port
  0:6dB, 1:3.5dB
**/
  UINT8                       PcieRootPort0DeEmphasis;

/**  PCIe Root Port 1 DeEmphasis
  Desired DeEmphasis level for PCIE root port
  0:6dB, 1:3.5dB
**/
  UINT8                       PcieRootPort1DeEmphasis;

/**  PCIe Root Port 2 DeEmphasis
  Desired DeEmphasis level for PCIE root port
  0:6dB, 1:3.5dB
**/
  UINT8                       PcieRootPort2DeEmphasis;

/**  PCIe Root Port 3 DeEmphasis
  Desired DeEmphasis level for PCIE root port
  0:6dB, 1:3.5dB
**/
  UINT8                       PcieRootPort3DeEmphasis;

/**  PCIe Root Port 4 DeEmphasis
  Desired DeEmphasis level for PCIE root port
  0:6dB, 1:3.5dB
**/
  UINT8                       PcieRootPort4DeEmphasis;

/**  PCIe Root Port 5 DeEmphasis
  Desired DeEmphasis level for PCIE root port
  0:6dB, 1:3.5dB
**/
  UINT8                       PcieRootPort5DeEmphasis;

/**  PCIe Root Port 6 DeEmphasis
  Desired DeEmphasis level for PCIE root port
  0:6dB, 1:3.5dB
**/
  UINT8                       PcieRootPort6DeEmphasis;

/**  PCIe Root Port 7 DeEmphasis
  Desired DeEmphasis level for PCIE root port
  0:6dB, 1:3.5dB
**/
  UINT8                       PcieRootPort7DeEmphasis;

/**  eMMC DLL Configuration Data
  Pointer to eMMC DLL Configuration Data
**/
  UINT32                      EMMCDLLConfigPtr;

/**  PCH Protect Range Limit
  Left shifted address by 12 bits with address bits 11:0 are assumed to be FFFh for
  limit comparison.
**/
  UINT16                      PchProtectedRangeLimit[5];

/**  PCH Protect Range Base
  Left shifted address by 12 bits with address bits 11:0 are assumed to be 0.
**/
  UINT16                      PchProtectedRangeBase[5];

/**  PchAdrEn
  PchAdr 0:PLATFORM POR, <b>1:FORCE ENABLE(Default)</b>, 2:FORCE DISABLE
  0:PLATFORM POR, 1:FORCE ENABLE, 2:FORCE DISABLE
**/
  UINT8                       PchAdrEn;

/**  Enable Timed GPIO0
  Enable/Disable Timed GPIO0. When disabled, it disables cross time stamp time-synchronization
  as extension of Hammock Harbor time synchronization
  $EN_DIS
**/
  UINT8                       EnableTimedGpio0;

/**  Enable Timed GPIO1
  Enable/Disable Timed GPIO0. When disabled, it disables cross time stamp time-synchronization
  as extension of Hammock Harbor time synchronization
  $EN_DIS
**/
  UINT8                       EnableTimedGpio1;

/**  FSP smm init enable
  Enable / Disable FSP smm init
  $EN_DIS
**/
  UINT8                       FspSmmInitEn;

/**  C2C3TT
  Default = 0, means [AUTO]. C2 to C3 Transition Timer, PPDN_INIT = C2C3TT CSR Bit[11:0]
  0: Default, Bit[11:0] : C2 to C3 Transition Timer
**/
  UINT8                       CpuPmC2c3tt;

/**  Processor Enable Monitor MWAIT
  Enable(Default) or Disable Processor Monitor MWAIT
  $EN_DIS
**/
  UINT8                       CpuPmMonitorMWait;

/**  Processor TurboMode Function
  Enable(Default) or Disable Processor TurboMode Function
  $EN_DIS
**/
  UINT8                       CpuPmTurboMode;

/**  Hardware P-States
  Disable: Hardware chooses a P-state based on OS Request (Legacy P-States)\n
  Native Mode:Hardware chooses a P-state based on OS guidance\n
  Out of Band Mode:Hardware autonomously chooses a P-state (no OS guidance)
  0:Disable, 1:Native Mode (Default), 2:Out of Band Mode, 3:Native Mode with No Legacy Support
**/
  UINT8                       CpuPmProcessorHWPMEnable;

/**  HardwarePM Interrupt
  Enable or Disable (Default) Hardware PM Interrupt
  $EN_DIS
**/
  UINT8                       CpuPmProcessorHWPMInterrupt;

/**  EPP Profile
  Choose an HWPM Profile, 0: Performance, 128: Balanced Performance, 192: Balanced
  Power, 255: Power
  0: Performance, 128: Balanced Performance, 192: Balanced Power, 255: Power
**/
  UINT8                       CpuPmProcessorEPPProfile;

/**  Boot Performance Mode
  Select the performance state that the BIOS will set before OS hand off, 0: Max Performance,
  1: Max Efficiency
  0: Max Performance (Default), 1: Max Efficiency
**/
  UINT8                       CpuPmBootPstate;

/**  Power Performance Tuning
  Power Performance Tuning <b>0: OS Controls EPB (Default)</b>, 1: BIOS Controls EPB,
  2: PECI Controls EPB
  0: OS Controls EPB, 1: BIOS Controls EPB, 2: PECI Controls EPB
**/
  UINT8                       CpuPmPwrPerfTuning;

/**  Enable or Disable Thermal Monitor
  Enable or Disable Thermal Monitor, 0: Disable, 1: Enable
  $EN_DIS
**/
  UINT8                       ThermalMonitor;

/**  FSPS Upd settings support
  : FSPS Upd settings support
  $EN_DIS
**/
  UINT8                       FspsUpdSupport;

/** N/A
  Pointer to node list which is used to initizalize security variables - CCT_VS_METADATA_NODE
**/
  EFI_PHYSICAL_ADDRESS        SecurityCctVarStorageMetadataNodePtr;

/** N/A
**/
  UINT8                       ReservedSiliconInitUpd[16];

} FSPS_CONFIG;


typedef struct {

/** N/A
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** N/A
**/
  FSPS_ARCH2_UPD              FspsArchUpd;

/** N/A
**/
  FSPS_CONFIG                 FspsConfig;

/** N/A
**/
  UINT16                      UpdTerminator;

} FSPS_UPD;

#pragma pack()

#endif
